#include "ListMapXml.h"
#include "Map.h"
#include "tinyxml.h"
#include <string>
#include <stdexcept>
using namespace std;


int slc2lev3(const char tile)
{
	if (tile == ' ')
		return 0;
	if (tile == '#')
		return 1;
	if (tile == '.')
		return 2;
	if (tile == '$')
		return 4;
	if (tile == '*')
		return 6;

	if (tile == '@') // Player Position
		return 0;
	if (tile == '+') // Player Position
		return 2;
	return 0;
}


/// Inform if a tile is a start position or not.
bool IsStartPosition(const char tile)
{
	if (tile == '@' || tile == '+')
		return true;
	return false;
}


ListMapXml::ListMapXml()
{
    LoadMaps("slc/original.slc");
    nextMap = 0;
}

ListMapXml::ListMapXml(const char* fileName)
{
    LoadMaps(fileName);
    nextMap = 0;
}


ListMapXml::~ListMapXml()
{
    mapas.clear();
}

CMap* ListMapXml::operator[](const int posicao)
{
    return mapas[posicao];
}

void ListMapXml::LoadMaps(const char* fileName = "slc/original.slc")
{
    numMaps = 0;


    /*
    Aqui tem que usar o tiny xml ou ento o IrrXml para interpretar o formato SLC
    e colocar dentro do vetor.
    */
    TiXmlBase::SetCondenseWhiteSpace(false);
    TiXmlDocument *doc = new TiXmlDocument(fileName);
	if (!doc->LoadFile() || doc->Error())
        throw runtime_error("Nao foi possivel abrir o arquivo \"slc/original.slc\"");

	TiXmlElement *raizLevels = doc->RootElement();
	raizLevels = raizLevels->FirstChildElement("LevelCollection");
	TiXmlElement *level = raizLevels->FirstChildElement("Level");
	//TiXmlBase::SetCondenseWhiteSpace(false);


	while (level)
	{
		int numLinhas, numColunas;
		level->Attribute("Width", &numColunas);
		level->Attribute("Height", &numLinhas);
		CMap* novoMapa = new CMap(numLinhas, numColunas);
		novoMapa->playerCol = 1; // ser sobrescrito
		novoMapa->playerRow = 1;

		TiXmlElement *linhaXML = level->FirstChildElement("L");
		for (int linha = 0; linha < numLinhas; linha++)
		{
			//string linhaString = linhaXML->GetText();
			TiXmlNode *texto = linhaXML->FirstChild();
			string linhaString = dynamic_cast<TiXmlText*>(texto)->Value();

			for (int coluna = 0; coluna < linhaString.length(); coluna++)
			{
				if (IsStartPosition(linhaString[coluna]))
				{
					novoMapa->playerRow = linha;
					novoMapa->playerCol = coluna;
				}
				novoMapa->matrix[linha][coluna] = slc2lev3(linhaString[coluna]);
			}
			linhaXML = linhaXML->NextSiblingElement("L");
		}



        // insere o novo mapa na lista.
        mapas.push_back(novoMapa);
        numMaps++;
		level = level->NextSiblingElement("Level");
	}
    //numMaps = mapas.size();
	delete doc;
}

/*! Retorna o prximo mapa e j incrementa pra apontar pro prximo do prximo.
 * Porque o prximo na verdade, vai passar a ser o atual.
 */
int ListMapXml::Next()
{
	int result = nextMap;
	if (++nextMap >= mapas.size())
		nextMap = 0;
	return result;
}

/*! Retorna o prximo mapa que deve ser carregado.
 *  usado quando o usurio reseta a fase, por exemplo, o mapa que
 * deve ser carregado  o atual, por isso no deve ser incrementado.
 */
int ListMapXml::GetNextMap()
{
	return nextMap;
}

void ListMapXml::SetNextMap(int newNextMap)
{
	nextMap = newNextMap;
}

int ListMapXml::GetNumMaps()
{
	return numMaps;
}
