#include <allegro.h>
#include "ListMapH8OR.h"
#include "Map.h"

int InsertMapH8OR(const char *fileName, int atrib, void *objListMap)
{
    CMap *novoMapa = new CMap(fileName);
    ((ListMapH8OR*)objListMap)->mapas.push_back(novoMapa);
    return 0;
}


ListMapH8OR::ListMapH8OR()
{
    LoadMaps();
    nextMap = 0;
}


ListMapH8OR::~ListMapH8OR()
{
    mapas.clear();
}

CMap* ListMapH8OR::operator[](const int posicao)
{
    return mapas[posicao];
}

void ListMapH8OR::LoadMaps()
{
    numMaps = for_each_file_ex("lev3/*.lev", 0, 0, InsertMapH8OR, (void*)this);
}

/*! Retorna o prximo mapa e j incrementa pra apontar pro prximo do prximo.
 * Porque o prximo na verdade, vai passar a ser o atual.
 */
int ListMapH8OR::Next()
{
	int result = nextMap;
	if (++nextMap >= mapas.size())
		nextMap = 0;
	return result;
}

/*! Retorna o prximo mapa que deve ser carregado.
 *  usado quando o usurio reseta a fase, por exemplo, o mapa que
 * deve ser carregado  o atual, por isso no deve ser incrementado.
 */
int ListMapH8OR::GetNextMap()
{
	return nextMap;
}

void ListMapH8OR::SetNextMap(int newNextMap)
{
	nextMap = (newNextMap > 0 && newNextMap < numMaps) ? newNextMap : 0;
}

int ListMapH8OR::GetNumMaps()
{
	return numMaps;
}
