#ifndef SPRFXNED_H
#define SPRFXNED_H

#define MAX_FRAMES 1000
#define MAX_PALETTES 200
#define MAX_ANIMATIONS 200
#define MAX_ATTACKS 300

#include "nsdefs.h"
#include "sprite8.h"
#include <allegro.h>
#include <stdio.h>
#include "edscrol3.h"

FILE *fp, *fopen();
long int bytes_allocated;
char *sprite_data;
char *frame_ptrs[MAX_FRAMES];
int number_of_frames;
int num_def_actors;
short palettes[MAX_PALETTES][16];
unsigned short anim_seqs[MAX_ANIMATIONS][19];

typedef struct hbox {
	short left_bound;
	short right_bound;
	short upper_bound;
	short lower_bound;
	unsigned char damage;
	unsigned char effect;
	unsigned char stun;
   unsigned char sound;
   unsigned short point_value;
   unsigned char is_continuous;
	} attack;

attack attacks[MAX_ATTACKS];

void Sprite_Init(sprite_ptr sprite);
void Sprite_ReInit(sprite_ptr sprite,int x,int y,int z,int h);
void Place_Sprite(sprite_ptr sprite, short x, short y, short z);
void FA_Set_State(sprite_ptr setsprite, int setstate);
int Blit_Sprite(sprite_ptr spr);
int Palette_Blit_Sprite(sprite_ptr spr);
void Blit_Shadow(sprite_ptr spr, BITMAP *shadpic);
int Size_Of_Frame(int a);
int Location_Of_Frame(int a);
void Clear_All();
void Frames_Malloc();
void Load_Frames(char *filename);
int Find_Anim_Frame(sprite_ptr spr, int anim_seq);
int Check_For_Hit(sprite_ptr attacker, sprite_ptr target);
int Thrown_Char_Hit(sprite_ptr attacker, sprite_ptr target);

#endif
