#ifndef SPRFXNED_H
#include "sprfxned.h"
#include "ns1dat.h"
#define MEM_ALLOC_SIZE 4000000
#endif

void Sprite_Init(sprite_ptr sprite) {
	sprite->x = NOWHERE;
	sprite->y = NOWHERE;
	sprite->z = NOWHERE;
	sprite->x_velocity = 0;
	sprite->y_velocity = 0;
	sprite->z_velocity = 0;
	sprite->x_vel_tracker = 0;
	sprite->y_vel_tracker = 0;
	sprite->z_vel_tracker = 0;
	sprite->curr_frame = -1;
	sprite->curr_anim = 0;
	sprite->action_count = 0;
	sprite->frame_counter = 0;
	sprite->anim_done = 0;
	sprite->curr_attack = 0;
	sprite->invulnerable_flag = 0;
	sprite->invulnerable_time = 0;
	sprite->type = 0;
	sprite->controlled_by = CPU;
	sprite->curr_state = INACTIVE;
	sprite->hit_direction = 0;
	sprite->var1 = 0;
	sprite->var2 = 0;
	sprite->var3 = 0;
	sprite->target = 0;
	sprite->h = 0;
	sprite->v = 0;
	sprite->stun = 0;
	sprite->hold = NULL;
	}

void Sprite_ReInit(sprite_ptr sprite,signed int x,signed int y,signed int z,int h) {
	sprite->x = x;
	sprite->y = y;
	sprite->z = z;
	sprite->health = h;
	sprite->max_health = h;
	sprite->invulnerable_flag = 0;
	sprite->stun = 0;
	}

void Place_Sprite(sprite_ptr sprite, short x, short y, short z) {
	sprite->x = x;
	sprite->y = y;
	sprite->z = z;
	}

void FA_Set_State(sprite_ptr setsprite, int setstate) {
	setsprite->frame_counter = 0;
	setsprite->action_count = 0;
	setsprite->curr_anim = 0;
	setsprite->anim_done = 0;
	setsprite->curr_state = setstate;
	}

int Blit_Sprite(sprite_ptr spr) {
int xs, ys, xe, ye;
int x,y;
int clip_width,clip_height;
int spr_curr_width;
int spr_curr_height;
int pre_x, pre_y, pre_xy; 	// Preprocessed variables for extra speed
unsigned char *frame_data;
unsigned char pixel;
if (spr == NULL) {
	return 0;
	}
if (spr->curr_frame == -1) {
	return 0;
	}
spr_curr_width = frame_ptrs[spr->curr_frame][2];
spr_curr_height = frame_ptrs[spr->curr_frame][3];
frame_data = &frame_ptrs[spr->curr_frame][12];
spr->rel_x = (spr->x)-(start_x);
spr->rel_y = (spr->y)-(start_y)+(spr->z);
if (spr->flipflag == FLIP)
{
spr->rel_x += -(spr_curr_width+(frame_ptrs[spr->curr_frame][0]));
spr->rel_y += ((frame_ptrs[spr->curr_frame][1]) - spr_curr_height);
}
else
{
spr->rel_x += (frame_ptrs[spr->curr_frame][0]);
spr->rel_y += ((frame_ptrs[spr->curr_frame][1]) - spr_curr_height);
}
xs = spr->rel_x;
ys = spr->rel_y;
xe = xs + spr_curr_width - 1;
ye = ys + spr_curr_height - 1;
if ((xs >= screen_w) || (ys >= SCREEN_HEIGHT) || (xs <= (-spr_curr_width)) || (ys <= (-spr_curr_height)) )
	{ return 0;
	}
if (xs < 0)
	xs = 0;
else
if (xe >= screen_w)
	xe=screen_w-1;
if (ys < 0)
	ys=0;
else
if (ye >= SCREEN_HEIGHT)
	ye=SCREEN_HEIGHT-1;
clip_width = xe - xs + 1;
clip_height = ye - ys + 1;
pre_y = (ys - spr->rel_y) * spr_curr_width;
if (spr->flipflag == FLIP) // sprite faces left
{
pre_x = spr_curr_width-(xs-spr->rel_x)-1;
pre_xy = pre_x + pre_y;
for (y=0; y<clip_height; y++) {
for (x=0; x<clip_width; x++) {
pixel = frame_data[pre_xy - x];
if (pixel)
double_buffer->line[ys+y][xs+x] = pixel;
}
pre_xy += spr_curr_width;
}
}
else // sprite faces right
{
pre_x = xs - spr->rel_x;
pre_xy = pre_x + pre_y;
for (y=0; y<clip_height; y++) {
for (x=0; x<clip_width; x++) {
pixel = frame_data[pre_xy + x];
if (pixel)
double_buffer->line[ys+y][xs+x] = pixel;
}
pre_xy += spr_curr_width;
}
}
return 1;
}

int Palette_Blit_Sprite(sprite_ptr spr) {
int xs, ys, xe, ye;
int x,y;
int clip_width,clip_height;
int spr_curr_width;
int spr_curr_height;
int pre_x, pre_y, pre_xy; 	// Preprocessed variables for extra speed
unsigned char *frame_data;
unsigned char pixel;
// unsigned char curr_pal_from, curr_pal_to;
if (spr == NULL) {
	return 0;
	}
if (spr->curr_frame == -1) {
	return 0;
	}
spr_curr_width = (unsigned char)frame_ptrs[spr->curr_frame][2];
spr_curr_height = (unsigned char)frame_ptrs[spr->curr_frame][3];
frame_data = &frame_ptrs[spr->curr_frame][12];
spr->rel_x = (spr->x)-(start_x);
spr->rel_y = (spr->y)-(start_y)+(spr->z);
if (spr->flipflag == FLIP)
{
spr->rel_x += -(spr_curr_width+(frame_ptrs[spr->curr_frame][0]));
spr->rel_y += ((frame_ptrs[spr->curr_frame][1]) - spr_curr_height);
}
else
{
spr->rel_x += (frame_ptrs[spr->curr_frame][0]);
spr->rel_y += ((frame_ptrs[spr->curr_frame][1]) - spr_curr_height);
}
xs = spr->rel_x;
ys = spr->rel_y;
xe = xs + spr_curr_width - 1;
ye = ys + spr_curr_height - 1;
if ((xs >= screen_w) || (ys >= SCREEN_HEIGHT) || (xs <= (-(spr_curr_width))) || (ys <= (-(spr_curr_height))) )
	{ return 0;
	}
if (xs < 0)
	xs = 0;
else
if (xe >= screen_w)
	xe=screen_w-1;
if (ys < 0)
	ys=0;
else
if (ye >= SCREEN_HEIGHT)
	ye=SCREEN_HEIGHT-1;
clip_width = xe - xs + 1;
clip_height = ye - ys + 1;
pre_y = (ys - spr->rel_y) * spr_curr_width;
if (spr->flipflag == FLIP) // sprite faces left
{
pre_x = spr_curr_width-(xs - spr->rel_x) - 1;
pre_xy = pre_x + pre_y;
for (y=0; y<clip_height; y++) {
for (x=0; x<clip_width; x++) {
pixel = frame_data[pre_xy - x];
if (pixel) {
   double_buffer->line[ys+y][xs+x] = (char)(pixel+palettes[spr->palnum][pixel>>4]);
   }
}
pre_xy += spr_curr_width;
}
}
else // sprite faces right
{
pre_x = xs - spr->rel_x;
pre_xy = pre_x + pre_y;
for (y=0; y<clip_height; y++) {
for (x=0; x<clip_width; x++) {
pixel = frame_data[pre_xy + x];
if (pixel) {
   double_buffer->line[ys+y][xs+x] = (char)(pixel+palettes[spr->palnum][pixel>>4]);
	}

}
pre_xy += spr_curr_width;
}
}
return 1;
}

void Blit_Shadow(sprite_ptr spr, BITMAP *shadpic) {
	int xs, ys, xe, ye;
	int shad_rel_x, shad_rel_y;
	int shad_sx, shad_sy;
	int x,y;
	int clip_width,clip_height;
	int shadow_width;
	int shadow_height;
	unsigned char pixel;
	if (spr == NULL) {
		return;
		}
	if (spr->curr_frame == -1) {
		return;
		}
	shadow_width = shadpic->w;
	shadow_height = shadpic->h;
	shad_rel_x = (spr->x)-(start_x);
	shad_rel_y = /* (spr->y)- */(start_y)+(spr->z);
	shad_rel_x -= (shadow_width/2);
	shad_rel_y -= (shadow_height/2);
	xs = shad_rel_x;
	ys = shad_rel_y;
	xe = xs + shadow_width - 1;
	ye = ys + shadow_height - 1;
	if ((xs >= SCREEN_WIDTH) || (ys >= SCREEN_HEIGHT) || (xs <= (-(shadow_width))) || (ys <= (-(shadow_height))) ) {
		return;
		}
	shad_sx = 0;
	shad_sy = 0;
	if (xs < 0) {
		xs = 0;
		shad_sx = -shad_rel_x;
		}
	else if (xe >= SCREEN_WIDTH)
		xe=SCREEN_WIDTH-1;
	if (ys < 0) {
		ys = 0;
		shad_sy = -shad_rel_y;
		}
	else if (ye >= SCREEN_HEIGHT)
		ye=SCREEN_HEIGHT-1;
	clip_width = xe - xs + 1;
	clip_height = ye - ys + 1;
	for (y=0; y<clip_height; y++) {
		for (x=0; x<clip_width; x++) {
			if (shadpic->line[shad_sy+y][shad_sx+x]) {
				pixel = double_buffer->line[ys+y][xs+x];
				if (pixel % 16 < 15 && pixel / 16 != 0) {
					double_buffer->line[ys+y][xs+x] += 1;
					}
				}
			}
		}
	}
	
int Size_Of_Frame(int a) {
   int b;
   b=((int)(unsigned char)frame_ptrs[a][2]*(int)(unsigned char)frame_ptrs[a][3])+12;
   return b;
   }

int Location_Of_Frame(int a) {
   int b=0;
   int index=0;
   while (index<a) {
      b+=Size_Of_Frame(index);
      index++;
      }
   return b;
   }

void Clear_All() {
   int ii, jj;
   num_def_actors = 0;
   number_of_frames = 0;
   bytes_allocated=0;
   fp = NULL;
   for (ii=0; ii<MAX_FRAMES; ii++)
       frame_ptrs[ii] = NULL;
   for (ii=0; ii<MEM_ALLOC_SIZE; ii++)
       sprite_data[ii] = 0;
   for (ii=0; ii<MAX_PALETTES; ii++)
       for (jj=0; jj<16; jj++)
           palettes[ii][jj] = 0;
   for (ii=0; ii<MAX_ANIMATIONS; ii++)
       for (jj=0; jj<19; jj++)
           anim_seqs[ii][jj] = 0;
   for (ii=0; ii<MAX_ATTACKS; ii++) {
      attacks[ii].left_bound = 0;
      attacks[ii].right_bound = 0;
      attacks[ii].upper_bound = 0;
      attacks[ii].lower_bound = 0;
      attacks[ii].damage = 0;
      attacks[ii].effect = 0;
      attacks[ii].stun = 0;
      attacks[ii].sound = 0;
      attacks[ii].point_value = 0;
      }
   }

void Frames_Malloc() {
     sprite_data = (unsigned char *)malloc(MEM_ALLOC_SIZE);
     if (sprite_data == NULL) {
        printf("Can't allocate %d bytes for frames.\n", MEM_ALLOC_SIZE);
        exit(1);
        }
     else
         printf("Memory for sprite frames allocated.\n");
     }

void Load_Frames(char *file_name) {
   int i,j;
   Frames_Malloc();
   Clear_All();
   fp=fopen(file_name,"rb");
   number_of_frames = ((int)(unsigned char)getc(fp)) << 8;
   number_of_frames += (int)(unsigned char)getc(fp);
   frame_ptrs[0] = &sprite_data[0];
   for (i=0; i<number_of_frames; i++) {
       frame_ptrs[i][0]=getc(fp);
       frame_ptrs[i][1]=getc(fp);
       frame_ptrs[i][2]=getc(fp);
       frame_ptrs[i][3]=getc(fp);
       for (j=0; j<Size_Of_Frame(i)-4; j++)
           frame_ptrs[i][4+j]=getc(fp);
       if (i<number_of_frames-1)
          frame_ptrs[i+1] = &sprite_data[Location_Of_Frame(i)+Size_Of_Frame(i)];
       bytes_allocated+=Size_Of_Frame(i);
       }
   for (i=0; i<MAX_PALETTES; i++)
       for (j=0; j<16; j++) {
           palettes[i][j] = getc(fp) << 8;
           palettes[i][j] |= getc(fp);
           }
       for (i=0; i<MAX_ANIMATIONS; i++)
           for (j=0; j<19; j++) {
               anim_seqs[i][j] = getc(fp) << 8;
               anim_seqs[i][j] |= getc(fp);
               }
       for (i=0; i<MAX_ATTACKS; i++) {
           attacks[i].left_bound = getc(fp) << 8;
           attacks[i].left_bound |= getc(fp);
           attacks[i].right_bound = getc(fp) << 8;
           attacks[i].right_bound |= getc(fp);
           attacks[i].upper_bound = getc(fp) << 8;
           attacks[i].upper_bound |= getc(fp);
           attacks[i].lower_bound = getc(fp) << 8;
           attacks[i].lower_bound |= getc(fp);
           attacks[i].damage = getc(fp);
           attacks[i].effect = getc(fp);
           attacks[i].stun = getc(fp);
           attacks[i].sound = getc(fp);
           attacks[i].point_value = getc(fp) << 8;
           attacks[i].point_value |= getc(fp);
           attacks[i].is_continuous = getc(fp);
           }
       fclose(fp);
   	}

/*
int Check_For_Hit(sprite_ptr attacker, sprite_ptr target) {
   short atk_l, atk_r, atk_t, atk_b, tgt_l, tgt_r, tgt_t, tgt_b;
   int atk_ef, death_ef;
   int did_hit = 0;
   int i;
   atk_ef = (attacks[attacker->curr_attack].effect % 10);
   death_ef = (attacks[attacker->curr_attack].effect / 10);
   if (target->curr_frame == -1)
	   return 0;
   if (target->invulnerable_flag)
      return 0;
   if (atk_ef == 3 && target->hold != attacker)
	   return 0;
   atk_l = atk_r = attacker->x;
   atk_t = atk_b = attacker->y;
   if (attacker->flipflag == NOFLIP) {
      atk_l += attacks[attacker->curr_attack].left_bound;
      atk_r += attacks[attacker->curr_attack].right_bound;
      }
   else {
      atk_l -= attacks[attacker->curr_attack].right_bound;
      atk_r -= attacks[attacker->curr_attack].left_bound;
      }
   atk_t += attacks[attacker->curr_attack].upper_bound;
   atk_b += attacks[attacker->curr_attack].lower_bound;
   tgt_l = tgt_r = target->x;
   tgt_t = tgt_b = target->y;
   if (target->flipflag == NOFLIP) {
      tgt_l += (((unsigned char)frame_ptrs[target->curr_frame][4] << 8) | ((unsigned char)frame_ptrs[target->curr_frame][5]));
      tgt_r += (((unsigned char)frame_ptrs[target->curr_frame][6] << 8) | ((unsigned char)frame_ptrs[target->curr_frame][7]));
      }
   else {
      tgt_l -= (((unsigned char)frame_ptrs[target->curr_frame][6] << 8) | ((unsigned char)frame_ptrs[target->curr_frame][7]));
      tgt_r -= (((unsigned char)frame_ptrs[target->curr_frame][4] << 8) | ((unsigned char)frame_ptrs[target->curr_frame][5]));
      }
   tgt_t += (((unsigned char)frame_ptrs[target->curr_frame][8] << 8) | ((unsigned char)frame_ptrs[target->curr_frame][9]));
   tgt_b += (((unsigned char)frame_ptrs[target->curr_frame][10] << 8) | ((unsigned char)frame_ptrs[target->curr_frame][11]));
   if ((atk_r >= tgt_l) && (atk_l <= tgt_r) && (atk_b >= tgt_t) && (atk_t <= tgt_b))
      if (attacker->z >= (target->z - Z_HIT_RANGE) && attacker->z <= (target->z + Z_HIT_RANGE)) {
         target->hit_direction = (attacker->flipflag == FLIP)? -1 : 1;
         target->health -= attacks[attacker->curr_attack].damage;
         target->var1 = 0;
         target->curr_anim = 0;
         target->stun += attacks[attacker->curr_attack].stun;
         switch (attacks[attacker->curr_attack].sound) {
			case 0: {
            play_sample(ns1_data[heavy_slash_snd].dat, 255, 128, 1000, FALSE);
			if (blood_on) {
				for (i = 0; i < MAX_SPRITES; i++) {
					if (sprites[i].curr_state == INACTIVE) {
						sprites[i].controlled_by = CPU;
						sprites[i].type = EFFECT;
						sprites[i].var1 = BLOOD;
						sprites[i].flipflag = (target->hit_direction == -1)? NOFLIP : FLIP;
						sprites[i].curr_frame = 145;
						FA_Set_State((sprite_ptr)&sprites[i], SPECIAL); // anything but INACTIVE or STANDING
						sprites[i].anim_done = 0;
						if (atk_ef == 1 || atk_ef == 3) {
							Place_Sprite((sprite_ptr)&sprites[i],target->x,(target->y-32),target->z);
							}
						else {
							Place_Sprite((sprite_ptr)&sprites[i],target->x,(target->y-72),target->z);
							}
						break;
						}
					}
				}
			}
            break;
            case 1:
            play_sample(ns1_data[stick_hit_snd].dat, 255, 128, 1000, FALSE);
            break;
            case 2:
            play_sample(ns1_data[kick_snd].dat, 255, 128, 1000, FALSE);
            break;*/
            /* default:
                 play_sample(ns1_data[heavy_slash_snd].dat, 255, 128, 1000, FALSE);
                 break; */ /*
            }
         did_hit = 1;
		 if (atk_ef != 3) {
			if (target->hold != NULL) {
				if (target->curr_state == HOLDING || target->curr_state == HOLD_ATTACK || target->curr_state == WALKING_HOLD || target->curr_state == JUMPING_HOLD || target->curr_state == THROWING || target->curr_state == PILEDRIVER) {
					FA_Set_State(target->hold, DROP_FREE);
					target->var1 = 0;
					target->var2 = 0;
					target->var3 = 0;
					target->hold->hold = NULL;
					target->hold = NULL;
					}
				else if (target->curr_state == HELD1 || target->curr_state == HELD2) {
					if (target->hold->y == 0) {
						FA_Set_State(target->hold, STANDING);
						}
					else {
						target->hold->curr_state = JUMPING;
						}
					target->hold->var1 = 0;
					target->hold->var2 = 0;
					target->hold->var3 = 0;
					target->hold->hold = NULL;
					target->hold = NULL;
					}
				}
			}
			if (attacker->controlled_by == HUMAN && attacker->curr_state != JUMP_ATTACK) {
				attacker->target = 1; // The int target which is part of the sprite struct, not the sprite_ptr passed to this func
				attacker->var3 = AT_TIME;
				}
			switch (atk_ef) {
				case 0:
					FA_Set_State(target, GET_HIT_HEAD);
					break;
				case 1:
					FA_Set_State(target, GET_HIT_STOMACH);
					break;
				case 2:
					FA_Set_State(target, KNOCKED_DOWN);
					break;
				case 3:
					if (attacker->var1 == 2) {
						attacker->var1 = 0;
						attacker->var2 = 0;
						attacker->var3 = 0;
						attacker->hold = NULL;
						target->hold = NULL;
						FA_Set_State(target, KNOCKED_DOWN);
						}
					break;
				}
			// }
		 target->var2 = 0;
         if (target->stun >= 100)
            FA_Set_State(target, KNOCKED_DOWN);
         if (target->health <= 0) {
            target->health = 0;
			if (target->hold != NULL) {
				if (target->curr_state == HOLDING || target->curr_state == HOLD_ATTACK || target->curr_state == WALKING_HOLD || target->curr_state == JUMPING_HOLD) {
					FA_Set_State(target->hold, DROP_FREE);
					target->var1 = 0;
					target->var2 = 0;
					target->var3 = 0;
					target->hold->hold = NULL;
					target->hold = NULL;
					}
				else {
					target->hold->var1 = 0;
					target->hold->var2 = 0;
					target->hold->var3 = 0;
					target->hold->hold = NULL;
					target->hold = NULL;
					}
				}
            switch (death_ef) {
               default:
                 FA_Set_State(target, KNOCKED_DOWN);
                 break;
               }
            }
         }
      return did_hit;
   }

int Thrown_Char_Hit(sprite_ptr attacker, sprite_ptr target) { // attacker is guy who was thrown
   short atk_l, atk_r, atk_t, atk_b, tgt_l, tgt_r, tgt_t, tgt_b;
   int did_hit = 0;
   if (target->curr_frame == -1)
	   return 0;
   if (target->invulnerable_flag)
      return 0;
   atk_l = atk_r = attacker->x;
   atk_t = atk_b = attacker->y;
   if (attacker->flipflag == NOFLIP) {
      atk_l += (((unsigned char)frame_ptrs[attacker->curr_frame][4] << 8) | ((unsigned char)frame_ptrs[attacker->curr_frame][5]));
      atk_r += (((unsigned char)frame_ptrs[attacker->curr_frame][6] << 8) | ((unsigned char)frame_ptrs[attacker->curr_frame][7]));
      }
   else {
      atk_l -= (((unsigned char)frame_ptrs[attacker->curr_frame][6] << 8) | ((unsigned char)frame_ptrs[attacker->curr_frame][7]));
      atk_r -= (((unsigned char)frame_ptrs[attacker->curr_frame][4] << 8) | ((unsigned char)frame_ptrs[attacker->curr_frame][5]));
      }
   atk_t += (((unsigned char)frame_ptrs[attacker->curr_frame][8] << 8) | ((unsigned char)frame_ptrs[attacker->curr_frame][9]));
   atk_b += (((unsigned char)frame_ptrs[attacker->curr_frame][10] << 8) | ((unsigned char)frame_ptrs[attacker->curr_frame][11]));
   
   tgt_l = tgt_r = target->x;
   tgt_t = tgt_b = target->y;
   if (target->flipflag == NOFLIP) {
      tgt_l += (((unsigned char)frame_ptrs[target->curr_frame][4] << 8) | ((unsigned char)frame_ptrs[target->curr_frame][5]));
      tgt_r += (((unsigned char)frame_ptrs[target->curr_frame][6] << 8) | ((unsigned char)frame_ptrs[target->curr_frame][7]));
      }
   else {
      tgt_l -= (((unsigned char)frame_ptrs[target->curr_frame][6] << 8) | ((unsigned char)frame_ptrs[target->curr_frame][7]));
      tgt_r -= (((unsigned char)frame_ptrs[target->curr_frame][4] << 8) | ((unsigned char)frame_ptrs[target->curr_frame][5]));
      }
   tgt_t += (((unsigned char)frame_ptrs[target->curr_frame][8] << 8) | ((unsigned char)frame_ptrs[target->curr_frame][9]));
   tgt_b += (((unsigned char)frame_ptrs[target->curr_frame][10] << 8) | ((unsigned char)frame_ptrs[target->curr_frame][11]));
   if ((atk_r >= tgt_l) && (atk_l <= tgt_r) && (atk_b >= tgt_t) && (atk_t <= tgt_b))
      if (attacker->z >= (target->z - Z_HIT_RANGE) && attacker->z <= (target->z + Z_HIT_RANGE)) {
         target->hit_direction = attacker->hit_direction;
         target->health -= attacker->var1;
         target->var1 = 0;
         target->curr_anim = 0;
         play_sample(ns1_data[kick_snd].dat, 255, 128, 1000, FALSE);
         did_hit = 1;
		 if (target->hold != NULL) {
			if (target->curr_state == HOLDING || target->curr_state == HOLD_ATTACK || target->curr_state == WALKING_HOLD || target->curr_state == JUMPING_HOLD) {
				FA_Set_State(target->hold, DROP_FREE);
				target->var1 = 0;
				target->var2 = 0;
				target->var3 = 0;
				target->hold->hold = NULL;
				target->hold = NULL;
				}
			else if (target->curr_state == HELD1 || target->curr_state == HELD2) {
				if (target->hold->y == 0) {
					FA_Set_State(target->hold, STANDING);
					}
				else {
					target->hold->curr_state = JUMPING;
					}
				target->hold->var1 = 0;
				target->hold->var2 = 0;
				target->hold->var3 = 0;
				target->hold->hold = NULL;
				target->hold = NULL;
				}
			}
		FA_Set_State(target, KNOCKED_DOWN);
		target->var2 = 0;
        if (target->health <= 0) {
            target->health = 0;
			if (target->hold != NULL) {
				if (target->curr_state == HOLDING || target->curr_state == HOLD_ATTACK || target->curr_state == WALKING_HOLD || target->curr_state == JUMPING_HOLD) {
					FA_Set_State(target->hold, DROP_FREE);
					target->var1 = 0;
					target->var2 = 0;
					target->var3 = 0;
					target->hold->hold = NULL;
					target->hold = NULL;
					}
				else {
					target->hold->var1 = 0;
					target->hold->var2 = 0;
					target->hold->var3 = 0;
					target->hold->hold = NULL;
					target->hold = NULL;
					}
				}
            FA_Set_State(target, KNOCKED_DOWN);
            }
         }
      return did_hit;
   }

int Count_Players() {
   int i, c = 0;
   for (i=0; i<MAX_PLAYERS; i++) {
      if (player[i] != NULL)
         c++;
      }
   return c;
   }

void Find_Target(sprite_ptr spr) {
   int closest_dist = -1, closest_enemy = 0, dist;
   int i, j, r;
   if (Count_Players() < 2) {
      spr->target = 0;
      return;
      }
   for (i=0; i<MAX_PLAYERS; i++)
      if (player[i] != NULL) {
         dist = pow((spr->x-player[i]->x), 2) + pow((spr->y-player[i]->y), 2);
         if (dist < closest_dist || closest_dist == -1) {
            closest_dist = dist;
            closest_enemy = i;
            }
         }
   r=rand() % 3;
   if (r < 2) {
      spr->target = closest_enemy;
	  return;
	  }
   else {
      r=rand() % (Count_Players() - 1);
      for (j=0; j<MAX_PLAYERS; j++) {
         if (j != closest_enemy)
            r--;
         if (r == -1) {
            spr->target = j;
			return;
			}
         }
      }
   }

int Within_Range(sprite_ptr attacker, attack range) {
   int i;
   for (i=0; i<MAX_PLAYERS; i++) {
      if (player[i] != NULL) {
         if (player[i]->z >= (attacker->z-Z_HIT_RANGE) && player[i]->z <= (attacker->z+Z_HIT_RANGE))
            if (abs(player[i]->x - attacker->x) < range.right_bound) {
               attacker->target = i;
               return 1;
               }
         }
      }
   return 0;
   }

*/