#ifndef TEXTFUNX_C
#define TEXTFUNX_C
#include "textfunx.h"


void Grab_Letter(BITMAP *image, int numletter) {
int x_off,y_off,x,y,index;
x_off = 8 * (numletter%26);
y_off = 8 * (numletter/26);
for (y=0; y<8; y++) {
for (x=0; x<8; x++) {
alphabet[numletter][y][x] = image->line[y_off + y][x_off + x];
}
}
}

void Blit_Letter(int xc,int yc,char c) {
int x,y;
c -= 32;
if (c<0 || c>92)
	return;

for (y=0; y<8; y++) {
for (x=0; x<8; x++) {
if (alphabet[c][y][x])
double_buffer->line[yc+y][xc+x] = alphabet[c][y][x];
}

}
}

void Giant_Blit_Letter(int xc,int yc,char c) {
int x,y;
c -= 32;
if (c<0 || c>92)
	return;

for (y=0; y<16; y++) {
for (x=0; x<16; x++) {
if (alphabet[c][y/2][x/2])
double_buffer->line[yc+y][xc+x] = alphabet[c][y/2][x/2];
}

}
}

void Blit_Word(int x,int y,char *string) {
int index;
for (index=0; string[index]!=0; index++)
{
if (string[index]!='[')
{
if (string[index] == 'g' || string[index] == 'p' || string[index] == 'q' || string[index] == 'y')
	Blit_Letter(x+(index<<3),y+2,string[index]);
else if (string[index] == 'j') {
	Blit_Letter(x+(index<<3),y,'i');
	Blit_Letter(x+(index<<3),y+2,'j');
	}
else
Blit_Letter(x+(index<<3),y,string[index]);
}
}
}


void reverse(char s[]) {
	int c, i, j;
	for (i = 0, j = strlen(s)-1; i < j; i++, j--) {
		c = s[i];
		s[i] = s[j];
		s[j] = c;
		}
	}

int int_to_string(long int n, char *s) {
	int i, len;
   long int sign;
	len = 0;
	if ((sign = n) < 0)
		n = -n;
	i = 0;
	do {
		s[i++] = n % 10 + '0';
		len++;
		} while ((n /= 10) > 0);
	if (sign < 0)
	s[i++] = '-';
	s[i] = '\0';
	reverse(s);
	return len;
	}

void int_to_score(long int n, char *s, int len) {
	int i;
   long int sign;
	if ((sign = n) < 0)
		n = -n;
	i = 0;
	do {
		s[i++] = n % 10 + '0';
		} while ((n /= 10) > 0);
	if (sign < 0)
	s[i++] = '-';
	if (i < len) {
		while (i < len) {
			s[i] = ' ';
			i++;
			}
		}
	s[len] = '\0';
	reverse(s);
	}

void Giant_Blit_Word(int x,int y,char *string) {
int index;
for (index=0; string[index]!=0; index++)
{
if (string[index]!=' ')
{
if (string[index] == 'g' || string[index] == 'p' || string[index] == 'q' || string[index] == 'y')
	Giant_Blit_Letter(x+(index<<4),y+4,string[index]);
else if (string[index] == 'j') {
	Giant_Blit_Letter(x+(index<<4),y,'i');
	Giant_Blit_Letter(x+(index<<4),y+4,'j');
	}
else
Giant_Blit_Letter(x+(index<<4),y,string[index]);
}
}
}

void Load_Font(char *filename) {
	int i;
	fontpic = load_pcx(filename, null_palette);
	for (i = 0; i < 92; i++)
		Grab_Letter(fontpic, i);
      destroy_bitmap(fontpic);
	}

int Blit_Number(int x, int y, long int number) {
	int len;
	len = int_to_string(number, svar);
	Blit_Word(x,y,svar);
	return len;
	}

void Blit_Number_Space(int x, int y, long int number, int length) {
	int_to_score(number, svar, length);
	Blit_Word(x,y,svar);
	}

#endif

