#include <allegro.h>
#include "nsdefs.h"
#include "trigger.h"
#include "scrnfunx.h"
#include "tilefunx.h"
#include "readmap9.h"
#include "sprite8.h"
#include "textfunx.h"
#include "edscrol3.h"
#include "sprfxned.h"
#include "badguy.h"
#include "thing.h"
#include "stkeddat.h"
//#include "enbar.h"
#include <ctype.h>
#include <stdlib.h>
#include <malloc.h>
#include <stdio.h>

/* Globals */
sprite enemy[MAX_ENEMIES];
sprite cursor;
sprite arrow;
sprite sprites[MAX_SPRITES];
sprite_ptr priority_table[MAX_SPRITES];

char *message;
char messbuf[41];
char longmessbuf[100];
char *old_name;

BITMAP *hold_screen_buffer;
unsigned char full_screen_display = 0;
int tile_timing = 0;
unsigned char last_key_pressed;
int curr_trigger = 0;
unsigned char key_tracker[128];

char *file_name;
char *num_buffer;

int using_tile = 0;
int mouse_color = 2;
int cursor_pal = 0;

int object_frames[] = {-1,151,150,147,149,148,154};
int badguy_frames[] = {-1, 6, 15, 81, -1, 68, -1, -1, -1, 103, 35, 100, -1, -1, -1, -1, -1, -1, -1};

char *music_names[] = {"DIDN'T FORGET ABOUT DRE","STOMP DOWN","FLUFFY'S THEME","ROCK TUMBLER","FIG","SAY NOT","BOSS C","M TRAIN","DINNER ROLL"};
char *entrance_names[] = {"STANDING (NORMAL ENTRANCE)","JUMPING","CHARGING","WALK DOWN (FROM UPPER SCREEN)","WALK UP (FROM BOTTOM OF SCREEN)","DOUBLE JUMP (LIKE RHINO BOSS)","DROP FROM ABOVE","LEANING AGAINST WALL","SITTING","KNEELING, FACING RIGHT","KNEELING, FACING LEFT","KNEELING, FACING SCREEN","SLIDE DOWN CURTAINS"};
char *entrance_names_short[] = {"STANDING","JUMPING","CHARGING","WALK DOWN","WALK UP","DOUBLE JUMP","DROP","LEANING","SITTING","KNEEL/FC RIGHT","KNEEL/FC LEFT","KNEEL/FC SCREEN","DOWN CURTAINS"};
char *diff_strings[] = {"ALL","MED,HARD","HARD"};

DATAFILE *stalked_data; 


/* External variables */
extern int row_length;
extern int num_rows;
extern unsigned char *level;
extern int start_x = 0;
extern int start_y = 0; /* upper left corner of screen, tells
			      Draw_Screen where to start drawing from */
extern int screen_w = 288;
extern int bcount = 0;
extern int by = 0;
extern BITMAP *bg_pic;
extern char tile_file_name[];
extern char next_file_name[];
extern char bkgd_file_name[];
extern char trans_table[];
extern trigger trigger_points[MAX_TRIGGER_POINTS];
extern unsigned char number_of_things;
extern thing things[MAX_THINGS];
extern badguy badguylist[];

void Copy_Attributes(int enemy_num, int badguy_num) {
	sprites[enemy_num].name = badguylist[badguy_num].name;
	sprites[enemy_num].health = badguylist[badguy_num].stamina;
	sprites[enemy_num].max_health = badguylist[badguy_num].stamina;
	sprites[enemy_num].invulnerable_flag = 0;
	sprites[enemy_num].palnum = badguylist[badguy_num].palookup;
	sprites[enemy_num].type = badguylist[badguy_num].badguy_type;
	sprites[enemy_num].lvl = badguylist[badguy_num].strength_level;
	sprites[enemy_num].controlled_by = CPU_ENEMY;
	sprites[enemy_num].curr_state = STANDING;
	}

void Set_Priflags() {
	int i;
	for (i = 0; i < MAX_SPRITES; i++) {
		sprites[i].priflag = ((sprites[i].z * 1000) + ((sprites[i].type == EFFECT)? 250 : 0) + i - (((sprites[i].curr_state == HELD1) || (sprites[i].curr_state == HELD2) || (sprites[i].curr_state == HELD3))? 500 : 0));
		}
	}

void priswap(sprite_ptr spr[], int i, int j) {
	sprite_ptr temp;
	temp = spr[i];
	spr[i] = spr[j];
	spr[j] = temp;
	}

void prisort(sprite_ptr spr[], int left, int right) {
	int i, last;
	if (left >= right)
		return;
	priswap(spr, left, (left + right)/2);
	last = left;
	for (i = left+1; i <= right; i++) {
		if (spr[i]->priflag < spr[left]->priflag) {
			priswap(spr, ++last, i);
			}
		}
	priswap(spr, left, last);
	prisort(spr, left, last-1);
	prisort(spr, last+1, right);
	}

void Reset_Trigger_Points() {
	int i, j;
	for (i=0; i<MAX_TRIGGER_POINTS; i++) {
		trigger_points[i].stop_scroll = 0;
		trigger_points[i].xcoord = NO_TRIG;
		trigger_points[i].max_at_once = 0;
		trigger_points[i].total_badguys = 0;
		for (j=0; j<16; j++) {
			trigger_points[i].badguy[j].who = 0;
			trigger_points[i].badguy[j].how = 0;
			trigger_points[i].badguy[j].dif = 0;
			trigger_points[i].badguy[j].where_x = 0;
			trigger_points[i].badguy[j].where_y = 0;
			trigger_points[i].badguy[j].where_z = 128;
			}
		}
	}


void Blit_Tile(int xc,int yc,int c) {
     int x,y;
     for (y=0; y<16; y++) {
         for (x=0; x<16; x++) {
             if (tiles[c][y][x])
             double_buffer->line[yc+y][xc+x] = tiles[c][y][x];
             }
         }
     }


int Get_Press(int numkey) {
   if (!key[numkey]) {
      key_tracker[numkey] = 0;
      return 0;
      }
   else {
      if (key_tracker[numkey] == 1)
         return 0;
      else {
         key_tracker[numkey] = 1;
         return 1;
         }
      }
   }

char *Get_Line(int x, int y, char *buffer) {
      int c,i,index=0;
clear_keybuf();
for (i=0; i<13; i++)
	buffer[i]=' ';
	buffer[12]='\0';

Set_Priflags();
		prisort(priority_table, 0, MAX_SPRITES-1);
		Draw_Screen_Partial(start_x,start_y);
		/*for (i=0; i<MAX_SPRITES; i++) {
			if (priority_table[i]->type != EFFECT) {
				Blit_Shadow(priority_table[i], shad);
				}
			} */
		for (i = 0; i < MAX_SPRITES; i++) {
			Palette_Blit_Sprite(priority_table[i]);
			}

Blit_Word(0,192,message);
    Blit_Word(x, y, buffer);
    blit(double_buffer,screen,0,0,0,0,320,200);

while((c=(readkey()&0xff))!=13)
     {
     if (c==8 && index>0)
	{
	buffer[--index] = ' ';
	}
     else
     if (c>=46 && c<=122 && c!=47 && index<12)
	{
	buffer[index++] = toupper(c);
	}
	Set_Priflags();
	prisort(priority_table, 0, MAX_SPRITES-1);
	Draw_Screen_Partial(start_x,start_y);
	/*for (i=0; i<MAX_SPRITES; i++) {
		if (priority_table[i]->type != EFFECT) {
		Blit_Shadow(priority_table[i], shad);
		}
	} */
	for (i = 0; i < MAX_SPRITES; i++) {
		Palette_Blit_Sprite(priority_table[i]);
		}
    Blit_Word(0,192,message);
    Blit_Word(x, y, buffer);
    blit(double_buffer,screen,0,0,0,0,320,200);
    }

buffer[index] = 0;
Get_Press(KEY_ENTER);
return(buffer);

}

int Get_Number(int x, int y) {
      int c,i,index=0;
      int digit_limit = 5;
clear_keybuf();
for (i=0; i<6; i++)
	num_buffer[i]=' ';
	num_buffer[6]='\0';

Set_Priflags();
		prisort(priority_table, 0, MAX_SPRITES-1);
		Draw_Screen_Partial(start_x,start_y);
		/*for (i=0; i<MAX_SPRITES; i++) {
			if (priority_table[i]->type != EFFECT) {
				Blit_Shadow(priority_table[i], shad);
				}
			} */
		for (i = 0; i < MAX_SPRITES; i++) {
			Palette_Blit_Sprite(priority_table[i]);
			}
Blit_Word(0,192,message);
    Blit_Word(x, y, num_buffer);
    blit(double_buffer,screen,0,0,0,0,320,200);
while((c=(readkey()&0xff))!=13)
     {
     if (c==8 && index>0)
	{
	num_buffer[--index] = ' ';
	if (index == 0)
		digit_limit = 5;
	}
     else
     if (c == '-' && index == 0)
	{
	num_buffer[index++] = c;
	digit_limit = 6;
	}
     else
     if (c>=48 && c<=57 && index<digit_limit)
	{
	num_buffer[index++] = c;
	}
	Set_Priflags();
	prisort(priority_table, 0, MAX_SPRITES-1);
	Draw_Screen_Partial(start_x,start_y);
	/*for (i=0; i<MAX_SPRITES; i++) {
		if (priority_table[i]->type != EFFECT) {
			Blit_Shadow(priority_table[i], shad);
			}
		} */
	for (i = 0; i < MAX_SPRITES; i++) {
		Palette_Blit_Sprite(priority_table[i]);
		}
    Blit_Word(0,192,message);
    Blit_Word(x, y, num_buffer);
    blit(double_buffer,screen,0,0,0,0,320,200);
    }

num_buffer[index] = 0;
Get_Press(KEY_ENTER);
return(atoi(num_buffer));

}

int Are_You_Sure(char *about_what) {
	int answered = 0;
	int i;
	sprintf(messbuf, "%s: ARE YOU SURE? (Y/N)", about_what);
	message = messbuf;
	while (!answered) {
		if (Get_Press(KEY_Y)) {
			answered = 1;
			}
		if (Get_Press(KEY_N)) {
			answered = 2;
			}
		Set_Priflags();
		prisort(priority_table, 0, MAX_SPRITES-1);
		Draw_Screen_Partial(start_x,start_y);
		/*for (i=0; i<MAX_SPRITES; i++) {
			if (priority_table[i]->type != EFFECT) {
			Blit_Shadow(priority_table[i], shad);
			}
		} */
		for (i = 0; i < MAX_SPRITES; i++) {
			Palette_Blit_Sprite(priority_table[i]);
			}
		Blit_Word(0,192,message);
		blit(double_buffer,screen,0,0,0,0,320,200);
		}
	return answered;
	}

void Erase_Right_Side() {
	int i;
	for (i=288; i<SCREEN_WIDTH; i++) {
		vline(double_buffer,i,0,199,0);
		}
	}

void Save_File(int mode)
{
FILE *fp, *fopen();
int index;
int index2;
int i;
int decision = 0;
if (mode == 0) { // Mode 0 = regular save, mode 1 = quick save.
	for (index=0; index<13; index++)
		old_name[index] = file_name[index];
	message = "SAVE FILENAME:";
	Draw_Screen_Partial(start_x,start_y);
	Blit_Word(0, 192, message);
	blit(double_buffer,screen,0,0,0,0,320,200);
	Get_Line(120, 192, file_name);
	if (strcmp(file_name, "") == 0) {
		message = "SAVE CANCELLED.";
		for (index=0; index<13; index++)
			file_name[index] = old_name[index];
		return;
		}
	if ((_access(file_name,0)) != -1) {
		sprintf(messbuf,"%s EXISTS. OVERWRITE? Y/N",file_name);
		message = messbuf;
		Set_Priflags();
		prisort(priority_table, 0, MAX_SPRITES-1);
		Draw_Screen_Partial(start_x,start_y);
		for (i = 0; i < MAX_SPRITES; i++) {
			Palette_Blit_Sprite(priority_table[i]);
			}
		Blit_Word(0,192,message);
		blit(double_buffer,screen,0,0,0,0,320,200);
		while (!decision) {
			if (Get_Press(KEY_Y)) {
				decision = 1;
				}
			if (Get_Press(KEY_N)) {
				decision = 2;
				}
			}
		if (decision == 2) {
			message = "SAVE CANCELLED.";
			for (index=0; index<13; index++)
				file_name[index] = old_name[index];
			return;
			}
		}
	}
fp=fopen(file_name,"wb");
for (index=0; index<num_rows; index++) {
	for (index2=0; index2<row_length; index2++)
		putc(level[(index*row_length)+index2],fp);
	putc(255,fp);
	}
putc(254,fp);
for (index = 0; index < MAX_TRIGGER_POINTS; index++) {
	putc(trigger_points[index].stop_scroll,fp);
	putc((char)((trigger_points[index].xcoord)>>8),fp);
	putc((char)((trigger_points[index].xcoord)&0xff),fp);
	putc(trigger_points[index].max_at_once,fp);
	putc(trigger_points[index].total_badguys,fp);
	for (index2 = 0; index2 < 16; index2++) {
		putc(trigger_points[index].badguy[index2].who,fp);
		putc(trigger_points[index].badguy[index2].how,fp);
		putc(trigger_points[index].badguy[index2].dif,fp);
		putc((char)((trigger_points[index].badguy[index2].where_x)>>8),fp);
		putc((char)((trigger_points[index].badguy[index2].where_x)&0xff),fp);
		putc((char)((trigger_points[index].badguy[index2].where_y)>>8),fp);
		putc((char)((trigger_points[index].badguy[index2].where_y)&0xff),fp);
		putc((char)((trigger_points[index].badguy[index2].where_z)>>8),fp);
		putc((char)((trigger_points[index].badguy[index2].where_z)&0xff),fp);
		}
	}
for (index = 0; index < 12; index++) {
	putc(toupper(tile_file_name[index]),fp);
	}
putc(0,fp);
for (index = 0; index < 12; index++) {
	putc(toupper(next_file_name[index]),fp);
	}
putc(0,fp);
for (index = 0; index < 12; index++) {
	putc(toupper(bkgd_file_name[index]),fp);
	}
putc(0,fp);
putc(transparency,fp);
putc(relative_scroll_rate,fp);
putc(rise_rate,fp);
putc((char)(start_spot_x >> 8),fp);
putc((char)(start_spot_x &0xff),fp);
putc((char)(start_spot_y >> 8),fp);
putc((char)(start_spot_y &0xff),fp);
putc((char)(start_spot_z >> 8),fp);
putc((char)(start_spot_z &0xff),fp);
putc(how_player_enters,fp);
putc((char)(walk_to_spot_x >> 8),fp);
putc((char)(walk_to_spot_x &0xff),fp);
putc((char)(walk_to_spot_y >> 8),fp);
putc((char)(walk_to_spot_y &0xff),fp);
putc((char)(walk_to_spot_z >> 8),fp);
putc((char)(walk_to_spot_z &0xff),fp);
putc(how_player_exits,fp);
putc(left_end_type,fp);
putc(left_end_slant,fp);
putc((char)(left_end_offset >> 8),fp);
putc((char)(left_end_offset &0xff),fp);
putc(right_end_type,fp);
putc(right_end_slant,fp);
putc((char)(right_end_offset >> 8),fp);
putc((char)(right_end_offset &0xff),fp);
putc(top_end_type,fp);
putc(top_end_z,fp);
putc(bottom_end_type,fp);
putc(bottom_end_z,fp);
putc(color_cycle_low_end,fp);
putc(color_cycle_high_end,fp);
putc(color_cycle_speed,fp);
putc(music_num,fp);
putc(number_of_things,fp);
for (index = 0; index < MAX_THINGS; index++) {
	putc((char)(things[index].x >> 8),fp);
	putc((char)(things[index].x &0xff),fp);
	putc((char)(things[index].y >> 8),fp);
	putc((char)(things[index].y &0xff),fp);
	putc((char)(things[index].z >> 8),fp);
	putc((char)(things[index].z &0xff),fp);
	putc(things[index].type,fp);
	putc(things[index].palette,fp);
	putc(things[index].thing_inside,fp);
	}
fclose(fp);
sprintf(messbuf, "MAP SAVED AS %s.", file_name);
message = messbuf;
Blit_Word(0, 192, message);
blit(double_buffer,screen,0,0,0,0,320,200);
}

void Load_File()
{
message = "LOAD FILENAME:";
Draw_Screen_Partial(start_x,start_y);
Blit_Word(0, 192, message);
blit(double_buffer,screen,0,0,0,0,320,200);
Get_Line(120, 192, file_name);
if (strcmp(file_name, "") == 0) {
	message = "LOAD CANCELLED.";
	return;
	}
if ((_access(file_name,0)) != -1) {
	Clear_Level();
	Reset_Trigger_Points();
	Load_Map(file_name);
	sprintf(messbuf, "LOADED MAP %s.", file_name);
	}
else {
	sprintf(messbuf, "FILE %s NOT FOUND.", file_name);
	}
message = messbuf;
Blit_Word(0, 192, message);
blit(double_buffer,screen,0,0,0,0,320,200);
}

void Change_Tile_Set()
{
int index;
int found_dot = 0;
char trans_table_name[13];
for (index=0; index<13; index++)
	old_name[index] = tile_file_name[index];
message = "TILE SET FILENAME:";
Draw_Screen_Partial(start_x,start_y);
Blit_Word(0, 192, message);
blit(double_buffer,screen,0,0,0,0,320,200);
Get_Line(152, 192, tile_file_name);
if (strcmp(tile_file_name, "") == 0) {
	for (index=0; index<13; index++)
		tile_file_name[index] = old_name[index];
	message = "CHANGE TILE SET CANCELLED.";
	return;
	}
if ((_access(tile_file_name,0)) == -1) {
	sprintf(messbuf, "TILE SET %s NOT FOUND.", tile_file_name);
	message = messbuf;
	for (index=0; index<13; index++)
		tile_file_name[index] = old_name[index];
	return;
	}
Load_Tile_Set(tile_file_name);
index = 0;
while (!found_dot) {
   if (tile_file_name[index] == '.' || tile_file_name[index] == 0 || index > 12) {
      if (index > 8)
         index = 8;
      trans_table_name[index] = '.';
      trans_table_name[index+1] = 'T';
      trans_table_name[index+2] = 'R';
      trans_table_name[index+3] = 'A';
      trans_table_name[index+4] = 0;
      found_dot = 1;
      }
   else
       trans_table_name[index] = tile_file_name[index];
   index++;
   }
if ((access(trans_table_name, 0)) != -1)
   Load_Trans_Table(trans_table_name);
else
    Clear_Trans_Table();
sprintf(messbuf, "LOADED TILE SET %s.", tile_file_name);
message = messbuf;
Blit_Word(0, 192, message);
blit(double_buffer,screen,0,0,0,0,320,200);
}

void Show_Tile_Set_Name() {
	sprintf(messbuf, "TILE SET IS %s.", tile_file_name);
	message = messbuf;
	Draw_Screen_Partial(start_x,start_y);
	Blit_Word(0,192,message);
	blit(double_buffer,screen,0,0,0,0,320,200);
	}

void Change_Background()
{
int index;
for (index=0; index<13; index++)
	old_name[index] = bkgd_file_name[index];
message = "BACKGROUND FILENAME:";
Draw_Screen_Partial(start_x,start_y);
Blit_Word(0, 192, message);
blit(double_buffer,screen,0,0,0,0,320,200);
Get_Line(168, 192, bkgd_file_name);
if (strcmp(bkgd_file_name, "") == 0) {
	for (index=0; index<13; index++)
		bkgd_file_name[index] = old_name[index];
	message = "CHANGE BACKGROUND CANCELLED.";
	return;
	}
if ((_access(bkgd_file_name,0)) == -1) {
	sprintf(messbuf, "IMAGE %s NOT FOUND.", bkgd_file_name);
	message = messbuf;
	for (index=0; index<13; index++)
		bkgd_file_name[index] = old_name[index];
	return;
	}
bg_pic = load_pcx(bkgd_file_name,brizzle_palette);
sprintf(messbuf, "LOADED BACKGROUND %s.", bkgd_file_name);
message = messbuf;
Blit_Word(0, 192, message);
blit(double_buffer,screen,0,0,0,0,320,200);
}

void Show_Background_Name() {
	sprintf(messbuf, "BACKGROUND IS %s.", bkgd_file_name);
	message = messbuf;
	Draw_Screen_Partial(start_x,start_y);
	Blit_Word(0,192,message);
	blit(double_buffer,screen,0,0,0,0,320,200);
	}

void Change_Next_Scene()
{
int index;
for (index=0; index<13; index++)
	old_name[index] = next_file_name[index];
message = "NEXT SCENE FILENAME:";
Draw_Screen_Partial(start_x,start_y);
Blit_Word(0, 192, message);
blit(double_buffer,screen,0,0,0,0,320,200);
Get_Line(168, 192, next_file_name);
if (strcmp(next_file_name, "") == 0) {
	for (index=0; index<13; index++)
		next_file_name[index] = old_name[index];
	message = "CHANGE NEXT SCENE CANCELLED.";
	return;
	}
/* if ((_access(next_file_name,0)) == -1) {
	sprintf(messbuf, "FILE %s NOT FOUND.", next_file_name);
	for (index=0; index<13; index++)
		next_file_name[index] = old_name[index];
	return;
	} */
sprintf(messbuf, "NEXT SCENE SET TO %s.", next_file_name);
message = messbuf;
Blit_Word(0, 192, message);
blit(double_buffer,screen,0,0,0,0,320,200);
}

void Show_Next_Scene_Name() {
	sprintf(messbuf, "NEXT SCENE IS %s.", next_file_name);
	message = messbuf;
	Draw_Screen_Partial(start_x,start_y);
	Blit_Word(0,192,message);
	blit(double_buffer,screen,0,0,0,0,320,200);
	}

void New_Level() {
	int old_row_length = row_length;
	Draw_Screen_Partial(start_x,start_y);
	message = "LENGTH OF NEW LEVEL:";
	Blit_Word(0, 192, message);
	blit(double_buffer,screen,0,0,0,0,320,200);
	row_length = Get_Number(168,192);
	if (row_length < 20) {
		message = "MINIMUM LEVEL LENGTH IS 20 BLOCKS.";
		row_length = old_row_length;
		return;
		}
	else if (row_length > (MAX_LEVEL_SIZE / num_rows)) {
		sprintf(messbuf, "TOO BIG. MAX SIZE= %ld BLOCKS.", MAX_LEVEL_SIZE);
		message = messbuf;
		return;
		}
	else {
		Clear_Level();
		Reset_Trigger_Points();
		start_spot_x = 32; // default values
		start_spot_y = 0;
		start_spot_z = 160;
		walk_to_spot_x = 360;
		walk_to_spot_y = 0;
		walk_to_spot_z = 160;
		top_end_z = 128;
		bottom_end_z = 199;
		start_x = 0;
		Draw_Screen_Partial(start_x,start_y);
		message = "NEW LEVEL STARTED.";
		Blit_Word(0, 192, message);
		blit(double_buffer,screen,0,0,0,0,320,200);
		}
	}

void Enlarge_Level(int new_row_length) {
	long int i;
	int j, k;
	for (i=(num_rows*row_length)-1; i>=0; i--) {
		level[i+((new_row_length-row_length)*(i/row_length))]=level[i];
		}
	for (j=0; j<num_rows; j++) {
		for (k=0; k<(new_row_length-row_length); k++) {
			level[(j*new_row_length)+row_length+k]=0;
			}
		}
	row_length = new_row_length;
	}

void Cut_Level(int new_row_length) {
	long int i;
	for (i=0; i<(num_rows*row_length); i++) {
		level[i]=level[i+((row_length-new_row_length)*(i/new_row_length))];
		}
	row_length = new_row_length;
	}

void Resize_Level() {
	int proposed_row_length = 0;
	long int proposed_total_size = 0;
	message = "NEW LEVEL LENGTH:";
	Draw_Screen_Partial(start_x,start_y);
	Blit_Word(0,192,message);
	blit(double_buffer,screen,0,0,0,0,320,200);
	proposed_row_length = Get_Number(144,192);
	proposed_total_size = (long int)proposed_row_length * num_rows;
	if (proposed_row_length == 0) {
		message = "RESIZE LEVEL CANCELLED.";
		return;
		}
	else if (proposed_row_length < 20) {
		message = "MINIMUM LEVEL LENGTH IS 20 BLOCKS.";
		return;
		}
	else if (proposed_total_size > MAX_LEVEL_SIZE) {
		sprintf(messbuf, "TOO BIG. MAX SIZE= %ld BLOCKS.", MAX_LEVEL_SIZE);
		message = messbuf;
		return;
		}
	else if (proposed_row_length == row_length) {
		message = "LEVEL IS ALREADY THAT SIZE.";
		return;
		}
	else {
		if (proposed_row_length > row_length)
			Enlarge_Level(proposed_row_length);
		else if (proposed_row_length < row_length) // and it should be, or something is seriously wrong
			Cut_Level(proposed_row_length);
		}
	message = "LEVEL RESIZED.";
	}

void trigswap(trigger tp[], int i, int j) {
	trigger temp;
	temp = tp[i];
	tp[i] = tp[j];
	tp[j] = temp;
	}

void trigsort(trigger tp[], int left, int right) {
	int i, last;
	if (left >= right)
		return;
	trigswap(tp, left, (left + right)/2);
	last = left;
	for (i = left+1; i <= right; i++)
		if (tp[i].xcoord < tp[left].xcoord)
			trigswap(tp, ++last, i);
	trigswap(tp, left, last);
	trigsort(tp, left, last-1);
	trigsort(tp, last+1, right);
	}

void thingswap(thing th[], int i, int j) {
	thing temp;
	temp.type = th[i].type;
	temp.x = th[i].x;
	temp.y = th[i].y;
	temp.z = th[i].z;
	temp.palette = th[i].palette;
	temp.thing_inside = th[i].thing_inside;
	th[i].type = th[j].type;
	th[i].x = th[j].x;
	th[i].y = th[j].y;
	th[i].z = th[j].z;
	th[i].palette = th[j].palette;
	th[i].thing_inside = th[j].thing_inside;
	th[j].type = temp.type;
	th[j].x = temp.x;
	th[j].y = temp.y;
	th[j].z = temp.z;
	th[j].palette = temp.palette;
	th[j].thing_inside = temp.thing_inside;
	}

void thingsort(thing th[], int left, int right) {
	int i, last;
	if (left >= right)
		return;
	thingswap(th, left, (left + right)/2);
	last = left;
	for (i = left+1; i <= right; i++)
		if ((th[i].x) < (th[left].x))
			thingswap(th, ++last, i);
	thingswap(th, left, last);
	thingsort(th, left, last-1);
	thingsort(th, last+1, right);
	}

void Insert_Trigger_Point() {
	int i;
	int empty_slot = -1;
	int already_taken = 0;
	for (i=0;i<MAX_TRIGGER_POINTS;i++) {
		if (trigger_points[i].xcoord == NO_TRIG) {
			empty_slot = i;
			break;
			}
		}
	if (empty_slot == -1) {
		message = "ALL TRIGGER POINTS ARE IN USE.";
		return;
		}
	for (i=0;i<MAX_TRIGGER_POINTS;i++) {
		if (trigger_points[i].xcoord == start_x)
			already_taken = 1;
		}
	if (already_taken) {
		message = "ALREADY A TRIGGER POINT HERE.";
		return;
		}
	if (start_x > (row_length * 16) - SCREEN_WIDTH) {
		message = "TOO FAR TO RIGHT- UNREACHABLE.";
		return;
		}
	trigger_points[empty_slot].xcoord = start_x;
	trigsort(trigger_points, 0, MAX_TRIGGER_POINTS-1);
	sprintf(messbuf, "TRIGGER POINT ADDED AT X=%d.", start_x);
	message = messbuf;
	}

void View_Trigger_Points() {
	if (trigger_points[curr_trigger].xcoord == NO_TRIG) {
		if (curr_trigger == 0) {
			message = "NO TRIGGER POINTS IN THIS MAP.";
			return;
			}
		else {
			curr_trigger = 0;
			}
		if (trigger_points[curr_trigger].xcoord == NO_TRIG) {
			message = "NO TRIGGER POINTS IN THIS MAP.";
			return;
			}
		}
	start_x = trigger_points[curr_trigger].xcoord;
	sprintf(messbuf,"TRIGGER POINT %d, AT X=%d.",curr_trigger,start_x);
	message = messbuf;
	curr_trigger++;
	}

void Go_To_Trigger_Point() {
	int which;
	message = "GO TO WHICH TRIGGER POINT?";
	Draw_Screen_Partial(start_x,start_y);
	Blit_Word(0,192,message);
	blit(double_buffer,screen,0,0,0,0,320,200);
	which = Get_Number(216, 192);
	if (which < 0 || which > 99) {
		message = "OUT OF RANGE 0-99.";
		return;
		}
	if (trigger_points[which].xcoord == NO_TRIG) {
		message = "NO TRIGGER POINT WITH THAT NUMBER.";
		return;
		}
	curr_trigger = which;
	start_x = trigger_points[which].xcoord;
	sprintf(messbuf, "TRIGGER POINT %d, AT X=%d.",which,start_x);
	message = messbuf;
	}

int Check_On_Trigger_Point() {
	int i;
	int on_trig = -1;
	for (i=0;i<MAX_TRIGGER_POINTS;i++) {
		if (trigger_points[i].xcoord == start_x)
			on_trig = i;
		}
	return on_trig;
	}

void Delete_Trigger_Point(int i) {
	int j;
	trigger_points[i].stop_scroll = 0;
	trigger_points[i].xcoord = NO_TRIG;
	trigger_points[i].max_at_once = 0;
	trigger_points[i].total_badguys = 0;
	for (j=0; j<16; j++) {
		trigger_points[i].badguy[j].who = 0;
		trigger_points[i].badguy[j].how = 0;
		trigger_points[i].badguy[j].dif = 0;
		trigger_points[i].badguy[j].where_x = NOWHERE;
		trigger_points[i].badguy[j].where_y = NOWHERE;
		trigger_points[i].badguy[j].where_z = NOWHERE;
		}
	trigsort(trigger_points, 0, MAX_TRIGGER_POINTS-1);
	sprintf(messbuf, "TRIGGER POINT AT X=%d DELETED.", start_x);
	message = messbuf;
	}

int Choose_Badguy() {
	sprite display_badguy;
	int i;
	int done = 0;
	int on_badguy = -1;
	Sprite_Init(&display_badguy);
	display_badguy.flipflag = NOFLIP;
	Place_Sprite(&display_badguy,start_x+39,135,0);
	blit(double_buffer,hold_screen_buffer,0,0,0,0,320,200);
	while (!done) {
		if (Get_Press(KEY_ESC)) {
			done = 1;
			blit(hold_screen_buffer,double_buffer,0,0,0,0,320,200);
			return -1;
			}
		if (mouse_b & 1) {
			if (on_badguy != -1) {
				done = 1;
				blit(hold_screen_buffer,double_buffer,0,0,0,0,320,200);
				return on_badguy;
				}
			}
		blit(hold_screen_buffer,double_buffer,0,0,0,0,320,200);
		rectfill(double_buffer, 8, 8, SCREEN_WIDTH-9, SCREEN_HEIGHT-9, 26);
		rect(double_buffer, 8, 8, SCREEN_WIDTH-9, SCREEN_HEIGHT-9, 162);
		if ((mouse_x >= 70) && (mouse_y >= 16) && (mouse_y < 184) && ((((mouse_x-70)/58)*28)+((mouse_y-16)/6)) < (sizeof badguylist / sizeof badguylist[0])) {
			on_badguy = ((((mouse_x-70)/58)*28)+((mouse_y-16)/6));
			rectfill(double_buffer,70+(((mouse_x-70)/58)*58),16+(((mouse_y-16)/6)*6),127+(((mouse_x-70)/58)*58),21+(((mouse_y-16)/6)*6),71);
			display_badguy.curr_frame = (badguylist[on_badguy].badguy_type == NO_TYPE)? badguy_frames[badguylist[on_badguy].badguy_type] : badguy_frames[(badguylist[on_badguy].badguy_type)-999];
			display_badguy.palnum = badguylist[on_badguy].palookup;
			textprintf_centre(double_buffer,stalked_data[tiny_font].dat,39,150,-1,"HEALTH = %d",badguylist[on_badguy].stamina);
			if (on_badguy == 8 || on_badguy == 18) {
				textout_centre(double_buffer,stalked_data[tiny_font].dat,"BOSS",39,162,-1);
				}
			}
		else {
			on_badguy = -1;
			display_badguy.curr_frame = -1;
			}
		Palette_Blit_Sprite(&display_badguy);
		for (i = 0; i < (sizeof badguylist / sizeof badguylist[0]); i++) {
			textprintf(double_buffer, stalked_data[tiny_font].dat, 70+((i/28)*58), 16+((i%28)*6), -1, "%s", badguylist[i].name);
			}
		draw_sprite(double_buffer,stalked_data[mouse_arrow].dat,mouse_x,mouse_y);
		blit(double_buffer,screen,0,0,0,0,320,200);
		}
	}

int Choose_Entrance() {
	int columns = 1;
	int rows = (sizeof entrance_names / sizeof entrance_names[0]);
	int column_width = 124; // row height is always 6
	int left_side_margin = 8;
	int on_entrance = -1;
	int done = 0;
	int i;
	int left_box_edge,right_box_edge,top_box_edge,bottom_box_edge,leftmost_column_start,topmost_row_start,rightmost_column_end,bottommost_row_end;
	left_box_edge = (screen_w-((columns*column_width)+left_side_margin+8))/2;
	leftmost_column_start = (left_box_edge + left_side_margin);
	right_box_edge = (leftmost_column_start+(columns*column_width)+7);
	rightmost_column_end = right_box_edge - 8;
	top_box_edge = (SCREEN_HEIGHT-(((rows+2)*6)+16))/2;
	topmost_row_start = top_box_edge + 20;
	bottom_box_edge = (top_box_edge + ((rows+2)*6)) + 15;
	bottommost_row_end = bottom_box_edge - 8;
	blit(double_buffer,hold_screen_buffer,0,0,0,0,320,200);
	while (!done) {
		if (Get_Press(KEY_ESC)) {
			done = 1;
			blit(hold_screen_buffer,double_buffer,0,0,0,0,320,200);
			return -1;
			}
		if (mouse_b & 1) {
			if (on_entrance != -1) {
				done = 1;
				blit(hold_screen_buffer,double_buffer,0,0,0,0,320,200);
				return on_entrance;
				}
			}
		blit(hold_screen_buffer,double_buffer,0,0,0,0,320,200);
		rectfill(double_buffer, left_box_edge, top_box_edge, right_box_edge, bottom_box_edge, 26);
		rect(double_buffer, left_box_edge, top_box_edge, right_box_edge, bottom_box_edge, 162);
		if ((mouse_x >= leftmost_column_start) && (mouse_y >= topmost_row_start) && (mouse_y < bottommost_row_end) && ((((mouse_x-leftmost_column_start)/column_width)*rows)+((mouse_y-topmost_row_start)/6)) < (sizeof entrance_names / sizeof entrance_names[0])) {
			on_entrance = ((((mouse_x-leftmost_column_start)/column_width)*rows)+((mouse_y-topmost_row_start)/6));
			rectfill(double_buffer,leftmost_column_start+(((mouse_x-leftmost_column_start)/column_width)*column_width),topmost_row_start+(((mouse_y-topmost_row_start)/6)*6),((leftmost_column_start+column_width)-1)+(((mouse_x-leftmost_column_start)/column_width)*column_width),(topmost_row_start+5)+(((mouse_y-topmost_row_start)/6)*6),71);
			}
		else {
			on_entrance = -1;
			}
		textout_centre(double_buffer,stalked_data[tiny_font].dat,"CHOOSE ENTRANCE TYPE",(screen_w/2),(top_box_edge+8),-1);
		for (i = 0; i < (sizeof entrance_names / sizeof entrance_names[0]); i++) {
			textprintf(double_buffer, stalked_data[tiny_font].dat, leftmost_column_start+((i/rows)*column_width), topmost_row_start+((i%rows)*6), -1, "%s", entrance_names[i]);
			}
		draw_sprite(double_buffer,stalked_data[mouse_arrow].dat,mouse_x,mouse_y);
		blit(double_buffer,screen,0,0,0,0,320,200);
		}
	}

void Trig_Edit_Mode() {
	int departing = 0;
	int editing_field = 0;
	int on_badguy = 0;
	int i;
	int j;
	int blink_timer = 0;
	int view_items = 1;
	full_screen_display = 0;
	sprintf(longmessbuf,"");
	while (!departing) {
		if (editing_field == 0) { // Stop scroll
			if (trigger_points[curr_trigger].stop_scroll == 0)
				sprintf(longmessbuf,"STOP SCROLL: NO");
			else
				sprintf(longmessbuf,"STOP SCROLL: YES");
			if (key[KEY_UP]) { // up
				// if (key_tracker[72] < 2) {

					trigger_points[curr_trigger].stop_scroll = 1;
					// }
				}
			if (key[KEY_DOWN]) { // down
				// if (key_tracker[80] < 2) {

					trigger_points[curr_trigger].stop_scroll = 0;
					// }
				}
			if (Get_Press(KEY_RIGHT)) { // right
				// if (key_tracker[77] < 2) {

					editing_field++;
					// }
				}
			}
		if (editing_field == 1) { // Max at once
			sprintf(longmessbuf,"MAX ENEMIES AT ONCE: %d",trigger_points[curr_trigger].max_at_once);
			if (Get_Press(KEY_UP)) { // up
				// if (key_tracker[72] < 2) {

					if (trigger_points[curr_trigger].max_at_once < 6)
						trigger_points[curr_trigger].max_at_once++;
					// }
				}
			if (Get_Press(KEY_DOWN)) { // down
				// if (key_tracker[80] < 2) {

					if (trigger_points[curr_trigger].max_at_once > 1)
						trigger_points[curr_trigger].max_at_once--;
					// }
				}
			if (Get_Press(KEY_RIGHT)) { // right
				// if (key_tracker[77] < 2) {

					editing_field++;
					// }
				}
			if (Get_Press(KEY_LEFT)) { // left
				// if (key_tracker[75] < 2) {

					editing_field--;
					// }
				}
			}
		if (editing_field == 2) { // Total badguys at trigger point
			sprintf(longmessbuf,"TOTAL ENEMIES HERE: %d",trigger_points[curr_trigger].total_badguys);
			if (Get_Press(KEY_UP)) { // up
				// if (key_tracker[72] < 2) {

					if (trigger_points[curr_trigger].total_badguys < 16)
						trigger_points[curr_trigger].total_badguys++;
					// }
				}
			if (Get_Press(KEY_DOWN)) { // down
				// if (key_tracker[80] < 2) {

					if (trigger_points[curr_trigger].total_badguys > 0)
						trigger_points[curr_trigger].total_badguys--;
					// }
				}
			if (Get_Press(KEY_RIGHT)) { // right
				// if (key_tracker[77] < 2) {

					if (trigger_points[curr_trigger].total_badguys > 0)
						editing_field++;
					// }
				}
			if (Get_Press(KEY_LEFT)) { // left
				// if (key_tracker[75] < 2) {

					editing_field--;
					// }
				}
			}
		if (editing_field == 3) { // List of badguys
			sprintf(longmessbuf,"%s X=%d Y=%d Z=%d ST=%d DIF=%s ENT=%s",badguylist[trigger_points[curr_trigger].badguy[on_badguy].who].name,trigger_points[curr_trigger].badguy[on_badguy].where_x,trigger_points[curr_trigger].badguy[on_badguy].where_y,trigger_points[curr_trigger].badguy[on_badguy].where_z,badguylist[trigger_points[curr_trigger].badguy[on_badguy].who].stamina,diff_strings[trigger_points[curr_trigger].badguy[on_badguy].dif],entrance_names_short[trigger_points[curr_trigger].badguy[on_badguy].how]);
			if (Get_Press(KEY_UP)) { // up
				// if (key_tracker[72] < 2) {

					if (on_badguy > 0)
						on_badguy--;
					// }
				}
			if (Get_Press(KEY_DOWN)) { // down
				// if (key_tracker[80] < 2) {

					if (on_badguy < trigger_points[curr_trigger].total_badguys - 1)
						on_badguy++;
					// }
				}
			if (Get_Press(KEY_LEFT)) { // left
				// if (key_tracker[75] < 2) {

					editing_field--;
					// }
				}
			if (Get_Press(KEY_MINUS)) {
				// if (key_tracker[12] < 2) {

					if (trigger_points[curr_trigger].badguy[on_badguy].who > 0)
						trigger_points[curr_trigger].badguy[on_badguy].who--;
					// }
				}
			if (Get_Press(KEY_EQUALS)) {
				// if (key_tracker[13] < 2) {

					if (trigger_points[curr_trigger].badguy[on_badguy].who < (sizeof badguylist / sizeof badguylist[0])-1)
						trigger_points[curr_trigger].badguy[on_badguy].who++;
					// }
				}
			if (Get_Press(KEY_OPENBRACE)) {
				// if (key_tracker[26] < 2) {
               if (trigger_points[curr_trigger].badguy[on_badguy].how > 0)
					trigger_points[curr_trigger].badguy[on_badguy].how--;
					// }
				}
			if (Get_Press(KEY_CLOSEBRACE)) {
				// if (key_tracker[27] < 2) {

				if (trigger_points[curr_trigger].badguy[on_badguy].how < 12)
					trigger_points[curr_trigger].badguy[on_badguy].how++;
					// }
				}
			if (Get_Press(KEY_H)) {
				i = Choose_Entrance();
				if (i != -1) {
					trigger_points[curr_trigger].badguy[on_badguy].how = i;
					}
				}
			if (key[KEY_0]) {
				// if (key_tracker[11] < 2) {

					trigger_points[curr_trigger].badguy[on_badguy].dif = 0;
					// }
				}
			if (key[KEY_1]) {
				// if (key_tracker[2] < 2) {

					trigger_points[curr_trigger].badguy[on_badguy].dif = 1;
					// }
				}
			if (key[KEY_2]) {
				// if (key_tracker[3] < 2) {

					trigger_points[curr_trigger].badguy[on_badguy].dif = 2;
					// }
				}
			if (Get_Press(KEY_X)) {
				// if (key_tracker[45] < 2) {

				message = "BAD GUY RELATIVE X:";
				Draw_Screen_Partial(start_x,start_y);
				Blit_Word(0,192,message);
				blit(double_buffer,screen,0,0,0,0,320,200);
				trigger_points[curr_trigger].badguy[on_badguy].where_x = Get_Number(160,192);
					// }
				}
			if (Get_Press(KEY_Y)) {
				// if (key_tracker[21] < 2) {

				message = "BAD GUY Y:";
				Draw_Screen_Partial(start_x,start_y);
				Blit_Word(0,192,message);
				blit(double_buffer,screen,0,0,0,0,320,200);
				trigger_points[curr_trigger].badguy[on_badguy].where_y = Get_Number(88,192);
					// }
				}
			if (Get_Press(KEY_Z)) {
				// if (key_tracker[44] < 2) {

				message = "BAD GUY Z:";
				Draw_Screen_Partial(start_x,start_y);
				Blit_Word(0,192,message);
				blit(double_buffer,screen,0,0,0,0,320,200);
				trigger_points[curr_trigger].badguy[on_badguy].where_z = Get_Number(88,192);
					// }
				}
			if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
				if (Get_Press(KEY_4_PAD)) {
					trigger_points[curr_trigger].badguy[on_badguy].where_x--;
					}
				}
			else if (key[KEY_4_PAD]) {
				trigger_points[curr_trigger].badguy[on_badguy].where_x--;
				}
			if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
				if (Get_Press(KEY_6_PAD)) {
					trigger_points[curr_trigger].badguy[on_badguy].where_x++;
					}
				}
			else if (key[KEY_6_PAD]) {
				trigger_points[curr_trigger].badguy[on_badguy].where_x++;
				}
			if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
				if (Get_Press(KEY_8_PAD)) {
					trigger_points[curr_trigger].badguy[on_badguy].where_z--;
					}
				}
			else if (key[KEY_8_PAD]) {
				trigger_points[curr_trigger].badguy[on_badguy].where_z--;
				}
			if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
				if (Get_Press(KEY_2_PAD)) {
					trigger_points[curr_trigger].badguy[on_badguy].where_z++;
					}
				}
			else if (key[KEY_2_PAD]) {
				trigger_points[curr_trigger].badguy[on_badguy].where_z++;
				}
			if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
				if (Get_Press(KEY_MINUS_PAD)) {
					trigger_points[curr_trigger].badguy[on_badguy].where_y--;
					}
				}
			else if (key[KEY_MINUS_PAD]) {
				trigger_points[curr_trigger].badguy[on_badguy].where_y--;
				}
			if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
				if (Get_Press(KEY_PLUS_PAD)) {
					if (trigger_points[curr_trigger].badguy[on_badguy].where_y < 0) {
						trigger_points[curr_trigger].badguy[on_badguy].where_y++;
						}
					}
				}
			else if (key[KEY_PLUS_PAD]) {
				if (trigger_points[curr_trigger].badguy[on_badguy].where_y < 0) {
					trigger_points[curr_trigger].badguy[on_badguy].where_y++;
					}
				}
			if (Get_Press(KEY_5_PAD)) {
				trigger_points[curr_trigger].badguy[on_badguy].where_x = (SCREEN_WIDTH/2);
				trigger_points[curr_trigger].badguy[on_badguy].where_y = 0;
				trigger_points[curr_trigger].badguy[on_badguy].where_z = (top_end_z+bottom_end_z)/2;
				}
			if (Get_Press(KEY_INSERT)) {
				// if (key_tracker[82] < 2) {

				for(i=trigger_points[curr_trigger].total_badguys-1;i>on_badguy;i--) {
					trigger_points[curr_trigger].badguy[i] = trigger_points[curr_trigger].badguy[i-1];
					}
				trigger_points[curr_trigger].badguy[i].who = 0;
				trigger_points[curr_trigger].badguy[i].how = 0;
				trigger_points[curr_trigger].badguy[i].dif = 0;
				trigger_points[curr_trigger].badguy[i].where_x = NOWHERE;
				trigger_points[curr_trigger].badguy[i].where_y = NOWHERE;
				trigger_points[curr_trigger].badguy[i].where_z = NOWHERE;
					// }
				}
			if (Get_Press(KEY_DEL)) {
				// if (key_tracker[83] < 2) {

				for(i=on_badguy;i<trigger_points[curr_trigger].total_badguys;i++) {
					trigger_points[curr_trigger].badguy[i] = trigger_points[curr_trigger].badguy[i+1];
					}
				trigger_points[curr_trigger].badguy[trigger_points[curr_trigger].total_badguys].who = 0;
				trigger_points[curr_trigger].badguy[trigger_points[curr_trigger].total_badguys].how = 0;
				trigger_points[curr_trigger].badguy[trigger_points[curr_trigger].total_badguys].dif = 0;
				trigger_points[curr_trigger].badguy[trigger_points[curr_trigger].total_badguys].where_x = NOWHERE;
				trigger_points[curr_trigger].badguy[trigger_points[curr_trigger].total_badguys].where_y = NOWHERE;
				trigger_points[curr_trigger].badguy[trigger_points[curr_trigger].total_badguys].where_z = NOWHERE;
					// }
				}
			if (Get_Press(KEY_ENTER)) {
				i = Choose_Badguy();
				if (i != -1) {
					trigger_points[curr_trigger].badguy[on_badguy].who = i;
					}
				}
			blink_timer++;
			if (blink_timer == 20) {
				blink_timer = 0;
				}
			}
		else {
			blink_timer = 0;
			}
		if (Get_Press(KEY_I)) {
			if (view_items == 0) {
				view_items = 1;
				sprintf(longmessbuf,"ITEMS RESTORED TO VIEW.");
				}
			else {
				view_items = 0;
				sprintf(longmessbuf,"ITEMS HIDDEN FROM VIEW.");
				}
			}
		if (Get_Press(KEY_TAB)) {
			if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
				curr_trigger--;
				if (curr_trigger < 0) {
					curr_trigger = (MAX_TRIGGER_POINTS-1);
					while (trigger_points[curr_trigger].xcoord == NO_TRIG) {
						curr_trigger--;
						}
					}
				}
			else {
				curr_trigger++;
				if (trigger_points[curr_trigger].xcoord == NO_TRIG) {
					curr_trigger = 0;
					}
				}
			on_badguy = 0;
			start_x = trigger_points[curr_trigger].xcoord;
			if (editing_field == 3 && trigger_points[curr_trigger].total_badguys == 0) {
				editing_field = 2;
				}
			}
		if (Get_Press(KEY_E) || Get_Press(KEY_ESC)) {
			// if (key_tracker[18] < 2) {

				departing = 1;
				// }
			}
		Draw_Screen_Partial(start_x,start_y);
		j = 0;
		if (view_items) {
			for (i = 0; i < number_of_things; i++) {
				if (things[i].type != 0) {
					if (((things[i].x + frame_ptrs[object_frames[things[i].type]][0]) < (start_x+(SCREEN_WIDTH-32))) && (((things[i].x + frame_ptrs[object_frames[things[i].type]][0] + (unsigned char)frame_ptrs[object_frames[things[i].type]][2]) - 1) >= start_x)) {
						if (j < MAX_SPRITES) {
							sprites[j].curr_frame = object_frames[things[i].type];
							Place_Sprite(&sprites[j], things[i].x, things[i].y, things[i].z);
							sprites[j].palnum = things[i].palette;
							sprites[j].flipflag = NOFLIP;
							sprites[j].var1 = 0;
							j++;
							}
						}
					}
				}
			}
		for (i = 0; i < trigger_points[curr_trigger].total_badguys; i++) {
			if (j < MAX_SPRITES) {
				sprites[j].curr_frame = (badguylist[trigger_points[curr_trigger].badguy[i].who].badguy_type == NO_TYPE)? badguy_frames[badguylist[trigger_points[curr_trigger].badguy[i].who].badguy_type] : badguy_frames[(badguylist[trigger_points[curr_trigger].badguy[i].who].badguy_type)-999];
				Place_Sprite(&sprites[j], (start_x+trigger_points[curr_trigger].badguy[i].where_x), trigger_points[curr_trigger].badguy[i].where_y, trigger_points[curr_trigger].badguy[i].where_z);
				sprites[j].palnum = badguylist[trigger_points[curr_trigger].badguy[i].who].palookup;
				if (sprites[j].x > start_x+(screen_w/2)) {
					sprites[j].flipflag = FLIP;
					}
				else {
					sprites[j].flipflag = NOFLIP;
					}
				if (i == on_badguy) {
					sprites[j].var1 = 1;
					}
				else {
					sprites[j].var1 = 0;
					}
				j++;
				}
			}
		while (j < MAX_SPRITES) {
			sprites[j].curr_frame = -1;
			Place_Sprite(&sprites[j], NOWHERE, NOWHERE, NOWHERE);
			sprites[j].palnum = 0;
			sprites[j].flipflag = NOFLIP;
			j++;
			}
		Set_Priflags();
		prisort(priority_table, 0, MAX_SPRITES-1);
		Draw_Screen(start_x,start_y);
		for (i = 0; i < MAX_SPRITES; i++) {
			if (!(blink_timer >= 10 && priority_table[i]->var1)) {
				if (!Palette_Blit_Sprite(priority_table[i])) {
					if (priority_table[i]->x < start_x) {
						draw_sprite(double_buffer,stalked_data[ground_arrow].dat,4,priority_table[i]->z-5);
						}
					else if (priority_table[i]->x >= (start_x+screen_w)) {
						draw_sprite_h_flip(double_buffer,stalked_data[ground_arrow].dat,(screen_w-19),priority_table[i]->z-5);
						}
					else if (priority_table[i]->z > SCREEN_HEIGHT) {
						draw_sprite(double_buffer,stalked_data[ground_arrow_down].dat,(priority_table[i]->x-start_x)-7,SCREEN_HEIGHT-22);
						}
					}
				}
			}
		Blit_Word(0,0,"TRIGGER POINT EDITING MODE");
		Blit_Word(0,8,"TRIGGER POINT #");
		Blit_Number(120,8,curr_trigger);
		Blit_Word(0,16,"X=");
		Blit_Number(16,16,start_x);
		if (view_items == 0) {
			Blit_Word(0,24,"THINGS HIDDEN");
			}
		textout(double_buffer,stalked_data[tiny_font].dat,longmessbuf,0,192,-1);
		Erase_Right_Side();
		Blit_Word(288,0,"BAD");
		Blit_Word(288,8,"GUYS");
		for(i=0;i<(trigger_points[curr_trigger].total_badguys);i++) {
			Blit_Number(288,(i+3)*8,trigger_points[curr_trigger].badguy[i].who);
			if (on_badguy == i)
				Blit_Letter(304,(i+3)*8,'*');
			else
				Blit_Letter(304,(i+3)*8,':');
			Blit_Number(312,(i+3)*8,trigger_points[curr_trigger].badguy[i].dif);
			}
		vsync();
		blit(double_buffer,screen,0,0,0,0,320,200);
		}
	message="TRIGGER POINT EDITING MODE EXITED.";
	}

void Attribute_Edit_Mode() {
   int editing_field = 0;
   int departing = 0;
   int attribute_values[24];
   int att_high_limits[24]={1,127,127,32767,32767,32767,255,32767,32767,32767,255,255,127,32767,255,127,32767,127,255,127,255,255,255,255};
   int att_low_limits[24]={0,-128,-128,-32768,-32768,-32768,0,-32768,-32768,-32768,0,0,-128,-32768,0,-128,-32768,-128,0,-128,0,0,0,0};
   int index;
   int i,j;
   
   attribute_values[0] = transparency;
   attribute_values[1] = relative_scroll_rate;
   attribute_values[2] = rise_rate;
   attribute_values[3] = start_spot_x;
   attribute_values[4] = start_spot_y;
   attribute_values[5] = start_spot_z;
   attribute_values[6] = how_player_enters;
   attribute_values[7] = walk_to_spot_x;
   attribute_values[8] = walk_to_spot_y;
   attribute_values[9] = walk_to_spot_z;
   attribute_values[10] = how_player_exits;
   attribute_values[11] = left_end_type;
   attribute_values[12] = left_end_slant;
   attribute_values[13] = left_end_offset;
   attribute_values[14] = right_end_type;
   attribute_values[15] = right_end_slant;
   attribute_values[16] = right_end_offset;
   attribute_values[17] = top_end_type;
   attribute_values[18] = top_end_z;
   attribute_values[19] = bottom_end_type;
   attribute_values[20] = bottom_end_z;
   attribute_values[21] = color_cycle_low_end;
   attribute_values[22] = color_cycle_high_end;
   attribute_values[23] = color_cycle_speed;
   message = "ATTRIBUTE EDITING MODE";
   while (!departing) {
      if (Get_Press(KEY_UP))
         if (editing_field > 0)
            editing_field--;
      if (Get_Press(KEY_DOWN))
         if (editing_field < 23)
            editing_field++;
      if (Get_Press(KEY_RIGHT)) {
         if (attribute_values[editing_field] < att_high_limits[editing_field])
            attribute_values[editing_field]++;
         }
      if (Get_Press(KEY_LEFT)) {
         if (attribute_values[editing_field] > att_low_limits[editing_field])
            attribute_values[editing_field]--;
         }
      if (Get_Press(KEY_ENTER)) {
         message = "NEW VALUE:";
		 Draw_Screen(start_x,start_y);
		 j = 0;
		for (i = 0; i < number_of_things; i++) {
			if (things[i].type != 0) {
				if (((things[i].x + frame_ptrs[object_frames[things[i].type]][0]) < (start_x+(SCREEN_WIDTH-32))) && (((things[i].x + frame_ptrs[object_frames[things[i].type]][0] + (unsigned char)frame_ptrs[object_frames[things[i].type]][2]) - 1) >= start_x)) {
					if (j < MAX_SPRITES) {
						sprites[j].curr_frame = object_frames[things[i].type];
						Place_Sprite(&sprites[j], things[i].x, things[i].y, things[i].z);
						sprites[j].palnum = things[i].palette;
						sprites[j].flipflag = NOFLIP;
						j++;
						}
					}
				}
			}
		while (j < MAX_SPRITES) {
			sprites[j].curr_frame = -1;
			Place_Sprite(&sprites[j], NOWHERE, NOWHERE, NOWHERE);
			sprites[j].palnum = 0;
			sprites[j].flipflag = NOFLIP;
			j++;
			}
		Set_Priflags();
		prisort(priority_table, 0, MAX_SPRITES-1);
		Draw_Screen(start_x,start_y);
		for (i = 0; i < MAX_SPRITES; i++) {
			Palette_Blit_Sprite(priority_table[i]);
			}
         Blit_Word(8,0,"TRANSPARENCY");
         Blit_Word(8,8,"RELATIVE SCROLL RATE");
         Blit_Word(8,16,"RISE RATE");
         Blit_Word(8,24,"START SPOT X");
         Blit_Word(8,32,"START SPOT Y");
         Blit_Word(8,40,"START SPOT Z");
         Blit_Word(8,48,"HOW PLAYER ENTERS");
         Blit_Word(8,56,"WALK TO SPOT X (REL)");
         Blit_Word(8,64,"WALK TO SPOT Y");
         Blit_Word(8,72,"WALK TO SPOT Z");
         Blit_Word(8,80,"HOW PLAYER EXITS");
         Blit_Word(8,88,"LEFT END TYPE");
         Blit_Word(8,96,"LEFT END SLANT");
         Blit_Word(8,104,"LEFT END OFFSET");
         Blit_Word(8,112,"RIGHT END TYPE");
         Blit_Word(8,120,"RIGHT END SLANT");
         Blit_Word(8,128,"RIGHT END OFFSET");
         Blit_Word(8,136,"TOP END TYPE");
         Blit_Word(8,144,"TOP END Z");
         Blit_Word(8,152,"BOTTOM END TYPE");
         Blit_Word(8,160,"BOTTOM END Z");
         Blit_Word(8,168,"COLOR CYCLE LOW END");
         Blit_Word(8,176,"COLOR CYCLE HIGH END");
         Blit_Word(8,184,"COLOR CYCLE SPEED");
         for (index=0; index<24; index++) {
             if (index == editing_field)
                Blit_Letter(176, index*8, '?');
             else
                Blit_Number(176, index*8, attribute_values[index]);
             }
         Blit_Letter(0,(8*editing_field),'*');
         Blit_Word(0,192,message);
         blit(double_buffer,screen,0,0,0,0,320,200);
         attribute_values[editing_field] = Get_Number(88,192);
         if (attribute_values[editing_field] > att_high_limits[editing_field]) {
            sprintf(messbuf,"VALUE CANNOT EXCEED %d.",att_high_limits[editing_field]);
            message = messbuf;
            attribute_values[editing_field] = att_high_limits[editing_field];
            }
         else if (attribute_values[editing_field] < att_low_limits[editing_field]) {
            sprintf(messbuf,"VALUE CANNOT BE LESS THAN %d.",att_low_limits[editing_field]);
            message = messbuf;
            attribute_values[editing_field] = att_low_limits[editing_field];
            }
         else
            sprintf(messbuf,"VALUE SET TO %d.",attribute_values[editing_field]);
            message = messbuf;
         }
      if (Get_Press(KEY_A) || Get_Press(KEY_ESC))
         departing = 1;
	  Draw_Screen(start_x,start_y);
	  j = 0;
		for (i = 0; i < number_of_things; i++) {
			if (things[i].type != 0) {
				if (((things[i].x + frame_ptrs[object_frames[things[i].type]][0]) < (start_x+(SCREEN_WIDTH-32))) && (((things[i].x + frame_ptrs[object_frames[things[i].type]][0] + (unsigned char)frame_ptrs[object_frames[things[i].type]][2]) - 1) >= start_x)) {
					if (j < MAX_SPRITES) {
						sprites[j].curr_frame = object_frames[things[i].type];
						Place_Sprite(&sprites[j], things[i].x, things[i].y, things[i].z);
						sprites[j].palnum = things[i].palette;
						sprites[j].flipflag = NOFLIP;
						j++;
						}
					}
				}
			}
		while (j < MAX_SPRITES) {
			sprites[j].curr_frame = -1;
			Place_Sprite(&sprites[j], NOWHERE, NOWHERE, NOWHERE);
			sprites[j].palnum = 0;
			sprites[j].flipflag = NOFLIP;
			j++;
			}
		Set_Priflags();
		prisort(priority_table, 0, MAX_SPRITES-1);
		Draw_Screen(start_x,start_y);
		for (i = 0; i < MAX_SPRITES; i++) {
			Palette_Blit_Sprite(priority_table[i]);
			}
      Blit_Word(8,0,"TRANSPARENCY");
      Blit_Word(8,8,"RELATIVE SCROLL RATE");
      Blit_Word(8,16,"RISE RATE");
      Blit_Word(8,24,"START SPOT X");
      Blit_Word(8,32,"START SPOT Y");
      Blit_Word(8,40,"START SPOT Z");
      Blit_Word(8,48,"HOW PLAYER ENTERS");
      Blit_Word(8,56,"WALK TO SPOT X (REL)");
      Blit_Word(8,64,"WALK TO SPOT Y");
      Blit_Word(8,72,"WALK TO SPOT Z");
      Blit_Word(8,80,"HOW PLAYER EXITS");
      Blit_Word(8,88,"LEFT END TYPE");
      Blit_Word(8,96,"LEFT END SLANT");
      Blit_Word(8,104,"LEFT END OFFSET");
      Blit_Word(8,112,"RIGHT END TYPE");
      Blit_Word(8,120,"RIGHT END SLANT");
      Blit_Word(8,128,"RIGHT END OFFSET");
      Blit_Word(8,136,"TOP END TYPE");
      Blit_Word(8,144,"TOP END Z");
      Blit_Word(8,152,"BOTTOM END TYPE");
      Blit_Word(8,160,"BOTTOM END Z");
      Blit_Word(8,168,"COLOR CYCLE LOW END");
      Blit_Word(8,176,"COLOR CYCLE HIGH END");
      Blit_Word(8,184,"COLOR CYCLE SPEED");
      for (index=0; index<24; index++) {
         Blit_Number(176, index*8, attribute_values[index]);
         }
      Blit_Word(0,192,message);
      Blit_Letter(0,(8*editing_field),'*');
      blit(double_buffer,screen,0,0,0,0,320,200);
      }
   message = "ATTRIBUTE EDITING MODE EXITED.";
   transparency = attribute_values[0];
   relative_scroll_rate = attribute_values[1];
   rise_rate = attribute_values[2];
   start_spot_x = attribute_values[3];
   start_spot_y = attribute_values[4];
   start_spot_z = attribute_values[5];
   how_player_enters = attribute_values[6];
   walk_to_spot_x = attribute_values[7];
   walk_to_spot_y = attribute_values[8];
   walk_to_spot_z = attribute_values[9];
   how_player_exits = attribute_values[10];
   left_end_type = attribute_values[11];
   left_end_slant = attribute_values[12];
   left_end_offset = attribute_values[13];
   right_end_type = attribute_values[14];
   right_end_slant = attribute_values[15];
   right_end_offset = attribute_values[16];
   top_end_type = attribute_values[17];
   top_end_z = attribute_values[18];
   bottom_end_type = attribute_values[19];
   bottom_end_z = attribute_values[20];
   color_cycle_low_end = attribute_values[21];
   color_cycle_high_end = attribute_values[22];
   color_cycle_speed = attribute_values[23];
   }

void Jump_To_Location() {
     int new_x_loc;
     message = "NEW X-LOCATION:";
     Draw_Screen_Partial(start_x,start_y);
     Blit_Word(0,192,message);
     blit(double_buffer,screen,0,0,0,0,320,200);
     new_x_loc = Get_Number(128,192);
     if (new_x_loc < 0) {
          message = "CAN'T JUMP TO NEGATIVE X-LOCATION.";
          }
     else if (new_x_loc > ((row_length * 16) - SCREEN_WIDTH)) {
          message = "TOO FAR TO THE RIGHT.";
          }
     else {
          start_x = new_x_loc;
          sprintf(messbuf,"JUMPED TO X=%d.",new_x_loc);
          message = messbuf;
          }
     }

void Show_Music_Name() {
   sprintf(messbuf,"MUSIC IS \"%s\".",music_names[music_num]);
   message = messbuf;
   Draw_Screen_Partial(start_x,start_y);
	Blit_Word(0,192,message);
	blit(double_buffer,screen,0,0,0,0,320,200);
	}

void Flood_Fill(int x_tile, int y_tile, unsigned char fill_on_tile) { // uses recursive fill technique; this func is unused b/c it usually crashes the computer (probably overflows stack)
   if (x_tile >= 0 && x_tile < row_length && y_tile >= 0 && y_tile < num_rows)
   if (level[(y_tile * row_length) + x_tile] = fill_on_tile) {
      level[(y_tile * row_length) + x_tile] = using_tile;
      if (x_tile >= 0 && x_tile < row_length && y_tile-1 >= 0 && y_tile-1 < num_rows)
      if (level[((y_tile-1) * row_length) + x_tile] == fill_on_tile)
      Flood_Fill(x_tile, y_tile-1, fill_on_tile);
      if (x_tile+1 >= 0 && x_tile+1 < row_length && y_tile >= 0 && y_tile < num_rows)
      if (level[(y_tile * row_length) + x_tile+1] == fill_on_tile)
      Flood_Fill(x_tile+1, y_tile, fill_on_tile);
      if (x_tile >= 0 && x_tile < row_length && y_tile+1 >= 0 && y_tile+1 < num_rows)
      if (level[((y_tile+1) * row_length) + x_tile] == fill_on_tile)
      Flood_Fill(x_tile, y_tile+1, fill_on_tile);
      if (x_tile-1 >= 0 && x_tile-1 < row_length && y_tile >= 0 && y_tile < num_rows)
      if (level[(y_tile * row_length) + (x_tile-1)] == fill_on_tile)
      Flood_Fill(x_tile-1, y_tile, fill_on_tile);
      }
   else return;
   else return;
   }

void Make_Pattern(int x_tile, int y_tile) {
   int pattern_length;
   int index, index2;
   unsigned char fill_on_tile;
   unsigned char pattern_tiles[8];
   // long low_limit, high_limit;
   message = "PATTERN LENGTH:";
     Draw_Screen_Partial(start_x,start_y);
     Blit_Word(0,192,message);
     blit(double_buffer,screen,0,0,0,0,320,200);
     pattern_length = Get_Number(128,192);
     if (pattern_length < 0) {
          message = "CAN'T ENTER A NEGATIVE VALUE.";
          return;
          }
     else if (pattern_length == 0) {
          message = "PATTERN LENGTH CAN'T BE ZERO.";
          return;
          }
     else if (pattern_length > 8) {
          message = "PATTERN LENGTH CAN'T EXCEED 8.";
          return;
          }
     Get_Press(KEY_ENTER); //clear_keybuf();
     for (index = 0; index < pattern_length; index++) {
          sprintf(messbuf,"PICK PATTERN TILE #%d",index+1);
          message = messbuf;
          while (!Get_Press(KEY_ENTER)) {
          if (key[KEY_UP]) {
			tile_timing++;
			if (tile_timing == 15)
				tile_timing = 0;
			}
		if (key[KEY_DOWN]) {
			tile_timing++;
			if (tile_timing == 15)
				tile_timing = 0;
			}
		if (key[KEY_UP] && key[KEY_DOWN]) {
			tile_timing = 0;
			}
		if (!key[KEY_UP] && !key[KEY_DOWN]) {
			tile_timing = 0;
			}
		if (key[KEY_DOWN] && tile_timing == 1) {
			if (key[KEY_LSHIFT]) {
				using_tile-=10;
				if (using_tile < 0)
					using_tile = 0;
				}
			else
			if (using_tile > 0)
				using_tile--;
			}

		if (key[KEY_UP] && tile_timing == 1) {
			if (key[KEY_LSHIFT]) {
				using_tile+=10;
				if (using_tile > TILE_COUNT-1)
					using_tile = TILE_COUNT-1;
				}
			else
			if (using_tile < TILE_COUNT-1)
				using_tile++;
			}
                Draw_Screen_Partial(start_x,start_y);
                Erase_Right_Side();
			Blit_Word(0,192,message);
			Blit_Word(0,0,"X=");
			Blit_Number(16,0,start_x);
			Blit_Word(288,0,"CURR");
			Blit_Word(288,8,"TILE");
			Blit_Tile(296,16,using_tile);
			Blit_Number_Space(292,32,using_tile,3);
                Blit_Word(0,192,message);
				vsync();
                blit(double_buffer,screen,0,0,0,0,320,200);
                }
                pattern_tiles[index] = using_tile;
          }
          index2 = (y_tile * row_length) + x_tile;
          fill_on_tile = level[index2];
          while (level[index2] == fill_on_tile && index2 < ((y_tile+1)*row_length)) {
            level[index2] = pattern_tiles[((index2-((y_tile*row_length)+x_tile))%pattern_length)];
            index2++;
            }
          message = "PATTERN COMPLETED.";
   }

int Choose_Item(int mode) {
	sprite display_item;
	int i;
	int done = 0;
	int on_item = -1;
	Sprite_Init(&display_item);
	display_item.flipflag = NOFLIP;
	Place_Sprite(&display_item,start_x+39,135,0);
	blit(double_buffer,hold_screen_buffer,0,0,0,0,320,200);
	while (!done) {
		if (Get_Press(KEY_ESC)) {
			done = 1;
			blit(hold_screen_buffer,double_buffer,0,0,0,0,320,200);
			return -1;
			}
		if (mouse_b & 1) {
			if (on_item != -1) {
				done = 1;
				blit(hold_screen_buffer,double_buffer,0,0,0,0,320,200);
				return on_item;
				}
			}
		blit(hold_screen_buffer,double_buffer,0,0,0,0,320,200);
		rectfill(double_buffer, 8, 8, SCREEN_WIDTH-9, SCREEN_HEIGHT-9, 26);
		rect(double_buffer, 8, 8, SCREEN_WIDTH-9, SCREEN_HEIGHT-9, 162);
		if ((mouse_x >= 70) && (mouse_y >= 16) && (mouse_y < 184) && ((((mouse_x-70)/58)*28)+((mouse_y-16)/6)) < (sizeof thing_list / sizeof thing_list[0])) {
			on_item = ((((mouse_x-70)/58)*28)+((mouse_y-16)/6));
			rectfill(double_buffer,70+(((mouse_x-70)/58)*58),16+(((mouse_y-16)/6)*6),127+(((mouse_x-70)/58)*58),21+(((mouse_y-16)/6)*6),71);
			display_item.curr_frame = object_frames[on_item];
			}
		else {
			on_item = -1;
			display_item.curr_frame = -1;
			}
		Blit_Sprite(&display_item);
		textout_centre(double_buffer,stalked_data[tiny_font].dat,"CHOOSE ITEM",39,150,-1);
		if (mode == 0) {
			textout_centre(double_buffer,stalked_data[tiny_font].dat,"TYPE",39,156,-1);
			}
		else {
			textout_centre(double_buffer,stalked_data[tiny_font].dat,"CONTENTS",39,156,-1);
			}
		for (i = 0; i < (sizeof thing_list / sizeof thing_list[0]); i++) {
			textprintf(double_buffer, stalked_data[tiny_font].dat, 70+((i/28)*58), 16+((i%28)*6), -1, "%s", thing_list[i].name);
			}
		draw_sprite(double_buffer,stalked_data[mouse_arrow].dat,mouse_x,mouse_y);
		blit(double_buffer,screen,0,0,0,0,320,200);
		}
	}

void Move_Item(int item) {
	int i,j,done;
	done = 0;
	blit(double_buffer,hold_screen_buffer,0,0,0,0,320,200);
	things[item].x = start_x+(screen_w/2);
	things[item].y = 0;
	things[item].z = (top_end_z+bottom_end_z)/2;
	sprintf(longmessbuf,"MOVE THING INTO PLACE USING NUMPAD KEYS.");
	while (!done) {
		if (Get_Press(KEY_ENTER) || Get_Press(KEY_ENTER_PAD)) {
			done = 1;
			}
		if (Get_Press(KEY_5_PAD)) {
			things[item].x = start_x+(screen_w/2);
			things[item].y = 0;
			things[item].z = (top_end_z+bottom_end_z)/2;
			sprintf(longmessbuf, "THING #%d X=%d Y=%d Z=%d", item,things[item].x,things[item].y,things[item].z);
			}
		if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
			if (Get_Press(KEY_4_PAD)) {
				if (things[item].x > 0) {
					things[item].x--;
					}
				sprintf(longmessbuf, "THING #%d X=%d Y=%d Z=%d", item,things[item].x,things[item].y,things[item].z);
				}
			}
		else if (key[KEY_4_PAD]) {
			if (things[item].x > 0) {
				things[item].x--;
				}
			sprintf(longmessbuf, "THING #%d X=%d Y=%d Z=%d", item,things[item].x,things[item].y,things[item].z);
			}
		if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
			if (Get_Press(KEY_6_PAD)) {
				if (things[item].x < (row_length * 16) - 1) {
					things[item].x++;
					}
				sprintf(longmessbuf, "THING #%d X=%d Y=%d Z=%d", item,things[item].x,things[item].y,things[item].z);
				}
			}
		else if (key[KEY_6_PAD]) {
			if (things[item].x < (row_length * 16) - 1) {
				things[item].x++;
				}
			sprintf(longmessbuf, "THING #%d X=%d Y=%d Z=%d", item,things[item].x,things[item].y,things[item].z);
			}
		if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
			if (Get_Press(KEY_8_PAD)) {
				if (things[item].z > top_end_z) {
					things[item].z--;
					}
				sprintf(longmessbuf, "THING #%d X=%d Y=%d Z=%d", item,things[item].x,things[item].y,things[item].z);
				}
			}
		else if (key[KEY_8_PAD]) {
			if (things[item].z > top_end_z) {
				things[item].z--;
				}
			sprintf(longmessbuf, "THING #%d X=%d Y=%d Z=%d", item,things[item].x,things[item].y,things[item].z);
			}
		if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
			if (Get_Press(KEY_2_PAD)) {
				if (things[item].z < bottom_end_z) {
					things[item].z++;
					}
				sprintf(longmessbuf, "THING #%d X=%d Y=%d Z=%d", item,things[item].x,things[item].y,things[item].z);
				}
			}
		else if (key[KEY_2_PAD]) {
			if (things[item].z < bottom_end_z) {
				things[item].z++;
				}
			sprintf(longmessbuf, "THING #%d X=%d Y=%d Z=%d", item,things[item].x,things[item].y,things[item].z);
			}
		if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
			if (Get_Press(KEY_MINUS_PAD)) {
				things[item].y--;
				sprintf(longmessbuf, "THING #%d X=%d Y=%d Z=%d", item,things[item].x,things[item].y,things[item].z);
				}
			}
		else if (key[KEY_MINUS_PAD]) {
			things[item].y--;
			sprintf(longmessbuf, "THING #%d X=%d Y=%d Z=%d", item,things[item].x,things[item].y,things[item].z);
			}
		if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
			if (Get_Press(KEY_PLUS_PAD)) {
				if (things[item].y < 0) {
					things[item].y++;
					}
				sprintf(longmessbuf, "THING #%d X=%d Y=%d Z=%d", item,things[item].x,things[item].y,things[item].z);
				}
			}
		else if (key[KEY_PLUS_PAD]) {
			if (things[item].y < 0) {
				things[item].y++;
				}
			sprintf(longmessbuf, "THING #%d X=%d Y=%d Z=%d", item,things[item].x,things[item].y,things[item].z);
			}
		if (things[item].x < start_x) {
			start_x = things[item].x;
			}
		if (things[item].x >= (start_x+screen_w)) {
			start_x = (things[item].x-screen_w)+1;
			}
		j = 0;
		for (i = 0; i < number_of_things; i++) {
			if (things[i].type != 0) {
				if (((things[i].x + frame_ptrs[object_frames[things[i].type]][0]) < (start_x+(SCREEN_WIDTH-32))) && (((things[i].x + frame_ptrs[object_frames[things[i].type]][0] + (unsigned char)frame_ptrs[object_frames[things[i].type]][2]) - 1) >= start_x)) {
					if (j < MAX_SPRITES) {
						sprites[j].curr_frame = object_frames[things[i].type];
						Place_Sprite(&sprites[j], things[i].x, things[i].y, things[i].z);
						sprites[j].palnum = things[i].palette;
						sprites[j].flipflag = NOFLIP;
						j++;
						}
					}
				}
			}
		while (j < MAX_SPRITES) {
			sprites[j].curr_frame = -1;
			Place_Sprite(&sprites[j], NOWHERE, NOWHERE, NOWHERE);
			sprites[j].palnum = 0;
			sprites[j].flipflag = NOFLIP;
			j++;
			}
		Set_Priflags();
		prisort(priority_table, 0, MAX_SPRITES-1);
		Draw_Screen_Partial(start_x,start_y);
		for (i = 0; i < MAX_SPRITES; i++) {
			Palette_Blit_Sprite(priority_table[i]);
			}
		Erase_Right_Side();
		blit(hold_screen_buffer,double_buffer,288,0,288,0,32,200);
		Blit_Word(0,0,"THING EDITING MODE");
		
				if (start_x < 0)
					start_x = 0;
				if (start_x > ((row_length * 16) - screen_w))
					start_x = (row_length * 16) - screen_w;
			
		textout(double_buffer,stalked_data[tiny_font].dat,longmessbuf,0,192,-1);
		vsync();
		blit(double_buffer,screen,0,0,0,0,320,200);
		}
	}

int Choose_Palette(int t) {
	sprite display_item;
	int i;
	int done = 0;
	int on_pal = -1;
	Sprite_Init(&display_item);
	display_item.curr_frame = object_frames[t];
	display_item.flipflag = NOFLIP;
	Place_Sprite(&display_item,start_x+39,135,0);
	blit(double_buffer,hold_screen_buffer,0,0,0,0,320,200);
	while (!done) {
		if (Get_Press(KEY_ESC)) {
			done = 1;
			blit(hold_screen_buffer,double_buffer,0,0,0,0,320,200);
			return -1;
			}
		if (mouse_b & 1) {
			if (on_pal != -1) {
				done = 1;
				blit(hold_screen_buffer,double_buffer,0,0,0,0,320,200);
				return on_pal;
				}
			}
		blit(hold_screen_buffer,double_buffer,0,0,0,0,320,200);
		rectfill(double_buffer, 8, 8, SCREEN_WIDTH-9, SCREEN_HEIGHT-9, 26);
		rect(double_buffer, 8, 8, SCREEN_WIDTH-9, SCREEN_HEIGHT-9, 162);
		if ((mouse_x >= 70) && (mouse_y >= 16) && (mouse_y < 166) && (((((mouse_x-70)/29)*25)+((mouse_y-16)/6)) < MAX_PALETTES) && (((((mouse_x-70)/29)*25)+((mouse_y-16)/6)) >= 0)) {
			on_pal = ((((mouse_x-70)/29)*25)+((mouse_y-16)/6));
			rectfill(double_buffer,70+(((mouse_x-70)/29)*29),16+(((mouse_y-16)/6)*6),98+(((mouse_x-70)/29)*29),21+(((mouse_y-16)/6)*6),71);
			display_item.palnum = on_pal;
			}
		else {
			on_pal = -1;
			display_item.palnum = 0;
			}
		Palette_Blit_Sprite(&display_item);
		textout_centre(double_buffer,stalked_data[tiny_font].dat,"CHOOSE PALETTE",39,150,-1);
		for (i = 0; i < MAX_PALETTES; i++) {
			textprintf(double_buffer, stalked_data[tiny_font].dat, 70+((i/25)*29), 16+((i%25)*6), -1, "%d", i);
			}
		draw_sprite(double_buffer,stalked_data[mouse_arrow].dat,mouse_x,mouse_y);
		blit(double_buffer,screen,0,0,0,0,320,200);
		}
	}

void Item_Edit_Mode() {
	int departing = 0;
	int thing_list_start = 0;
	int curr_thing = 0;
	int prev_curr_thing = -1;
	int prev_curr_thing_x = NOWHERE;
	int did_move = 0;
	int i,j;
	full_screen_display = 0;
	Erase_Right_Side();
	sprintf(longmessbuf,"");
	while (!departing) {
		if (Get_Press(KEY_I) || Get_Press(KEY_ESC)) {
			departing = 1;
			}
		if (Get_Press(KEY_N)) {
			if (number_of_things < MAX_THINGS) {
				number_of_things++;
				i = Choose_Item(0);
				if (i != -1) {
					things[number_of_things-1].type = i;
					}
				else {
					things[number_of_things-1].type = 0;
					}
				Move_Item(number_of_things-1);
				i = Choose_Palette(things[number_of_things-1].type);
				if (i != -1) {
					things[number_of_things-1].palette = i;
					}
				else {
					things[number_of_things-1].palette = 0;
					}
				if (thing_list[things[number_of_things-1].type].thing_class == CPU_BREAKABLE) {
					i = Choose_Item(1);
					if (i != -1) {
						things[number_of_things-1].thing_inside = i;
						}
					else {
						things[number_of_things-1].thing_inside = 0;
						}
					}
				else {
					things[number_of_things-1].thing_inside = 0;
					}
				curr_thing = number_of_things-1;
				sprintf(longmessbuf, "#%d %s X=%d Y=%d Z=%d PAL#%d CONTAINS %s", curr_thing,thing_list[things[curr_thing].type].name,things[curr_thing].x,things[curr_thing].y,things[curr_thing].z,things[curr_thing].palette,(thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)? thing_list[things[curr_thing].thing_inside].name : "N/A");
				}
			}
		if (key[KEY_LEFT]) {
			if (key[KEY_LSHIFT]) {
				start_x-=10;
				if (start_x < 0)
					start_x = 0;
				}
			else
			if (start_x > 0)
				start_x--;
			did_move = 1;
			sprintf(longmessbuf,"X=%d",start_x);
			}
		if (key[KEY_RIGHT]) {
			if (key[KEY_LSHIFT]) {
				start_x+=10;
				if (start_x > ((row_length * 16) - screen_w))
					start_x = (row_length * 16) - screen_w;
				}
			else
			if (start_x < ((row_length * 16) - screen_w))
				start_x++;
			did_move = 1;
			sprintf(longmessbuf,"X=%d",start_x);
			}
		if (Get_Press(KEY_UP)) {
			if (number_of_things > 0) {
				if (curr_thing > 0) {
					curr_thing--;
					if (curr_thing < thing_list_start) {
						thing_list_start--;
						}
					}
				sprintf(longmessbuf, "#%d %s X=%d Y=%d Z=%d PAL#%d CONTAINS %s", curr_thing,thing_list[things[curr_thing].type].name,things[curr_thing].x,things[curr_thing].y,things[curr_thing].z,things[curr_thing].palette,(thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)? thing_list[things[curr_thing].thing_inside].name : "N/A");
				}
			}
		if (Get_Press(KEY_DOWN)) {
			if (number_of_things > 0) {
				if (curr_thing < (number_of_things-1)) {
					curr_thing++;
					if (curr_thing == (thing_list_start+24)) {
						thing_list_start++;
						}
					}
				sprintf(longmessbuf, "#%d %s X=%d Y=%d Z=%d PAL#%d CONTAINS %s", curr_thing,thing_list[things[curr_thing].type].name,things[curr_thing].x,things[curr_thing].y,things[curr_thing].z,things[curr_thing].palette,(thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)? thing_list[things[curr_thing].thing_inside].name : "N/A");
				}
			}
		if (Get_Press(KEY_PGUP)) {
			if (number_of_things > 0) {
				thing_list_start -= 24;
				curr_thing -= 24;
				if (thing_list_start < 0) {
					curr_thing -= thing_list_start;
					thing_list_start = 0;
					}
				sprintf(longmessbuf, "#%d %s X=%d Y=%d Z=%d PAL#%d CONTAINS %s", curr_thing,thing_list[things[curr_thing].type].name,things[curr_thing].x,things[curr_thing].y,things[curr_thing].z,things[curr_thing].palette,(thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)? thing_list[things[curr_thing].thing_inside].name : "N/A");
				}
			}
		if (Get_Press(KEY_PGDN)) {
			if (number_of_things > 0) {
				if (number_of_things > 24) {
					thing_list_start += 24;
					curr_thing += 24;
					if (thing_list_start > (number_of_things-24)) {
						curr_thing -= (thing_list_start - (number_of_things-24));
						thing_list_start = (number_of_things-24);
						}
					}
				sprintf(longmessbuf, "#%d %s X=%d Y=%d Z=%d PAL#%d CONTAINS %s", curr_thing,thing_list[things[curr_thing].type].name,things[curr_thing].x,things[curr_thing].y,things[curr_thing].z,things[curr_thing].palette,(thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)? thing_list[things[curr_thing].thing_inside].name : "N/A");
				}
			}
		if (Get_Press(KEY_HOME)) {
			if (number_of_things > 0) {
				if (curr_thing != thing_list_start) {
					curr_thing = thing_list_start;
					}
				else {
					thing_list_start = 0;
					curr_thing = 0;
					}
				sprintf(longmessbuf, "#%d %s X=%d Y=%d Z=%d PAL#%d CONTAINS %s", curr_thing,thing_list[things[curr_thing].type].name,things[curr_thing].x,things[curr_thing].y,things[curr_thing].z,things[curr_thing].palette,(thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)? thing_list[things[curr_thing].thing_inside].name : "N/A");
				}
			}
		if (Get_Press(KEY_END)) {
			if (number_of_things > 0) {
				if (number_of_things <= 24) {
					curr_thing = (number_of_things-1);
					}
				else {
					if (curr_thing != (thing_list_start+23)) {
						curr_thing = (thing_list_start+23);
						}
					else {
						thing_list_start = (number_of_things-24);
						curr_thing = (number_of_things-1);
						}
					}
				sprintf(longmessbuf, "#%d %s X=%d Y=%d Z=%d PAL#%d CONTAINS %s", curr_thing,thing_list[things[curr_thing].type].name,things[curr_thing].x,things[curr_thing].y,things[curr_thing].z,things[curr_thing].palette,(thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)? thing_list[things[curr_thing].thing_inside].name : "N/A");
				}
			}
		if (Get_Press(KEY_C)) {
			if ((number_of_things < MAX_THINGS) && (number_of_things > 0)) {
				number_of_things++;
				things[number_of_things-1].type = things[curr_thing].type;
				things[number_of_things-1].x = things[curr_thing].x;
				things[number_of_things-1].y = things[curr_thing].y;
				things[number_of_things-1].z = things[curr_thing].z;
				things[number_of_things-1].palette = things[curr_thing].palette;
				things[number_of_things-1].thing_inside = things[curr_thing].thing_inside;
				sprintf(longmessbuf, "THING #%d COPIED.", curr_thing);
				// message = messbuf;
				}
			}
		if (Get_Press(KEY_DEL)) {
			if (number_of_things > 0) {
				for (i=curr_thing; i<(number_of_things-1); i++) {
					things[i].type = things[i+1].type;
					things[i].x = things[i+1].x;
					things[i].y = things[i+1].y;
					things[i].z = things[i+1].z;
					things[i].palette = things[i+1].palette;
					things[i].thing_inside = things[i+1].thing_inside;
					}
				things[number_of_things-1].type = 0;
				things[number_of_things-1].x = 0;
				things[number_of_things-1].y = 0;
				things[number_of_things-1].z = 0;
				things[number_of_things-1].palette = 0;
				things[number_of_things-1].thing_inside = 0;
				sprintf(longmessbuf, "THING #%d DELETED.", curr_thing);
				// message = messbuf;
				number_of_things--;
				if ((number_of_things > 0) && (curr_thing >= number_of_things)) {
					curr_thing = (number_of_things - 1);
					}
				if (number_of_things > 24) {
					if (number_of_things < (thing_list_start+24)) {
						thing_list_start--;
						}
					}
				}
			}
		if (Get_Press(KEY_W)) {
			sprintf(longmessbuf, "#%d %s X=%d Y=%d Z=%d PAL#%d CONTAINS %s", curr_thing,thing_list[things[curr_thing].type].name,things[curr_thing].x,things[curr_thing].y,things[curr_thing].z,things[curr_thing].palette,(thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)? thing_list[things[curr_thing].thing_inside].name : "N/A");
			//message = messbuf;
			}
		if (Get_Press(KEY_ENTER)) {
			if (number_of_things > 0 && (curr_thing < number_of_things)) {
				i = Choose_Item(0);
				if (i != -1) {
					things[curr_thing].type = i;
					}
				Move_Item(curr_thing);
				i = Choose_Palette(things[curr_thing].type);
				if (i != -1) {
					things[curr_thing].palette = i;
					}
				if (thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE) {
					i = Choose_Item(1);
					if (i != -1) {
						things[curr_thing].thing_inside = i;
						}
					}
				sprintf(longmessbuf, "THING #%d UPDATED.", curr_thing);
				// message = messbuf;
				}
			}
		if (Get_Press(KEY_T)) {
			if (number_of_things > 0 && (curr_thing < number_of_things)) {
				i = Choose_Item(0);
				if (i != -1) {
					things[curr_thing].type = i;
					}
				sprintf(longmessbuf, "THING #%d TYPE IS %s.", curr_thing,thing_list[things[curr_thing].type].name);
				// message = messbuf;
				}
			}
		if (Get_Press(KEY_X)) {
			if (number_of_things > 0 && (curr_thing < number_of_things)) {
				message = "THING X:";
				Draw_Screen_Partial(start_x,start_y);
				Blit_Word(0, 192, message);
				blit(double_buffer,screen,0,0,0,0,320,200);
				things[curr_thing].x = Get_Number(72,192);
				sprintf(longmessbuf, "THING #%d X = %d.", curr_thing,things[curr_thing].x);
				// message = messbuf;
				}
			}
		if (Get_Press(KEY_Y)) {
			if (number_of_things > 0 && (curr_thing < number_of_things)) {
				message = "THING Y:";
				Draw_Screen_Partial(start_x,start_y);
				Blit_Word(0, 192, message);
				blit(double_buffer,screen,0,0,0,0,320,200);
				things[curr_thing].y = Get_Number(72,192);
				sprintf(longmessbuf, "THING #%d Y = %d.", curr_thing,things[curr_thing].y);
				// message = messbuf;
				}
			}
		if (Get_Press(KEY_Z)) {
			if (number_of_things > 0 && (curr_thing < number_of_things)) {
				message = "THING Z:";
				Draw_Screen_Partial(start_x,start_y);
				Blit_Word(0, 192, message);
				blit(double_buffer,screen,0,0,0,0,320,200);
				things[curr_thing].z = Get_Number(72,192);
				sprintf(longmessbuf, "THING #%d Z = %d.", curr_thing,things[curr_thing].z);
				// message = messbuf;
				}
			}
		if (Get_Press(KEY_P)) {
			if (number_of_things > 0 && (curr_thing < number_of_things)) {
				i = Choose_Palette(things[curr_thing].type);
				if (i != -1) {
					things[curr_thing].palette = i;
					}
				sprintf(longmessbuf, "THING #%d PALETTE = %d.", curr_thing,things[curr_thing].palette);
				// message = messbuf;
				}
			}
		if (Get_Press(KEY_K)) {
			if (number_of_things > 0 && (curr_thing < number_of_things) && (thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)) {
				i = Choose_Item(1);
				if (i != -1) {
					things[curr_thing].thing_inside = i;
					}
				sprintf(longmessbuf, "THING #%d CONTAINS %s.", curr_thing,thing_list[things[curr_thing].type].name);
				// message = messbuf;
				}
			}
		if (Get_Press(KEY_5_PAD)) {
			things[curr_thing].x = start_x+(screen_w/2);
			things[curr_thing].y = 0;
			things[curr_thing].z = (top_end_z+bottom_end_z)/2;
			sprintf(longmessbuf, "#%d %s X=%d Y=%d Z=%d PAL#%d CONTAINS %s", curr_thing,thing_list[things[curr_thing].type].name,things[curr_thing].x,things[curr_thing].y,things[curr_thing].z,things[curr_thing].palette,(thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)? thing_list[things[curr_thing].thing_inside].name : "N/A");
			}
		if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
			if (Get_Press(KEY_4_PAD)) {
				if (number_of_things > 0) {
					if (things[curr_thing].x > 0) {
						things[curr_thing].x--;
						}
					sprintf(longmessbuf, "#%d %s X=%d Y=%d Z=%d PAL#%d CONTAINS %s", curr_thing,thing_list[things[curr_thing].type].name,things[curr_thing].x,things[curr_thing].y,things[curr_thing].z,things[curr_thing].palette,(thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)? thing_list[things[curr_thing].thing_inside].name : "N/A");
					}
				}
			}
		else if (key[KEY_4_PAD]) {
			if (number_of_things > 0) {
				if (things[curr_thing].x > 0) {
					things[curr_thing].x--;
					}
				sprintf(longmessbuf, "#%d %s X=%d Y=%d Z=%d PAL#%d CONTAINS %s", curr_thing,thing_list[things[curr_thing].type].name,things[curr_thing].x,things[curr_thing].y,things[curr_thing].z,things[curr_thing].palette,(thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)? thing_list[things[curr_thing].thing_inside].name : "N/A");
				}
			}
		if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
			if (Get_Press(KEY_6_PAD)) {
				if (number_of_things > 0) {
					if (things[curr_thing].x < (row_length * 16) - 1) {
						things[curr_thing].x++;
						}
					sprintf(longmessbuf, "#%d %s X=%d Y=%d Z=%d PAL#%d CONTAINS %s", curr_thing,thing_list[things[curr_thing].type].name,things[curr_thing].x,things[curr_thing].y,things[curr_thing].z,things[curr_thing].palette,(thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)? thing_list[things[curr_thing].thing_inside].name : "N/A");
					}
				}
			}
		else if (key[KEY_6_PAD]) {
			if (number_of_things > 0) {
				if (things[curr_thing].x < (row_length * 16) - 1) {
					things[curr_thing].x++;
					}
				sprintf(longmessbuf, "#%d %s X=%d Y=%d Z=%d PAL#%d CONTAINS %s", curr_thing,thing_list[things[curr_thing].type].name,things[curr_thing].x,things[curr_thing].y,things[curr_thing].z,things[curr_thing].palette,(thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)? thing_list[things[curr_thing].thing_inside].name : "N/A");
				}
			}
		if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
			if (Get_Press(KEY_8_PAD)) {
				if (number_of_things > 0) {
					if (things[curr_thing].z > top_end_z) {
						things[curr_thing].z--;
						}
					sprintf(longmessbuf, "#%d %s X=%d Y=%d Z=%d PAL#%d CONTAINS %s", curr_thing,thing_list[things[curr_thing].type].name,things[curr_thing].x,things[curr_thing].y,things[curr_thing].z,things[curr_thing].palette,(thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)? thing_list[things[curr_thing].thing_inside].name : "N/A");
					}
				}
			}
		else if (key[KEY_8_PAD]) {
			if (number_of_things > 0) {
				if (things[curr_thing].z > top_end_z) {
					things[curr_thing].z--;
					}
				sprintf(longmessbuf, "#%d %s X=%d Y=%d Z=%d PAL#%d CONTAINS %s", curr_thing,thing_list[things[curr_thing].type].name,things[curr_thing].x,things[curr_thing].y,things[curr_thing].z,things[curr_thing].palette,(thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)? thing_list[things[curr_thing].thing_inside].name : "N/A");
				}
			}
		if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
			if (Get_Press(KEY_2_PAD)) {
				if (number_of_things > 0) {
					if (things[curr_thing].z < bottom_end_z) {
						things[curr_thing].z++;
						}
					sprintf(longmessbuf, "#%d %s X=%d Y=%d Z=%d PAL#%d CONTAINS %s", curr_thing,thing_list[things[curr_thing].type].name,things[curr_thing].x,things[curr_thing].y,things[curr_thing].z,things[curr_thing].palette,(thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)? thing_list[things[curr_thing].thing_inside].name : "N/A");
					}
				}
			}
		else if (key[KEY_2_PAD]) {
			if (number_of_things > 0) {
				if (things[curr_thing].z < bottom_end_z) {
					things[curr_thing].z++;
					}
				sprintf(longmessbuf, "#%d %s X=%d Y=%d Z=%d PAL#%d CONTAINS %s", curr_thing,thing_list[things[curr_thing].type].name,things[curr_thing].x,things[curr_thing].y,things[curr_thing].z,things[curr_thing].palette,(thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)? thing_list[things[curr_thing].thing_inside].name : "N/A");
				}
			}
		if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
			if (Get_Press(KEY_MINUS_PAD)) {
				if (number_of_things > 0) {
					things[curr_thing].y--;
					sprintf(longmessbuf, "#%d %s X=%d Y=%d Z=%d PAL#%d CONTAINS %s", curr_thing,thing_list[things[curr_thing].type].name,things[curr_thing].x,things[curr_thing].y,things[curr_thing].z,things[curr_thing].palette,(thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)? thing_list[things[curr_thing].thing_inside].name : "N/A");
					}
				}
			}
		else if (key[KEY_MINUS_PAD]) {
			if (number_of_things > 0) {
				things[curr_thing].y--;
				sprintf(longmessbuf, "#%d %s X=%d Y=%d Z=%d PAL#%d CONTAINS %s", curr_thing,thing_list[things[curr_thing].type].name,things[curr_thing].x,things[curr_thing].y,things[curr_thing].z,things[curr_thing].palette,(thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)? thing_list[things[curr_thing].thing_inside].name : "N/A");
				}
			}
		if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
			if (Get_Press(KEY_PLUS_PAD)) {
				if (number_of_things > 0) {
					if (things[curr_thing].y < 0) {
						things[curr_thing].y++;
						}
					sprintf(longmessbuf, "#%d %s X=%d Y=%d Z=%d PAL#%d CONTAINS %s", curr_thing,thing_list[things[curr_thing].type].name,things[curr_thing].x,things[curr_thing].y,things[curr_thing].z,things[curr_thing].palette,(thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)? thing_list[things[curr_thing].thing_inside].name : "N/A");
					}
				}
			}
		else if (key[KEY_PLUS_PAD]) {
			if (number_of_things > 0) {
				if (things[curr_thing].y < 0) {
					things[curr_thing].y++;
					}
				sprintf(longmessbuf, "#%d %s X=%d Y=%d Z=%d PAL#%d CONTAINS %s", curr_thing,thing_list[things[curr_thing].type].name,things[curr_thing].x,things[curr_thing].y,things[curr_thing].z,things[curr_thing].palette,(thing_list[things[curr_thing].type].thing_class == CPU_BREAKABLE)? thing_list[things[curr_thing].thing_inside].name : "N/A");
				}
			}
		if (number_of_things > 0) {
			if (prev_curr_thing_x != things[curr_thing].x) {
				if (things[curr_thing].x < start_x) {
					start_x = things[curr_thing].x;
					}
				if (things[curr_thing].x >= (start_x+screen_w)) {
					start_x = (things[curr_thing].x-screen_w)+1;
					}
				prev_curr_thing_x = things[curr_thing].x;
				}
			}
		j = 0;
		for (i = 0; i < number_of_things; i++) {
			if (things[i].type != 0) {
				if (((things[i].x + frame_ptrs[object_frames[things[i].type]][0]) < (start_x+(SCREEN_WIDTH-32))) && (((things[i].x + frame_ptrs[object_frames[things[i].type]][0] + (unsigned char)frame_ptrs[object_frames[things[i].type]][2]) - 1) >= start_x)) {
					if (j < MAX_SPRITES) {
						sprites[j].curr_frame = object_frames[things[i].type];
						Place_Sprite(&sprites[j], things[i].x, things[i].y, things[i].z);
						sprites[j].palnum = things[i].palette;
						sprites[j].flipflag = NOFLIP;
						j++;
						}
					}
				}
			}
		while (j < MAX_SPRITES) {
			sprites[j].curr_frame = -1;
			Place_Sprite(&sprites[j], NOWHERE, NOWHERE, NOWHERE);
			sprites[j].palnum = 0;
			sprites[j].flipflag = NOFLIP;
			j++;
			}
		Set_Priflags();
		prisort(priority_table, 0, MAX_SPRITES-1);
		Draw_Screen_Partial(start_x,start_y);
		/*for (i=0; i<MAX_SPRITES; i++) {
			if (priority_table[i]->type != EFFECT) {
				Blit_Shadow(priority_table[i], shad);
				}
			} */
		for (i = 0; i < MAX_SPRITES; i++) {
			Palette_Blit_Sprite(priority_table[i]);
			}
		Erase_Right_Side();
		Blit_Word(0,0,"THING EDITING MODE");
		if (number_of_things == 0) {
			if (!did_move) {
				sprintf(longmessbuf,"NO THINGS IN LEVEL.");
				}
			}
		else {
			if (curr_thing != prev_curr_thing) {
				start_x = things[curr_thing].x - (screen_w/2);
				if (start_x < 0)
					start_x = 0;
				if (start_x > ((row_length * 16) - screen_w))
					start_x = (row_length * 16) - screen_w;
				prev_curr_thing = curr_thing;
				}
			if (number_of_things > 24) {
				j = 24;
				}
			else {
				j = number_of_things;
				}
			for (i=0; i<j; i++) {
				Blit_Number(296, (i*8), things[i+thing_list_start].type);
				}
			Blit_Letter(288,(curr_thing-thing_list_start)*8,'*');
			}
		textout(double_buffer,stalked_data[tiny_font].dat,longmessbuf,0,192,-1);
		// Blit_Word(0,192,message);
		vsync();
		blit(double_buffer,screen,0,0,0,0,320,200);
		}
	thingsort(things, 0, (int)(number_of_things-1));
	message = "THING EDITING MODE EXITED.";
	}

int Choose_Music() {
	int columns = 1;
	int rows = (sizeof music_names / sizeof music_names[0]);
	int column_width = 86; // row height is always 6
	int left_side_margin = 8;
	int on_music = -1;
	int done = 0;
	int i;
	int left_box_edge,right_box_edge,top_box_edge,bottom_box_edge,leftmost_column_start,topmost_row_start,rightmost_column_end,bottommost_row_end;
	left_box_edge = (screen_w-((columns*column_width)+left_side_margin+8))/2;
	leftmost_column_start = (left_box_edge + left_side_margin);
	right_box_edge = (leftmost_column_start+(columns*column_width)+7);
	rightmost_column_end = right_box_edge - 8;
	top_box_edge = (SCREEN_HEIGHT-(((rows+2)*6)+16))/2;
	topmost_row_start = top_box_edge + 20;
	bottom_box_edge = (top_box_edge + ((rows+2)*6)) + 15;
	bottommost_row_end = bottom_box_edge - 8;
	blit(double_buffer,hold_screen_buffer,0,0,0,0,320,200);
	while (!done) {
		if (Get_Press(KEY_ESC)) {
			done = 1;
			blit(hold_screen_buffer,double_buffer,0,0,0,0,320,200);
			message = "CHOOSE MUSIC CANCELLED.";
			return -1;
			}
		if (mouse_b & 1) {
			while (mouse_b & 1) {
				; // to ensure mouse button is not down when prog returns to main loop
				}
			if (on_music != -1) {
				done = 1;
				blit(hold_screen_buffer,double_buffer,0,0,0,0,320,200);
				sprintf(messbuf,"MUSIC IS \"%s\".",music_names[on_music]);
				message = messbuf;
				return on_music;
				}
			}
		blit(hold_screen_buffer,double_buffer,0,0,0,0,320,200);
		rectfill(double_buffer, left_box_edge, top_box_edge, right_box_edge, bottom_box_edge, 26);
		rect(double_buffer, left_box_edge, top_box_edge, right_box_edge, bottom_box_edge, 162);
		if ((mouse_x >= leftmost_column_start) && (mouse_y >= topmost_row_start) && (mouse_y < bottommost_row_end) && ((((mouse_x-leftmost_column_start)/column_width)*rows)+((mouse_y-topmost_row_start)/6)) < (sizeof music_names / sizeof music_names[0])) {
			on_music = ((((mouse_x-leftmost_column_start)/column_width)*rows)+((mouse_y-topmost_row_start)/6));
			rectfill(double_buffer,leftmost_column_start+(((mouse_x-leftmost_column_start)/column_width)*column_width),topmost_row_start+(((mouse_y-topmost_row_start)/6)*6),((leftmost_column_start+column_width)-1)+(((mouse_x-leftmost_column_start)/column_width)*column_width),(topmost_row_start+5)+(((mouse_y-topmost_row_start)/6)*6),71);
			}
		else {
			on_music = -1;
			}
		textout_centre(double_buffer,stalked_data[tiny_font].dat,"CHOOSE MUSIC",(screen_w/2),(top_box_edge+8),-1);
		for (i = 0; i < (sizeof music_names / sizeof music_names[0]); i++) {
			textprintf(double_buffer, stalked_data[tiny_font].dat, leftmost_column_start+((i/rows)*column_width), topmost_row_start+((i%rows)*6), -1, "%s", music_names[i]);
			}
		draw_sprite(double_buffer,stalked_data[mouse_arrow].dat,mouse_x,mouse_y);
		blit(double_buffer,screen,0,0,0,0,320,200);
		}
	}

void main() {
	int i,j;
   RGB black = {0,0,0};
   RGB *blackptr = &black;
	file_name = (char *)malloc(13);
	num_buffer = (char *)malloc(6);
	message = (char *)malloc(41);
	old_name = (char *)malloc(13);
   for (i=0; i<13; i++) {
	   file_name[i] = '\0';
       tile_file_name[i] = '\0';
       next_file_name[i] = '\0';
	   bkgd_file_name[i] = '\0';
       }
	sprintf(tile_file_name, "NSBLOX1.PCX\0");
	sprintf(next_file_name, "END\0");
   sprintf(bkgd_file_name, "DEFAULTB.PCX\0");
   transparency = 0;
   relative_scroll_rate = 0;
   rise_rate = 0;
   how_player_enters = 0;
   how_player_exits = 0;
   left_end_type = 0;
   left_end_slant = 0;
   left_end_offset = 0;
   right_end_type = 0;
   right_end_slant = 0;
   right_end_offset = 0;
   top_end_type = 0;
   bottom_end_type = 0;
   color_cycle_low_end = 0;
   color_cycle_high_end = 0;
   color_cycle_speed = 0;
   music_num = 0;
   number_of_things = 0;
   for (i=0; i<MAX_THINGS; i++) {
	things[i].type = 0;
	things[i].x = 0;
	things[i].y = 0;
	things[i].z = 0;
	things[i].palette = 0;
	things[i].thing_inside = 0;
	}
   allegro_init();
   stalked_data = load_datafile("stalked.dat");
   text_mode(-1);
   //set_mouse_sprite(stalked_data[mouse_arrow].dat);
	Level_Malloc();
	Clear_Level();
	start_spot_x = 32;
   start_spot_y = 0;
   start_spot_z = 160;
   walk_to_spot_x = 360;
   walk_to_spot_y = 0;
   walk_to_spot_z = 160;
   top_end_z = 128;
   bottom_end_z = 199;
	Reset_Trigger_Points();
   bg_pic = load_pcx(bkgd_file_name,brizzle_palette);
   Load_Trans_Table("nsblox1.tra");
   Load_Tile_Set(tile_file_name);
	num_rows = 13;
	row_length = 20;
	Load_Font("nsfonts1.pcx");
	Sprite_Init((sprite_ptr)&cursor);
	Sprite_Init((sprite_ptr)&arrow);
	for (i=0; i<MAX_ENEMIES; i++)
		Sprite_Init((sprite_ptr)&enemy[i]);
	for (i = 0; i < MAX_SPRITES; i++) {
		Sprite_Init(&sprites[i]);
		}
	for (i=0; i<MAX_SPRITES; i++) {
		priority_table[i] = (sprite_ptr)&sprites[i];
		}
	Load_Frames("stalkers.nff");
   cursor.curr_frame = 36;
   cursor.z = 0;
   	message = "STALKED VERSION 2.6 BY TIM NOLAN";
	Init_Double_Buffer();
	set_gfx_mode(GFX_AUTODETECT,320,200,320,200);
	hold_screen_buffer = create_bitmap(320,200);
   install_keyboard();
   install_timer();
   install_mouse();
   // freeze_mouse_flag = 1;
	set_palette(brizzle_palette);
   set_color(0, blackptr);
	clear(screen);
	while (!Get_Press(KEY_ESC)) {
		if (key[KEY_LEFT]) {
			if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
				start_x-=10;
				if (start_x < 0)
					start_x = 0;
				}
			else
			if (start_x > 0)
				start_x--;
			}
		if (key[KEY_RIGHT]) {
			if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
				start_x+=10;
				if (start_x > ((row_length * 16) - screen_w))
					start_x = (row_length * 16) - screen_w;
				}
			else
			if (start_x < ((row_length * 16) - screen_w))
				start_x++;
			}
		if (key[KEY_UP]) {
			tile_timing++;
			if (tile_timing == 15)
				tile_timing = 0;
			}
		if (key[KEY_DOWN]) {
			tile_timing++;
			if (tile_timing == 15)
				tile_timing = 0;
			}
		if (key[KEY_UP] && key[KEY_DOWN]) {
			tile_timing = 0;
			}
		if (!key[KEY_UP] && !key[KEY_DOWN]) {
			tile_timing = 0;
			}
		if (key[KEY_DOWN] && tile_timing == 1) {
			if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
				using_tile-=10;
				if (using_tile < 0)
					using_tile = 0;
				}
			else
			if (using_tile > 0)
				using_tile--;
			}

		if (key[KEY_UP] && tile_timing == 1) {
			if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
				using_tile+=10;
				if (using_tile > TILE_COUNT-1)
					using_tile = TILE_COUNT-1;
				}
			else
			if (using_tile < TILE_COUNT-1)
				using_tile++;
			}
		if (Get_Press(KEY_HOME))
			start_x = 0;
		if (Get_Press(KEY_END))
			start_x = (row_length * 16) - screen_w;
		if (Get_Press(KEY_SLASH))
			message = "";
		if (Get_Press(KEY_F)) {
         if (!full_screen_display) {
				full_screen_display = 1;
				message = "";
				screen_w = 320;
				}
			else {
				clear(double_buffer);
				full_screen_display = 0;
				screen_w = 288;
				}
         }

		if (Get_Press(KEY_S)) {
			if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
				if (strcmp(file_name, "") != 0) {
					Save_File(1);
					}
				}
			else {
				Save_File(0);
				}
			}
		if (Get_Press(KEY_L)) {
			// key[38] = 2;
			Load_File();
			start_x = 0;
			}
		if (Get_Press(KEY_C)) {
			// key[46] = 2;
			if (key[KEY_LSHIFT] || key[KEY_RSHIFT])
				Show_Tile_Set_Name();
			else
				Change_Tile_Set();
			}
		if (Get_Press(KEY_X)) {

			if (key[KEY_LSHIFT] || key[KEY_RSHIFT])
				Show_Next_Scene_Name();
			else
				Change_Next_Scene();
			}
      if (Get_Press(KEY_B)) {

			if (key[KEY_LSHIFT] || key[KEY_RSHIFT])
				Show_Background_Name();
			else
				Change_Background();
			}
		if (Get_Press(KEY_N)) {
			// key[49] = 2;
			New_Level();
			}
		if (Get_Press(KEY_R)) {
			// key[19] = 2;
			Resize_Level();
			}
		if (Get_Press(KEY_G)) {
			// if (key_tracker[34] < 2) {

				if (strncmp(next_file_name, "END", 4) == 0)
					message = "NO NEXT SCENE.";
				else {
					if (Are_You_Sure("GO TO NEXT") == 1) {
						if ((_access(next_file_name,0)) != -1) {
							sprintf(messbuf, "NEXT SCENE %s LOADED.", next_file_name);
							message = messbuf;
							Load_Map(next_file_name);
							start_x = 0;
							}
						else {
							sprintf(messbuf, "FILE %s NOT FOUND.", next_file_name);
							message = messbuf;
							}
						}
					else {
						message = "GO TO NEXT SCENE CANCELLED.";
						}
					}
			//	}
			}
		if (Get_Press(KEY_T)) {
			// if (key_tracker[20] < 2) {

				if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
					View_Trigger_Points();
					}
				else if (key[KEY_LCONTROL] || key[KEY_RCONTROL]) {
					Go_To_Trigger_Point();
					}
				else {
					Insert_Trigger_Point();
					}
			//	}
			}
		if (Get_Press(KEY_BACKSLASH)) {
			if (Are_You_Sure("RESET TRIGS") == 1) {
				Reset_Trigger_Points();
				message = "TRIGGER POINTS RESET.";
				}
			else {
				message = "RESET TRIG POINTS CANCELLED.";
				}
			}
		if (Get_Press(KEY_O)) {
			// if (key_tracker[24] < 2) {

				if (Check_On_Trigger_Point() != -1) {
					curr_trigger = Check_On_Trigger_Point();
					sprintf(messbuf,"ON TRIGGER POINT %d, X=%d.",curr_trigger,start_x);
					message = messbuf;
					}
				else {
					message = "NOT ON A TRIGGER POINT.";
					}
			//	}
			}
		if (Get_Press(KEY_DEL)) {
			// if (key_tracker[83] < 2) {

				if (Check_On_Trigger_Point() != -1) {
					Delete_Trigger_Point(Check_On_Trigger_Point());
					}
			//	}
			}
		if (Get_Press(KEY_E)) {
			// if (key_tracker[18] < 2) {

				if (Check_On_Trigger_Point() != -1) {
					curr_trigger = Check_On_Trigger_Point();
					Trig_Edit_Mode();
					}
			//	}
			}
      if (Get_Press(KEY_J)) {
         Jump_To_Location();
         }
      if (Get_Press(KEY_A)) {
         Attribute_Edit_Mode();
         }
      if (Get_Press(KEY_M)) {
        if (key[KEY_LSHIFT] || key[KEY_RSHIFT])
			Show_Music_Name();
		else {
			i = Choose_Music();
			if (i != -1) {
				music_num = i;
				}
			}
        }
	  if (Get_Press(KEY_I)) {
		Item_Edit_Mode();
		}
	  if (full_screen_display) {
		screen_w = 320;
		}
	  else {
		screen_w = 288;
		}
      cursor.y = (mouse_y / 16) * 16;
		cursor.x = ((start_x + mouse_x) / 16) * 16;
      if (Get_Press(KEY_P)) {
         Make_Pattern(cursor.x/16,cursor.y/16);
         }
		if (mouse_b & 1) {
         /* if (key[KEY_LSHIFT] || key[KEY_RSHIFT])
            Flood_Fill(cursor.x/16,cursor.y/16,level[((cursor.y/16)*row_length)+(cursor.x/16)]);
         else */ if (cursor.x / 16 < row_length)
				level[((cursor.y/16)*row_length)+(cursor.x/16)] = using_tile;
			}
		if (mouse_b & 2) {
			if (cursor.x / 16 < row_length)
				using_tile = level[((cursor.y/16)*row_length)+(cursor.x/16)];
			}
		if (start_x > (row_length * 16) - screen_w)
			start_x = (row_length * 16) - screen_w;
		j = 0;
		for (i = 0; i < number_of_things; i++) {
			if (things[i].type != 0) {
				if (((things[i].x + frame_ptrs[object_frames[things[i].type]][0]) < (start_x+screen_w)) && (((things[i].x + frame_ptrs[object_frames[things[i].type]][0] + (unsigned char)frame_ptrs[object_frames[things[i].type]][2]) - 1) >= start_x)) {
					if (j < MAX_SPRITES) {
						sprites[j].curr_frame = object_frames[things[i].type];
						Place_Sprite(&sprites[j], things[i].x, things[i].y, things[i].z);
						sprites[j].palnum = things[i].palette;
						sprites[j].flipflag = NOFLIP;
						j++;
						}
					}
				}
			}
		while (j < MAX_SPRITES) {
			sprites[j].curr_frame = -1;
			Place_Sprite(&sprites[j], NOWHERE, NOWHERE, NOWHERE);
			sprites[j].palnum = 0;
			sprites[j].flipflag = NOFLIP;
			j++;
			}
		Set_Priflags();
		prisort(priority_table, 0, MAX_SPRITES-1);
		Draw_Screen(start_x,start_y);
		for (i = 0; i < MAX_SPRITES; i++) {
			Palette_Blit_Sprite(priority_table[i]);
			}
		if (!full_screen_display) {
			Erase_Right_Side();
			Blit_Word(0,192,message);
			Blit_Word(0,0,"X=");
			Blit_Number(16,0,start_x);
			Blit_Word(288,0,"CURR");
			Blit_Word(288,8,"TILE");
			Blit_Tile(296,16,using_tile);
			Blit_Number_Space(292,32,using_tile,3);
			Palette_Blit_Sprite((sprite_ptr)&cursor);
			double_buffer->line[mouse_y][mouse_x] = mouse_color;
         }
      vsync();
		blit(double_buffer,screen,0,0,0,0,320,200);
		if (mouse_color == 2)
			mouse_color = 1;
		else
			mouse_color = 2;
		if (cursor.palnum == 0)
			cursor.palnum = 5;
		else
			cursor.palnum = 0;
		}

	}

END_OF_MAIN();