#ifndef NSDEFS_H
#define NSDEFS_H

#define TILE_COUNT (int) 254
#define MAX_LEVEL_SIZE 65535
#define FPS 70
#define GRAVITY 5
#define NOWHERE -9999
#define MAX_ENEMIES 6
#define MAX_FRAMES 1000
#define MAX_SPRITES 30
#define MAX_PLAYERS 4 // 2
#define Z_HIT_RANGE 8
#define PLAYER_GRAB_X_RANGE 16
#define PLAYER_GRAB_Z_RANGE 3
#define ELK_GRAB_X_RANGE 30
#define ELK_GRAB_Z_RANGE 4
#define PICK_UP_X_RANGE 20
#define PICK_UP_Z_RANGE 6
#define PLAYER_GRACE_PERIOD 35
#define PLAYER_HIT_ENEMY enemy[e].x+actor_cboxes[enemy[e].box_used].box_params[enemy[e].curr_box][0]+actor_cboxes[enemy[e].box_used].box_params[enemy[e].curr_box][2]>player.at_x&&enemy[e].x+actor_cboxes[enemy[e].box_used].box_params[enemy[e].curr_box][0]<player.at_x+player.at_width&&enemy[e].y+actor_cboxes[enemy[e].box_used].box_params[enemy[e].curr_box][1]+actor_cboxes[enemy[e].box_used].box_params[enemy[e].curr_box][3]>player.at_y&&enemy[e].y+actor_cboxes[enemy[e].box_used].box_params[enemy[e].curr_box][1]<player.at_y+player.at_height&&enemy[e].z>player.z-Z_HIT_RANGE&&enemy[e].z<player.z+Z_HIT_RANGE
#define ENEMY_HIT_PLAYER player.x+actor_cboxes[player.box_used].box_params[player.curr_box][0]+actor_cboxes[player.box_used].box_params[player.curr_box][2]>enemy[e].at_x&&player.x+actor_cboxes[player.box_used].box_params[player.curr_box][0]<enemy[e].at_x+enemy[e].at_width&&player.y+actor_cboxes[player.box_used].box_params[player.curr_box][1]+actor_cboxes[player.box_used].box_params[player.curr_box][3]>enemy[e].at_y&&player.y+actor_cboxes[player.box_used].box_params[player.curr_box][1]<enemy[e].at_y+enemy[e].at_height&&player.z>enemy[e].z-Z_HIT_RANGE&&player.z<enemy[e].z+Z_HIT_RANGE
#define E_FALL_VEL 100
#define PLAYER_DIRECTION ((player.flipflag == FLIP)? -1 : 1)
#define ENEMY_DIRECTION ((enemy[e].flipflag == FLIP)? -1 : 1)
#define DIRECTION_TO_PLAYER ((player.x < enemy[e].x)? -1 : 1)
#define MAX_TRIGGER_POINTS 100
#define WHO 0
#define HOW 1
#define D_LVL 2
#define NO_TRIG 9999
#define P_FALL_VEL 120
#define EN_TIME 140
#define MESS_TIME 350
#define DELAY_TIME 210
#define AT_TIME 50
#define INDEX_UP KEY_UP
#define INDEX_DOWN KEY_DOWN
#define INDEX_LEFT KEY_LEFT
#define INDEX_RIGHT KEY_RIGHT
#define INDEX_JUMP KEY_ALT
#define INDEX_ATTACK KEY_CONTROL
#define TARGET player[spr->target]
#define SPRITE_DIRECTION ((spr->flipflag == FLIP)? -1 : 1)
#define TARGET_DIRECTION ((player[spr->target]->flipflag == FLIP)? -1 : 1)
#define DIRECTION_TO_TARGET ((player[spr->target]->x < spr->x)? -1 : 1)
#define MAX_BARS 6
#define MAX_THINGS 100
#define NORTH 0
#define EAST 1
#define SOUTH 2
#define WEST 3
#define JUMP 4
#define STRIKE 5

enum sprite_states{STANDING=0, JUMPING, ATTACK1, ATTACK2, ATTACK3, ATTACK4, ATTACK5, GET_HIT_HEAD, GET_HIT_STOMACH, KNOCKED_DOWN, ON_GROUND, ON_GROUND_BRIEF, BOUNCE, DEAD, INACTIVE, HOP_TOWARD, HOP_AWAY, GET_UP, WALK_DOWN, WALK_UP, CHARGING, DOUBLE_JUMP, DROP, LEANING, SITTING, KNEELING_AWAY, KNEELING_FORWARD, KNEELING_TOWARD, APPROACH, RETREAT, PAUSING, GET_BEHIND, Z_ADJUST, WALKING, JUMP_ATTACK, BLINK_OUT, WAIT_FOR_NEXT_LIFE, HOLDING, HELD1, HELD2, HELD3, DROP_FREE, HOLD_ATTACK, THROWING, WALKING_HOLD, JUMPING_HOLD, PILEDRIVER, THROWN, SPECIAL, RIDE_CURTAINS, PICK_UP, GENERIC1, GENERIC2, GENERIC3};

enum agents{CPU, CPU_ENEMY, HUMAN, CPU_BREAKABLE, CPU_ITEM, CPU_FOOD, CPU_SOLID};

enum actor_types{NO_TYPE=0, RAT=1000, BOAR, ELK, CHEETAH, WEASEL, DUCK, TURTLE, SALAMANDER, KOALA, FLUFFY, RHINO, SHELLY, OPIE, OMAR, RYUTARO, GERRI, CASTOR, MAXINE, LENNY, BOBO, MING, AL, EFFECT};

enum thing_types{NO_THING=0, RANDOM_ITEM, RANDOM_FOOD, OIL_DRUM, SANDWICH, GEM, YOGURT, DEBRIS_BOTTOM, DEBRIS_FLYING, NEW_ITEM}; // insert all new entries before DEBRIS_BOTTOM

enum effect_types{BLOOD=2000, SMACK_MARK, KICK_MARK, BLOCK_MARK};

enum mindsets{OFFENSIVE, DEFENSIVE, CLEVER, COMBO1, COMBO2};

enum color_bands{Reserved, Blue, Green, Yellow, Red, Orange, Purple, Gray, Mahogany, Turquoise, Gold, Cyan, Dull_Green, Magenta, Sepia, Blue_Violet};
#endif
