// Graphics Module
// Important!

#include "cGraphics.h"

// Static member implementation
bool cGraphics::initialized;
bool cGraphics::trail_effect_enabled;
BITMAP *cGraphics::double_buffer;
BITMAP *cGraphics::not_loaded;
int cGraphics::SCR_WIDTH;
int cGraphics::SCR_HEIGHT;
int cGraphics::mode;

bool
cGraphics::Initialize (int new_mode)
{
	int video_card, scr_h;
	PALETTE pal;
	cImage *bar;
	
	switch (new_mode)
	{
	case DEBUG:
		video_card = GFX_AUTODETECT_WINDOWED;
		SCR_WIDTH = 800;
		SCR_HEIGHT = 600;
		scr_h = 600;
		break;
	case FULLSCREEN:
		video_card = GFX_AUTODETECT_FULLSCREEN;
		SCR_WIDTH = 800;
		SCR_HEIGHT = 600;
		scr_h = 600;
		break;
	case WIDESCREEN:
		video_card = GFX_AUTODETECT_FULLSCREEN;
		SCR_WIDTH = 1024;
		SCR_HEIGHT = 600;
		scr_h = 768;
		break;
	default:// Complain about an error
		return false;
		break;
	}
	
	mode = new_mode;
	
	set_color_depth(16);
	if (!set_gfx_mode(video_card, SCR_WIDTH, scr_h, 0, 0))
		initialized = false;

	// Successfully initialized graphics!
	initialized = true;
	trail_effect_enabled = false;

	// Allocate memory for double buffer
	double_buffer = create_bitmap(SCR_WIDTH+1, SCR_HEIGHT+1);
	
	// Load "Not Loaded!" picture
	not_loaded = load_bitmap("media/NotLoaded.pcx", pal);
	
	if (mode == WIDESCREEN) {
		bar = new cImage();
		bar->GenerateFractal(0,1024,84,-0.7995-0.003*8,-0.1809-0.0030,0.0030*12.2,0.0030,90,0);
		blit(bar->pic, screen, 0, 0, 0, 0, SCR_WIDTH, 84);
		bar->GenerateFractal(0,1024,84,-0.7995-0.003*8,-0.1809,0.0030*12.2,0.0030,90,0);
		blit(bar->pic, screen, 0, 0, 0, 684, SCR_WIDTH, 84);
		delete bar;
	}
	return (initialized);
}// end cGraphics::Initialize

void
cGraphics::DrawBuffer ()
{
	static bool draw_vsync = false;
	
	draw_vsync ^= true; // ^ is xor
	
	//if (draw_vsync)
		vsync();

	if (mode == WIDESCREEN)
		blit(double_buffer, screen, 0, 0, 0, 84, SCR_WIDTH, SCR_HEIGHT);
	else
		blit(double_buffer, screen, 0, 0, 0, 0, SCR_WIDTH, SCR_HEIGHT);
}// end cGraphics::DrawBuffer

bool
cGraphics::AlreadyInitialized()
{
	return (initialized);
}// end cGraphics::AlreadyInitialized

void
cGraphics::UnloadModule()
{
	destroy_bitmap(not_loaded);
	destroy_bitmap(double_buffer);
}// end cGraphics::UnloadModule

int
cGraphics::GetMode()
{
	return(mode);
}// end cGraphics::GetMode

void
cGraphics::SetMode(int new_mode)
{
	int video_card, scr_h;
	cImage *bar;

	switch (new_mode)
	{
	case DEBUG:
		video_card = GFX_AUTODETECT_WINDOWED;
		SCR_WIDTH = 800;
		SCR_HEIGHT = 600;
		scr_h = 600;
		break;
	case FULLSCREEN:
		video_card = GFX_AUTODETECT_FULLSCREEN;
		SCR_WIDTH = 800;
		SCR_HEIGHT = 600;
		scr_h = 600;
		break;
	case WIDESCREEN:
		video_card = GFX_AUTODETECT_FULLSCREEN;
		SCR_WIDTH = 1024;
		SCR_HEIGHT = 600;
		scr_h = 768;
		break;
	default:// Complain about an error
		return;
		break;
	}
	
	destroy_bitmap (double_buffer);
	
	mode = new_mode;
	
	set_color_depth(16);
	set_gfx_mode(video_card, SCR_WIDTH, scr_h, 0, 0);

	// Successfully initialized graphics!
	initialized = true;
	trail_effect_enabled = false;

	// Allocate memory for double buffer
	double_buffer = create_bitmap(SCR_WIDTH+1, SCR_HEIGHT+1);
	
	if (mode == WIDESCREEN) {
		bar = new cImage();
		bar->GenerateFractal(0,1024,84,-0.7995-0.003*8,-0.1809-0.0030,0.0030*12.2,0.0030,90,0);
		blit(bar->pic, screen, 0, 0, 0, 0, SCR_WIDTH, 84);
		bar->GenerateFractal(0,1024,84,-0.7995-0.003*8,-0.1809,0.0030*12.2,0.0030,90,0);
		blit(bar->pic, screen, 0, 0, 0, 684, SCR_WIDTH, 84);
		delete bar;
	}
}

void
cGraphics::DrawText (int x, int y, int r, int g, int b, char *text)
{
	textout_ex(double_buffer, font, text, x, y, makecol(r,g,b), -1);
}
