// City module 

#include "cCity.h"

static long RandGen(void);

static long seed;
static cImage *base[6], *ext[3];

// default city
cCity::cCity()
{
	int i, j;
	
	base[0] = new cImage("media/building_base.pcx");
	base[1] = new cImage("media/building_base2.pcx");
	base[2] = new cImage("media/building_base3.pcx");
	base[3] = new cImage("media/grass.pcx");
	base[4] = new cImage("media/rubble.pcx");
	base[5] = new cImage("media/water.pcx");
	
	ext[0] = new cImage("media/building_ext.pcx");
	ext[1] = new cImage("media/building_ext2.pcx");
	ext[2] = new cImage("media/building_ext3.pcx");
	
	x_tiles = 40;
   	y_tiles = 30;
   	
	map = (int **)malloc(y_tiles*sizeof(int *)+1);

	seed = 10141206;//19781014;
	for (i = 0; i < y_tiles; i++) {
		map[i] = (int *)malloc(x_tiles*sizeof(int)+1);
		for (j = 0; j < x_tiles; j++) {
				map[i][j]=(RandGen()%4)+100*(RandGen()%2);
				if (map[i][j]%100 >= 2) {
					if (RandGen()%2) {
					//	map[i][j]-= 1+RandGen()%2;
					}
				}
    
     			if (RandGen()%72 == 0)	
     				map[i][j] = (RandGen()%3)*100+7+RandGen()%3;
     				
				// Water
				if (i < 4 || i > y_tiles - 4 || j < 4 || j > x_tiles-5) {
     				map[i][j] = CITY_WATER;
				}
		}
	}
	map[7][6] = CITY_GRASS;//grass
	map[7][7] = CITY_GRASS;//grass
	map[8][6] = CITY_GRASS;//grass
	map[8][7] = 212;//tower
	map[8][8] = CITY_GRASS;//grass
	map[9][8] = 104;//5-storey building
	map[9][6] = CITY_GRASS;//grass
	map[9][7] = CITY_GRASS;//grass
	map[15][20] = CITY_GRASS;
	
	x_start = 2624;
 	y_start = 1488;
 	tile_size_x = 128;
  	tile_size_y = 96;
   	world_w = tile_size_x * x_tiles;
   	world_h = tile_size_y * y_tiles;
   	scr_tile_w = cGraphics::SCR_WIDTH/tile_size_x + 2;
    scr_tile_h = cGraphics::SCR_HEIGHT/tile_size_y + 2;
	storey_height = 31;
	population = 0;
	
	for (i = 0; i < y_tiles; i++)
		for (j = 0; j < x_tiles; j++)
			if (map[i][j] / 100 < 3)
				population += (map[i][j]%100+1)*193;
}

cCity::~cCity()
{
	int i;
	
	for (i = y_tiles-1; i >= 0; i--)
		free(map[i]);
	free(map);
	
	delete ext[2];
	delete ext[1];
	delete ext[0];
	delete base[5];
	delete base[4];
	delete base[3];
	delete base[2];
	delete base[1];
	delete base[0];
}

void
cCity::GetTile(int test_x, int test_y, int *x_tile, int *y_tile)
{
	*y_tile = (test_y )/tile_size_y;
	*x_tile = (test_x-32*(*y_tile%3))/tile_size_x;
}

void
cCity::DrawBase(int x, int y)
{
	int first_i, first_j, x_offset, y_offset;
 	int map_item, floor, i, j;

	first_i = y/tile_size_y;
		
	switch (first_i%3)
	{
	case 0:
		first_j = x/tile_size_x;
		x_offset = x - first_j*tile_size_x;
		break;
	case 1:
		first_j = (x-32)/tile_size_x;
		x_offset = x - first_j*tile_size_x-32;
		break;
	case 2:
		first_j = (x-64)/tile_size_x;
		x_offset = x - first_j*tile_size_x-64;
		break;
	}
	
	y_offset = y%tile_size_y;

	for (i = 0; i < scr_tile_h+5; i++) { // +5 is cheap way around tower problem
		if (i+first_i >= y_tiles || i+first_i < 0)
			continue;
		for (j = 0; j < scr_tile_w; j++) {
			if (j+first_j >= x_tiles || j+first_j < 0) // Lazy safety
				continue;
			map_item = map[i+first_i][j+first_j];
			base[map_item/100]->Draw(j*tile_size_x-x_offset, i*tile_size_y-y_offset);

			// Storeys above ground
			for (floor = 0; floor < MIN(4,map_item%100); floor++) {
				ext[map_item/100]->Draw(j*tile_size_x-x_offset,
    									i*tile_size_y-storey_height*(floor+1)-y_offset);
			}
		}	
		// Adjust first_j as necessary
		switch ((first_i+i)%3)
		{
		case 0:
		case 1:
			if (x_offset >= 32) {
				x_offset -= 32;
			}
			else {
				--first_j;
				x_offset += 96;
			}
			break;
		case 2:
			if (x_offset < 64) {
				x_offset += 64;
			}
			else {
				++first_j;
				x_offset -= 64;
			}
			break;
		default:
			//complain about an error here
			break;
		}
	}
}

void
cCity::DrawExt(int x, int y)
{
	int first_i, first_j, x_offset, y_offset;
 	int map_item, floor, i, j;
 	
 	first_i = y/tile_size_y;
		
	switch (first_i%3)
	{
	case 0:
		first_j = x/tile_size_x;
		x_offset = x - first_j*tile_size_x;
		break;
	case 1:
		first_j = (x-32)/tile_size_x;
		x_offset = x - first_j*tile_size_x-32;
		break;
	case 2:
		first_j = (x-64)/tile_size_x;
		x_offset = x - first_j*tile_size_x-64;
		break;
	}
	
	y_offset = y%tile_size_y;

	for (i = 0; i < scr_tile_h+5; i++) { // +5 is cheap way around tower problem
			if (i+first_i >= y_tiles || i+first_i < 0)
			continue;
		for (j = 0; j < scr_tile_w; j++) {
			if (j+first_j >= x_tiles || j+first_j < 0)
				continue;
			map_item = map[i+first_i][j+first_j];
			for (floor = 4; floor < map_item%100; floor++) {
				ext[map_item/100]->Draw(j*tile_size_x-x_offset, 
    									i*tile_size_y-storey_height*(floor+1)-y_offset);
			}
		}
		// Adjust first_j as necessary
		switch ((first_i+i)%3)
		{
		case 0:
		case 1:
			if (x_offset >= 32) {
				x_offset -= 32;
			}
			else {
				--first_j;
				x_offset += 96;
			}
			break;
		case 2:
			if (x_offset < 64) {
				x_offset += 64;
			}
			else {
				++first_j;
				x_offset -= 64;
			}
			break;
		default:
			//complain about an error here
			break;
		}
	}
}

void
cCity::CalcScreenTiles()
{
	scr_tile_w = cGraphics::SCR_WIDTH/tile_size_x + 2;
    scr_tile_h = cGraphics::SCR_HEIGHT/tile_size_y + 2;
}

int
cCity::GetCityWidthPixel()
{
	return (world_w);
}

int
cCity::GetCityHeightPixel()
{
	return (world_h);
}

void
cCity::LowerBuilding(int x, int y)
{
	int i, j;
	
	// Cull request
	if (x < 0 || x >= world_w || y < 0 || y >= world_h)
		return;
		
	GetTile(x, y, &j, &i);
	
	if (map[i][j] % 100 != 0)
		--map[i][j];

	// Completely destroyed
	if (map[i][j] % 100 == 0 && map[i][j] != CITY_GRASS && map[i][j] != CITY_WATER)
		map[i][j] = CITY_RUBBLE;
		
	population -= 193;
	if (population < 0)
		population = 0;
}

int
cCity::GetBuildingHeight(int x, int y)
{
	int i, j;
	
	// Cull request
	if (x < 0 || x >= world_w || y < 0 || y >= world_h)
		return 0;
		
	GetTile(x, y, &j, &i);
	if (map[i][j] != CITY_GRASS && map[i][j] != CITY_RUBBLE && map[i][j] != CITY_WATER)
		return ((map[i][j] % 100) + 1);
	//else
		return (0);
}

int
cCity::GetStoreyHeight()
{
	return (storey_height);
}

void
cCity::GetStartingPoint(int *x, int *y)
{
	*x = x_start;
	*y = y_start;
}

int
cCity::GetPopulation()
{
	return (population);
}

static long
RandGen(void)
{
	unsigned long hi, lo;

	lo = 16807 * (seed & 0xFFFF);
	hi = 16807 * (seed >> 16);
	
	lo += (hi & 0x7FFF) << 16;
	lo += hi >> 15;
	
	if (lo > 0x7FFFFFFF) lo -= 0x7FFFFFFF;
	
	seed = (long)lo;
	
	return (seed);
}
