// Main Module for SpeedHack 2007 Entry
// Copyright Kwame Alexander, Sep.14, 2007

#include <allegro.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "cGraphics.h"
#include "cImage.h"
#include "cFX.h"
#include "cCity.h"
#include "cColour.h"
#include "cBall.h"

#define FACE_DOWN	0
#define FACE_UP		1
#define FACE_LEFT	2
#define FACE_RIGHT	3

#define FAERIE_X	(x+cGraphics::SCR_WIDTH/2)
#define FAERIE_Y	(y + cGraphics::SCR_HEIGHT/2+FAERIE_ALT)
#define FAERIE_ALT	155

static void DrawShadow(int x, int y, cImage *shadow, int bldg_h_pix, int alt);
static void LocateFaerie(int f_x, int f_y, int *x, int *y);
static void FaerieBomb (int x, int y, cCity *city, int time_set);
static int MainMenu(void);

int main (void)
{
	int i, j, x, y, cool=0, x_offset=0, y_offset=0, x_start,y_start;
	int floor, temp_tile, tiles_across, tiles_down, first_i, first_j;
	int map_item, f_j, x_o, world_w, world_h, f_tile_i, f_tile_j, curr_frame=FACE_DOWN;
	int fire_index=0, restrictor = -1, shadow_height, bomb_restrictor=-1;
	int bomb_power = 121;
	long framecounter=0;
	bool first_press=true, still_pressing=false;
	char population[25];
	cImage *faerie[4], *shadow[2], *circle, *circle2, *pop_sign;
	cCity *city;
	cBall *fire[8], *ffire;
	MIDI *music;

 	allegro_init();
	install_keyboard();
	install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
	srand(time(NULL));
	
	
	set_color_depth(16);
	cGraphics::Initialize(cGraphics::FULLSCREEN);
		
	//textout_ex(screen, font, "Kwame is great!", 100, 100, makecol(0,128,255), -1);
	
	// Yay music!
	music = load_midi("media/music0.mid");
/*	fp=fopen("scrap/midilength.txt","wt");
	fprintf(fp, "midi length: %d", get_midi_length(music));
	fclose(fp);*/
 	
 	play_looped_midi(music, 8, -1);
 	//play_midi(music,1);
 	midi_seek(8);
 	
 	if (MainMenu()==1) {
		cGraphics::UnloadModule();
		stop_midi();
		destroy_midi(music);
		return (0);
	}


	faerie[FACE_DOWN] = new cImage("media/faerie.pcx");
	faerie[FACE_UP] = new cImage("media/faerie_back.pcx");
	faerie[FACE_LEFT] = new cImage("media/faerie_left.pcx");
	faerie[FACE_RIGHT] = new cImage("media/faerie_right.pcx");
	shadow[0] = new cImage("media/shadow.pcx");
	shadow[1] = new cImage("media/small_shadow.pcx");
	circle = new cImage("media/circle96x96.pcx");
	circle2 = new cImage("media/circle64x64.pcx");
	pop_sign = new cImage("media/pop_sign.pcx");
	
 	for (i = 0; i<8;i++) {
	 	fire[i] = new cBall();
	}
	
	// Generate city
	city = new cCity();
	
	// Dimensions of world in pixels
	world_w = city->GetCityWidthPixel();
	world_h = city->GetCityHeightPixel();

	// Locate faerie at starting point
	city->GetStartingPoint(&x_start,&y_start);
	LocateFaerie(x_start,y_start,&x,&y);
 		
	while (!key[KEY_ESC]) {
		if (key[KEY_UP]) {
			y-=5;
			if (y < 0)
				y = 0;
			// Collide with high buildings
			if (city->GetBuildingHeight(FAERIE_X, FAERIE_Y) > 5)
				y += 5;
			curr_frame = FACE_UP;
		}
		if (key[KEY_DOWN]) {
			y+=5;
			if (y > world_h - cGraphics::SCR_HEIGHT - 1)
				y = world_h - cGraphics::SCR_HEIGHT - 1;
			// Collide with high buildings
			if (city->GetBuildingHeight(FAERIE_X, FAERIE_Y) > 5)
				y -= 5;
			curr_frame = FACE_DOWN;
		}
		if (key[KEY_LEFT]) {
			x-=5;
			// 64 is the limit, but add 112 for widescreen
			if (x < 64 && cGraphics::GetMode() == cGraphics::WIDESCREEN) 
				x = 64;
			else if (x < 112+64 && cGraphics::GetMode() != cGraphics::WIDESCREEN)
				x = 112+64;
			// Collide with high buildings
			if (city->GetBuildingHeight(FAERIE_X, FAERIE_Y) > 5)
				x += 5;
			
			curr_frame = FACE_LEFT;
		}
		if (key[KEY_RIGHT]) {
			x+=5;
			if (x > world_w - cGraphics::SCR_WIDTH-1)
				x = world_w - cGraphics::SCR_WIDTH-1;
			// Collide with high buildings
			if (city->GetBuildingHeight(FAERIE_X, FAERIE_Y) > 5)
				x -= 5;
			curr_frame = FACE_RIGHT;
		}
		if (key[KEY_F1]) {
			if (cGraphics::GetMode() == cGraphics::WIDESCREEN) {
				cGraphics::SetMode(cGraphics::FULLSCREEN);
				city->CalcScreenTiles();
				x += 112;
			}
			else {
				cGraphics::SetMode(cGraphics::WIDESCREEN);
				city->CalcScreenTiles();
				x -= 112;
			}
		}
		// Faerie Fire
		ffire = fire[++fire_index&0x7];
			
		if (key[KEY_LSHIFT] && framecounter > restrictor && !ffire->active) {
			
			ffire->active = true;
			
			switch (curr_frame)
			{
			case FACE_DOWN:
				ffire->Create(FAERIE_X, FAERIE_Y+9, FAERIE_ALT,
    						  rand()%7-3, 5, 7+rand()%7);
				if (key[KEY_DOWN])
					ffire->y_vel+=5;
				break;
			case FACE_UP:
				ffire->Create(FAERIE_X, FAERIE_Y-9, FAERIE_ALT,
    						  rand()%7-3, -5, 7+rand()%7);
				if (key[KEY_UP])
					ffire->y_vel-=5;
				break;
			case FACE_LEFT:
				ffire->Create(FAERIE_X-12, FAERIE_Y, FAERIE_ALT,
    						  -7, rand()%5-2, 7+rand()%7);
				if (key[KEY_LEFT])
					ffire->x_vel-=5;
				break;
			case FACE_RIGHT:
				ffire->Create(FAERIE_X-12, FAERIE_Y, FAERIE_ALT,
    						  7, rand()%5-2, 7+rand()%7);
				if (key[KEY_RIGHT])
					ffire->x_vel+=5;
				break;
			}
			
			restrictor = framecounter + 3;
		}
		
		for (i = 0; i < 8; i++)
  			fire[i]->Update(city);	

		city->DrawBase(x, y);
		
		for (i = 0; i < 8; i++)
			if (fire[i]->y < FAERIE_Y)
				fire[i]->Draw(x,y, shadow[1]);

  		DrawShadow(cGraphics::SCR_WIDTH/2-24,cGraphics::SCR_HEIGHT/2+32,shadow[0],
				   city->GetBuildingHeight(FAERIE_X,FAERIE_Y)*city->GetStoreyHeight(),FAERIE_ALT);
  		
		faerie[curr_frame]->DrawCentred(cGraphics::SCR_WIDTH/2,cGraphics::SCR_HEIGHT/2+abs((framecounter/10)%11-5));

		// Faerie bomb
		if (key[KEY_LCONTROL]) {
			//if (first_press || still_pressing && 
   			if (bomb_power > 0) {
				++cool;
				circle->AndMaskDraw(FAERIE_X-x-48,FAERIE_Y-FAERIE_ALT-y-48, 24+abs(((cool/3)%15)-7)<<12);
				circle2->OrMaskDraw(FAERIE_X-x-32,FAERIE_Y-FAERIE_ALT-y-32, 31);

				if (still_pressing)
					FaerieBomb (FAERIE_X, FAERIE_Y, city, -1);
				else
					FaerieBomb (FAERIE_X, FAERIE_Y, city, 0);
				
				still_pressing = true;
				--bomb_power;
				
				for (i = 0; i < 25; i++)
					fire[0]->pic[1+rand()%2]->AndMaskDraw(rand()%(cGraphics::SCR_WIDTH-24),
     									 rand()%(cGraphics::SCR_HEIGHT-24), 0x1F);
			}
		}
		else {
				still_pressing = false;
		}
  		if (!still_pressing && framecounter%30 == 0) {
  			++bomb_power;
  			if (bomb_power > 121)
  				bomb_power = 121;
		}
  		
  		for (i = 0; i < 8; i++)
			if (fire[i]->y >= FAERIE_Y)
				fire[i]->Draw(x,y, shadow[1]);
		
		city->DrawExt(x,y);

	//	textprintf_ex(cGraphics::double_buffer,font, 100, 0, makecol(0,255,255),-1, "fire[1]->y=%d   y+scr/2=%d",
    	//			  fire[1]->y, y+cGraphics::SCR_WIDTH/2);		

		
		sprintf (population, "Population: %7d ",city->GetPopulation());
		pop_sign->Draw(2,2);
  		cGraphics::DrawText(6,10,255,0,0,population);
		cFX::DrawRectangle(2,30, 2+bomb_power*2, 50, 0, 0, 128+abs(-127+framecounter%255));
			
		cGraphics::DrawBuffer();
		++framecounter;
	}// end while

	delete city;
	destroy_midi(music);
	for (i = 7; i>=0;i--) {
	 	delete fire[i];
	}
	delete pop_sign;
	delete circle2;
	delete circle;
	delete shadow[1];
	delete shadow[0];
	delete faerie[3];
	delete faerie[2];
	delete faerie[1];
	delete faerie[0];
	
	return (0);
}
END_OF_MAIN()

static void
CreateModeList (void)
{
	int i;
	FILE *fp;
	GFX_MODE_LIST *mode_list;	
 
 	mode_list = get_gfx_mode_list(GFX_DIRECTX);
	if (mode_list == NULL) {
		textout_ex(screen, font, "Failed mode list", 100, 150, makecol(0,128,255), -1);
		while (!keypressed());
		return;
	}
	fp = fopen ("scrap/mode_list.txt", "wt");
	
	for (i = 0; i < mode_list->num_modes; i++)
		fprintf(fp,"Width: %d\tHeight: %d\tBPP: %d\n",mode_list->mode[i].width,
				mode_list->mode[i].height,mode_list->mode[i].bpp);
	fclose(fp);
	destroy_gfx_mode_list(mode_list);
}

static void
DrawShadow(int x, int y, cImage *shadow, int bldg_h_pix, int alt)
{
	
	if (bldg_h_pix > alt)
		return;
		
	shadow->AndMaskDraw(x,y+alt-bldg_h_pix, 0x79EF);
}

static void
LocateFaerie(int f_x, int f_y, int *x, int *y)
{
	*x = f_x - cGraphics::SCR_WIDTH/2;
	*y = f_y - cGraphics::SCR_HEIGHT/2-155;
}

static void
FaerieBomb (int x, int y, cCity *city, int timer_set)
{
	int xx, yy, r=1;
	static long timer = 0;
 	
 	if (timer_set >= 0)
 		timer = timer_set;
 		
	for (r = 0; r < 4; r++) {
		if (timer == 30*r)
			for (yy = y-96*r; yy <= y+96*r; yy+=96)
				for (xx = x-128*r; xx <= x+128*r; xx+=128)
					city->LowerBuilding(xx,yy);
	}
	++timer;
}

static int
MainMenu(void)
{
	int choice=0, i;
 	long fc=0, res=0;
	cImage *bg, *face, *title, *menu, *arrow;
	
	bg = new cImage();
	face = new cImage("media/faerieface.pcx");
	title = new cImage("media/title.pcx");
	menu = new cImage("media/menu.pcx");
	arrow = new cImage("media/faerie_fire.pcx"); // make this blow up when enter is hit
	
	bg->GenerateFractal(1,800,600,1.767,0.036,0.003,0.0025,100,1);
	
	while (!key[KEY_ESC]&&!key[KEY_ENTER]) {
		bg->Draw(0,0);
		face->Draw(500,200);
		title->DrawCentred(400,90);
		menu->DrawCentred(400,300);
		arrow->Draw(280,255+choice*70);
		cGraphics::DrawBuffer();
		++fc;
		if (fc>res){
			if (key[KEY_DOWN]) {
				++choice;
				if (choice > 1)
					choice = 0;
				res = fc+15;
			}
			if (key[KEY_UP]) {
				--choice;
				if (choice < 0)
					choice = 1;
				res = fc+15;
			}
		}
	}

	if (key[KEY_ESC])
		choice = 1;
	
	delete menu;
	delete title;
	delete face;
	delete bg;
	
	return (choice);
}
