// Image header

#ifndef IMAGE_MODULE
#define IMAGE_MODULE

#include <allegro.h>
#include <stdlib.h>
#include <math.h>
#include "cGraphics.h"

class cGraphics;

class cImage // friend of cGraphics
{
	public:
		cImage();
		cImage(char *filename);
		~cImage();
		void Load(char *filename);
		void Unload();
		void Draw(int x, int y);
		void DrawCentred(int x, int y);
		void OrMaskDraw(int x, int y, short mask);
		void AndMaskDraw(int x, int y, short mask);
		void GenerateFractal(int type, int width, int height, double src_x, double src_y,
							 double src_w, double src_h, int iterations, int pal); // not realtime
		friend class cGraphics;//for sharing fractal info
	private:
		BITMAP *pic;
		bool loaded;
		static const int MAX_FRACTAL_ITERATIONS = 200;
		int half_w;
		int half_h;
};

#endif
