// Graphics Header
// Important

#ifndef GRAPHICS_MODULE
#define GRAPHICS_MODULE

#include <allegro.h>
#include "cImage.h"

class cFX;
class cImage;

class cGraphics
{
	public:
		static bool Initialize (int new_mode);
		static void UnloadModule();
		static bool AlreadyInitialized();
		static void DrawBuffer ();
		static const int DEBUG = 0;
		static const int FULLSCREEN = 1;
		static const int WIDESCREEN = 2;
		static bool trail_effect_enabled;
		static int SCR_WIDTH;
		static int SCR_HEIGHT;
		static int GetMode();
		static void SetMode(int new_mode);
		static void DrawText (int x, int y, int r, int g, int b, char *text);
		friend class cFX;
		friend class cImage;
		static BITMAP *double_buffer;
	private:
		//static BITMAP *double_buffer;
		static bool initialized;
		static BITMAP *not_loaded;
		static int mode;
};


#endif
