// City module header

#ifndef CITY_MODULE
#define CITY_MODULE


#include <stdlib.h>
#include "cGraphics.h"
#include "cImage.h"

#define	CITY_GRASS	300
#define CITY_RUBBLE	400
#define CITY_WATER	500

class cCity
{
public:
	cCity();// loads default city for now
 	cCity(char *filename);
	~cCity();
	void GetTile(int test_x, int test_y, int *x_tile, int *y_tile);
	void DrawBase(int x, int y);
	void DrawExt(int x, int y);
	int GetCityWidthPixel();
	int GetCityHeightPixel();
	void GetStartingPoint(int *x, int *y);
	void Load(char *filename);
	void CalcScreenTiles();
	void LowerBuilding(int x, int y);
	int GetBuildingHeight(int x, int y);
	int GetStoreyHeight();
	int GetPopulation();
private:
	int **map;
	int x_start, y_start;
	int tile_size_x, tile_size_y;// size of tile in pixels
	int x_tiles, y_tiles;// change to buildings
	int world_w, world_h;//city size in pixels
	int scr_tile_w, scr_tile_h;//number of tiles across screen
	int storey_height; // height of each bulding storey
	int population;
};

#endif
