// Individual Image Module

#include "cImage.h"

cImage::cImage()
{
	pic = NULL;
	loaded = false;
}// end cImage::cImage()

cImage::cImage(char *filename)
{
	loaded = false;
	Load(filename);
}// end cImage::cImage()

cImage::~cImage()
{
	Unload();
}// end cImage::~Image

void
cImage::Load(char *filename)
{
	PALETTE dummy;
	
	Unload();
	pic = load_bitmap(filename,dummy);
	loaded = true;
	half_w = pic->w/2;
	half_h = pic->h/2;
}// end cImage::Load

void
cImage::Unload()
{
	if (loaded) {
		destroy_bitmap(pic);
		loaded = false;
	}
	
}// end cImage::Unload

void
cImage::Draw(int x, int y)
{
	if (!loaded) {
	    draw_sprite(cGraphics::double_buffer, cGraphics::not_loaded,x,y);
		return;
	}
		
	draw_sprite(cGraphics::double_buffer, pic, x, y);
}// end cImage::Draw

void
cImage::DrawCentred(int x, int y)
{
	if (!loaded) {
	    draw_sprite(cGraphics::double_buffer, cGraphics::not_loaded,x,y);
		return;
	}
		
	draw_sprite(cGraphics::double_buffer, pic, x-half_w, y-half_h);
}// end cImage::DrawCentred

void
cImage::OrMaskDraw(int x, int y, short mask)
{
	int i, j;
	int l, w, t, h;
	int scr_w, scr_h;
	BITMAP *double_buffer;
	
	double_buffer = cGraphics::double_buffer;
	scr_w = cGraphics::SCR_WIDTH;
	scr_h = cGraphics::SCR_HEIGHT;
	
	if (!loaded) {
	    draw_sprite(double_buffer, cGraphics::not_loaded,x,y);
		return;
	}
	
	// Cull
	if (x + pic->w < 0 || x >= scr_w ||
		y + pic->h < 0 || y >= scr_h)
	{
		return;
	}
	
	// Clip to screen
	if (x < 0) {// Too far left
		l = -x;
		w = pic->w-l;
	}
	else if (x > scr_w - pic->w) {// Too far right
		l = 0;
  		w = scr_w - x;
	}
	else {
		l = 0;
		w = pic->w;
	}

	if (y < 0) {// Too far up
		t = -y;
		h = pic->h-t;
	}
	else if (y > scr_h - pic->h) {// Too far down
		t = 0;
  		h = scr_h - y;
	}
	else {
		t = 0;
		h = pic->h;
	}
  	
  	// Draw it!
	for (i = t; i < t+h; i++)
		for (j = l; j < l+w; j++)
			if (((unsigned short *)pic->line[i])[j] != 0xF81F) // compare with magenta(empty space)
				((short *)double_buffer->line[i+y])[j+x] |= mask;
}// end cImage::OrMaskDraw
			
void
cImage::AndMaskDraw(int x, int y, short mask)
{
	int i, j;
	int l, w, t, h;
	int scr_w, scr_h;
	BITMAP *double_buffer;
	
	double_buffer = cGraphics::double_buffer;
	scr_w = cGraphics::SCR_WIDTH;
	scr_h = cGraphics::SCR_HEIGHT;
	
	if (!loaded) {
	    draw_sprite(double_buffer, cGraphics::not_loaded,x,y);
		return;
	}
	
	// Cull
	if (x + pic->w < 0 || x >= scr_w ||
		y + pic->h < 0 || y >= scr_h)
	{
		return;
	}
	
	// Clip to screen
	if (x < 0) {// Too far left
		l = -x;
		w = pic->w-l;
	}
	else if (x > scr_w - pic->w) {// Too far right
		l = 0;
  		w = scr_w - x;
	}
	else {
		l = 0;
		w = pic->w;
	}

	if (y < 0) {// Too far up
		t = -y;
		h = pic->h-t;
	}
	else if (y > scr_h - pic->h) {// Too far down
		t = 0;
  		h = scr_h - y;
	}
	else {
		t = 0;
		h = pic->h;
	}
  	
  	// Draw it!
	for (i = t; i < t+h; i++)
		for (j = l; j < l+w; j++)
			if (((unsigned short *)pic->line[i])[j] != 0xF81F) // compare with magenta(empty space)
				((short *)double_buffer->line[i+y])[j+x] &= mask;
}// end cImage::AndMaskDraw

void
cImage::GenerateFractal(int type, int width, int height, double src_x, double src_y,
							 double src_w, double src_h, int max_iterations, int pal)
{
 	double min_x, max_x, min_y, max_y;
 	double x_scale, y_scale, x_offset, y_offset;
 	double x, y, x0, y0, x00, y00, temp;
 	int iteration, i, col_up, col_down, colour[MAX_FRACTAL_ITERATIONS+1];
    double col;
  
	if (max_iterations > MAX_FRACTAL_ITERATIONS)
		max_iterations = MAX_FRACTAL_ITERATIONS;
		
  	// Prepare image
   	Unload();
  	pic = create_bitmap(width, height);
  	
  	if (pal == 0) {
	  	// Set up palette (Red-Yellow-Red)
	    col = 255.0/(max_iterations/2.0);
	    for (i = 0; i < max_iterations/2; i++) {
	        col_down = 255-(int)(i*col);
	        if (col_down < 0)
	            col_down = 0;
	        col_up = (int)(i*col);
	        if (col_up > 255)
	            col_up = 255;
	        colour[i] = makecol(255,col_up,0);
	        colour[i+max_iterations/2] = makecol(255,col_down,0);
	    }
	    colour[max_iterations] = colour[0];
  	}
  	else {
  		// Set up palette (Green-Cyan-Green)
	    col = 255.0/(max_iterations/2.0);
	    for (i = 0; i < max_iterations/2; i++) {
	        col_down = 255-(int)(i*col);
	        if (col_down < 0)
	            col_down = 0;
	        col_up = (int)(i*col);
	        if (col_up > 255)
	            col_up = 255;
	        colour[i] = makecol(64,0,col_up);
	        colour[i+max_iterations/2] = makecol(64, 0,col_down);
	    }
	    colour[max_iterations] = colour[0];
 	}
  	// Set up variables to calculate fractal
  	min_x = src_x;
    max_x = src_x+src_w;
    min_y = src_y;
    max_y = src_y+src_h;
    
    x_scale = width/(max_x-min_x);
    y_scale = height/(max_y-min_y);
    x_offset = min_x-(-0.5*(max_x-min_x));
    y_offset = min_y-(-0.5*(max_y-min_y));
    
    for (y0 = 0; y0 < height; y0++) {
        for (x0 = 0; x0 < width; x0++) {
            x = x00=(x0 - width/2) / x_scale+x_offset;
            y = y00=(y0 - height/2) / y_scale+y_offset;
            
            iteration = 0;
            
            while (x*x+y*y<(2.0*2.0) && iteration < max_iterations)
            {
				if (type == 0) {
	                temp=(x+y)*(x-y)+x00;
    	            y = 2*x*y + y00;// choose which fractal to use
         		}
         		else {
         			temp=x*x-y*y-x00;
                	y = 2*fabs(x*y) - y00;
         		}
                x = temp;
                ++iteration;
            }

			// Uncomment to add transparency
		//	if (iteration > 65)
            	putpixel(pic,(int)x0,(int)y0,colour[iteration]);
        //	else
        //		putpixel(pic,(int)x0,(int)y0,makecol(255,0,255));//transparency(magenta)
        }
    }
    loaded = true;
}// end cImage::GenerateFractal
