// Faerie Fire Module

#include "cBall.h"

static void DrawShadow(int x, int y, cImage *shadow, int bldg_h_pix, int alt);

cBall::cBall()
{
	pic[0] = new cImage("media/faerie_fire.pcx");
	pic[1] = new cImage("media/faerie_fire2.pcx");
	pic[2] = new cImage("media/faerie_fire3.pcx");
	active = false;
	x = y = bldg_h = 0;
}

cBall::~cBall()
{
	delete pic[0];
 	delete pic[1];
  	delete pic[2];
}
		
void
cBall::Create(int xx, int yy, int aalt, int xx_vel, int yy_vel, int aalt_vel)
{
		int i;
		
	 	x = xx; y = yy; alt = aalt; x_vel = xx_vel, y_vel = yy_vel;
	 	alt_vel = aalt_vel;
	 	active = true;
	 	time_active = 0;
	 	state = 0;
	 	for (i = 0; i < 4; i++) {
	 		oldx[i] = x;
	 		oldy[i] = y;
		}
}
	
void
cBall::Update(cCity *city){
					int i;
					
					if (!active) return;
					
					if (state == 0) {
						// Trail
						if (time_active % 4 == 0) {
	       			  		for (i = 1; i < 4; i++) {
		       			  		oldx[i] = oldx[i-1];
		       			  		oldy[i] = oldy[i-1];
				  			}
				  			oldx[0] = x;
				  			oldy[0] = y;
			  			}
		 			  	x+=x_vel;y+=y_vel;alt+=alt_vel;alt_vel-=1;
		 				  	
	 				  	bldg_h= city->GetBuildingHeight(x,y)*city->GetStoreyHeight();
	
              			if (alt < bldg_h) {
	       			  		alt_vel = -alt_vel / 2;
	       			  		
	              			// Friction
	              			if (bldg_h == 0) {
	       			  			x_vel /= 2;
	       			  			y_vel /= 2;
			  				}
	    					if (time_active > 30) {
		        				//active = false;
		        				state = 1;
		        				city->LowerBuilding(x, y);
		        				time_active = 3;
	 						}
						}
					}
					else {
						if (time_active >= 9-1)
							active = false;

					}	
					++time_active;
        	  	};
void
cBall::Draw(int x_off, int y_off, cImage *shadow){
int i;

	if(!active)return;
 					
 	if (state == 0) {
		pic[0]->DrawCentred(x-x_off,y-y_off-alt);
		DrawShadow(x-x_off, y-y_off, shadow, bldg_h, alt);
	}
	else
		pic[time_active/3]->DrawCentred(x-x_off,y-y_off-alt);
};

static void
DrawShadow(int x, int y, cImage *shadow, int bldg_h_pix, int alt)
{
	
	if (bldg_h_pix > alt)
		return;
		
	shadow->AndMaskDraw(x,y+alt-bldg_h_pix, 0x79EF);
}          		
