#ifndef TILEFUNX_C
#define TILEFUNX_C
#include <allegro.h>
#include "nsdefs.h"
#include "tilefunx.h"

// Must include PCXFUNX first
// TILE_COUNT must also be defined somewhere in program


void Grab_Tile(BITMAP *image, int numtile) {
	int x_off,y_off,x,y;
	x_off = 16 * (numtile%16);
	y_off = 16 * (numtile/16);

	for (y=0; y<16; y++) {
		for (x=0; x<16; x++) {
			tiles[numtile][y][x] = image->line[y_off+y][x_off + x];
			}
		}
	}

void Load_Tile_Set(char *filename) {
	int i;
	tilepic = load_pcx(filename, brizzle_palette);
	brizzle_palette[0].r = 0;
	brizzle_palette[0].g = 0;
	brizzle_palette[0].b = 0;
	set_palette(brizzle_palette);
	for (i = 0; i < TILE_COUNT; i++)
		Grab_Tile(tilepic, i);
	destroy_bitmap(tilepic);
	}

#endif
