#ifndef THINGHND_C
#define THINGHND_C

#include "thinghnd.h"

void Handle_Thing(sprite_ptr spr) {
	if (spr->curr_state == GET_HIT_HEAD || spr->curr_state == GET_HIT_STOMACH) {
		spr->curr_state = KNOCKED_DOWN;
		}
	if (spr->type == RANDOM_ITEM) {
		spr->type = NEW_ITEM;
		spr->curr_frame = -1;
		spr->var2 = GEM;
		}
	if (spr->type == RANDOM_FOOD) {
		spr->type = NEW_ITEM;
		spr->curr_frame = -1;
		r = rand() % 2;
		switch (r) {
			case 0:
			spr->var2 = SANDWICH;
			break;
			case 1:
			spr->var2 = YOGURT;
			break;
			default:
			spr->var2 = SANDWICH;
			break;
			}
		}
	if (spr->type == OIL_DRUM) {
		spr->curr_frame = 147;
		if (spr->curr_state == KNOCKED_DOWN) {
			spr->curr_frame = 153;
			if (spr->action_count == 0) {
				play_sample(ns1_data[hit_can_sound].dat, 255, 128, 1000, FALSE);
				for (i = 0; i < MAX_SPRITES; i++) {
					if (sprites[i].curr_state == INACTIVE) {
						sprites[i].palnum = spr->palnum;
						sprites[i].type = DEBRIS_BOTTOM;
						sprites[i].controlled_by = CPU_BREAKABLE;
						FA_Set_State(&sprites[i], GENERIC1);
						sprites[i].invulnerable_flag = 1;
						sprites[i].curr_frame = 152;
						sprites[i].hit_direction = spr->hit_direction;
						Place_Sprite(&sprites[i],spr->x,0,spr->z);
						break;
						}
					}
				}
			if (spr->action_count % 2 == 0) {
				spr->z += NOWHERE;
				}
			else {
				spr->z -= NOWHERE;
				}
			if (spr->action_count == 60) {
				spr->x_velocity = 0;
				spr->y_velocity = 0;
				spr->z_velocity = 0;
				FA_Set_State(spr, GENERIC3);
				}
			}
		}
	if (spr->type == DEBRIS_BOTTOM) {
		if (spr->curr_state == GENERIC1) {
			spr->y_velocity = (-10 + spr->action_count) * GRAVITY;
			spr->z_velocity = 0;
			spr->x_velocity = E_FALL_VEL * spr->hit_direction;
			if (spr->action_count % 2 == 0) {
				spr->z += NOWHERE;
				}
			else {
				spr->z -= NOWHERE;
				}
			spr->action_count++;
			if (spr->y_velocity > 0 && spr->y == 0 && spr->z > 0) {
				FA_Set_State(spr, GENERIC2);
				}
			}
		if (spr->curr_state == GENERIC2) {
			spr->x_velocity = 0;
			spr->y_velocity = 0;
			spr->z_velocity = 0;
			if (spr->action_count % 2 == 0) {
				spr->z += NOWHERE;
				}
			else {
				spr->z -= NOWHERE;
				}
			spr->action_count++;
			if (spr->action_count == 41) {
				FA_Set_State(spr, GENERIC3);
				}
			}
		}
	if (spr->type == SANDWICH) {
		spr->curr_frame = 149;
		spr->var1 = 50;
		}
	if (spr->type == YOGURT) {
		spr->curr_frame = 154;
		spr->var1 = 20;
		}
	if (spr->type == GEM) {
		spr->curr_frame = 148;
		spr->var1 = 5000;
		}
	if (spr->curr_state == DROP) {
		spr->y_velocity = (-25 + spr->action_count) * GRAVITY;
		spr->z_velocity = 0;
		spr->action_count++;
		if (spr->y_velocity > 0 && spr->y == 0) {
			spr->x_velocity = 0;
			FA_Set_State(spr, SPECIAL);
			}
		}
	if (spr->curr_frame != -1) {
		if ((spr->x + (frame_ptrs[spr->curr_frame][6] << 8) | (frame_ptrs[spr->curr_frame][7])) < (start_x-128)) {
			spr->curr_state = INACTIVE;
			spr->curr_frame = -1;
			spr->type = NO_TYPE;
			spr->controlled_by = CPU;
			spr->x_velocity = 0;
			spr->y_velocity = 0;
			spr->z_velocity = 0;
			spr->var1 = 0;
			spr->var2 = 0;
			spr->var3 = 0;
			}
		}
	if (spr->curr_state == GENERIC3) { // Time to take out the trash!
		spr->z = NOWHERE;
		if (spr->action_count > EN_TIME) {
			Sprite_Init(spr);
			}
		spr->action_count++;
		}
	}

#endif
