#ifndef LENNY_C
#define LENNY_C

#include "lenny.h"

void Handle_Lenny(sprite_ptr spr) {
   if (spr->curr_state == WALKING) {
      spr->curr_anim = 1;
      if (spr->h == -1) {
         spr->flipflag = FLIP;
         spr->x_velocity = -80;
         }
      if (spr->h == 1) {
         spr->flipflag = NOFLIP;
         spr->x_velocity = 80;
         }
      if (spr->h == 0) {
         spr->x_velocity = 0;
         }
      if (spr->v == -1) {
         spr->z_velocity = -50;
         }
      if (spr->v == 1) {
         spr->z_velocity = 50;
         }
      if (spr->v == 0) {
         spr->z_velocity = 0;
         }
      }
   if (spr->curr_state == JUMP_ATTACK) {
      spr->y_velocity = (-40 + spr->action_count) * GRAVITY;
      spr->curr_anim = 37;
      if (spr->anim_done) {
         spr->frame_counter = 0;
         spr->curr_state = JUMPING;
         }
      spr->action_count++;
      if (spr->y_velocity > 0 && (spr->y == 0 || Check_Under_Feet(spr)))
         FA_Set_State(spr, STANDING);
      }
   if (spr->curr_state == JUMPING) {
         spr->curr_frame = 136;
		 spr->curr_anim = 0;
			spr->y_velocity = (-40 + spr->action_count) * GRAVITY;
			spr->action_count++;
         if (spr->y_velocity > 0 && (spr->y == 0 || Check_Under_Feet(spr)))
				FA_Set_State(spr, STANDING);
         }
   if (spr->curr_state == THROWING) {
		spr->x_velocity = 0;
		spr->y_velocity = 0;
		spr->z_velocity = 0;
		spr->curr_anim = 29;
		spr->invulnerable_flag = 1;
		spr->invulnerable_time = 0;
		if (spr->hold != NULL) {
			spr->hold->action_count = 0;
			spr->hold->invulnerable_flag = 1;
			}
		if (spr->curr_frame == 98 && spr->hold != NULL) {
			spr->hold->curr_state = HELD2;
			spr->hold->flipflag = spr->flipflag;
			spr->hold->z = spr->z;
			spr->hold->y = spr->y - 41;
			spr->hold->x = spr->x - (1 * ((spr->flipflag == FLIP)? -1 : 1));
			}
		if (spr->curr_frame == 99 && spr->hold != NULL) {
			if (spr->hold->curr_state != THROWN) {
				FA_Set_State(spr->hold, THROWN);
				spr->hold->z = spr->z;
				spr->hold->y = spr->y - 36;
				spr->hold->x = spr->x + (94 * ((spr->flipflag == FLIP)? -1 : 1));
				spr->hold->hit_direction = SPRITE_DIRECTION;
				spr->hold->x_velocity = 120 * SPRITE_DIRECTION;
				spr->hold->y_velocity = (-20 * GRAVITY);
				spr->hold->var1 = 12;
				// spr->hold->hold = NULL;
				spr->hold = NULL;
				}
			}
		if (spr->anim_done) {
			if (spr->hold != NULL) {
				spr->hold->action_count = 0;
				}
			FA_Set_State(spr, STANDING);
			}
		if (spr->y < 0 && !Check_Under_Feet(spr)) {
			spr->x_velocity = 0;
			spr->z_velocity = 0;
			if (spr->hold != NULL) {
				FA_Set_State(spr->hold, DROP_FREE);
				spr->hold = NULL;
				}
			spr->invulnerable_flag = 0;
			FA_Set_State(spr, DROP_FREE);
			}
		}
   if (spr->curr_state == HOLD_ATTACK) {
		spr->x_velocity = 0;
		spr->y_velocity = 0;
		spr->z_velocity = 0;
		spr->curr_anim = 28;
		if (spr->hold != NULL) {
			spr->hold->action_count = 0;
			}
		if (spr->curr_frame == 73 && spr->hold != NULL) {
			spr->hold->curr_state = HELD1;
			spr->hold->z = spr->z;
			spr->hold->y = spr->y - 36;
			spr->hold->x = spr->x + (12 * ((spr->flipflag == FLIP)? -1 : 1));
			}
		if (spr->curr_frame == 97 && spr->hold != NULL) {
			spr->hold->curr_state = HELD2;
			spr->hold->z = spr->z;
			spr->hold->y = spr->y - 32;
			spr->hold->x = spr->x + (44 * ((spr->flipflag == FLIP)? -1 : 1));
			}
		if (spr->anim_done) {
			if (spr->hold != NULL) {
				spr->hold->action_count = 0;
				}
			FA_Set_State(spr, HOLDING);
			}
		if (spr->y < 0 && !Check_Under_Feet(spr)) {
			spr->x_velocity = 0;
			spr->z_velocity = 0;
			if (spr->hold != NULL) {
				FA_Set_State(spr->hold, DROP_FREE);
				spr->hold = NULL;
				}
			FA_Set_State(spr, DROP_FREE);
			}
		}
   if (spr->curr_state == HOLDING) {
		spr->curr_frame = 73;
		spr->x_velocity = 0;
		spr->y_velocity = 0;
		spr->z_velocity = 0;
		if (spr->target) {
			spr->target = 0;
			spr->var1++;
			}
		if (spr->hold == NULL) {
			spr->var1 = 0;
			spr->var2 = 0;
			spr->var3 = 0;
			FA_Set_State(spr, STANDING);
			}
		else if (spr->hold->hold == NULL || spr->hold->hold != spr) {
			spr->hold = NULL;
			spr->var1 = 0;
			spr->var2 = 0;
			spr->var3 = 0;
			FA_Set_State(spr, STANDING);
			}
		if (spr->hold != NULL) {
			spr->hold->curr_state = HELD1;
			spr->hold->z = spr->z;
			spr->hold->y = spr->y - 36;
			spr->hold->x = spr->x + (12 * ((spr->flipflag == FLIP)? -1 : 1));
			}
		if (spr->y < 0 && !Check_Under_Feet(spr)) {
			spr->x_velocity = 0;
			spr->z_velocity = 0;
			if (spr->hold != NULL) {
				FA_Set_State(spr->hold, DROP_FREE);
				spr->hold = NULL;
				}
			FA_Set_State(spr, DROP_FREE);
			}
		}
   if (spr->curr_state == SPECIAL) {
	   spr->invulnerable_flag = 1;
	   spr->invulnerable_time = 0;
	   //spr->y = 0;
	   while ((spr->y < 0) && (!Check_Under_Feet(spr))) {
			spr->y++;
			}
	   spr->x_velocity = 0;
	   spr->y_velocity = 0;
	   spr->z_velocity = 0;
	   if (spr->action_count < 104) {
			if (spr->action_count == 0) {
				spr->curr_anim = 38;
				}
			if (spr->anim_done) {
				spr->frame_counter = 0;
				spr->anim_done = 0;
				if (spr->curr_anim == 38) {
					spr->curr_anim = 39;
					}
				else {
					spr->curr_anim = 38;
					}
				}
			if (spr->frame_counter == 0 /*1*/ && spr->action_count > 1) {
				if (spr->flipflag == NOFLIP) {
					spr->flipflag = FLIP;
					}
				else {
					spr->flipflag = NOFLIP;
					}
				}
			}
		else if (spr->action_count < 140) {
			if (spr->target == 1) {
				spr->health -= 9;
				if (spr->health < 1) {
					spr->health = 1;
					}
				spr->target = 0;
				}
			spr->invulnerable_flag = 0;
			spr->curr_frame = 127;
			spr->curr_anim = 0;
			spr->curr_attack = 0;
			}
	   else	if (spr->action_count == 140) {
			FA_Set_State(spr, STANDING);
			}
	   	spr->action_count++;
		if (spr->y < 0 && !Check_Under_Feet(spr)) {
			spr->x_velocity = 0;
			spr->z_velocity = 0;
			spr->invulnerable_flag = 0;
			FA_Set_State(spr, DROP_FREE);
			}
		}
   if (spr->curr_state == ATTACK5) {
      FA_Set_State(spr, ATTACK1);
      spr->var1 = 0;
      }
   if (spr->curr_state == ATTACK4) {
      FA_Set_State(spr, ATTACK1);
      spr->var1 = 0;
      }
   if (spr->curr_state == ATTACK3) {
      spr->x_velocity = 0;
      spr->y_velocity = 0;
      spr->z_velocity = 0;
      spr->curr_anim = 2;
      if (spr->anim_done)
         FA_Set_State(spr, STANDING);
	  if (spr->y < 0 && !Check_Under_Feet(spr)) {
			spr->x_velocity = 0;
			spr->z_velocity = 0;
			FA_Set_State(spr, DROP_FREE);
			}
      }
   if (spr->curr_state == ATTACK2) {
      spr->x_velocity = 0;
      spr->y_velocity = 0;
      spr->z_velocity = 0;
      spr->curr_anim = 3;
      if (spr->anim_done)
         FA_Set_State(spr, STANDING);
	  if (spr->y < 0 && !Check_Under_Feet(spr)) {
			spr->x_velocity = 0;
			spr->z_velocity = 0;
			FA_Set_State(spr, DROP_FREE);
			}
      }
   if (spr->curr_state == ATTACK1) {
      spr->x_velocity = 0;
      spr->y_velocity = 0;
      spr->z_velocity = 0;
      spr->curr_anim = 16;
      if (spr->anim_done)
         FA_Set_State(spr, STANDING);
	  if (spr->y < 0 && !Check_Under_Feet(spr)) {
			spr->x_velocity = 0;
			spr->z_velocity = 0;
			FA_Set_State(spr, DROP_FREE);
			}
      }
   if (spr->curr_state == HELD1) {
		spr->curr_frame = 30;
		if (spr->hold->curr_state == HOLDING && spr->action_count == 140) {
			FA_Set_State(spr->hold, STANDING);
			FA_Set_State(spr, DROP_FREE);
			spr->hold->hold = NULL;
			spr->hold = NULL;
			}
		spr->action_count++;
		}
   if (spr->curr_state == HELD2) {
		spr->curr_frame = 71;
		if (spr->hold->curr_state == HOLDING && spr->action_count == 140) {
			FA_Set_State(spr->hold, STANDING);
			FA_Set_State(spr, DROP_FREE);
			spr->hold->hold = NULL;
			spr->hold = NULL;
			}
		spr->action_count++;
		}
   if (spr->curr_state == GET_HIT_STOMACH) {
      spr->curr_frame = 71;
      }
   if (spr->curr_state == GET_HIT_HEAD) {
      spr->curr_frame = 30;
      }
   if (spr->curr_state == PICK_UP) {
		spr->curr_frame = 96;
		}
   if (spr->curr_state == THROWN) {
		spr->curr_frame = 3;
		}
   if (spr->curr_state == KNOCKED_DOWN) {
      spr->curr_frame = 3;
      }
   if (spr->curr_state == ON_GROUND_BRIEF || spr->curr_state == ON_GROUND || spr->curr_state == DEAD) {
      spr->curr_frame = 4;
      }
   if (spr->curr_state == BOUNCE) {
      spr->curr_frame = 5;
      }
   if (spr->curr_state == ON_GROUND) {
      if (spr->action_count == 140) {
         FA_Set_State(spr, GET_UP);
         spr->hit_direction = 0;
         }
      spr->action_count++;
      }
   if (spr->curr_state == GET_UP) {
      spr->curr_anim = 27;
      if (spr->anim_done) {
         FA_Set_State(spr, STANDING);
		spr->invulnerable_time = PLAYER_GRACE_PERIOD;
		}
	  if (spr->y < 0 && !Check_Under_Feet(spr)) {
			spr->x_velocity = 0;
			spr->z_velocity = 0;
			FA_Set_State(spr, DROP_FREE);
			}
      }
   if (spr->curr_state == STANDING) {
      spr->curr_frame = 0;
      }
   if (spr->curr_state == WAIT_FOR_NEXT_LIFE) {
      spr->curr_frame = 43;
      }
   }

#endif
