#ifndef KOALA_C
#define KOALA_C

#include "koala.h"

void Do_Koala_AI(sprite_ptr spr) {
	if (TARGET->curr_state == WAIT_FOR_NEXT_LIFE) {
		Find_Target(spr);
		}
	if (spr->curr_state == STANDING) {
		if (DIRECTION_TO_TARGET == -1) {
				spr->flipflag = FLIP;
				}
			else {
				spr->flipflag = NOFLIP;
				}
		if (abs(spr->x - (start_x+160)) > 160 && (!(Within_Range(spr, attacks[17]) && (SPRITE_DIRECTION == DIRECTION_TO_TARGET)))) {
			FA_Set_State(spr, APPROACH);
			}
		else if (abs(spr->x - TARGET->x) > 180) {
			r = rand() % 100;
			if (r < 95) {
				FA_Set_State(spr, APPROACH);
				}
			else {
				FA_Set_State(spr, PAUSING);
				}
			}
		else if (abs(spr->x - TARGET->x) > 90) {
			r = rand() % 100;
			if (r < 80) {
				FA_Set_State(spr, APPROACH);
				}
			else {
				FA_Set_State(spr, PAUSING);
				}
			}
		else if (abs(spr->x - TARGET->x) > attacks[17].right_bound) {
			r = rand() % 100;
			if (r < 70) {
				FA_Set_State(spr, APPROACH);
				}
			if (r < 82) {
				FA_Set_State(spr, PAUSING);
				}
			if (r < 92) {
				FA_Set_State(spr, GET_BEHIND);
				}
			else {
				FA_Set_State(spr, RETREAT);
				}
			}
		else {
			if (Within_Range(spr, attacks[17]) && (SPRITE_DIRECTION == DIRECTION_TO_TARGET)) {
				if (SPRITE_DIRECTION == TARGET_DIRECTION) {
					r = rand() % 100;
					if (r < 3) {
						FA_Set_State(spr, ATTACK1);
						}
					}
				else {
					r = rand() % 100;
					if (r < 3) {
						FA_Set_State(spr, ATTACK1);
						}
					else if (r == 3) {
						FA_Set_State(spr, GET_BEHIND);
						}
					else if (r == 4) {
						FA_Set_State(spr, RETREAT);
						}
					}
				}
			else {
				r = rand() % 100;
				if (r < 75) {
					FA_Set_State(spr, Z_ADJUST);
					}
				else if (r < 87) {
					FA_Set_State(spr, PAUSING);
					}
				else if (r < 95) {
					FA_Set_State(spr, APPROACH);
					}
				else {
					FA_Set_State(spr, RETREAT);
					}
				}
			}
		}
	if (spr->curr_state == PAUSING) {
		spr->x_velocity = 0;
		spr->y_velocity = 0;
		spr->z_velocity = 0;
		spr->curr_frame = 103;
		spr->action_count++;
		if (spr->action_count >= 30) {
			r = rand() % 100;
			if (r < 3) {
				FA_Set_State(spr, STANDING);
				}
			}
		if (Within_Range(spr, attacks[17])) {
			r = rand() % 100;
			if (r < 2) {
				FA_Set_State(spr, STANDING);
				}
			}
		}
	if (spr->curr_state == LEANING) {
	  spr->curr_frame = 103;
      spr->hit_direction = 0;
      spr->flipflag = NOFLIP;
	  spr->x_velocity = 0;
	  spr->y_velocity = 0;
	  spr->z_velocity = 0;
	  spr->action_count = 0;
      if (spr->x < TARGET->x + 20) {
         FA_Set_State(spr, STANDING);
         }
      } // end LEANING
	if (spr->curr_state == KNEELING_AWAY || spr->curr_state == KNEELING_FORWARD) {
		spr->curr_frame = 116;
		spr->hit_direction = 0;
		spr->x_velocity = 0;
		spr->y_velocity = 0;
		spr->z_velocity = 0;
		if (spr->curr_state == KNEELING_AWAY)
			spr->flipflag = NOFLIP;
		else
			spr->flipflag = FLIP;
		spr->action_count = 0;
		if (spr->x < TARGET->x + 20) {
			FA_Set_State(spr, STANDING);
			}
		}
	if (spr->curr_state == APPROACH) {
		if (spr->action_count == 0) {
			if (DIRECTION_TO_TARGET == -1) {
				spr->flipflag = FLIP;
				}
			else {
				spr->flipflag = NOFLIP;
				}
			spr->curr_anim = 30;
			spr->x_velocity = (65 * DIRECTION_TO_TARGET);
			if (spr->x != TARGET->x) {
				spr->z_velocity = (abs(spr->x_velocity)*(TARGET->z-spr->z))/(abs(TARGET->x-spr->x));
				r = rand() % 100;
				if (r < 5) {
					spr->z_velocity -= 45;
					}
				if (r < 10) {
					spr->z_velocity += 45;
					}
				if (r < 20) {
					spr->z_velocity -= 25;
					}
				if (r < 30) {
					spr->z_velocity += 25;
					}
				if (spr->z_velocity > 50) {
					spr->z_velocity = 50;
					}
				if (spr->z_velocity < -50) {
					spr->z_velocity = -50;
					}
				}
			}
		spr->action_count++;
		r = rand() % 100;
		if ((abs(spr->x - (start_x+160)) > 160) && (SPRITE_DIRECTION != DIRECTION_TO_TARGET)) {
			FA_Set_State(spr, PAUSING);
			}
		if (spr->action_count > 80 && r < 2) {
			FA_Set_State(spr, PAUSING);
			}
		if (Within_Range(spr, attacks[17])) {
			FA_Set_State(spr, STANDING);
			}
		if (spr->y < 0 && !Check_Under_Feet(spr)) {
			spr->x_velocity = 0;
			spr->z_velocity = 0;
			FA_Set_State(spr, DROP_FREE);
			}
		}

	if (spr->curr_state == RETREAT) {
		if (spr->action_count == 0) {
			if (DIRECTION_TO_TARGET == -1) {
				spr->flipflag = FLIP;
				}
			else {
				spr->flipflag = NOFLIP;
				}
			spr->curr_anim = 31;
			spr->x_velocity = (-55 * DIRECTION_TO_TARGET);
			}
		spr->action_count++;
		if (spr->action_count > 85) {
			r = rand() % 100;
			if (r < 7) {
				FA_Set_State(spr, PAUSING);
				}
			}
		if (abs(spr->x - (start_x+160)) > 160) {
			FA_Set_State(spr, PAUSING);
			}
		if (spr->y < 0 && !Check_Under_Feet(spr)) {
			spr->x_velocity = 0;
			spr->z_velocity = 0;
			FA_Set_State(spr, DROP_FREE);
			}
		}
	if (spr->curr_state == GET_BEHIND) {
         spr->curr_anim = 30;
         if (spr->action_count == 0) {
            spr->h = DIRECTION_TO_TARGET;
            if (spr->z > 164)
               spr->v = -1;
            else
                spr->v = 1;
            }
         spr->action_count++;
         if (spr->x > TARGET->x)
				spr->flipflag = FLIP;
			else
				spr->flipflag = NOFLIP;
         if (spr->h < 0)
            spr->x_velocity = ((175-abs(spr->action_count-175))*2) / -5;
         else
             spr->x_velocity = ((175-abs(spr->action_count-175))*2) / 5;
         if (spr->v < 0)
            spr->z_velocity = (-175 + spr->action_count) / 5;
         else
             spr->z_velocity = (175 - spr->action_count) / 5;
         if (abs(TARGET->z-spr->z) < Z_HIT_RANGE && abs(TARGET->x-spr->x) < attacks[17].right_bound) {
            r = rand() % 100;
            if (r < 5) {
               spr->h = 0;
               spr->v = 0;
               FA_Set_State(spr, STANDING);
               }
            }
         if (abs(spr->x-TARGET->x) > 160) {
            spr->h = 0;
            spr->v = 0;
            FA_Set_State(spr, APPROACH);
            }
         if (spr->action_count >= 350) {
            spr->h = 0;
            spr->v = 0;
            FA_Set_State(spr, STANDING);
            }
		 if (spr->y < 0 && !Check_Under_Feet(spr)) {
			spr->x_velocity = 0;
			spr->z_velocity = 0;
			FA_Set_State(spr, DROP_FREE);
			}
         }
	if (spr->curr_state == Z_ADJUST) {
		if (DIRECTION_TO_TARGET == -1) {
			spr->flipflag = FLIP;
			}
		else {
			spr->flipflag = NOFLIP;
			}
		spr->curr_anim = 30;
		if (spr->z >= TARGET->z+Z_HIT_RANGE) {
            spr->z_velocity = -50;
			}
        else if (spr->z <= TARGET->z-Z_HIT_RANGE) {
            spr->z_velocity = 50;
			}
        else if (spr->z == TARGET->z) {
            FA_Set_State(spr, STANDING);
            }
        else {
            r = rand() % 100;
            if (r < 7) {
				FA_Set_State(spr, STANDING);
				}
            }
		if (spr->y < 0 && !Check_Under_Feet(spr)) {
			spr->x_velocity = 0;
			spr->z_velocity = 0;
			FA_Set_State(spr, DROP_FREE);
			}
		}
	if (spr->curr_state == WALK_DOWN) {
		if (spr->x > TARGET->x)
			spr->flipflag = FLIP;
		else
			spr->flipflag = NOFLIP;
        spr->z_velocity = 50;
        spr->curr_anim = 30;
        if (spr->z >= 144 || spr->z >= TARGET->z) {
			FA_Set_State(spr, STANDING);
            }
        } // end WALK_DOWN
    if (spr->curr_state == WALK_UP) {
		if (spr->x > TARGET->x)
			spr->flipflag = FLIP;
		else
			spr->flipflag = NOFLIP;
        spr->z_velocity = -50;
        spr->curr_anim = 30;
        if (spr->z <= 184 || spr->z <= TARGET->z) {
			FA_Set_State(spr, STANDING);
            }
        } // end WALK_UP
	}

void Handle_Koala(sprite_ptr spr) {
   if (spr->curr_state == WALKING) {
      spr->curr_anim = 30;
      if (spr->h == -1) {
         spr->flipflag = FLIP;
         spr->x_velocity = -65;
         }
      if (spr->h == 1) {
         spr->flipflag = NOFLIP;
         spr->x_velocity = 65;
         }
      if (spr->h == 0) {
         spr->x_velocity = 0;
         }
      if (spr->v == -1) {
         spr->z_velocity = -50;
         }
      if (spr->v == 1) {
         spr->z_velocity = 50;
         }
      if (spr->v == 0) {
         spr->z_velocity = 0;
         }
      }
   if (spr->curr_state == JUMP_ATTACK) {
      spr->curr_state = JUMPING;
      }
   if (spr->curr_state == JUMPING) {
      spr->curr_state = STANDING;
      }
   if (spr->curr_state == SPECIAL) {
      FA_Set_State(spr, ATTACK1);
      spr->var1 = 0;
      }	
   if (spr->curr_state == ATTACK5) {
      FA_Set_State(spr, ATTACK1);
      spr->var1 = 0;
      }
   if (spr->curr_state == ATTACK4) {
      FA_Set_State(spr, ATTACK1);
      spr->var1 = 0;
      }
   if (spr->curr_state == ATTACK3) {
      FA_Set_State(spr, ATTACK1);
      spr->var1 = 0;
      }
   if (spr->curr_state == ATTACK2) {
      FA_Set_State(spr, ATTACK1);
      spr->var1 = 0;
      }
   if (spr->curr_state == ATTACK1) {
      spr->x_velocity = 0;
      spr->y_velocity = 0;
      spr->z_velocity = 0;
      spr->curr_anim = 32;
      if (spr->anim_done) {
         FA_Set_State(spr, STANDING);
         }
	  if (spr->y < 0 && !Check_Under_Feet(spr)) {
		spr->x_velocity = 0;
		spr->z_velocity = 0;
		FA_Set_State(spr, DROP_FREE);
		}
      }
   if (spr->curr_state == HELD1) {
	  spr->curr_frame = 104;
	  if (spr->hold->curr_state == HOLDING && spr->action_count == 180) {
			FA_Set_State(spr->hold, STANDING);
			FA_Set_State(spr, DROP_FREE);
			spr->hold->hold = NULL;
			spr->hold = NULL;
			}
		spr->action_count++;
		}
   if (spr->curr_state == HELD2) {
	  spr->curr_frame = 105;
	  if (spr->hold->curr_state == HOLDING && spr->action_count == 180) {
			FA_Set_State(spr->hold, STANDING);
			FA_Set_State(spr, DROP_FREE);
			spr->hold->hold = NULL;
			spr->hold = NULL;
			}
		spr->action_count++;
		}
   /* if (spr->curr_state == DROP_FREE) {
	   spr->y_velocity = (spr->action_count * GRAVITY);
	   spr->action_count++;
	   if (spr->y == 0) {
		   FA_Set_State(spr, STANDING);
			}
		} */
   if (spr->curr_state == GET_HIT_STOMACH) {
      spr->curr_frame = 105;
      if (spr->controlled_by == CPU_ENEMY)
         if (spr->action_count == 80) {
            FA_Set_State(spr, STANDING);
            spr->hit_direction = 0;
            }
      }
   if (spr->curr_state == GET_HIT_HEAD) {
      spr->curr_frame = 104;
      if (spr->controlled_by == CPU_ENEMY)
         if (spr->action_count == 80) {
            FA_Set_State(spr, STANDING);
            spr->hit_direction = 0;
            }
      }
   if (spr->curr_state == PICK_UP) {
		spr->curr_frame = 116;
		}
   if (spr->curr_state == THROWN) {
		spr->curr_frame = 106;
		}
   if (spr->curr_state == KNOCKED_DOWN) {
      spr->curr_frame = 106;
      }
   if (spr->curr_state == ON_GROUND_BRIEF || spr->curr_state == ON_GROUND || spr->curr_state == DEAD) {
      spr->curr_frame = 107;
      }
   if (spr->curr_state == BOUNCE) {
      spr->curr_frame = 108;
      }
   if (spr->curr_state == ON_GROUND) {
      if (spr->action_count == 160) {
         FA_Set_State(spr, GET_UP);
         spr->hit_direction = 0;
         }
      spr->action_count++;
      }
   if (spr->curr_state == GET_UP) {
	  spr->curr_anim = 33;
      if (spr->anim_done) {
         FA_Set_State(spr, STANDING);
         }
	  if (spr->y < 0 && !Check_Under_Feet(spr)) {
		spr->x_velocity = 0;
		spr->z_velocity = 0;
		FA_Set_State(spr, DROP_FREE);
		}
      }
   if (spr->curr_state == STANDING) {
      spr->curr_frame = 103;
      }
   if (spr->curr_state == WAIT_FOR_NEXT_LIFE) {
      spr->curr_frame = 103;
      }
   }

#endif
