#ifndef ELK_C
#define ELK_C

#include "elk.h"

void Do_Elk_AI(sprite_ptr spr) {
	if (TARGET->curr_state == WAIT_FOR_NEXT_LIFE) {
		Find_Target(spr);
		}
	if (spr->curr_state == STANDING) {
		if (DIRECTION_TO_TARGET == -1) {
			spr->flipflag = FLIP;
			}
		else {
			spr->flipflag = NOFLIP;
			}
		if (abs(spr->x - (start_x+160)) > 160) {
			FA_Set_State(spr, APPROACH);
			}
		else if (abs(spr->x - TARGET->x) > 160) {
			r = rand() % 100;
			if (r < 90) {
				FA_Set_State(spr, APPROACH);
				}
			else {
				FA_Set_State(spr, PAUSING);
				}
			}
		else if (abs(spr->x - TARGET->x) > 100) {
			r = rand() % 100;
			if (r < 70) {
				FA_Set_State(spr, PAUSING);
				}
			else {
				FA_Set_State(spr, APPROACH);
				}
			}
		else if (Within_Range(spr, attacks[14])) {
			r = rand() % 100;
			if (r < 4) {
				FA_Set_State(spr, ATTACK1);
				}
			}
		else {
			r = rand() % 100;
			if (r < 60) {
				FA_Set_State(spr, APPROACH);
				}
			else if (r < 90) {
				if (spr->z != TARGET->z) {
					FA_Set_State(spr, Z_ADJUST);
					}
				else {
					FA_Set_State(spr, APPROACH);
					}
				}
			else {
				FA_Set_State(spr, RETREAT);
				}
			}
		}
	if (spr->curr_state == PAUSING) {
		spr->x_velocity = 0;
		spr->y_velocity = 0;
		spr->z_velocity = 0;
		spr->curr_frame = 81;
		spr->action_count++;
		if (spr->action_count >= 35) {
			r = rand() % 100;
			if (r < 3) {
				FA_Set_State(spr, STANDING);
				}
			}
		if (Within_Range(spr, attacks[14])) {
			r = rand() % 100;
			if (r < 2) {
				FA_Set_State(spr, STANDING);
				}
			}
		}
	if (spr->curr_state == LEANING) {
	  spr->curr_frame = 81;
      spr->hit_direction = 0;
      spr->flipflag = NOFLIP;
	  spr->x_velocity = 0;
	  spr->y_velocity = 0;
	  spr->z_velocity = 0;
	  spr->action_count = 0;
      if (spr->x < TARGET->x + 20 || (num_bars_drawn)) {
         FA_Set_State(spr, STANDING);
         }
      } // end LEANING
	if (spr->curr_state == KNEELING_AWAY || spr->curr_state == KNEELING_FORWARD) {
		spr->curr_frame = 119;
		spr->hit_direction = 0;
		spr->x_velocity = 0;
		spr->y_velocity = 0;
		spr->z_velocity = 0;
		if (spr->curr_state == KNEELING_AWAY)
			spr->flipflag = NOFLIP;
		else
			spr->flipflag = FLIP;
		spr->action_count = 0;
		if (spr->x < TARGET->x + 20) {
			FA_Set_State(spr, STANDING);
			}
		}
	if (spr->curr_state == APPROACH) {
		if (spr->action_count == 0) {
			if (DIRECTION_TO_TARGET == -1) {
				spr->flipflag = FLIP;
				}
			else {
				spr->flipflag = NOFLIP;
				}
			spr->curr_anim = 23;
			spr->x_velocity = (60 * DIRECTION_TO_TARGET);
			if (spr->x != TARGET->x) {
				spr->z_velocity = (abs(spr->x_velocity)*(TARGET->z-spr->z))/(abs(TARGET->x-spr->x));
				r = rand() % 100;
				if (r < 5) {
					spr->z_velocity -= 45;
					}
				if (r < 10) {
					spr->z_velocity += 45;
					}
				if (r < 20) {
					spr->z_velocity -= 25;
					}
				if (r < 30) {
					spr->z_velocity += 25;
					}
				if (spr->z_velocity > 50) {
					spr->z_velocity = 50;
					}
				if (spr->z_velocity < -50) {
					spr->z_velocity = -50;
					}
				}
			}
		spr->action_count++;
		if (abs(spr->x - TARGET->x) <= 100) {
			r = rand() % 100;
			if (r < 2) {
				FA_Set_State(spr, STANDING);
				}
			else if (r < 3) {
				FA_Set_State(spr, RETREAT);
				}
			}
		if ((abs(spr->x - TARGET->x) > 100) && (abs(spr->x - TARGET->x) < 160)) {
			r = rand() % 100;
			if (r < 1) {
				FA_Set_State(spr, PAUSING);
				}
			}
		if ((abs(spr->x - (start_x+160)) > 160) && (SPRITE_DIRECTION != DIRECTION_TO_TARGET)) {
			FA_Set_State(spr, PAUSING);
			}
		if (spr->x == TARGET->x) {
			FA_Set_State(spr, Z_ADJUST);
			}
		if (spr->y < 0 && !Check_Under_Feet(spr)) {
			spr->x_velocity = 0;
			spr->z_velocity = 0;
			FA_Set_State(spr, DROP_FREE);
			}
		}
	if (spr->curr_state == RETREAT) {
		if (spr->action_count == 0) {
			if (DIRECTION_TO_TARGET == -1) {
				spr->flipflag = FLIP;
				}
			else {
				spr->flipflag = NOFLIP;
				}
			spr->curr_anim = 24;
			spr->x_velocity = (-60 * DIRECTION_TO_TARGET);
			r = rand() % 100;
			if (r < 5) {
				spr->z_velocity = -45;
				}
			else if (r < 10) {
				spr->z_velocity = 45;
				}
			else if (r < 20) {
				spr->z_velocity = -25;
				}
			else if (r < 30) {
				spr->z_velocity = 25;
				}
			else {
				spr->z_velocity = 0;
				}
			}
		spr->action_count++;
		if (abs(spr->x - TARGET->x) > 160) {
			FA_Set_State(spr, PAUSING);
			}
		if (abs(spr->x - (start_x+160)) > 160) {
			FA_Set_State(spr, PAUSING);
			}
		if (spr->action_count > 140) {
			r = rand() % 100;
			if (r < 3) {
				FA_Set_State(spr, PAUSING);
				}
			}
		if (spr->y < 0 && !Check_Under_Feet(spr)) {
			spr->x_velocity = 0;
			spr->z_velocity = 0;
			FA_Set_State(spr, DROP_FREE);
			}
		}
	if (spr->curr_state == Z_ADJUST) {
		spr->curr_anim = 23;
		if (spr->x > TARGET->x) {
			spr->flipflag = FLIP;
			}
		else {
			spr->flipflag = NOFLIP;
			}
        if (spr->z >= TARGET->z+Z_HIT_RANGE) {
            spr->z_velocity = -50;
			}
        else if (spr->z <= TARGET->z-Z_HIT_RANGE) {
            spr->z_velocity = 50;
			}
        else if (spr->z == TARGET->z) {
            FA_Set_State(spr, STANDING);
            }
        else {
            r = rand() % 100;
            if (r < 6) {
				FA_Set_State(spr, STANDING);
				}
            }
		if (spr->y < 0 && !Check_Under_Feet(spr)) {
			spr->x_velocity = 0;
			spr->z_velocity = 0;
			FA_Set_State(spr, DROP_FREE);
			}
        }
	if (spr->curr_state == WALK_DOWN) {
		if (spr->x > TARGET->x)
			spr->flipflag = FLIP;
		else
			spr->flipflag = NOFLIP;
        spr->z_velocity = 50;
        spr->curr_anim = 23;
        if (spr->z >= 144 || spr->z >= TARGET->z) {
			FA_Set_State(spr, STANDING);
            }
        } // end WALK_DOWN
    if (spr->curr_state == WALK_UP) {
		if (spr->x > TARGET->x)
			spr->flipflag = FLIP;
		else
			spr->flipflag = NOFLIP;
        spr->z_velocity = -50;
        spr->curr_anim = 23;
        if (spr->z <= 184 || spr->z <= TARGET->z) {
			FA_Set_State(spr, STANDING);
            }
        } // end WALK_UP
	}

void Handle_Elk(sprite_ptr spr) {
   if (spr->curr_state == WALKING) {
      spr->curr_anim = 23;
      if (spr->h == -1) {
         spr->flipflag = FLIP;
         spr->x_velocity = -60;
         }
      if (spr->h == 1) {
         spr->flipflag = NOFLIP;
         spr->x_velocity = 60;
         }
      if (spr->h == 0) {
         spr->x_velocity = 0;
         }
      if (spr->v == -1) {
         spr->z_velocity = -50;
         }
      if (spr->v == 1) {
         spr->z_velocity = 50;
         }
      if (spr->v == 0) {
         spr->z_velocity = 0;
         }
      }
   if (spr->curr_state == JUMP_ATTACK) {
      spr->curr_state = JUMPING;
      }
   if (spr->curr_state == JUMPING) {
      spr->curr_state = STANDING;
      }
   if (spr->curr_state == SPECIAL) {
      FA_Set_State(spr, ATTACK1);
      spr->var1 = 0;
      }	
   if (spr->curr_state == ATTACK5) {
      FA_Set_State(spr, ATTACK1);
      spr->var1 = 0;
      }
   if (spr->curr_state == ATTACK4) {
      FA_Set_State(spr, ATTACK1);
      spr->var1 = 0;
      }
   if (spr->curr_state == ATTACK3) {
      FA_Set_State(spr, ATTACK1);
      spr->var1 = 0;
      }
   if (spr->curr_state == ATTACK2) {
      FA_Set_State(spr, ATTACK1);
      spr->var1 = 0;
      }
   if (spr->curr_state == ATTACK1) {
      spr->x_velocity = 0;
      spr->y_velocity = 0;
      spr->z_velocity = 0;
      spr->curr_anim = 25;
      if (spr->anim_done) {
         FA_Set_State(spr, STANDING);
         }
	  if (spr->y < 0 && !Check_Under_Feet(spr)) {
		spr->x_velocity = 0;
		spr->z_velocity = 0;
		FA_Set_State(spr, DROP_FREE);
		}
      }
   if (spr->curr_state == HELD1) {
	  spr->curr_frame = 118;
	  if (spr->hold->curr_state == HOLDING && spr->action_count == 80) {
			FA_Set_State(spr->hold, STANDING);
			FA_Set_State(spr, DROP_FREE);
			spr->hold->hold = NULL;
			spr->hold = NULL;
			}
		spr->action_count++;
		}
   if (spr->curr_state == HELD2) {
	  spr->curr_frame = 83;
	  if (spr->hold->curr_state == HOLDING && spr->action_count == 80) {
			FA_Set_State(spr->hold, STANDING);
			FA_Set_State(spr, DROP_FREE);
			spr->hold->hold = NULL;
			spr->hold = NULL;
			}
		spr->action_count++;
		}
   /* if (spr->curr_state == DROP_FREE) {
	   spr->y_velocity = (spr->action_count * GRAVITY);
	   spr->action_count++;
	   if (spr->y == 0) {
		   FA_Set_State(spr, STANDING);
			}
		} */
   if (spr->curr_state == GET_HIT_STOMACH) {
      spr->curr_frame = 83;
      if (spr->controlled_by == CPU_ENEMY)
         if (spr->action_count == 45) {
            FA_Set_State(spr, STANDING);
            spr->hit_direction = 0;
            }
      }
   if (spr->curr_state == GET_HIT_HEAD) {
      spr->curr_frame = 118;
      if (spr->controlled_by == CPU_ENEMY)
         if (spr->action_count == 45) {
            FA_Set_State(spr, STANDING);
            spr->hit_direction = 0;
            }
      }
   if (spr->curr_state == PICK_UP) {
		spr->curr_frame = 119;
		}
   if (spr->curr_state == THROWN) {
		spr->curr_frame = 84;
		}
   if (spr->curr_state == KNOCKED_DOWN) {
      spr->curr_frame = 84;
      }
   if (spr->curr_state == ON_GROUND_BRIEF || spr->curr_state == ON_GROUND || spr->curr_state == DEAD) {
      spr->curr_frame = 82;
      }
   if (spr->curr_state == BOUNCE) {
      spr->curr_frame = 85;
      }
   if (spr->curr_state == ON_GROUND) {
      if (spr->action_count == 110) {
         FA_Set_State(spr, GET_UP);
         spr->hit_direction = 0;
         }
      spr->action_count++;
      }
   if (spr->curr_state == GET_UP) {
	  if (spr->action_count < 10) {
         spr->curr_frame = 120;
         }
      if (spr->action_count >= 10 && spr->action_count < 205) {
         spr->curr_anim = 34;
         }
      else
         spr->curr_anim = 0;
      if (spr->action_count >= 205 && spr->action_count <= 211) {
         spr->curr_frame = 122;
         }
      if (spr->action_count >= 212) {
         FA_Set_State(spr, STANDING);
         }
      spr->action_count++;
	  if (spr->y < 0 && !Check_Under_Feet(spr)) {
		spr->x_velocity = 0;
		spr->z_velocity = 0;
		FA_Set_State(spr, DROP_FREE);
		}
      }
   if (spr->curr_state == STANDING) {
      spr->curr_frame = 81;
      }
   if (spr->curr_state == WAIT_FOR_NEXT_LIFE) {
      spr->curr_frame = 81;
      }
   }

#endif
