#ifndef CONTROLS_C
#include "controls.h"
#define CONTROLS_C

void Handle_Controls() {
	int i,j;
	poll_joystick();
	for (i = 0; i < MAX_PLAYERS; i++) {
		if (control_type[i] == -1) { // keyboard
			for (j = 0; j < 6; j++) {
				if (key[controls[i][j]]) {
					master_controls[i][j] = 1;
					}
				else {
					master_controls[i][j] = 0;
					}
				}
			}
		else { // joystick or joypad
			if (joy[control_type[i]].stick[0].axis[0].d1) {
				master_controls[i][WEST] = 1;
				}
			else {
				master_controls[i][WEST] = 0;
				}
			if (joy[control_type[i]].stick[0].axis[0].d2) {
				master_controls[i][EAST] = 1;
				}
			else {
				master_controls[i][EAST] = 0;
				}
			if (joy[control_type[i]].stick[0].axis[1].d1) {
				master_controls[i][NORTH] = 1;
				}
			else {
				master_controls[i][NORTH] = 0;
				}
			if (joy[control_type[i]].stick[0].axis[1].d2) {
				master_controls[i][SOUTH] = 1;
				}
			else {
				master_controls[i][SOUTH] = 0;
				}
			if (joy[control_type[i]].button[1].b) {
				master_controls[i][JUMP] = 1;
				}
			else {
				master_controls[i][JUMP] = 0;
				}
			if (joy[control_type[i]].button[0].b) {
				master_controls[i][STRIKE] = 1;
				}
			else {
				master_controls[i][STRIKE] = 0;
				}
			}
		}
	}

int New_Press(int pl, int button) {
   static char master_tracker[MAX_PLAYERS][6];
   if (!master_controls[pl][button]) {
      master_tracker[pl][button] = 0;
      return 0;
      }
   else {
      if (master_tracker[pl][button] == 1)
         return 0;
      else {
         master_tracker[pl][button] = 1;
         return 1;
         }
      }
   }

#endif
