#ifndef READMAP9_H
#define READMAP9_H

#include "nsdefs.h"
#include "trigger.h"
#include "tilefunx.h"
#include <allegro.h>
#include <stdio.h>
#include <io.h>

typedef struct thing_typ {
	short x;
	short y;
	short z;
	unsigned char type;
	unsigned char palette;
	unsigned char thing_inside;
	} thing;

int row_length, num_rows;
unsigned char *level;
char tile_file_name[13];
char next_file_name[13];
char bkgd_file_name[13];
unsigned char transparency;
char relative_scroll_rate;
char rise_rate;
short start_spot_x;
short start_spot_y;
short start_spot_z;
unsigned char how_player_enters;
short walk_to_spot_x;
short walk_to_spot_y;
short walk_to_spot_z;
unsigned char how_player_exits;
unsigned char left_end_type;
char left_end_slant;
short left_end_offset;
unsigned char right_end_type;
char right_end_slant;
short right_end_offset;
char top_end_type;
unsigned char top_end_z;
char bottom_end_type;
unsigned char bottom_end_z;
unsigned char color_cycle_low_end;
unsigned char color_cycle_high_end;
unsigned char color_cycle_speed;
unsigned char music_num;
unsigned char number_of_things;
thing things[MAX_THINGS];
char trans_table[TILE_COUNT];
BITMAP *bg_pic;
PALETTE scrap_palette;

void Level_Malloc();

void Clear_Level();

void Clear_Trans_Table();

void Load_Trans_Table(char *trans_file_name);

void Load_Map(char *file_name);


#endif
