#ifndef READMAP9_C
#define READMAP9_C

#include "readmap9.h"

void Level_Malloc() {
	level = (unsigned char *) malloc((unsigned long) MAX_LEVEL_SIZE);
	if (level == NULL) {
		printf("Can't allocate memory for level.\n");
		exit(1);
		}
	else printf("Memory for level allocated.\n");
	}

void Clear_Level() {
	long int i;
	for (i=0; i<MAX_LEVEL_SIZE; i++)
		level[i] = 0;
   transparency = 0;
   relative_scroll_rate = 0;
   rise_rate = 0;
   start_spot_x = 0;
   start_spot_y = 0;
   start_spot_z = 0;
   how_player_enters = 0;
   walk_to_spot_x = 0;
   walk_to_spot_y = 0;
   walk_to_spot_z = 0;
   how_player_exits = 0;
   left_end_type = 0;
   left_end_slant = 0;
   left_end_offset = 0;
   right_end_type = 0;
   right_end_slant = 0;
   right_end_offset = 0;
   top_end_type = 0;
   top_end_z = 0;
   bottom_end_type = 0;
   bottom_end_z = 0;
   color_cycle_low_end = 0;
   color_cycle_high_end = 0;
   color_cycle_speed = 0;
   music_num = 0;
   number_of_things = 0;
   for (i=0; i<MAX_THINGS; i++) {
		things[i].x = NOWHERE;
		things[i].y = NOWHERE;
		things[i].z = NOWHERE;
		things[i].type = 0;
		things[i].palette = 0;
		things[i].thing_inside = 0;
		}
   }

void Clear_Trans_Table() {
     int index;
     for (index = 0; index < TILE_COUNT; index++)
         trans_table[index] = 1;
     }

void Load_Trans_Table(char *file_name) {
     FILE *fp, *fopen();
     int index = 0;
     fp=fopen(file_name,"rb");
     Clear_Trans_Table();
     while (index < TILE_COUNT) {
        trans_table[index] = getc(fp);
        index++;
        }
     fclose(fp);
     }


void Load_Map(char *file_name)
{
FILE *fp, *fopen();
int index = 0;
int index2 = 0;
int found_dot = 0;
char eof_test;
char trans_table_name[13];
unsigned char c;
fp=fopen(file_name,"rb");
// 254=EOF in Timap encoding; 255=end of row
Clear_Level();
num_rows = 0;
row_length = 0;
while  ((c = getc(fp)) != 254) {
	if (c == 255) {
		num_rows++;
		row_length=index-1;
		index = 0;
		}
	else
	level[index2++] = c;
	index++;
	}
for (index = 0; index < MAX_TRIGGER_POINTS; index++) {
	trigger_points[index].stop_scroll = getc(fp);
	trigger_points[index].xcoord = ((int) getc(fp)) << 8;
	trigger_points[index].xcoord |= (int) getc(fp);
	trigger_points[index].max_at_once = getc(fp);
	trigger_points[index].total_badguys = getc(fp);
	for (index2 = 0; index2 < 16; index2++) {
		trigger_points[index].badguy[index2].who = getc(fp);
		trigger_points[index].badguy[index2].how = getc(fp);
		trigger_points[index].badguy[index2].dif = getc(fp);
		trigger_points[index].badguy[index2].where_x = ((short)getc(fp)) << 8;
		trigger_points[index].badguy[index2].where_x |= (short)getc(fp);
		trigger_points[index].badguy[index2].where_y = ((short)getc(fp)) << 8;
		trigger_points[index].badguy[index2].where_y |= (short)getc(fp);
		trigger_points[index].badguy[index2].where_z = ((short)getc(fp)) << 8;
		trigger_points[index].badguy[index2].where_z |= (short)getc(fp);
		}
	}
for (index = 0; index < 13; index++) {
	tile_file_name[index]=getc(fp);
	}
   tile_file_name[12] = '\0'; // This is what we call defensive programming!
for (index = 0; index < 13; index++) {
	next_file_name[index]=getc(fp);
	}
   next_file_name[12] = '\0';
for (index = 0; index < 13; index++) {
	bkgd_file_name[index]=getc(fp);
	}
   bkgd_file_name[12] = '\0';
transparency = getc(fp);
relative_scroll_rate = getc(fp);
rise_rate = getc(fp);
start_spot_x = ((short)getc(fp)) << 8;
start_spot_x |= (short)getc(fp);
start_spot_y = ((short)getc(fp)) << 8;
start_spot_y |= (short)getc(fp);
start_spot_z = ((short)getc(fp)) << 8;
start_spot_z |= (short)getc(fp);
how_player_enters = getc(fp);
walk_to_spot_x = ((short)getc(fp)) << 8;
walk_to_spot_x |= (short)getc(fp);
walk_to_spot_y = ((short)getc(fp)) << 8;
walk_to_spot_y |= (short)getc(fp);
walk_to_spot_z = ((short)getc(fp)) << 8;
walk_to_spot_z |= (short)getc(fp);
how_player_exits = getc(fp);
left_end_type = getc(fp);
left_end_slant = getc(fp);
left_end_offset = ((short)getc(fp)) << 8;
left_end_offset |= (short)getc(fp);
right_end_type = getc(fp);
right_end_slant = getc(fp);
right_end_offset = ((short)getc(fp)) << 8;
right_end_offset |= (short)getc(fp);
top_end_type = getc(fp);
top_end_z = getc(fp);
bottom_end_type = getc(fp);
bottom_end_z = getc(fp);
color_cycle_low_end = getc(fp);
color_cycle_high_end = getc(fp);
color_cycle_speed = getc(fp);
music_num = getc(fp);
eof_test = getc(fp);
if (eof_test != EOF) { // In case you want to load an old-format map file
	ungetc(eof_test, fp);
	number_of_things = getc(fp);
	for (index = 0; index < MAX_THINGS; index++) {
		things[index].x = ((short)getc(fp)) << 8;
		things[index].x |= (short)getc(fp);
		things[index].y = ((short)getc(fp)) << 8;
		things[index].y |= (short)getc(fp);
		things[index].z = ((short)getc(fp)) << 8;
		things[index].z |= (short)getc(fp);
		things[index].type = getc(fp);
		things[index].palette = getc(fp);
		things[index].thing_inside = getc(fp);
		}
	}
fclose(fp);

if ((_access(tile_file_name, 0)) != -1) // That is, if the file exists...
   Load_Tile_Set(tile_file_name);
if ((_access(bkgd_file_name, 0)) != -1)
   bg_pic = load_pcx(bkgd_file_name,scrap_palette);
index = 0;
while (!found_dot) {
   if (tile_file_name[index] == '.' || tile_file_name[index] == 0 || index > 12) {
      if (index > 8)
         index = 8;
      trans_table_name[index] = '.';
      trans_table_name[index+1] = 'T';
      trans_table_name[index+2] = 'R';
      trans_table_name[index+3] = 'A';
      trans_table_name[index+4] = 0;
      found_dot = 1;
      }
   else
       trans_table_name[index] = tile_file_name[index];
   index++;
   }
if ((_access(trans_table_name, 0)) != -1)
   Load_Trans_Table(trans_table_name);
else
    Clear_Trans_Table();
}

#endif
