/* Kung Fu
   Neil Walker 12/November/1999
   www.retrospec.co.uk
*/
#include "core.h"
int m_mode;

BITMAP* gbuffer; //double buffer for map
BITMAP* mbuffer; //double buffer for menu
BITMAP* terrain;	//small terrain window;

int gbufw,gbufh,gbufw_c,gbufh_c; //size of gbuffer (full and centre) for quickness
int mbufw,mbufh,mbufw_c,mbufh_c; //size of mbuffer (full and centre) for quickness
int colour_light, colour_dark, colour_white, colour_red, colour_black;
int font_height;

volatile int frame_count;
volatile int fps;
volatile bool digipurge=false;

////////////////////////
//main
//the starting point
////////////////////////
int main(int argc, char* argv[])
{
	srand(time(NULL)); //one and only seed

	//this calls all initialisation stuff
	InitSystem();
	InitAllegro();
	InitGame();

	play_game();

	DeinitGame();
	DeinitAllegro();
	DeinitSystem();

	return 0;
	//main console startup to determine available modes, etc.
}
END_OF_MAIN();

//-----------------------------------------------------------/

void InitSystem()
{
	gbuffer=NULL;
	gbufw=0;
	gbufh=0;
	gbufw_c=0;
	gbufh_c=0; 

	mbuffer=NULL;
	mbufw=0;
	mbufh=0;
	mbufw_c=0;
	mbufh_c=0; 

	terrain=NULL;
}

void InitAllegro()
{
	//entry from after initsystem
	//initialise graphics engine
	//graphics mode not to be set here, called by init_game after this
	//system to be left in TEXT mode or similar

	//standard Allegro initialise

	m_mode=MODE_DOS;

	allegro_init();
	install_timer();
	install_keyboard();
	//install_joystick(JOY_TYPE_AUTODETECT);
	//install_mouse();
	fps=frame_count=0;
	LOCK_VARIABLE(fps);
	LOCK_VARIABLE(frame_count);
	LOCK_FUNCTION(fps_handler);
	LOCK_FUNCTION(game_timer);
	install_int(fps_handler,1000);

	m_mode=MODE_DOS;
}

void InitGame()
{
	//called after init_system and init_allegro
	//entry point is still in text mode
	//exit point is a graphics mode
	//set up translucency table
	//load up data file (temporarily)

//must set graphics mode here
	int fallback=GFX_AUTODETECT_WINDOWED;
	int preferred=GFX_AUTODETECT;
	int w,h;

	set_color_depth(GAME_DEPTH);
	w=800;
	h=600;
	if(set_gfx_mode(preferred,800,600,0,0)<0)
		if(set_gfx_mode(fallback,800,600,0,0)<0)
		{
			w=1024;
			h=768;
			if(set_gfx_mode(preferred,1024,768,0,0)<0)
				if(set_gfx_mode(fallback,1024,768,0,0)<0)
				{
					w=640;
					h=480;
					if(set_gfx_mode(preferred,640,480,0,0)<0)
						if(set_gfx_mode(fallback,640,480,0,0)<0)
							AbortSystem("Cannot set 800 or 1024 16 bit windowed or normal!");
				}
		}


	//set 8 bit to 16 bit conversion, which is none - just show it
	m_mode=MODE_GFX;      //needed for console stuff
	set_color_conversion(COLORCONV_NONE);
	//set text to transparent
	text_mode(-1);
	clear_bitmap(screen);


//palettes, etc.

//buffers
	//create global double buffer
	int mwidth=200;
	gbuffer=create_system_bitmap(w,h);
	if (gbuffer==NULL) gbuffer=create_bitmap(w,h);
	if (gbuffer==NULL) AbortSystem("error allocating screen space");

	mbuffer=create_system_bitmap(mwidth,h);
	if (mbuffer==NULL) mbuffer=create_bitmap(mwidth,h);
	if (mbuffer==NULL) AbortSystem("error allocating buffer space");

	terrain=create_system_bitmap(128,128);
	if(terrain==NULL) terrain=create_bitmap(128,128);
	if(terrain==NULL) AbortSystem("error allocating terrain space");

	gbufw=gbuffer->w;
	gbufh=gbuffer->h;
	gbufw_c=gbuffer->w/2;
	gbufh_c=gbuffer->h/2;

	mbufw=mbuffer->w;
	mbufh=mbuffer->h;
	mbufw_c=mbuffer->w/2;
	mbufh_c=mbuffer->h/2;

	//colours
	colour_light=makecol(COLOUR_LIGHT);
	colour_dark=makecol(COLOUR_DARK);
	colour_red=makecol(COLOUR_RED);
	colour_white=makecol(COLOUR_WHITE);
	colour_black=makecol(COLOUR_BLACK);

	//font
	font_height=text_height(font);
}

void DeinitGame()
{
	allegro_exit();
	m_mode=MODE_DOS;
}

////////////////////////////
//deinit_allegro
//stop allegro
///////////////////////
void DeinitAllegro()
{
	//allegro_exit removes all initialised stuff for us
	allegro_exit();
	m_mode=MODE_DOS;
}


void DeinitSystem()
{
}


/////////
//abort system
//forced shutdown
///////////
void AbortSystem(char* err)
{
	 //usually called by itself or programmer if terminal or after shutdown
	 char umsg[255];

	 if((*err!=NULL)) sprintf(umsg,"Aborting system because:\n%s",err);
	 else sprintf(umsg,"Aborting system (no reason given");
	 set_gfx_mode(GFX_TEXT,0,0,0,0);
	 allegro_message(umsg);
	 allegro_exit();
	 exit(0);
}


void TextMsg(char* msg)
{
	//only message if not in graphics mode
	if(m_mode==MODE_DOS) allegro_message(msg);
}

void WaitForKey(int keyp)
{
	clear_keybuf();
	while(readkey()>>8 !=keyp);
}

void logentry(char* entry)
{
	FILE *stream;
	if( (stream = fopen( "logfile.txt", "a+t" )) != NULL )
	{
		fprintf(stream,"%s\n",entry);
		fclose(stream);
	}
}


///////
//standard fps timer
//fps_handler
////////////
void fps_handler()
{
 //called every 1000 milliseconds
 fps=frame_count; //set fps to display to user
 frame_count=0;   //reset the count for the next loop
}
END_OF_FUNCTION(fps_handler);

