/* Underwurlde:Resurrection
   Neil Walker 12/9/1999
   www.retrospec.org
*/

//contains all core values that should not be overridden
#ifndef GAME_CORE
#define GAME_CORE

#include <allegro.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#include <math.h>

#define CORE_ALLEGRO_SYSTEM_DECL
#define MODE_GFX 1        //set_gfx_mode set to graphics
#define MODE_DOS 3        //allegro is not running
#define GAME_DEPTH 16
#define COLOUR_LIGHT 255,255,0
#define COLOUR_DARK 200,200,200
#define COLOUR_RED 255,0,0
#define COLOUR_WHITE 255,255,255
#define COLOUR_BLACK 0,0,0

struct TDPoint;	//forward declaration
//system stuff
void InitAllegro();			//initialise Allegro
void DeinitAllegro();
void InitSystem();	//main console startup to determine available modes, etc.
void InitGame();	//initialise game
void DeinitGame();	//stop all the stuff we have started
void DeinitSystem();
void AbortSystem(char*);
void TextMsg(char*);
void WaitForKey(int keyp=KEY_F7);	//default
void logentry(char*);
void fps_handler();

//mapping functions
void debug();
void setup_game();
void play_game();

bool keyInput();
bool mapUpdate();

void menuDraw();
void mapdraw();
void buildmap(bool reseed=true);
void smoothmap(int,int);
void normalisemap(int);
void stretchmap();
void roughenmap();
void buildmap3D();
void drawmap3D();
void matrixbuild(double,double,double);
TDPoint rotatepoint(double,double,double);

#endif
