# - Find allegroGL
# Find the native ALLEGROGL includes and library
#
#  ALLEGROGL_INCLUDE_DIR - where to find alleggl.h, etc.
#  ALLEGROGL_LIBRARIES   - List of libraries when using allegro.
#  ALLEGROGL_FOUND       - True if allegro found.

FIND_PACKAGE(ALLEGRO)
FIND_PACKAGE(OpenGL)

IF (ALLEGROGL_INCLUDE_DIR)
  # Already in cache, be silent
  SET(ALLEGROGL_FIND_QUIETLY TRUE)
ENDIF (ALLEGROGL_INCLUDE_DIR)

FIND_PATH(ALLEGROGL_INCLUDE_DIR alleggl.h
  /usr/local/include
  /usr/include
  $ENV{MINGDIR}/include
)

SET(ALLEGROGL_NAMES agl alleggl agllib agldll)
FIND_LIBRARY(ALLEGROGL_LIBRARY
NAMES ${ALLEGROGL_NAMES}
PATHS /usr/lib /usr/local/lib $ENV{MINGDIR}/lib)

IF (ALLEGROGL_INCLUDE_DIR AND ALLEGROGL_LIBRARY)
   SET(ALLEGROGL_FOUND TRUE)
    SET( ALLEGROGL_LIBRARIES ${ALLEGROGL_LIBRARY} ${ALLEGRO_LIBRARIES} ${OPENGL_LIBRARIES})
ELSE (ALLEGROGL_INCLUDE_DIR AND ALLEGROGL_LIBRARY)
   SET(ALLEGROGL_FOUND FALSE)
   SET( ALLEGROGL_LIBRARIES )
ENDIF (ALLEGROGL_INCLUDE_DIR AND ALLEGROGL_LIBRARY)

IF (ALLEGROGL_FOUND)
   IF (NOT ALLEGROGL_FIND_QUIETLY)
      MESSAGE(STATUS "Found AllegroGL: ${ALLEGROGL_LIBRARY}")
   ENDIF (NOT ALLEGROGL_FIND_QUIETLY)
ELSE (ALLEGROGL_FOUND)
   IF (ALLEGROGL_FIND_REQUIRED)
      MESSAGE(STATUS "Looked for AllegroGL libraries named ${ALLEGROGL_NAMES}.")
      MESSAGE(FATAL_ERROR "Could NOT find AllegroGL library")
   ENDIF (ALLEGROGL_FIND_REQUIRED)
ENDIF (ALLEGROGL_FOUND)

MARK_AS_ADVANCED(
  ALLEGROGL_LIBRARY
  ALLEGROGL_INCLUDE_DIR
  )