/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import java.awt.image.DataBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public final class DataBufferNIOInt
extends DataBuffer {
    IntBuffer data;
    IntBuffer[] bankdata;

    public DataBufferNIOInt(int n) {
        super(3, n);
        this.data = this.getBufferOfSize(n * 4).asIntBuffer();
        this.bankdata = new IntBuffer[1];
        this.bankdata[0] = this.data;
    }

    public IntBuffer getBuffer() {
        return this.data;
    }

    public IntBuffer getBuffer(int n) {
        return this.bankdata[n];
    }

    public int[] getData() {
        return this.data.array();
    }

    public int[] getData(int n) {
        return this.bankdata[n].array();
    }

    public int[][] getBankData() {
        return (int[][])this.bankdata.clone();
    }

    public int getElem(int n) {
        return this.data.get(n + this.offset);
    }

    public int getElem(int n, int n2) {
        return this.bankdata[n].get(n2 + this.offsets[n]);
    }

    public void setElem(int n, int n2) {
        this.data.put(n + this.offset, n2);
    }

    public void setElem(int n, int n2, int n3) {
        this.bankdata[n].put(n2 + this.offsets[n], n3);
    }

    ByteBuffer getBufferOfSize(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }
}

