/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CGraphicsConfig;
import apple.awt.CGraphicsEnvironment;
import apple.awt.OSXOffScreenSurfaceData;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.ImageCapabilities;
import java.awt.image.ColorModel;
import java.security.AccessController;
import sun.awt.DisplayChangedListener;
import sun.awt.image.SunVolatileImage;
import sun.java2d.InvalidPipeException;
import sun.java2d.SurfaceData;
import sun.security.action.GetPropertyAction;

public class OSXVolatileImage
extends SunVolatileImage
implements DisplayChangedListener {
    private void initialize() {
        ((CGraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment()).addDisplayChangedListener(this);
    }

    public OSXVolatileImage(Component component, int n, int n2) {
        super(component, n, n2);
        this.initialize();
    }

    public OSXVolatileImage(Component component, int n, int n2, Object object) {
        super(component, n, n2, object);
        this.initialize();
    }

    public OSXVolatileImage(GraphicsConfiguration graphicsConfiguration, int n, int n2) {
        super(graphicsConfiguration, n, n2);
        this.initialize();
    }

    protected OSXOffScreenSurfaceData createHWData() {
        ColorModel colorModel = this.getDeviceColorModel();
        return OSXOffScreenSurfaceData.createData(this.getWidth(), this.getHeight(), colorModel, this.graphicsConfig, this, false);
    }

    public void initAcceleratedBackground() {
        try {
            this.surfaceDataHw = this.createHWData();
            if (this.surfaceDataHw != null) {
                this.surfaceData = this.surfaceDataHw;
                this.initContents();
                return;
            }
        }
        catch (InvalidPipeException invalidPipeException) {
            this.surfaceDataHw = null;
        }
        this.surfaceData = this.getSurfaceDataSw();
    }

    public SurfaceData restoreContents() {
        if (accelerationEnabled) {
            this.surfaceLossHw = true;
            this.surfaceLoss = true;
        }
        return super.restoreContents();
    }

    protected ColorModel getDeviceColorModel() {
        if (this.comp != null) {
            CGraphicsConfig cGraphicsConfig = (CGraphicsConfig)this.comp.getGraphicsConfiguration();
            return cGraphicsConfig.getColorModel();
        }
        return ((CGraphicsConfig)this.graphicsConfig).getColorModel();
    }

    protected void restoreSurfaceDataHw() {
        ((OSXOffScreenSurfaceData)this.surfaceDataHw).restoreSurface();
    }

    public void displayChanged() {
        if (!accelerationEnabled) {
            return;
        }
        this.surfaceLoss = true;
        this.surfaceLossHw = true;
        if (this.surfaceDataHw != null) {
            this.surfaceDataSw = null;
            this.surfaceData = this.getSurfaceDataSw();
            SurfaceData surfaceData = this.surfaceDataHw;
            this.surfaceDataHw = null;
            surfaceData.invalidate();
            if (this.comp != null) {
                this.graphicsConfig = this.comp.getGraphicsConfiguration();
            }
        }
    }

    public void paletteChanged() {
        this.surfaceLoss = true;
    }

    public ImageCapabilities getCapabilities() {
        if (accelerationEnabled && !(this.imageCaps instanceof HWACImageCaps)) {
            this.imageCaps = new HWACImageCaps();
        }
        return super.getCapabilities();
    }

    public void flush() {
        this.surfaceLoss = true;
        OSXOffScreenSurfaceData oSXOffScreenSurfaceData = (OSXOffScreenSurfaceData)this.surfaceDataHw;
        this.surfaceDataHw = null;
        if (oSXOffScreenSurfaceData != null) {
            oSXOffScreenSurfaceData.flush();
        }
    }

    public String toString() {
        return super.toString() + " surfaceDataHw=" + this.surfaceDataHw + " surfaceData=" + this.surfaceData;
    }

    static {
        boolean bl;
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.noddraw"));
        String string2 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.ddoffscreen"));
        boolean bl2 = bl = string2 != null && (string2.equals("false") || string2.equals("f"));
        if (string != null || bl) {
            accelerationEnabled = false;
        }
    }

    private class HWACImageCaps
    extends SunVolatileImage.DefaultImageCapabilities {
        private HWACImageCaps() {
            super((SunVolatileImage)OSXVolatileImage.this);
        }

        public boolean isTrueVolatile() {
            return this.isAccelerated();
        }
    }
}

