/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CGraphicsDevice;
import apple.awt.IntegerNIORaster;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.loops.SurfaceType;

public class OSXOffScreenSurfaceData
extends BufImgSurfaceData {
    public static final String DESC_INT_ARGB = "Integer ARGB";
    public static final SurfaceType sIntARGB = SurfaceType.IntRgb.deriveSubType("Integer ARGB");
    private int fTransparency;

    public static OSXOffScreenSurfaceData createData(int n, int n2, ColorModel colorModel, GraphicsConfiguration graphicsConfiguration, Image image, boolean bl) {
        if (!((CGraphicsDevice)graphicsConfiguration.getDevice()).isOffscreenAccelerationEnabled()) {
            return null;
        }
        int n3 = bl ? 2 : 1;
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, n3);
        OSXOffScreenSurfaceData oSXOffScreenSurfaceData = OSXOffScreenSurfaceData.createDataINIO(bufferedImage, image, OSXOffScreenSurfaceData.getSurfaceType(colorModel, n3), n3);
        return oSXOffScreenSurfaceData;
    }

    protected OSXOffScreenSurfaceData(BufferedImage bufferedImage, Image image, SurfaceType surfaceType, int n) {
        super(bufferedImage, surfaceType);
        this.fTransparency = n;
    }

    static OSXOffScreenSurfaceData createDataINIO(BufferedImage bufferedImage, Image image, SurfaceType surfaceType, int n) {
        OSXOffScreenSurfaceData oSXOffScreenSurfaceData = new OSXOffScreenSurfaceData(bufferedImage, image, surfaceType, n);
        IntegerNIORaster integerNIORaster = (IntegerNIORaster)bufferedImage.getRaster();
        oSXOffScreenSurfaceData.initNIORaster(integerNIORaster.getBuffer(), integerNIORaster.getWidth(), integerNIORaster.getHeight());
        return oSXOffScreenSurfaceData;
    }

    public static SurfaceType getSurfaceType(ColorModel colorModel, int n) {
        return sIntARGB;
    }

    public void restoreSurface() {
    }

    public Raster getRaster() {
        return super.getRaster(0, 0, this.getBounds().width, this.getBounds().height);
    }

    public int getTransparency() {
        return this.fTransparency;
    }
}

