/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CComponent;
import apple.awt.CToolkit;
import apple.awt.CWindow;
import apple.awt.ComponentModel;
import apple.awt.ContainerModel;
import apple.awt.PeerPaintEvent;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.InvocationEvent;
import java.awt.peer.ComponentPeer;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

public class EventFactoryProxy {
    static final boolean kDEBUG_PAINTING = false;
    private static Object sAllThreadsCurrentEvent;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static void postComponentResizedEvent(int n, Object object) {
        if (!$assertionsDisabled && !CToolkit.stdio("EventFactoryProxy.postComponentResizedEvent")) {
            throw new AssertionError();
        }
        try {
            CComponent cComponent = (CComponent)object;
            ComponentEvent componentEvent = new ComponentEvent(cComponent.fTarget, 101);
            if (cComponent instanceof ContainerModel) {
                ((ContainerModel)cComponent).fPeerPainterLOCKABLE.addResizeEvent(componentEvent);
            } else {
                CToolkit.postEvent(cComponent, (AWTEvent)componentEvent);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void postComponentMovedEvent(int n, Object object) {
        if (!$assertionsDisabled && !CToolkit.stdio("EventFactoryProxy.postComponentMovedEvent")) {
            throw new AssertionError();
        }
        try {
            CComponent cComponent = (CComponent)object;
            ComponentEvent componentEvent = new ComponentEvent(cComponent.fTarget, 100);
            CToolkit.postEvent(cComponent, (AWTEvent)componentEvent);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void postComponentAdded(ComponentModel componentModel) {
        if (!$assertionsDisabled && !CToolkit.stdio("EventFactoryProxy.postComponentAdded")) {
            throw new AssertionError();
        }
        try {
            final Component component = componentModel.fTarget;
            Runnable runnable = new Runnable(){

                public void run() {
                    if (component instanceof Window) {
                        Window window = (Window)component;
                        window.invalidate();
                        window.validate();
                        window.doLayout();
                    } else {
                        Container container = component.getParent();
                        if (container != null) {
                            container.invalidate();
                            container.validate();
                            container.doLayout();
                        } else if (component instanceof Container) {
                            Container container2 = (Container)component;
                            container2.invalidate();
                            container2.validate();
                            container2.doLayout();
                        }
                    }
                }
            };
            InvocationEvent invocationEvent = new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable);
            AppContext appContext = CToolkit.finalTargetToAppContext(component);
            if (appContext != null) {
                SunToolkit.postEvent(appContext, invocationEvent);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void drawRectForView(long l, int n, int n2, int n3, int n4, boolean bl, Object object, long l2) {
        if (!$assertionsDisabled && !CToolkit.stdio("EventFactoryProxy.drawRectForView")) {
            throw new AssertionError();
        }
        ContainerModel containerModel = (ContainerModel)object;
        long l3 = 0L;
        PeerPaintEvent peerPaintEvent = containerModel.getPeerPainter();
        if (peerPaintEvent != null) {
            peerPaintEvent.paintFromCocoaDrawRect(n, n2, n3, n4, bl, l2);
        }
    }

    private static void viewInLiveResize(long l, Object object, boolean bl) {
        if (!$assertionsDisabled && !CToolkit.stdio("EventFactoryProxy.viewInLiveResize: " + bl)) {
            throw new AssertionError();
        }
        ContainerModel containerModel = (ContainerModel)object;
        containerModel.setInLiveResizing(bl);
    }

    private static int forwardEvent(AWTEvent aWTEvent) {
        if (!$assertionsDisabled && !CToolkit.stdio("EventFactoryProxy.forwardEvent:" + aWTEvent.getClass())) {
            throw new AssertionError();
        }
        if (aWTEvent instanceof ComponentEvent) {
            CToolkit.postEvent(aWTEvent);
        } else if (aWTEvent != null) {
            Thread.dumpStack();
        }
        return 0;
    }

    private static void changeFocus(final boolean bl, Component component) {
        if (!$assertionsDisabled && !CToolkit.stdio("EventFactoryProxy.changeFocus")) {
            throw new AssertionError();
        }
        AppContext appContext = CToolkit.finalTargetToAppContext(component);
        final KeyboardFocusManager keyboardFocusManager = (KeyboardFocusManager)appContext.get(KeyboardFocusManager.class);
        Runnable runnable = new Runnable(){

            public void run() {
                if (bl) {
                    keyboardFocusManager.focusNextComponent();
                } else {
                    keyboardFocusManager.focusPreviousComponent();
                }
            }
        };
        InvocationEvent invocationEvent = new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable);
        SunToolkit.postEvent(appContext, invocationEvent);
    }

    private static void windowMoved(final CWindow cWindow) {
        if (!$assertionsDisabled && !CToolkit.stdio("EventFactoryProxy.windowMoved")) {
            throw new AssertionError();
        }
        SunToolkit.executeOnEventHandlerThread(cWindow.fTarget, new Runnable(){

            public void run() {
                cWindow.displayChanged();
                cWindow.updateLocationOnScreen();
            }
        });
    }

    static void setCurrentEvent(Object object) {
        sAllThreadsCurrentEvent = object;
    }

    static Object getCurrentEvent() {
        return sAllThreadsCurrentEvent;
    }

    private static Component findFocusTraversalRoot(ComponentPeer componentPeer) {
        if (componentPeer instanceof CWindow) {
            Window window = (Window)((CWindow)componentPeer).fTarget;
            return window.getFocusTraversalPolicy().getInitialComponent(window);
        }
        return null;
    }

    static {
        $assertionsDisabled = !EventFactoryProxy.class.desiredAssertionStatus();
        sAllThreadsCurrentEvent = null;
    }
}

