/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CToolkitThreadBlockedHandler;
import apple.awt.HTMLDecodingInputStream;
import apple.awt.OSXImage;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;
import sun.awt.image.ImageRepresentation;

public class CDataTransferer
extends DataTransferer {
    private static final Map predefinedClipboardNameMap;
    private static final Map predefinedClipboardFormatMap;
    private static final String[] predefinedClipboardNames;
    public static final int CF_UNSUPPORTED = 0;
    public static final int CF_STRING = 1;
    public static final int CF_FILE = 2;
    public static final int CF_TIFF = 3;
    public static final int CF_RICH_TEXT = 4;
    public static final int CF_HTML = 5;
    public static final int CF_PICT = 6;
    public static final int CF_PDF = 7;
    public static final int CF_URL = 8;
    public static final Long L_CF_TIFF;
    private static final Long[] imageFormats;
    private static CDataTransferer fTransferer;

    private static native void initializeNSMappingTable();

    private CDataTransferer() {
    }

    public static synchronized CDataTransferer getInstanceImpl() {
        if (fTransferer == null) {
            fTransferer = new CDataTransferer();
        }
        return fTransferer;
    }

    public String getDefaultUnicodeEncoding() {
        return "utf-16le";
    }

    public boolean isLocaleDependentTextFormat(long l) {
        return l == 1L;
    }

    public boolean isFileFormat(long l) {
        return l == 2L;
    }

    public boolean isImageFormat(long l) {
        return l == 3L;
    }

    protected Long[] getImageFormatsAsLongArray() {
        return imageFormats;
    }

    public Map getFormatsForFlavors(DataFlavor[] dataFlavorArray, FlavorTable flavorTable) {
        Map map = super.getFormatsForFlavors(dataFlavorArray, flavorTable);
        return map;
    }

    public byte[] translateTransferable(Transferable transferable, DataFlavor dataFlavor, long l) throws IOException {
        byte[] byArray = super.translateTransferable(transferable, dataFlavor, l);
        return byArray;
    }

    protected Object translateBytesOrStream(InputStream inputStream, byte[] byArray, DataFlavor dataFlavor, long l, Transferable transferable) throws IOException {
        if (l == 5L && dataFlavor.isFlavorTextType()) {
            if (inputStream == null) {
                inputStream = new ByteArrayInputStream(byArray);
                byArray = null;
            }
            inputStream = new HTMLDecodingInputStream(inputStream);
        }
        if (l == 8L && URL.class.equals(dataFlavor.getRepresentationClass())) {
            if (byArray == null) {
                byArray = CDataTransferer.inputStreamToByteArray(inputStream);
                inputStream = null;
            }
            String string = CDataTransferer.getDefaultTextCharset();
            if (transferable != null && transferable.isDataFlavorSupported(javaTextEncodingFlavor)) {
                try {
                    string = new String((byte[])transferable.getTransferData(javaTextEncodingFlavor), "UTF-8");
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    // empty catch block
                }
            }
            return new URL(new String(byArray, string));
        }
        return super.translateBytesOrStream(inputStream, byArray, dataFlavor, l, transferable);
    }

    protected synchronized Long getFormatForNativeAsLong(String string) {
        Long l = (Long)predefinedClipboardNameMap.get(string);
        if (l == null) {
            l = new Long(this.registerFormatWithPasteboard(string));
            predefinedClipboardNameMap.put(string, l);
            predefinedClipboardFormatMap.put(l, string);
        }
        return l;
    }

    private native long registerFormatWithPasteboard(String var1);

    private native String formatForIndex(long var1);

    protected String getNativeForFormat(long l) {
        String string = null;
        if (l >= 0L && l < (long)predefinedClipboardNames.length) {
            string = predefinedClipboardNames[(int)l];
        } else {
            Long l2 = new Long(l);
            string = (String)predefinedClipboardFormatMap.get(l2);
            if (string == null && (string = this.formatForIndex(l)) != null) {
                predefinedClipboardNameMap.put(string, l2);
                predefinedClipboardFormatMap.put(l2, string);
            }
        }
        if (string == null) {
            string = predefinedClipboardNames[0];
        }
        return string;
    }

    public ToolkitThreadBlockedHandler getToolkitThreadBlockedHandler() {
        return CToolkitThreadBlockedHandler.getToolkitThreadBlockedHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] imageToPlatformBytes(Image image, long l) {
        Object object;
        Object var4_3 = null;
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 3);
        Graphics graphics = bufferedImage.getGraphics();
        try {
            if (image instanceof OSXImage) {
                object = ((OSXImage)((Object)image)).getImageRep();
                ((ImageRepresentation)object).reconstruct(32);
            }
            graphics.drawImage(image, 0, 0, n, n2, null);
        }
        finally {
            graphics.dispose();
        }
        object = bufferedImage.getRaster();
        DataBuffer dataBuffer = ((Raster)object).getDataBuffer();
        return this.imageDataToPlatformImageBytes(((DataBufferInt)dataBuffer).getData(), ((Raster)object).getWidth(), ((Raster)object).getHeight());
    }

    private native byte[] imageDataToPlatformImageBytes(int[] var1, int var2, int var3);

    protected Image platformImageBytesOrStreamToImage(InputStream inputStream, byte[] byArray, long l) throws IOException {
        byte[] byArray2 = byArray;
        if (byArray2 == null) {
            byArray2 = CDataTransferer.inputStreamToByteArray(inputStream);
        }
        return this.getImageForByteStream(byArray2);
    }

    private native Image getImageForByteStream(byte[] var1);

    static {
        predefinedClipboardNames = new String[]{"", "STRING", "FILE_NAME", "TIFF", "RICH_TEXT", "HTML", "PICT", "PDF", "URL"};
        HashMap<String, Long> hashMap = new HashMap<String, Long>(predefinedClipboardNames.length, 1.0f);
        HashMap<Long, String> hashMap2 = new HashMap<Long, String>(predefinedClipboardNames.length, 1.0f);
        for (int i = 1; i < predefinedClipboardNames.length; ++i) {
            hashMap.put(predefinedClipboardNames[i], new Long(i));
            hashMap2.put(new Long(i), predefinedClipboardNames[i]);
        }
        predefinedClipboardNameMap = Collections.synchronizedMap(hashMap);
        predefinedClipboardFormatMap = Collections.synchronizedMap(hashMap2);
        CDataTransferer.initializeNSMappingTable();
        L_CF_TIFF = (Long)predefinedClipboardNameMap.get(predefinedClipboardNames[3]);
        imageFormats = new Long[]{L_CF_TIFF};
    }
}

