///AstarPathfinder.h

class AstarPathfinder
{
private:
	struct NODE 
	{
		long f, h;
		int g, tmpg;
		int x, y;
		int NodeNum;
		NODE *Parent;
		NODE *Child[8];
		NODE *NextNode;
	};

	NODE *OPEN;
	NODE *CLOSED;
	NODE *PATH;
	struct STACK 
	{
	   	NODE *NodePtr;
	    STACK *NextStackPtr;
	};	
	STACK *Stack;
    bool isPath;   
    int HEIGHT,
        WIDTH,
        TOTAL_TILES;
    int *TileMap;
public:   
   	AstarPathfinder(WORLD &Map);
    ~AstarPathfinder();
   	void InitAstarTileMap(WORLD &Map);      
   	void RedoAstarTileMap(WORLD &Map);   
  
	bool NewPath(int sx, int sy, int dx, int dy);
	bool ReachedGoal(void);
	void PathNextNode(void);
	int NodeGetX(void);
	int NodeGetY(void);
    int TileNum(int x, int y);
	bool FreeTile(int x, int y);
private:

	void BoundaryTiles(void);
    void FreeNodes(void);
    void FindPath(int sx, int sy, int dx, int dy);
	NODE *ReturnBestNode(void);
	void GenerateSuccessors(NODE *BestNode, int dx, int dy);
   	void GenerateSucc(NODE *BestNode,int x, int y, int dx, int dy);
	NODE *CheckOPEN(int tilenum);
	NODE *CheckCLOSED(int tilenum);
	void Insert(NODE *Successor);
	void PropagateDown(NODE *Old);
    void Push(NODE *Node);
	NODE *Pop(void);
};