/* 
Copyright (c) 2005 - 2007 Tobias Scheuer

The zlib/libpng License

This software is provided 'as-is', without any express or implied warranty. 
In no event will the authors be held liable for any damages arising from the 
use of this software.

Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim 
that you wrote the original software. If you use this software in a product, 
an acknowledgment in the product documentation would be appreciated but is 
not required.

2. Altered source versions must be plainly marked as such, and must not be 
misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
*/

#ifndef INC_VIEWPORT
#define INC_VIEWPORT
#endif

#ifndef INC_TYPES
#include "Types.h"
#endif
#ifndef INC_DISPLAYENGINE
#include "../gfwk/src/DisplayEngine.h"
#endif

class WorldMap;
class MainView;

//----------------------------------------------------------------------------

class WorldTopStatus : public ViewPortBase
{
public:
  WorldTopStatus( const ScreenRect&asr, const WorldMap&amap ) : ViewPortBase( asr ), map_(amap) {}
  virtual void display( BITMAP*const );
private:
  const WorldMap&map_;
};

//----------------------------------------------------------------------------

class WorldBotStatus : public ViewPortBase
{
public:
  WorldBotStatus( const ScreenRect&asr, const WorldMap&amap ) : ViewPortBase( asr ), map_(amap) {}
  virtual void display( BITMAP*const );
private:
  const WorldMap&map_;
};

//----------------------------------------------------------------------------

class MainMenu : public ViewPortBase
{
public:
  MainMenu( const ScreenRect&asr, WorldMap&amap, MainView&aview );
  ~MainMenu();
  virtual void display( BITMAP*const );
private:
  WorldMap&map_;
  MainView&view_;
  DIALOG_PLAYER*dlg_player;
};

//----------------------------------------------------------------------------

