#include "StdAfx.h"

/* 
Copyright (c) 2005 - 2007 Tobias Scheuer

The zlib/libpng License

This software is provided 'as-is', without any express or implied warranty. 
In no event will the authors be held liable for any damages arising from the 
use of this software.

Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim 
that you wrote the original software. If you use this software in a product, 
an acknowledgment in the product documentation would be appreciated but is 
not required.

2. Altered source versions must be plainly marked as such, and must not be 
misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
*/

#ifndef INC_GAMELOOPIFC
#include "../gfwk/src/GameLoopIfc.h"
#endif

#ifndef INC_TOOLS
#include "Tools.h"
#endif

//----------------------------------------------------------------------------

void CostRevenueCollector::clear()
{
  cur_cst_ = 0;
  cst_last_day_ = 0;
  cst_mtd_ = 0;
  cst_last_month_ = 0;
  cst_ytd_ = 0;
  cst_last_year_ = 0;

  cur_rev_ = 0;
  rev_last_day_ = 0;
  rev_mtd_ = 0;
  rev_last_month_ = 0;
  rev_ytd_ = 0;
  rev_last_year_ = 0;
}

void CostRevenueCollector::update_day()
{
  cst_last_day_ = cur_cst_;
  cur_cst_ = 0;
  rev_last_day_ = cur_rev_;
  cur_rev_ = 0;
}

void CostRevenueCollector::update_month()
{
  cst_last_month_ = cst_mtd_;
  cst_mtd_ = 0;
  rev_last_month_ = rev_mtd_;
  rev_mtd_ = 0;
}

void CostRevenueCollector::update_year()
{
  cst_last_year_ = cst_ytd_;
  cst_ytd_ = 0;
  rev_last_year_ = rev_ytd_;
  rev_ytd_ = 0;
}

//----------------------------------------------------------------------------

Neighbourhood::Neighbourhood( int max_radius )
{
  nb_eq_.resize( max_radius );
  for( int ix=-max_radius+1; ix<=max_radius-1; ++ix )
  {
    for( int iy=-max_radius+1; iy<=max_radius-1; ++iy )
    {
      const TileKOO tij( ix, iy );
      const size_t lij = tij.length();
      if( lij < max_radius )
        nb_eq_[lij].push_back(tij);
    }
  }
  for( size_t ir=0; ir<nb_eq_.size(); ++ir )
  {
    for( size_t it=0; it<nb_eq_[ir].size(); ++it )
    {
      nb_le_.push_back( nb_eq_[ir][it] );
    }
    nb_sizes_.push_back( nb_le_.size() );
  }
}

//----------------------------------------------------------------------------

