/* 
Copyright (c) 2005 - 2007 Tobias Scheuer

The zlib/libpng License

This software is provided 'as-is', without any express or implied warranty. 
In no event will the authors be held liable for any damages arising from the 
use of this software.

Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim 
that you wrote the original software. If you use this software in a product, 
an acknowledgment in the product documentation would be appreciated but is 
not required.

2. Altered source versions must be plainly marked as such, and must not be 
misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
*/

#ifndef INC_TILEMGR
#define INC_TILEMGR
#endif

#ifndef INC_TYPES
#include "Types.h"
#endif
#ifndef INC_DISPLAYENGINE
#include "../gfwk/src/DisplayEngine.h"
#endif

#include <string>
#include <vector>

//----------------------------------------------------------------------------

struct Tile
{
  Tile() : bmp_(0) {}
  Tile( BITMAP*const abmp, size_t aclass_idx, size_t atile_idx, bool is_part )
    : bmp_(abmp)
    , class_idx_(aclass_idx), tile_idx_(atile_idx)
    , is_part_(is_part)
  {}
  BITMAP* bmp_;
  size_t class_idx_;
  size_t tile_idx_;
  bool is_part_;
};

struct MultiTile
{
  MultiTile() {}
  MultiTile( size_t aclass_idx, size_t atile_idx, bool ais_h_flip, size_t ax_ext, size_t ay_ext )
    : class_idx_(aclass_idx), tile_idx_(atile_idx)
    , x_ext_(ax_ext), y_ext_(ay_ext)
    , is_h_flipped_(ais_h_flip)
  {
    tiles_.resize( ax_ext * ay_ext );
  }
  size_t index( size_t ix, size_t iy ) const { return ix+x_ext_*iy; }
  void set_tile( size_t ix, size_t iy, const Tile* );
  const Tile* get_tile( size_t ix, size_t iy ) const;
private:
  std::vector<const Tile*> tiles_;
public:
  size_t x_ext_;
  size_t y_ext_;
  size_t class_idx_;
  size_t tile_idx_;
  bool is_h_flipped_;
};

//----------------------------------------------------------------------------

class TileMgr
{
public:
  TileMgr();
  ~TileMgr();
  void init( const char*ini_fn );
  void clear();
  size_t tile_width() const { return tile_w_; }
  size_t tile_height() const { return tile_h_; }
  const Tile& tile_by_tile_idx( size_t i ) const { return *tiles_[i]; }
  const MultiTile& multi_tile_by_idx( size_t i ) const { return mtiles_[i]; }
  int id_of_class( const char* ) const;
  const char* class_of_tile( const Tile&tile ) const;
  size_t num_tiles_of_class_idx( size_t class_idx ) const           { return          tiles_by_class_id_[class_idx].size(); }
  size_t  tile_idx_by_class_idx( size_t class_idx, size_t i ) const { return          tiles_by_class_id_[class_idx][i]; }
  const Tile& tile_by_class_idx( size_t class_idx, size_t i ) const { return *tiles_[ tiles_by_class_id_[class_idx][i] ]; }
private:
  BITMAP* tileset_;
  std::vector<const Tile*> tiles_;
  std::vector<MultiTile> mtiles_;
  std::vector<std::string> class_names_;
  std::vector<std::vector<int> > tiles_by_class_id_;
  int tile_w_;
  int tile_h_;
};

//----------------------------------------------------------------------------

