#include "stdafx.h"

/* 
Copyright (c) 2005 - 2007 Tobias Scheuer

The zlib/libpng License

This software is provided 'as-is', without any express or implied warranty. 
In no event will the authors be held liable for any damages arising from the 
use of this software.

Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim 
   that you wrote the original software. If you use this software in a product, 
   an acknowledgment in the product documentation would be appreciated but is 
   not required.

2. Altered source versions must be plainly marked as such, and must not be 
   misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
*/

#ifndef INC_DISPLAYENGINE
#include "../gfwk/src/DisplayEngine.h"
#endif
#ifndef INC_GAMELOOP
#include "../gfwk/src/GameLoop.h"
#endif
#ifndef INC_SYSTEMDIALOG
#include "../gfwk/src/SystemDialog.h"
#endif
#ifndef INC_GAMECLOCK
#include "../gfwk/src/GameClock.h"
#endif

#ifndef INC_STRINGMGR
#include "StringMgr.h"
#endif
#ifndef INC_VIEWPORT
#include "ViewPort.h"
#endif
#ifndef INC_WORLDMAP
#include "WorldMap.h"
#endif
#ifndef INC_VIEWMAP
#include "ViewMap.h"
#endif
#ifndef INC_TILEMGR
#include "TileMgr.h"
#endif

#include <string>
#include <crtdbg.h>

namespace
{

const char* main_ini_fn = "tnt.ini";

} // namespace

//----------------------------------------------------------------------------

int main(int argc, char* argv[], char* envp[])
{
  // initialize subsystems
  set_uformat( U_ASCII );
  allegro_init();
  install_timer();
  install_keyboard();
  install_mouse();

  GameClock game_time;
  game_time.init( main_ini_fn );

  StringMgr string_mgr;
  string_mgr.init( main_ini_fn );

  DisplayEngine display_engine;
  display_engine.init( main_ini_fn );

  TileMgr tile_mgr;
  tile_mgr.init( main_ini_fn );

  WorldMap world_map( game_time, tile_mgr, string_mgr );
  world_map.init( main_ini_fn );

  SystemDialog sys_dialog( world_map );
  sys_dialog.init( main_ini_fn );

  const int bar_height = text_height(font) + 6;
  const int top_divider = 360;
  const int menu_width = 72;

  WorldTopStatus top_status_bar( ScreenRect( top_divider, 0, SCREEN_W-top_divider, bar_height ), world_map );
  WorldBotStatus bot_status_bar( ScreenRect( 0, SCREEN_H-bar_height, SCREEN_W, bar_height ), world_map );
  MainView main_view( ScreenRect( 0, bar_height, SCREEN_W-menu_width, SCREEN_H-bar_height*2 ), world_map );
  main_view.init( main_ini_fn );
  MainMenu main_menu( ScreenRect( SCREEN_W-menu_width, bar_height, menu_width, SCREEN_H-bar_height*2 ), world_map, main_view );
  world_map.attach_viewports( main_menu, main_view );

  GameLoop game_loop( display_engine, sys_dialog );
  game_loop.config( main_ini_fn );

  GameLoopDebugView game_loop_debug_view( ScreenRect( 0, 0, top_divider, bar_height ), display_engine, game_loop );

  game_loop.add_view_port( game_loop_debug_view );
  game_loop.add_view_port( top_status_bar );
  game_loop.add_view_port( bot_status_bar );
  game_loop.add_view_port( main_view );
  game_loop.add_view_port( main_menu );

  game_loop.add_kbd_handler( game_loop_debug_view );
  game_loop.add_kbd_handler( main_view );
  game_loop.add_kbd_handler( game_time );

  game_loop.add_gcl_handler( game_time );
  game_loop.add_gcl_handler( world_map );

  game_loop.add_scroll_handler( main_view );

  game_loop.loop();

	return 0;
}
END_OF_MAIN();

//----------------------------------------------------------------------------

