#include "StdAfx.h"

/* 
Copyright (c) 2005 - 2007 Tobias Scheuer

The zlib/libpng License

This software is provided 'as-is', without any express or implied warranty. 
In no event will the authors be held liable for any damages arising from the 
use of this software.

Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim 
that you wrote the original software. If you use this software in a product, 
an acknowledgment in the product documentation would be appreciated but is 
not required.

2. Altered source versions must be plainly marked as such, and must not be 
misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
*/

#ifndef INC_WORLDMAP
#include "WorldMap.h"
#endif

//----------------------------------------------------------------------------

Office::Office( const TileKOO&at, int aapp_id, int avalue, bool is_owner )
: center_tile_(at)
, off_id_()
, player_is_owner_(is_owner)
, value_(avalue)
{
}

//----------------------------------------------------------------------------

int WorldMap::build_off_find_cost( const TileKOO&t, int&sub_idx, Outline&office_shape ) const
{
  office_shape.clear();
  if( !is_inside_map(t) )
    return 0;
  const MapTile&mt = map_tiles_[ index(t) ];
  if( !mt.player_can_buy_ && !mt.player_is_owner_ )
    return 0;
  if( mt.is_rail() || mt.is_building_ )
    return 0;
  if( !find_boxes_near( def_values_.boxes_used_for_office_, t ) )
    return 0;
  int cost = 0;
  if( mt.player_can_buy_ && !mt.player_is_owner_ )
    cost += mt.value();
  cost += def_values_.cost_build_office + def_values_.cost_buy_office;
  if( cost <= cash_.player_total_ )
  {
    const int class_idx = class_idxs_[IDXofficePlayer1];
    const int n_alt_tiles = tile_mgr_.num_tiles_of_class_idx(class_idx);
    if( sub_idx < 0 || sub_idx >= n_alt_tiles )
      sub_idx = 0;
    const size_t tile_idx = tile_mgr().tile_idx_by_class_idx( class_idx, sub_idx );
    const Tile*const p_tile = &tile_mgr().tile_by_tile_idx( tile_idx );
    office_shape.push_back( OutlineDesc( t, p_tile ) );
    return cost;
  }
  return 0;
}

bool WorldMap::build_off( const TileKOO&t, int sub_idx )
{
  assertCondition( is_on_map(t) );
  MapTile&mt = map_tiles_[ index(t) ];
  assertCondition( mt.player_can_buy_ || mt.player_is_owner_ );
  assertCondition( !mt.is_rail() );
  assertCondition( !mt.is_building_ );
  if( !find_boxes_near( def_values_.boxes_used_for_office_, t ) )
    return false;
  if( mt.player_can_buy_ && !mt.player_is_owner_ )
  {
    if( !buy_land(t,true) )
      return false;
  }
  assertCondition( mt.player_is_owner_ );
  const int cost = def_values_.cost_build_office + def_values_.cost_buy_office;
  cash_.office_re_.push_cost( cost );
  cash_.total_.push_cost( cost );
  cash_.player_total_ -= cost;

  const int off_id = find_empty_slot( v_offices_ );

  const Office new_off( t, off_id, def_values_.cost_build_office, true );
  if( off_id >= v_offices_.size() )
    v_offices_.push_back( new_off );
  else
    v_offices_[off_id] = new_off;

  unload_boxes_for_construction( def_values_.boxes_used_for_office_, t );
  set_general_tile( t, IDXofficePlayer1, sub_idx, mt.player_can_buy_, mt.player_is_owner_ );
  mt.office_id_ = off_id;
  mt.is_building_ = true;
  mt.can_hold_boxes_ = false;
  mt.n_persons_ = 0;
  mt.n_jobs_ = def_values_.min_jobs_office_;
  return true;
}

//----------------------------------------------------------------------------

int WorldMap::buy_off_find_cost( const TileKOO&t ) const
{
  if( !is_inside_map(t) )
    return 0;
  const MapTile&mt = map_tiles_[ index(t) ];
  if( !mt.can_buy_office() )
    return 0;
  const Office&off = v_offices_[ mt.office_id_ ];
  const int cost = off.value_ + mt.value() + def_values_.cost_buy_office;
  if( cost <= cash_.player_total_ )
    return cost;
  return 0;
}

bool WorldMap::buy_off( const TileKOO&t )
{
  assertCondition( is_on_map(t) );
  MapTile&mt = map_tiles_[ index(t) ];
  assertCondition( mt.can_buy_office() );
  chg_maptile_only_tile( mt, IDXofficePlayer1, SUB_IDX_KEEPORIG );
  Office&off = v_offices_[ mt.office_id_];
  off.player_is_owner_ = true;
  const int cost = off.value_ + def_values_.cost_buy_office;
  cash_.office_re_.push_cost( cost );
  cash_.total_.push_cost( cost );
  cash_.player_total_ -= cost;
  buy_land( t, false );
  return true;
}

//----------------------------------------------------------------------------

int WorldMap::sell_off_find_revenue( const TileKOO&t ) const
{
  if( !is_inside_map(t) )
    return 0;
  const MapTile&mt = map_tiles_[ index(t) ];
  if( !mt.can_sell_office() )
    return 0;
  const Office&off = v_offices_[ mt.office_id_ ];
  const int revenue = off.value_ + mt.value();
  return revenue;
}

bool WorldMap::sell_off( const TileKOO&t )
{
  assertCondition( is_on_map(t) );
  MapTile&mt = map_tiles_[ index(t) ];
  assertCondition( mt.can_sell_office() );
  chg_maptile_only_tile( mt, IDXoffice1, SUB_IDX_KEEPORIG );
  Office&off = v_offices_[ mt.office_id_ ];
  off.player_is_owner_ = false;
  const int revenue = off.value_;
  cash_.office_re_.push_revenue( revenue );
  cash_.total_.push_revenue( revenue );
  cash_.player_total_ += revenue;
  sell_land( t );
  return true;
}

//----------------------------------------------------------------------------

bool WorldMap::delete_off( const TileKOO&t )
{
  assertCondition( is_on_map(t) );
  MapTile&mt = map_tiles_[ index(t) ];
  if( mt.player_is_owner_ )
  {
    assertCondition( mt.can_sell_office() );
  }
  Office&off = v_offices_[ mt.office_id_ ];
  set_general_tile( t, IDXempty, SUB_IDX_RANDOM, mt.player_can_buy_, mt.player_is_owner_ );
  off.clear();
  if( mt.player_is_owner_ )
  {
    const int cost = def_values_.cost_delete_office;
    cash_.office_re_.push_cost( cost );
    cash_.total_.push_cost( cost );
    cash_.player_total_ -= cost;
  }
  return true;
}

//----------------------------------------------------------------------------

void WorldMap::update_offices()
{
  for( size_t iot=0; iot<v_offices_.size(); ++iot )
  {
    Office&off = v_offices_[iot];
    if( !off.is_valid() )
      continue;
    MapTile&mt = map_tiles_[ index(off.center_tile_) ];
    // change number of persons
    if( mt.add_value_ > mt.bas_value_ )
      mt.n_jobs_ += mt.add_value_ / mt.bas_value_;
    if( mt.n_jobs_ < def_values_.max_jobs_office_ / 3 )
      mt.n_jobs_ += 1;
    if( mt.nearest_station_id_ >= 0 )
    {
      const Station&station = v_stations_[mt.nearest_station_id_];
      if( station.n_office_env_ > 0 )
      {
        const int d_jobs = ( station.n_daily_passengers_counter_.average() ) / station.n_office_env_;
        if( d_jobs < 40 )
          mt.n_jobs_ -= ( 50 - d_jobs ) / 5;
        else
          mt.n_jobs_ += MIN( ( 30 + d_jobs ) / 50, ( def_values_.max_jobs_office_ ) /20 );
      }
    }
    // limit number of persons
    if( mt.n_jobs_ < def_values_.min_jobs_office_ )
      mt.n_jobs_ = def_values_.min_jobs_office_;
    else if( mt.n_jobs_ > def_values_.max_jobs_office_ )
      mt.n_jobs_ = def_values_.max_jobs_office_;
  }
}

//----------------------------------------------------------------------------


