#include "StdAfx.h"

/* 
Copyright (c) 2005 - 2007 Tobias Scheuer

The zlib/libpng License

This software is provided 'as-is', without any express or implied warranty. 
In no event will the authors be held liable for any damages arising from the 
use of this software.

Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim 
that you wrote the original software. If you use this software in a product, 
an acknowledgment in the product documentation would be appreciated but is 
not required.

2. Altered source versions must be plainly marked as such, and must not be 
misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
*/

#ifndef INC_VIEWPORT
#include "ViewPort.h"
#endif
#ifndef INC_WORLDMAP
#include "WorldMap.h"
#endif
#ifndef INC_VIEWMAP
#include "ViewMap.h"
#endif
#ifndef INC_GAMECLOCK
#include "../gfwk/src/GameClock.h"
#endif

//----------------------------------------------------------------------------

void WorldTopStatus::display( BITMAP*const db )
{
  rectfill( db, area.x, area.y, area.x+area.w-1, area.y+area.h-1, makecol(200,200,0) );
  rect(     db, area.x, area.y, area.x+area.w-1, area.y+area.h-1, makecol(0,0,255) );
  textprintf_right_ex( db, font, area.x+area.w-3, area.y+3, makecol(64, 64, 128), -1
    , "%6dP  %9d$  %3d%% - %02d:%02d %02d.%02d.%04d"
    , map_.assets_.all_inhabitants_
    , map_.get_player_cash().player_total_
    , map_.game_clock_.get_cur_speed()
    , map_.game_clock_.get_hour_of_day(), map_.game_clock_.get_minute_of_hour()
    , map_.game_clock_.get_day_of_month(), map_.game_clock_.get_month_of_year(), map_.game_clock_.get_years_since0()
    );
}

//----------------------------------------------------------------------------

void WorldBotStatus::display( BITMAP*const db )
{
  rectfill( db, area.x, area.y, area.x+area.w-1, area.y+area.h-1, makecol(200,200,0) );
  rect(     db, area.x, area.y, area.x+area.w-1, area.y+area.h-1, makecol(0,0,255) );
  std::string state_string = map_.bot_state_string_;
  std::string info_string = map_.bot_info_string_;
  textprintf_ex( db, font, area.x+3, area.y+3, makecol(0,0,0), -1, state_string.c_str() );
  textprintf_right_ex( db, font, area.x+area.w-3, area.y+3, makecol(0,0,0), -1, info_string.c_str() );
}

//----------------------------------------------------------------------------

namespace
{

DIALOG main_dlg[] =
{
  /* (proc)        (x)  (y)   (w)  (h)  (fg)  (bg)   (key) (flags)            (d1) (d2) (dp)  (dp2) (dp3) */
  { d_box_proc,     0,   0,    0,   0,    0,  65504,  0, D_HIDDEN,             0,   0,  NULL,    0,    0 },
  { d_button_proc,  8, 300,   48,  24,    0,  18400,  0, D_HIDDEN,          1001,   0, "BUY",    0,    0 },
  { d_button_proc, 72, 300,   48,  24,    0,  18400,  0, D_HIDDEN,          1002,   0, "SEL",    0,    0 },
  { d_button_proc,128, 300,   48,  24,    0,  18400,  0, D_HIDDEN,          1003,   0, "DEL",    0,    0 },
  { d_button_proc,  8, 300,   48,  24,    0,  18400,  0, D_HIDDEN,          1004,   0, "REV",    0,    0 },

  { d_button_proc,  8,   8,   24,  24,    0,  18400,  0,   D_EXIT,           101,   0,   "P",    0,    0 },
  { d_button_proc, 40,   8,   24,  24,    0,  18400,  0,   D_EXIT,           102,   0,   "S",    0,    0 },

  { d_button_proc,  8,  40,   24,  24,    0,  18400,  0,   D_EXIT,       BuyLand,   0,  "BL",    0,    0 },
  { d_button_proc, 40,  40,   24,  24,    0,  18400,  0,   D_EXIT,      SellLand,   0,  "SL",    0,    0 },
  { d_button_proc,  8,  72,   24,  24,    0,  18400,  0,   D_EXIT,      LayTrack,   0,  "LT",    0,    0 },
  { d_button_proc, 40,  72,   24,  24,    0,  18400,  0,   D_EXIT,   DeleteTrack,   0,  "DT",    0,    0 },
  { d_button_proc,  8, 104,   24,  24,    0,  18400,  0,   D_EXIT,  BuildStation,   0,  "BS",    0,    0 },
  { d_button_proc,  8, 136,   24,  24,    0,  18400,  0,   D_EXIT,   PlaceFTrain,   0, "PFT",    0,    0 },
  { d_button_proc, 40, 136,   24,  24,    0,  18400,  0,   D_EXIT,   PlacePTrain,   0, "PPT",    0,    0 },
  { d_button_proc,  8, 200,   24,  24,    0,  18400,  0,   D_EXIT,   BuildApartm,   0, "Apa",    0,    0 },
  { d_button_proc,  8, 232,   24,  24,    0,  18400,  0,   D_EXIT,   BuildOffice,   0, "Off",    0,    0 },
  { NULL,           0,   0,    0,   0,    0,      0,  0,        0,             0,   0, NULL,    0,    0 }
};
const int main_dlg_size = sizeof(main_dlg)/sizeof(main_dlg[0]);

} // namespace

MainMenu::MainMenu( const ScreenRect&asr, WorldMap&amap, MainView&aview )
: ViewPortBase( asr )
, map_(amap)
, view_(aview)
{
  main_dlg[0].w = 72;
  main_dlg[0].h = area.h;
  position_dialog( main_dlg, area.x+area.w-72, area.y );
  set_dialog_color( main_dlg, makecol(0,0,0), makecol(200,200,0) );
  main_dlg[0].bg = makecol(200,200,70);
  dlg_player = init_dialog( main_dlg, 0 );
}

MainMenu::~MainMenu()
{
  shutdown_dialog( dlg_player );
}

void MainMenu::display( BITMAP*const db )
{
  main_dlg[0].w = area.w;
  main_dlg[0].h = area.h;
  for( int i=0; i<main_dlg_size; ++i )
  {
    if( main_dlg[i].d1 > 1000 )
      main_dlg[i].flags = D_HIDDEN;
  }
  position_dialog( main_dlg, area.x, area.y );

  rectfill( db, area.x, area.y, area.x+area.w-1, area.y+area.h-1, makecol(200,200,100) );
  rect(     db, area.x, area.y, area.x+area.w-1, area.y+area.h-1, makecol(0,0,255) );

  int freight_train_id = -1;
  int pers_train_id = -1;
  int station_id = -1;
  int apa_id = -1;
  int off_id = -1;

  map_.change_menu_state( map_.is_anything_selected(), map_.menu_show_minimap_ );

  if( map_.menu_show_details_ )
  {
    int x = area.x+8;
    int y = area.y+area.h-area.w+8;
    const int th = text_height(font)+3;
    const int text_color = makecol(0,0,0);
    if( map_.selected_train_ >= 0 )
    {
      const Train&train = map_.get_trains()[map_.selected_train_];
      assertCondition( train.is_valid() );
      if( train.is_freight_train() )
      {
        freight_train_id = map_.selected_train_;
        main_dlg[3].flags = D_EXIT;
        main_dlg[4].flags = D_EXIT;
        textprintf_ex( db, font, x, y, text_color, -1, "Freight Train %d", freight_train_id );
        y += th;
        textprintf_ex( db, font, x, y, text_color, -1, "%d Boxes", train.n_boxes_ );
        if( train.is_stopped_at_station_ )
        {
          y += th;
          textprintf_ex( db, font, x, y, text_color, -1, "Halt in Station" );
        }
      }
      else
      {
        pers_train_id = map_.selected_train_;
        main_dlg[3].flags = D_EXIT;
        main_dlg[4].flags = D_EXIT;
        textprintf_ex( db, font, x, y, text_color, -1, "Passenger Train %d", pers_train_id);
        y += th;
        textprintf_ex( db, font, x, y, text_color, -1, "%d Passengers", train.n_passengers_ );
        if( train.is_stopped_at_station_ )
        {
          y += th;
          textprintf_ex( db, font, x, y, text_color, -1, "Halt in Station" );
        }
      }
    }
    else if( map_.selected_station_ >= 0 )
    {
      station_id = map_.selected_station_;
      const Station&station = map_.get_stations()[station_id];
      main_dlg[3].flags = D_EXIT;
      textprintf_ex( db, font, x, y, text_color, -1, "Station %d", station_id );
      y += th;
      textprintf_ex( db, font, x, y, text_color, -1, "%d Persons", station.n_persons_env_ );
      y += th;
      textprintf_ex( db, font, x, y, text_color, -1, "%d Jobs", station.n_jobs_env_ );
      y += th;
      textprintf_ex( db, font, x, y, text_color, -1, "%d Apartments", station.n_apartment_env_ );
      y += th;
      textprintf_ex( db, font, x, y, text_color, -1, "%d Offices", station.n_office_env_ );
      y += th;
      textprintf_ex( db, font, x, y, text_color, -1, "%d Avg. Passengers", station.n_daily_passengers_counter_.average() );
      y += th;
      textprintf_ex( db, font, x, y, text_color, -1, "%d Passenger today", station.n_good_passengers_ );
      if( station.n_miss_passengers_ > 0 )
      {
        y += th;
        textprintf_ex( db, font, x, y, makecol(200,0,0), -1, "%d Passengers missed", station.n_miss_passengers_ );
      }
    }
    else if( map_.selected_apartment_ >= 0 )
    {
      apa_id = map_.selected_apartment_;
      const Apartment&app = map_.get_apartments()[apa_id];
      const MapTile&mt = map_.get_map_tile( app.center_tile_ );
      textprintf_ex( db, font, x, y, text_color, -1, "Apartment %d", apa_id );
      y += th;
      textprintf_ex( db, font, x, y, text_color, -1, "Value: %d$", app.value_ );
      y += th;
      textprintf_ex( db, font, x, y, text_color, -1, "%d Persons", mt.n_persons_ );
      y += th;
      textprintf_ex( db, font, x, y, text_color, -1, "%d Jobs", mt.n_jobs_ );
      y += th;
      textprintf_ex( db, font, x, y, text_color, -1, "P/L    Month   Year" );
      y += th;
      textprintf_ex( db, font, x, y, text_color, -1, "This: %5d$ %5d$", app.cost_rev_.rev_mtd_-app.cost_rev_.cst_mtd_, app.cost_rev_.rev_ytd_-app.cost_rev_.cst_ytd_ );
      y += th;
      textprintf_ex( db, font, x, y, text_color, -1, "Last: %5d$ %5d$", app.cost_rev_.rev_last_month_-app.cost_rev_.cst_last_month_, app.cost_rev_.rev_last_year_-app.cost_rev_.cst_last_year_ );
      if( app.player_is_owner_ )
      {
        main_dlg[2].flags = D_EXIT;
        main_dlg[3].flags = D_EXIT;
      }
      else
      {
        const int cost = map_.buy_apa_find_cost( app.center_tile_ );
        if( cost > 0 )
        {
          y += th;
          textprintf_ex( db, font, x, y, text_color, -1, "%d$ to buy", cost );
          main_dlg[1].flags = D_EXIT;
        }
        else
        {
          y += th;
          textprintf_ex( db, font, x, y, text_color, -1, "Too expensive to buy" );
        }
      }
    }
    else if( map_.selected_office_ >= 0 )
    {
      off_id = map_.selected_office_;
      const Office&off = map_.get_offices()[off_id];
      const MapTile&mt = map_.get_map_tile( off.center_tile_ );
      textprintf_ex( db, font, x, y, text_color, -1, "Office %d", off_id );
      y += th;
      textprintf_ex( db, font, x, y, text_color, -1, "Value: %d$", off.value_ );
      y += th;
      textprintf_ex( db, font, x, y, text_color, -1, "%d Jobs", mt.n_jobs_ );
      y += th;
      textprintf_ex( db, font, x, y, text_color, -1, "P/L    Month   Year" );
      y += th;
      textprintf_ex( db, font, x, y, text_color, -1, "This: %5d$ %5d$", off.cost_rev_.rev_mtd_-off.cost_rev_.cst_mtd_, off.cost_rev_.rev_ytd_-off.cost_rev_.cst_ytd_ );
      y += th;
      textprintf_ex( db, font, x, y, text_color, -1, "Last: %5d$ %5d$", off.cost_rev_.rev_last_month_-off.cost_rev_.cst_last_month_, off.cost_rev_.rev_last_year_-off.cost_rev_.cst_last_year_ );
      if( off.player_is_owner_ )
      {
        main_dlg[2].flags = D_EXIT;
        main_dlg[3].flags = D_EXIT;
      }
      else
      {
        const int cost = map_.buy_off_find_cost( off.center_tile_);
        if( cost > 0 )
        {
          y += th;
          textprintf_ex( db, font, x, y, text_color, -1, "%d$ to buy", cost );
          main_dlg[1].flags = D_EXIT;
        }
        else
        {
          y += th;
          textprintf_ex( db, font, x, y, text_color, -1, "Too expensive to buy" );
        }
      }
    }
  }

  ScreenRect map_rect;
  {
    const bool show_large_mm = map_.menu_show_minimap_ && !map_.menu_show_details_;
    //const int pixsz = show_large_mm ? MIN( 4, area.w / MAX( map_.map_width(), map_.map_height() ) ) : 1;
    const int pixsz = show_large_mm ? 2 : 1;
    const int px_map_max = pixsz*map_.map_width();
    const int py_map_max = pixsz*map_.map_height();
    const int pxy_win_max = ( show_large_mm ? map_.def_values_.menu_large_width_ : map_.def_values_.menu_small_width_ );
    const int pw = MIN( px_map_max, pxy_win_max );
    const int ph = MIN( py_map_max, pxy_win_max );
    const int dd1 = ( pxy_win_max - pw ) / 2;
    const int px0 = area.x+area.w-pw-dd1;
    const int py0 = area.y+area.h-ph-dd1;
    map_rect = ScreenRect( px0, py0, pw, ph );
    rect( db, px0, py0, px0+pw-1, py0+ph-1, makecol(0,0,0) );
    const TileKOO view_center = view_.get_visible_center();
    const int ix_max = map_.map_width();
    const int iy_max = map_.map_height();
    int ix0 = view_center.x - pw/(pixsz*2);
    int ix1 = view_center.x + pw/pixsz - pw/(pixsz*2);
    int iy0 = view_center.y - ph/(pixsz*2);
    int iy1 = view_center.y + ph/pixsz - ph/(pixsz*2);
    if( ix0 < 0 )
    {
      ix1 += -ix0;
      ix0 = 0;
    }
    else if( ix1 > ix_max )
    {
      ix0 -= ix1-ix_max;
      ix1 = ix_max;
    }
    assertCondition( ix0 >= 0 );
    assertCondition( ix1 <= ix_max );
    if( iy0 < 0 )
    {
      iy1 += -iy0;
      iy0 = 0;
    }
    else if( iy1 > iy_max )
    {
      iy0 -= iy1-iy_max;
      iy1 = iy_max;
    }
    assertCondition( iy0 >= 0 );
    assertCondition( iy1 <= iy_max );

    for( int ix=ix0; ix<ix1; ++ix )
      for( int iy=iy0; iy<iy1; ++iy )
      {
        const MapTile&mt = map_.get_map_tile( TileKOO(ix,iy) );
        int col
          = mt.train_show_!=NoTrain ? makecol(255,255,255)
          : mt.is_rail() ? makecol(128,128,128)
          : mt.is_building_ ? makecol(255,0,0)
          : mt.n_persons_>0 || mt.n_jobs_>0 ? ( mt.nearest_station_id_>0 ? makecol(150,0,50) : makecol(100,0,25) )
          : ( mt.nearest_station_id_>0 ? makecol(0,100,0) : makecol(0,50,0) )
          ;
        if( ix>0 && ix+1<map_.map_width() )
        {
          const MapTileViewInf&mt_0 = view_.get_map_tile_view( TileKOO(ix,iy) );
          const MapTileViewInf&mt_r = view_.get_map_tile_view( TileKOO(ix-1,iy) );
          const MapTileViewInf&mt_l = view_.get_map_tile_view( TileKOO(ix+1,iy) );
          if( mt_0.is_tile_visible_ && ( !mt_r.is_tile_visible_ || !mt_l.is_tile_visible_ ) )
            col = makecol(255,255,255);
        }
        if( pixsz==1 )
          putpixel( db, px0+ix-ix0, py0+iy-iy0, col );
        else
          rectfill( db, px0+pixsz*(ix-ix0), py0+pixsz*(iy-iy0), px0+pixsz*(ix-ix0+1)-1, py0+pixsz*(iy-iy0+1)-1, col );
      }
  }

  dlg_player->res |= D_REDRAW;
  dlg_player->kbd_on = FALSE;
  dlg_player->joy_on = FALSE;
  gui_set_screen( db );
  update_dialog( dlg_player );
  gui_set_screen(0);

  // detect right mouse click
  static ScreenKOO mouse_pos_drag_start(-1,-1);
  static bool drag_started = false;
  static bool click_started = false;
  const ScreenKOO mouse_pos( mouse_x, mouse_y );

  if( (mouse_b & 2) && !drag_started )
  {
    if( mouse_pos_drag_start.x < 0 )
      mouse_pos_drag_start = mouse_pos;
    if(  ABS(mouse_pos_drag_start.x - mouse_pos.x ) > MOUSE_DRAG_THRESHOLD
      || ABS(mouse_pos_drag_start.y - mouse_pos.y ) > MOUSE_DRAG_THRESHOLD
      )
    {
      drag_started = true;
    }
  }
  if( !(mouse_b & 2) )
  {
    if( !drag_started && mouse_pos_drag_start.x > 0 )
    {
      dlg_player->obj = 0;
      map_.change_menu_state( false, map_.menu_show_minimap_ );
      map_.change_game_state( NormalSimulation );
      map_.reset_selection();
    }
    drag_started = false;
    mouse_pos_drag_start.x = -1;
  }

  // detect left mouse click inside map rect
  if( (mouse_b & 1) && !drag_started )
  {
    if( map_rect.is_inside_rect( mouse_x, mouse_y ) )
    {
      click_started = true;
    }
  }
  if( !(mouse_b & 1) && click_started )
  {
    click_started = false;
    simulate_keypress( KEY_M << 8 );
  }

  // handle dialog buttons
  if( dlg_player->obj > 0 )
  {
    const DIALOG&act_dlg = dlg_player->dialog[ dlg_player->obj ];
    switch( act_dlg.d1 )
    {
    case 101:  // Play - Pause
      simulate_keypress( KEY_P << 8 );
      break;
    case 102:  // System Menu
      simulate_keypress( KEY_F10 << 8 );
      break;
    case 1001: // Buy
      if( apa_id >= 0 )
      {
        const Apartment&app = map_.get_apartments()[ apa_id ];
        map_.buy_apa( app.center_tile_ );
      }
      else if( off_id >= 0 )
      {
        const Office&off = map_.get_offices()[off_id];
        map_.buy_off( off.center_tile_ );
      }
      break;
    case 1002: // Sell
      if( apa_id >= 0 )
      {
        const Apartment&app = map_.get_apartments()[ apa_id ];
        map_.sell_apa( app.center_tile_ );
      }
      else if( off_id >= 0 )
      {
        const Office&off = map_.get_offices()[off_id];
        map_.sell_off( off.center_tile_ );
      }
      break;
    case 1003: // Delete
      if( freight_train_id >= 0 )
      {
        map_.remove_train( freight_train_id );
        map_.reset_selection();
        map_.change_menu_state( false, map_.menu_show_minimap_ );
      }
      else if( pers_train_id >= 0 )
      {
        map_.remove_train( pers_train_id );
        map_.reset_selection();
        map_.change_menu_state( false, map_.menu_show_minimap_ );
      }
      else if( station_id > 0 )
      {
        map_.delete_station( station_id );
        map_.reset_selection();
        map_.change_menu_state( false, map_.menu_show_minimap_ );
      }
      else if( apa_id >= 0 )
      {
        const Apartment&app = map_.get_apartments()[ apa_id ];
        map_.delete_apa( app.center_tile_ );
        map_.reset_selection();
        map_.change_menu_state( false, map_.menu_show_minimap_ );
      }
      else if( off_id >= 0 )
      {
        const Office&off = map_.get_offices()[off_id];
        map_.delete_off( off.center_tile_ );
        map_.reset_selection();
        map_.change_menu_state( false, map_.menu_show_minimap_ );
      }
      break;
    case 1004: // reverse train
      if( freight_train_id >= 0 )
      {
        map_.reverse_train( true, freight_train_id );
      }
      else if( pers_train_id >= 0 )
      {
        map_.reverse_train( false, pers_train_id );
      }
      break;
    default:
      map_.change_game_state( (GameState)(act_dlg.d1) );
      break;
    }
    dlg_player->obj = 0;
  }

}

//----------------------------------------------------------------------------

