/* 
Copyright (c) 2005 - 2007 Tobias Scheuer

The zlib/libpng License

This software is provided 'as-is', without any express or implied warranty. 
In no event will the authors be held liable for any damages arising from the 
use of this software.

Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim 
that you wrote the original software. If you use this software in a product, 
an acknowledgment in the product documentation would be appreciated but is 
not required.

2. Altered source versions must be plainly marked as such, and must not be 
misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
*/

#ifndef INC_TYPES
#define INC_TYPES
#endif

//----------------------------------------------------------------------------

struct TileKOO
{
  TileKOO() : x(-1), y(-1) {}
  TileKOO( int ax, int ay ) : x(ax), y(ay) {}
  bool is_valid() const { return x>=0 && y>=0; }
  void clear() { x=-1; y=-1; }
  double length() const;
  const TileKOO& operator+= ( const TileKOO&rhs ) { x += rhs.x; y += rhs.y; return *this; }
  const TileKOO& operator-= ( const TileKOO&rhs ) { x -= rhs.x; y -= rhs.y; return *this; }
  const TileKOO operator+ ( const TileKOO&rhs ) const
  {
    TileKOO result(*this);
    result+=rhs;
    return result;
  }
  const TileKOO operator- ( const TileKOO&rhs ) const
  {
    TileKOO result(*this);
    result-=rhs;
    return result;
  }
  int x;
  int y;
};

inline bool operator == ( const TileKOO&lhs, const TileKOO&rhs ) { return lhs.x == rhs.x && lhs.y == rhs.y; }
inline bool operator != ( const TileKOO&lhs, const TileKOO&rhs ) { return lhs.x != rhs.x || lhs.y != rhs.y; }

double distance( TileKOO, const TileKOO& );

struct ScreenKOO
{
  ScreenKOO() : x(0), y(0) {}
  ScreenKOO( int ax, int ay ) : x(ax), y(ay) {}
  int x;
  int y;
};

//----------------------------------------------------------------------------

enum MultiTileIDX
{
  MTIDXstation_up_nwso
, MTIDXstation_up_nosw
, MTIDXstation_dn_nosw
, MTIDXstation_dn_nwso
};

//----------------------------------------------------------------------------

