#include "StdAfx.h"

/* 
Copyright (c) 2005 - 2007 Tobias Scheuer

The zlib/libpng License

This software is provided 'as-is', without any express or implied warranty. 
In no event will the authors be held liable for any damages arising from the 
use of this software.

Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim 
that you wrote the original software. If you use this software in a product, 
an acknowledgment in the product documentation would be appreciated but is 
not required.

2. Altered source versions must be plainly marked as such, and must not be 
misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
*/

#ifndef INC_GAMELOOPIFC
#include "../gfwk/src/GameLoopIfc.h"
#endif

#ifndef INC_STRINGMGR
#include "StringMgr.h"
#endif

//----------------------------------------------------------------------------

StringMgr::StringMgr(void)
{
}

StringMgr::~StringMgr(void)
{
}

//----------------------------------------------------------------------------

void StringMgr::read_string( const char*name, const char*str )
{
  strings[name] = get_config_string( "strings", name, str );
}

//----------------------------------------------------------------------------

void StringMgr::init( const char*ini_fn )
{
  assertCondition( ini_fn );

  push_config_state();
  set_config_file(ini_fn);

  std::string lang_fn = get_config_string( "system", "language", "en.ini" );

  pop_config_state();

  push_config_state();
  set_config_file( lang_fn.c_str() );

  read_string( "new_game_seed",      "Seed" );
  read_string( "new_game_width",     "Width" );
  read_string( "new_game_height",    "Height" );
  read_string( "new_game_ok",        "OK" );
  read_string( "new_game_cancel",    "Cancel" );
  read_string( "load_game",          "Load Game" );
  read_string( "save_game",          "Save Game" );
  read_string( "main_buy_land",      "Buy Land" );
  read_string( "main_sell_land",     "Sell Land" );
  read_string( "main_lay_tracks",    "Lay Tracks" );
  read_string( "main_delete_tracks", "Delete Tracks" );
  read_string( "main_build_station", "Build Station" );
  read_string( "main_place_f_train", "Place Freight Train" );
  read_string( "main_place_p_train", "Place Passenger Train" );
  read_string( "main_build_apa",     "Build Apartment" );
  read_string( "main_build_off",     "Build Office" );

  pop_config_state();
}

//----------------------------------------------------------------------------

const char* StringMgr::get_string( const char* sel ) const
{
  static const char empty_str[] = "";

  const stringmap::const_iterator it = strings.find(sel);
  if( it != strings.end() )
    return it->second.c_str();
  return empty_str;
}

//----------------------------------------------------------------------------
