#include "StdAfx.h"

/* 
Copyright (c) 2005 - 2007 Tobias Scheuer

The zlib/libpng License

This software is provided 'as-is', without any express or implied warranty. 
In no event will the authors be held liable for any damages arising from the 
use of this software.

Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim 
that you wrote the original software. If you use this software in a product, 
an acknowledgment in the product documentation would be appreciated but is 
not required.

2. Altered source versions must be plainly marked as such, and must not be 
misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
*/

#ifndef INC_WORLDMAP
#include "WorldMap.h"
#endif

#ifndef INC_MTRAND
#include "../gfwk/src/mtrand.h"
#endif

//----------------------------------------------------------------------------

namespace
{

//----------------------------------------------------------------------------

struct TileClassMapEntry
{
  TileClassIDX tcl_idx_;
  const char* tcl_name_;
};

const TileClassMapEntry tile_class_map[] = 
{
  { IDXrail_nnss,  "rail-nn-ss" }
  , { IDXrail_wwoo,  "rail-ww-oo" }
  , { IDXrail_nwso,  "rail-nw-so" }
  , { IDXrail_nosw,  "rail-no-sw" }

  , { IDXrail_wwso,  "rail-ww-so" }
  , { IDXrail_swoo,  "rail-sw-oo" }
  , { IDXrail_noww,  "rail-no-ww" }
  , { IDXrail_oonw,  "rail-oo-nw" }
  , { IDXrail_sonn,  "rail-so-nn" }
  , { IDXrail_nnsw,  "rail-nn-sw" }
  , { IDXrail_ssno,  "rail-ss-no" }
  , { IDXrail_nwss,  "rail-nw-ss" }

  , { IDXlok_nnss,  "lok-nn-ss" }
  , { IDXlok_wwoo,  "lok-ww-oo" }
  , { IDXlok_nwso,  "lok-nw-so" }
  , { IDXlok_nosw,  "lok-no-sw" }

  , { IDXpwag_nnss,  "pwag-nn-ss" }
  , { IDXpwag_wwoo,  "pwag-ww-oo" }
  , { IDXpwag_nwso,  "pwag-nw-so" }
  , { IDXpwag_nosw,  "pwag-no-sw" }

  , { IDXfwag0_nnss,  "fwag0-nn-ss" }
  , { IDXfwag0_wwoo,  "fwag0-ww-oo" }
  , { IDXfwag0_nwso,  "fwag0-nw-so" }
  , { IDXfwag0_nosw,  "fwag0-no-sw" }
  , { IDXfwag1_nnss,  "fwag1-nn-ss" }
  , { IDXfwag1_wwoo,  "fwag1-ww-oo" }
  , { IDXfwag1_nwso,  "fwag1-nw-so" }
  , { IDXfwag1_nosw,  "fwag1-no-sw" }
  , { IDXfwag2_nnss,  "fwag2-nn-ss" }
  , { IDXfwag2_wwoo,  "fwag2-ww-oo" }
  , { IDXfwag2_nwso,  "fwag2-nw-so" }
  , { IDXfwag2_nosw,  "fwag2-no-sw" }

  , { IDXempty, "empty" }
  , { IDXgras,  "gras" }
  , { IDXsmall_house, "small_house" }
  , { IDXlarge_house, "large_house" }
  , { IDXwater, "water" }
  , { IDXdark,  "dark" }

  , { IDXboxes1, "boxes-1" }
  , { IDXboxes2, "boxes-2" }
  , { IDXboxes3, "boxes-3" }
  , { IDXboxes4, "boxes-4" }
  , { IDXboxes5, "boxes-5" }
  , { IDXboxes6, "boxes-6" }
  , { IDXboxes7, "boxes-7" }
  , { IDXboxes8, "boxes-8" }

  , { IDXapartment1, "apartment-1" }
  , { IDXapartmentPlayer1, "apartment-player-1" }
  , { IDXoffice1, "office-1" }
  , { IDXofficePlayer1, "office-player-1" }
};
const int tile_class_map_size = sizeof(tile_class_map)/sizeof(tile_class_map[0]);

//struct MultiTileClassMapEntry
//{
//  MultiTileIDX tcl_idx_;
//  const char* tcl_name_;
//};
//
//const MultiTileClassMapEntry multi_tile_class_map[] = 
//{
//  { MTIDXstation_up_nwso, "station-up-nwso" }
//, { MTIDXstation_up_nosw, "station-up-nosw" }
//, { MTIDXstation_dn_nosw, "station-dn-nosw" }
//, { MTIDXstation_dn_nwso, "station-dn-nwso" }
//};
//const int multi_tile_class_map_size = sizeof(multi_tile_class_map)/sizeof(multi_tile_class_map[0]);

//----------------------------------------------------------------------------

const TileClassIDX tile_class_overlay [][TrainShow_size] = 
{
  { IDXrail_nnss, IDXlok_nnss, IDXpwag_nnss, IDXlok_nnss, IDXfwag0_nnss, IDXfwag1_nnss, IDXfwag2_nnss }
, { IDXrail_wwoo, IDXlok_wwoo, IDXpwag_wwoo, IDXlok_wwoo, IDXfwag0_wwoo, IDXfwag1_wwoo, IDXfwag2_wwoo }
, { IDXrail_nwso, IDXlok_nwso, IDXpwag_nwso, IDXlok_nwso, IDXfwag0_nwso, IDXfwag1_nwso, IDXfwag2_nwso }
, { IDXrail_nosw, IDXlok_nosw, IDXpwag_nosw, IDXlok_nosw, IDXfwag0_nosw, IDXfwag1_nosw, IDXfwag2_nosw }

, { IDXrail_wwso, IDXlok_nwso, IDXpwag_nwso, IDXlok_nwso, IDXfwag0_nwso, IDXfwag1_nwso, IDXfwag2_nwso }
, { IDXrail_swoo, IDXlok_nosw, IDXpwag_nosw, IDXlok_nosw, IDXfwag0_nosw, IDXfwag1_nosw, IDXfwag2_nosw }
, { IDXrail_noww, IDXlok_nosw, IDXpwag_nosw, IDXlok_nosw, IDXfwag0_nosw, IDXfwag1_nosw, IDXfwag2_nosw }
, { IDXrail_oonw, IDXlok_nwso, IDXpwag_nwso, IDXlok_nwso, IDXfwag0_nwso, IDXfwag1_nwso, IDXfwag2_nwso }
, { IDXrail_sonn, IDXlok_nwso, IDXpwag_nwso, IDXlok_nwso, IDXfwag0_nwso, IDXfwag1_nwso, IDXfwag2_nwso }
, { IDXrail_nnsw, IDXlok_nosw, IDXpwag_nosw, IDXlok_nosw, IDXfwag0_nosw, IDXfwag1_nosw, IDXfwag2_nosw }
, { IDXrail_ssno, IDXlok_nosw, IDXpwag_nosw, IDXlok_nosw, IDXfwag0_nosw, IDXfwag1_nosw, IDXfwag2_nosw }
, { IDXrail_nwss, IDXlok_nwso, IDXpwag_nwso, IDXlok_nwso, IDXfwag0_nwso, IDXfwag1_nwso, IDXfwag2_nwso }
};
const int tile_class_overlay_size = sizeof(tile_class_overlay)/sizeof(tile_class_overlay[0]);

//----------------------------------------------------------------------------

} // namespace











//----------------------------------------------------------------------------

WorldMap::WorldMap( GameClock&agc, const TileMgr&atm, const StringMgr&astrm )
: game_clock_(agc)
, neighbourhood_(15)
, tile_mgr_(atm)
, stop_if_build_(0)
, str_mgr_(astrm)
, map_x_ext_(0), map_y_ext_(0)
, ext_entry_()
, ext_train_(
    def_values_.p_speed_tenth_tiles_per_hour, def_values_.p_station_time_tenth_of_hour
  , def_values_.f_speed_tenth_tiles_per_hour, def_values_.f_station_time_tenth_of_hour
  )
, game_state_(NormalSimulation)
, selected_train_(-1)
, selected_station_(-1)
, selected_apartment_(-1)
, selected_office_(-1)
, menu_show_details_(false)
, menu_show_minimap_(false)
, cash_( def_values_.initial_total_cash_ )
, assets_()
, current_day_since0_(-1)
, current_month_(0)
, current_year_since0_(0)
, last_value_update_time_(0)
, last_build_decision_time_(0)
, last_update_buildings_time_(0)
, p_main_menu_(0)
, p_main_view_(0)
{
  class_idxs_.resize( tile_class_map_size );
  tile_idxs_.resize( tile_class_map_size );
  for( int it=0; it<tile_class_map_size; ++it )
  {
    assertCondition( it==tile_class_map[it].tcl_idx_ );
    class_idxs_[it] = tile_mgr_.id_of_class( tile_class_map[it].tcl_name_ );
    assertCondition( class_idxs_[it] >= 0 );
    tile_idxs_[it] = tile_mgr_.tile_idx_by_class_idx( class_idxs_[it], 0 );
  }
}

WorldMap::~WorldMap()
{
  map_tiles_.clear();
}

//----------------------------------------------------------------------------

void WorldMap::reset_selection()
{
  selected_train_ = -1;
  selected_station_ = -1;
  selected_apartment_ = -1;
  selected_office_ = -1;
}

bool WorldMap::is_anything_selected() const
{
  return selected_train_ >= 0 || selected_station_ >= 0 || selected_apartment_ >= 0 || selected_office_ >= 0;
}

//----------------------------------------------------------------------------

const Tile& WorldMap::get_tile( TileClassIDX tcl_idx ) const
{
  return tile_mgr_.tile_by_tile_idx( tile_idxs_[tcl_idx] );
}

const Tile& WorldMap::get_train_overlay( TileClassIDX tcl_idx, TrainShow train_show ) const
{
  assertCondition( tcl_idx >= 0 && tcl_idx <=IDXraillast );
  const TileClassIDX ret_tcl_idx = tile_class_overlay[tcl_idx][train_show];
  return get_tile( ret_tcl_idx );
}

const MapTile& WorldMap::get_map_tile( const TileKOO&t ) const
{
  return map_tiles_[ index(t) ];
}

//----------------------------------------------------------------------------

void WorldMap::chg_maptile_only_tile( MapTile&mt, TileClassIDX tcl_idx, int sub_idx )
{
  const int class_idx = class_idxs_[tcl_idx];
  const int n_alt_tiles = tile_mgr_.num_tiles_of_class_idx(class_idx);
  assertCondition( n_alt_tiles > 0 );
  if( n_alt_tiles==1 )
  {
    const int tile_idx = tile_idxs_[tcl_idx];
    const Tile&tile = tile_mgr_.tile_by_tile_idx( tile_idx );
    mt.assign_tile( &tile, tcl_idx );
  }
  else
  {
    int alt_idx = sub_idx;
    if( mt.tile_ && sub_idx==SUB_IDX_KEEPORIG )
    {
      const int old_tile_idx = mt.tile_->tile_idx_;
      const int old_class_idx = mt.tile_->class_idx_;
      for( int i=0; i<n_alt_tiles; ++i )
        if( tile_mgr_.tile_idx_by_class_idx( old_class_idx, i ) == old_tile_idx )
        {
          alt_idx = i;
          break;
        }
    }
    const int tile_idx = tile_mgr_.tile_idx_by_class_idx( class_idx, alt_idx>=0 ? alt_idx : rng.IRand(n_alt_tiles) );
    const Tile&tile = tile_mgr_.tile_by_tile_idx( tile_idx );
    mt.assign_tile( &tile, tcl_idx );
  }
}

//----------------------------------------------------------------------------

MapTile& WorldMap::set_general_tile( const TileKOO&t, TileClassIDX tcl_idx, int sub_idx, bool player_can_buy, bool player_is_owner )
{
  MapTile&mt = map_tiles_[ index(t) ];
  chg_maptile_only_tile( mt, tcl_idx, sub_idx );

  mt.can_hold_boxes_ = false;
  mt.player_can_buy_ = player_can_buy;
  mt.player_is_owner_ = player_is_owner;
  mt.bas_value_ = def_values_.bas_value_empty;
  mt.n_boxes_ = 0;
  mt.n_persons_ = 0;
  mt.n_jobs_ = 0;
  mt.train_show_ = NoTrain;
  mt.is_building_ = false;
  mt.apartment_id_ = -1;
  mt.office_id_ = -1;
  switch(tcl_idx)
  {
  case IDXgras:
    mt.bas_value_ = def_values_.bas_value_gras;
    break;
  case IDXsmall_house:
    mt.bas_value_ = def_values_.bas_value_small_house;
    mt.n_persons_ = def_values_.n_persons_small_house;
    break;
  case IDXlarge_house:
    mt.bas_value_ = def_values_.bas_value_large_house;
    mt.n_persons_ = def_values_.n_persons_large_house;
    break;
  case IDXwater:
    mt.bas_value_ = def_values_.bas_value_water;
    break;
  default:
    mt.bas_value_ = def_values_.bas_value_empty;
    break;
  }
  return mt;
}

//----------------------------------------------------------------------------

bool WorldMap::build_small_house( const TileKOO&t )
{
  assertCondition( is_on_map(t) );
  const MapTile&mt = map_tiles_[ index(t) ];
  if(  mt.player_is_owner_ 
    || mt.is_rail()
    || mt.is_building_
    || mt.n_boxes_ > 0
    )
    return false;
  if( !find_boxes_near( def_values_.boxes_used_for_small_house, t ) )
    return false;
  unload_boxes_for_construction( def_values_.boxes_used_for_small_house, t );
  set_general_tile( t, IDXsmall_house, SUB_IDX_RANDOM, mt.player_can_buy_, mt.player_is_owner_ );

  return true;
}

bool WorldMap::build_large_house( const TileKOO&t )
{
  assertCondition( is_on_map(t) );
  const MapTile&mt = map_tiles_[ index(t) ];
  if(  mt.player_is_owner_ 
    || mt.is_rail()
    || mt.is_building_
    || mt.n_boxes_ > 0
    )
    return false;
  if( !find_boxes_near( def_values_.boxes_used_for_large_house, t ) )
    return false;
  unload_boxes_for_construction( def_values_.boxes_used_for_large_house, t );
  set_general_tile( t, IDXlarge_house, SUB_IDX_RANDOM, mt.player_can_buy_, mt.player_is_owner_ );

  return true;
}

//----------------------------------------------------------------------------
