#include "StdAfx.h"

/* 
Copyright (c) 2005 - 2007 Tobias Scheuer

The zlib/libpng License

This software is provided 'as-is', without any express or implied warranty. 
In no event will the authors be held liable for any damages arising from the 
use of this software.

Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim 
that you wrote the original software. If you use this software in a product, 
an acknowledgment in the product documentation would be appreciated but is 
not required.

2. Altered source versions must be plainly marked as such, and must not be 
misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
*/

#ifndef INC_WORLDMAP
#include "WorldMap.h"
#endif

//----------------------------------------------------------------------------

int WorldMap::buy_land_find_costs( const TileKOO&t ) const
{
  if( !is_inside_map(t) )
    return 0;
  const MapTile&mt = map_tiles_[ index(t) ];
  if( mt.player_can_buy_ && !mt.player_is_owner_ && mt.value() <= cash_.player_total_ )
    return mt.value();
  return 0;
}

int WorldMap::sell_land_find_revenue( const TileKOO&t ) const
{
  if( !is_inside_map(t) )
    return 0;
  const MapTile&mt = map_tiles_[ index(t) ];
  if( mt.player_is_owner_ )
    return mt.value();
  return 0;
}

bool WorldMap::buy_land( const TileKOO&t, bool make_box_tile )
{
  assertCondition( is_on_map(t) );
  MapTile&mt = map_tiles_[ index(t) ];
  assertCondition( mt.player_can_buy_ );
  assertCondition( !mt.player_is_owner_ );
  const int cost = mt.value();
  cash_.land_.push_cost( cost );
  cash_.total_.push_cost( cost );
  cash_.player_total_ -= cost;
  mt.player_can_buy_ = false;
  mt.player_is_owner_ = true;
  if( make_box_tile && !mt.can_hold_boxes_ )
  {
    set_box_tile( t, true, 0 );
  }
  return true;
}

bool WorldMap::sell_land( const TileKOO&t )
{
  assertCondition( is_on_map(t) );
  MapTile&mt = map_tiles_[ index(t) ];
  assertCondition( !mt.player_can_buy_ );
  assertCondition( mt.player_is_owner_ );
  const int revenue = mt.value();
  cash_.land_.push_revenue( revenue );
  cash_.total_.push_revenue( revenue );
  cash_.player_total_ += revenue;
  mt.player_can_buy_ = true;
  mt.player_is_owner_ = false;
  return true;
}

//----------------------------------------------------------------------------

