/* 
Copyright (c) 2005 - 2007 Tobias Scheuer

The zlib/libpng License

This software is provided 'as-is', without any express or implied warranty. 
In no event will the authors be held liable for any damages arising from the 
use of this software.

Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim 
that you wrote the original software. If you use this software in a product, 
an acknowledgment in the product documentation would be appreciated but is 
not required.

2. Altered source versions must be plainly marked as such, and must not be 
misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
*/

#ifndef INC_VIEWMAP
#define INC_VIEWMAP
#endif

#ifndef INC_TYPES
#include "Types.h"
#endif
#ifndef INC_DISPLAYENGINE
#include "../gfwk/src/DisplayEngine.h"
#endif

#include <vector>

class WorldMap;
struct Tile;

//----------------------------------------------------------------------------

struct MapTileViewInf
{
  bool is_tile_visible_;
};

//----------------------------------------------------------------------------

class MainView : public ViewPortBase, public KbdHndlIfc, public ScrollingIfc
{
public:
  MainView( const ScreenRect&asr, WorldMap&amap );
  void init( const char*ini_fn );
  virtual void display( BITMAP*const );
  virtual void notify_chg_size();
  virtual void handle_kbd( int scan_code, int shift_flags );
  virtual bool handle_scroll();

  TileKOO get_visible_center() const;
  const MapTileViewInf& get_map_tile_view( const TileKOO&t ) const;
private:
  ScreenKOO convert_tile2screen( const TileKOO&t ) const;
  void draw_one_tile( BITMAP*const db, ScreenKOO s, const Tile&tile ) const;
  void draw_one_tile_lit( BITMAP*const db, ScreenKOO s, const Tile&tile, int r, int g, int b, int a ) const;
  void draw_one_tile_trans( BITMAP*const db, ScreenKOO s, const Tile&tile, int r, int g, int b, int a ) const;
  void draw_tile_outline( BITMAP*const db, const TileKOO&t, bool border, int color ) const;

  void handle_mouse_clicked( BITMAP*const db, const TileKOO&mouse_hover, bool mouse_click_complete );
  void show_details_at_mouse( BITMAP*const db, const TileKOO&mouse_hover, int count_all_drawn_tiles ) const;
  void show_report_1( BITMAP*const db ) const;
  void show_report_2( BITMAP*const db ) const;
  void show_report_3( BITMAP*const db ) const;

  void show_p_train_list( BITMAP*const db ) const;

  WorldMap&map;
  ScreenKOO offset;
  int frst_x_;
  int frst_y_;
  int last_x_;
  int last_y_;
  std::vector<MapTileViewInf> map_tiles_view_inf_;
  double cursor_move_step_width;
  double mouse_scroll_sensitivity;
  // handling mouse clicks on map
  TileKOO start_tile_selected;
  TileKOO tile_clicked;
  bool mouse_clicked;
  // which station to build
  MultiTileIDX station_idx;
  // which sub-type of a building to choose
  int sub_idx;
  // which direction for the train
  bool train_reversed;
  // debug info
  int report_to_show;
  // debug info
  bool do_show_debug_details;
};

//----------------------------------------------------------------------------

