/* 
Copyright (c) 2005 - 2007 Tobias Scheuer

The zlib/libpng License

This software is provided 'as-is', without any express or implied warranty. 
In no event will the authors be held liable for any damages arising from the 
use of this software.

Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim 
that you wrote the original software. If you use this software in a product, 
an acknowledgment in the product documentation would be appreciated but is 
not required.

2. Altered source versions must be plainly marked as such, and must not be 
misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
*/

#ifndef INC_SYSTEMDIALOG
#include "SystemDialog.h"
#endif

#include <allegro.h>

#include <string>

//----------------------------------------------------------------------------

namespace
{

DIALOG sys_dlg[] =
{
  /* (proc)        (x)  (y)  (w)  (h)  (fg) (bg)   (key) (flags) (d1) (d2) (dp)                    (dp2) (dp3) */
  { d_box_proc,    32,  32,  224, 312, 0,   65504, 0,    0,      0,   0,   NULL,                   NULL, NULL },
  { d_button_proc, 48,  48,  192, 40,  0,   18400, 0,    D_EXIT, 0,   0,   (void*)"continue game", NULL, NULL },
  { d_button_proc, 48,  96,  192, 40,  0,   18400, 0,    D_EXIT, 0,   0,   (void*)"new game",      NULL, NULL },
  { d_button_proc, 48,  144, 192, 40,  0,   18400, 0,    D_EXIT, 0,   0,   (void*)"save game",     NULL, NULL },
  { d_button_proc, 48,  192, 192, 40,  0,   18400, 0,    D_EXIT, 0,   0,   (void*)"load game",     NULL, NULL },
  { d_button_proc, 48,  240, 192, 40,  0,   18400, 0,    D_EXIT, 0,   0,   (void*)"options",       NULL, NULL },
  { d_button_proc, 48,  288, 192, 40,  0,   1535,  0,    D_EXIT, 0,   0,   (void*)"exit",          NULL, NULL },
  { d_yield_proc,  32,  32,  0,   0,   0,   0,     0,    0,      0,   0,   NULL,                   NULL, NULL },
  { NULL,          0,   0,   0,   0,   0,   0,     0,    0,      0,   0,   NULL,                   NULL, NULL }
};
const int sys_dlg_size = sizeof(sys_dlg)/sizeof(sys_dlg[0]);

enum StringSelect
{
  Menu_Continue_Game = 1
, Menu_New_Game = 2
, Menu_Save_Game = 3
, Menu_Load_Game = 4
, Menu_Options = 5
, Menu_Quit_Game = 6
};

std::string button_names[sys_dlg_size-2];

} // namespace

//----------------------------------------------------------------------------

SystemDialog::SystemDialog( SysMenuIfc&sys_menu )
: sys_menu_(sys_menu)
{
  centre_dialog( sys_dlg );
}

void SystemDialog::init( const char*ini_fn )
{
  assertCondition( ini_fn );

  push_config_state();
  set_config_file(ini_fn);

  std::string lang_fn = get_config_string( "system", "language", "en.ini" );

  pop_config_state();

  push_config_state();
  set_config_file( lang_fn.c_str() );

  button_names[Menu_Continue_Game] = get_config_string( "strings", "menu_continue_game", "Continue" );
  button_names[Menu_New_Game] = get_config_string( "strings", "menu_new_game", "New Game" );
  button_names[Menu_Save_Game] = get_config_string( "strings", "menu_save_game", "Save Game" );
  button_names[Menu_Load_Game] = get_config_string( "strings", "menu_load_game", "Load Game" );
  button_names[Menu_Options] = get_config_string( "strings", "menu_settings", "Options" );
  button_names[Menu_Quit_Game] = get_config_string( "strings", "menu_quit_game", "Quit" );

  for( int id=1; id<=6; ++id )
  {
    if( button_names[id].length() > 0 )
    {
      sys_dlg[id].dp = (void*)button_names[id].c_str();
    }
  }

  pop_config_state();
}

void SystemDialog::quit()
{
  if( sys_menu_ .can_continue() )
    sys_menu_.save_autosave();
  exit(0);
}

//----------------------------------------------------------------------------

void SystemDialog::initial_dialog()
{
  while( !sys_menu_.can_continue() )
  {
    set_trans_blender( 0, 0, 0, 255 );
    DIALOG*const pdlg_cont = &sys_dlg[Menu_Continue_Game];
    const bool exists_as = sys_menu_.exists_autosave();
    if( !exists_as )
      pdlg_cont->flags = pdlg_cont->flags | D_DISABLED;
    DIALOG*const pdlg_save = &sys_dlg[Menu_Save_Game];
    pdlg_save->flags = pdlg_save->flags | D_DISABLED;
    const int rc = do_dialog( sys_dlg, exists_as ? 1 : 2 );
    if( rc<0 )
      exit(0);
    dispatch_selection( rc );
    pdlg_cont->flags = pdlg_cont->flags & ~D_DISABLED;
    pdlg_save->flags = pdlg_save->flags & ~D_DISABLED;
  }
}

void SystemDialog::ingame_dialog()
{
  set_trans_blender( 0, 0, 0, 255 );
  const int rc = do_dialog( sys_dlg, 1 );
  dispatch_selection( rc );
}

//----------------------------------------------------------------------------

void SystemDialog::dispatch_selection( int selected )
{
  switch(selected)
  {
  case 1: // continue game
    if( !sys_menu_.can_continue() )
    {
      sys_menu_.load_autosave();
    }
    break;
  case 2: // new game
    sys_menu_.new_game();
    break;
  case 3: // save game
    sys_menu_.save_game();
    break;
  case 4: // load game
    sys_menu_.load_game();
    break;
  case 5: // options
    break;
  case 6: // quit
    quit();
    break;
  case -1:// esc
  default:
    break;
  }
}

//----------------------------------------------------------------------------

