/* 
Copyright (c) 2005 - 2007 Tobias Scheuer

The zlib/libpng License

This software is provided 'as-is', without any express or implied warranty. 
In no event will the authors be held liable for any damages arising from the 
use of this software.

Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim 
that you wrote the original software. If you use this software in a product, 
an acknowledgment in the product documentation would be appreciated but is 
not required.

2. Altered source versions must be plainly marked as such, and must not be 
misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
*/

#ifndef INC_GAMELOOP
#define INC_GAMELOOP
#endif

#ifndef INC_GAMELOOPIFC
#include "GameLoopIfc.h"
#endif
#ifndef INC_DISPLAYENGINE
#include "DisplayEngine.h"
#endif

#include <vector>

class SystemDialog;

//----------------------------------------------------------------------------

class GameLoop
{
public:
  GameLoop( DisplayEngine&, SystemDialog& );
  ~GameLoop() {}
  void config( const char*ini_fn );
  void add_view_port( ViewPortIfc& );
  void add_kbd_handler( KbdHndlIfc& );
  void add_gcl_handler( GameClockIfc& );
  void add_scroll_handler( ScrollingIfc& );
  void loop();
private:
  friend class GameLoopDebugView;
  int cur_skip;
  int max_skip;
  int rest_dur_ms;
  int normal_fps;
  DisplayEngine&display_engine;
  SystemDialog&sys_dialog;
  std::vector<GameClockIfc*> v_game_clock_hndls;
  std::vector<ViewPortIfc*> v_viewports;
  std::vector<KbdHndlIfc*> v_kbd_hndls;
  std::vector<ScrollingIfc*> v_scroll_hndls;
};

//----------------------------------------------------------------------------

class GameLoopDebugView : public ViewPortBase, public KbdHndlIfc
{
public:
  GameLoopDebugView( const ScreenRect&asr, const DisplayEngine&ade, const GameLoop&agl );
  virtual void display( BITMAP*const );
  virtual void handle_kbd( int scan_code, int shift_flags );
private:
  const DisplayEngine&display_engine;
  const GameLoop&game_loop;
  int what_to_show_;
};

//----------------------------------------------------------------------------

