/*
#ifndef INC_MTRAND
#include "mtrand.h"
#endif

mtrand.h - Uses the Mersenne Twister RNG to generate random numbers.

Mersenne Twister RNG made by Makoto Matsumoto and Takuji Nishimura,

More information about MT can be found at:
http://www.math.sci.hiroshima-u.ac.jp/~m-mat/MT/emt.html

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

3. The names of its contributors may not be used to endorse or promote 
products derived from this software without specific prior written 
permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS   
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR   
A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef INC_MTRAND
#define INC_MTRAND

class MTRand
{
  // Period parameters 
  static const int N = 624;
  static const int M = 397;

  unsigned long mt[N];            // The array for the state vector
  int mti;                        // mti == N + 1 means mt[N] is not initialized

public:
  MTRand();                       // Default CTOR
  MTRand(unsigned long seed);     // CTOR which takes a seed
  void Seed(unsigned long seed);  // Initializes mt[N] with a seed
  unsigned long Rand();           // Generates a random number on [0,0xffffffff]-interval
  int IRand(int max, int min);    // Generates a random number on [min, max[-interval
  int IRand(int max);             // Generates a random number on [0, max[-interval
  double DRand();                 // generates a random number in [0,1[
  double DRand(double max);       // generates a random number in [0,max[
};

extern MTRand rng;

#endif // INC_MTRAND

