/*
#ifndef INC_GAMELOOPIFC
#include "GameLoopIfc.h"
#endif
*/

/* 
Copyright (c) 2005 - 2007 Tobias Scheuer

The zlib/libpng License

This software is provided 'as-is', without any express or implied warranty. 
In no event will the authors be held liable for any damages arising from the 
use of this software.

Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim 
that you wrote the original software. If you use this software in a product, 
an acknowledgment in the product documentation would be appreciated but is 
not required.

2. Altered source versions must be plainly marked as such, and must not be 
misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
*/
#ifndef INC_GAMELOOPIFC
#define INC_GAMELOOPIFC
#endif

struct BITMAP;

//----------------------------------------------------------------------------

void fatalError( const char*msg );
void fatalError( const char*msg, const char*fname, int line_no );

#define assertCondition( a ) { if(!(a)) { fatalError( #a, __FILE__, __LINE__ ); } }

//----------------------------------------------------------------------------

class KbdHndlIfc
{
public:
  virtual void handle_kbd( int scan_code, int shift_flags ) = 0;
};

//----------------------------------------------------------------------------

class ScrollingIfc
{
public:
  virtual bool handle_scroll() = 0;
};

//----------------------------------------------------------------------------

class ViewPortIfc
{
public:
  virtual void display( BITMAP*const ) = 0;
};

//----------------------------------------------------------------------------

class GameClockIfc
{
public:
  virtual void advance_game_time() = 0;
};

//----------------------------------------------------------------------------

class SysMenuIfc
{
public:
  virtual void new_game() = 0;
  virtual void save_game() = 0;
  virtual void load_game() = 0;
  virtual bool can_continue() const = 0;
  virtual void save_autosave() = 0;
  virtual void load_autosave() = 0;
  virtual bool exists_autosave() = 0;
};

//----------------------------------------------------------------------------

