/* 
Copyright (c) 2005 - 2007 Tobias Scheuer

The zlib/libpng License

This software is provided 'as-is', without any express or implied warranty. 
In no event will the authors be held liable for any damages arising from the 
use of this software.

Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim 
that you wrote the original software. If you use this software in a product, 
an acknowledgment in the product documentation would be appreciated but is 
not required.

2. Altered source versions must be plainly marked as such, and must not be 
misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
*/

#ifndef INC_GAMECLOCK
#define INC_GAMECLOCK
#endif

#ifndef INC_GAMELOOPIFC
#include "GameLoopIfc.h"
#endif

//----------------------------------------------------------------------------

class GameClock : public GameClockIfc, public KbdHndlIfc
{
public:
  enum { ticks_per_game_hour = 1000, ticks_per_second_realtime = 100 };

  GameClock();
  void init( const char*ini_fn );

  // GameClockIfc
  virtual void advance_game_time();
  // KbdHndlIfc
  virtual void handle_kbd( int scan_code, int shift_flags );

  // game clock functions
  void reset_game_time( int new_time=0, int new_speed=100 );
  void stop( bool do_stop ) { is_stopped_ = do_stop; }

  int get_normal_fps() const { return normal_fps; }
  int get_cur_speed() const { return (is_pause_||is_stopped_) ? 0 : speed_percent; }

  int get_time_since0() const { return (int)game_time; }
  int get_speed_value() const { return speed_percent; }

  int get_minute_of_hour() const;
  int get_hour_of_day() const;
  int get_hour_since0() const;
  int get_days_since0() const;
  int get_day_of_month() const;
  int get_month_of_year() const;
  int get_years_since0() const;

  // real time functions
  int get_realtime() const;

protected:
  int min_speed;
  int max_speed;
  int normal_fps;
  int msec_per_game_hour_;
  double game_time;
  int speed_percent;
  bool is_pause_;
  bool is_stopped_;
};

//----------------------------------------------------------------------------
