/* 
Copyright (c) 2005 - 2007 Tobias Scheuer

The zlib/libpng License

This software is provided 'as-is', without any express or implied warranty. 
In no event will the authors be held liable for any damages arising from the 
use of this software.

Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim 
that you wrote the original software. If you use this software in a product, 
an acknowledgment in the product documentation would be appreciated but is 
not required.

2. Altered source versions must be plainly marked as such, and must not be 
misrepresented as being the original software.

3. This notice may not be removed or altered from any source distribution.
*/

#ifndef INC_DISPLAYENGINE
#define INC_DISPLAYENGINE
#endif

#ifndef INC_GAMELOOPIFC
#include "GameLoopIfc.h"
#endif

struct BITMAP;

//----------------------------------------------------------------------------

struct ScreenRect
{
  ScreenRect() : x(0), y(0), w(0), h(0) {}
  ScreenRect( int ax, int ay, int aw, int ah ) : x(ax), y(ay), w(aw), h(ah) {}
  int x;
  int y;
  int w;
  int h;
  bool is_inside_rect( int bx, int by ) const
  {
    return x<bx && y<by && bx<x+w && by<y+h;
  }
};

//----------------------------------------------------------------------------

class DisplayEngine
{
public:
  enum UpdateMethod
  {
    UPDATE_NONE       = 0
  , UPDATE_SV_DOUBLE  = 1
  , UPDATE_VV_DOUBLE  = 2
  , UPDATE_SVV_TRIPLE = 3
  };

  DisplayEngine();
  ~DisplayEngine();
  void init( const char*ini_fn );
  BITMAP*const draw_buffer() const { return system_buffer ? system_buffer : active_buffer; }
  void prepare_draw_buffer();
  void display_draw_buffer();
  UpdateMethod getCurrentUpdateMethod() const { return update_method_; }
private:
  void allocate_and_clear_buffers( UpdateMethod );
  void destroy_all_buffers();
  void init_gfx();
  UpdateMethod update_method_;
  BITMAP* active_buffer;
  BITMAP* system_buffer;
  BITMAP* video_buffer1;
  BITMAP* video_buffer2;
};

//----------------------------------------------------------------------------

class ViewPortBase : public ViewPortIfc
{
public:
  ViewPortBase( const ScreenRect& );
  ~ViewPortBase();
  virtual void notify_chg_size();
  void chg_width_left( int w );
  void chg_width_right( int w );
  void chg_height_top( int h );
  void chg_height_bottom( int h );

protected:
  ScreenRect area;
};

//----------------------------------------------------------------------------

