// Panda 2 by el Hamil.
// Began coding on the 15th of June 1999.
// The game was first released on the 10th of September 1999.
// Right now it's the 11th of October 1999.

// Panda 2 for MS-Windows.
// Not released yet.
// Began conversion on the 23rd of November 1999.
// Right now it's the 6th of January 2000.


// ******  Includes:  ******

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif

#define BITMAP WINDOWS_BITMAP
#include <windows.h>
#undef BITMAP
#undef RGB
#include <allegro.h>
#include <winalleg.h>
#include <fstream.h>
#include <string.h>
#include <time.h>


// ******  Defines:  ******

// Remove this define to get the English version of the game.
#define SVENSKA

#define BLIT_NOW		acquire_screen(); blit(virscr,screen, 0,0, 0,0, 640,480); release_screen()

#define AND				&&
#define OR				||
#define EVER			;;
//#define UCHAR			unsigned char

#define MAPSIZE			20
#define TILESIZE		24
#define NRTILES			29
#define NRLEVELS		11

#define OFFICIAL		1
#define HOMEMADE		2

#define NORTH			0
#define WEST			1
#define EAST			2
#define SOUTH			3

#define NOSOLID			0
#define SOLID			15
#define SOLID_TOP		1
#define SOLID_LEFT		2
#define SOLID_RIGHT		4
#define SOLID_BOTTOM	8

// Some important colors.
#define BGCOL			11  // Background color
#define TXCOL			0   // Normal text color
#define SCOL			18  // Same in both palettes
#define DAYCOL			23
#define NIGHTCOL		215

// The tiles.
#define GRASS			0
#define TREE			1
#define STUB			2
#define KEY				3
#define CLOSEDGATE		4
#define OPENGATE		5
#define BUTTON_R		6
#define BUTTON_G		7
#define BUTTON_B		8
#define PIPE_NS_R		9
#define PIPE_WE_R		10
#define PIPE_NS_G		11
#define PIPE_WE_G		12
#define PIPE_NS_B		13
#define PIPE_WE_B		14
#define PIPE_NS_RG		15
#define PIPE_WE_RG		16
#define PIPE_NS_RB		17
#define PIPE_WE_RB		18
#define PIPE_NS_GB		19
#define PIPE_WE_GB		20
#define SPINPIPE_NS		21
#define SPINPIPE_WE		22
#define PIPE_NS			23
#define PIPE_WE			24
#define BRANCH_N		25
#define BRANCH_W		26
#define BRANCH_S		27
#define BRANCH_E		28

// These aren't actual tiles, they are only used to specify Panda's starting position on a map.
#define PANDAHERE_N		29
#define PANDAHERE_W		30
#define PANDAHERE_E		31
#define PANDAHERE_S		32

// Index of datafile contents.
#define DBRANCH_E		0        /* RLE  */
#define DBRANCH_N		1        /* RLE  */
#define DBRANCH_S		2        /* RLE  */
#define DBRANCH_W		3        /* RLE  */
#define DCLOSED			4        /* RLE  */
#define DCPRIGHT_B		5        /* RLE  */
#define DCPRIGHT_R		6        /* RLE  */
#define DEAST0			7        /* RLE  */
#define DEAST1			8        /* RLE  */
#define DEAST2			9        /* RLE  */
#define DEAST3			10       /* RLE  */
#define DEAST4			11       /* RLE  */
#define DFONT			12       /* FONT */
#define DFRAME_B		13       /* BMP  */
#define DFRAME_G		14       /* BMP  */
#define DFRAME_R		15       /* BMP  */
#define DGRASS			16       /* RLE  */
#define DKEY			17       /* RLE  */
#define DLETTER_A		18       /* RLE  */
#define DLETTER_D		19       /* RLE  */
#define DLETTER_N		20       /* RLE  */
#define DLETTER_P		21       /* RLE  */
#define DMOON			22       /* BMP  */
#define DNORTH0			23       /* RLE  */
#define DNORTH1			24       /* RLE  */
#define DNORTH2			25       /* RLE  */
#define DNORTH3			26       /* RLE  */
#define DNORTH4			27       /* RLE  */
#define DOPEN			28       /* RLE  */
#define DPAL			29       /* PAL  */
#define DPIPE_NS		30       /* RLE  */
#define DPIPE_NS_B		31       /* RLE  */
#define DPIPE_NS_G		32       /* RLE  */
#define DPIPE_NS_GB		33       /* RLE  */
#define DPIPE_NS_R		34       /* RLE  */
#define DPIPE_NS_RB		35       /* RLE  */
#define DPIPE_NS_RG		36       /* RLE  */
#define DPIPE_NS_SPIN	37       /* RLE  */
#define DPIPE_WE		38       /* RLE  */
#define DPIPE_WE_B		39       /* RLE  */
#define DPIPE_WE_G		40       /* RLE  */
#define DPIPE_WE_GB		41       /* RLE  */
#define DPIPE_WE_R		42       /* RLE  */
#define DPIPE_WE_RB		43       /* RLE  */
#define DPIPE_WE_RG		44       /* RLE  */
#define DPIPE_WE_SPIN	45       /* RLE  */
#define DSIGN2B			46       /* RLE  */
#define DSIGN_B			47       /* RLE  */
#define DSIGN_G			48       /* RLE  */
#define DSIGN_R			49       /* RLE  */
#define DSOUTH0			50       /* RLE  */
#define DSOUTH1			51       /* RLE  */
#define DSOUTH2			52       /* RLE  */
#define DSOUTH3			53       /* RLE  */
#define DSOUTH4			54       /* RLE  */
#define DSTUB			55       /* RLE  */
#define DSUN			56       /* BMP  */
#define DSWITCH_B		57       /* RLE  */
#define DSWITCH_G		58       /* RLE  */
#define DSWITCH_R		59       /* RLE  */
#define DTREE			60       /* RLE  */
#define DWEST0			61       /* RLE  */
#define DWEST1			62       /* RLE  */
#define DWEST2			63       /* RLE  */
#define DWEST3			64       /* RLE  */
#define DWEST4			65       /* RLE  */


// THISOFF is a constant I use to make .pan files easier to understand in a normal
// text editor. Without it, they would consist mainly of the characters 0-34, between
// which there are little visual difference. "aaaabcaadaaaae" is kinda easier to understand.
// When a file is saved, THISOFF is added. When a file is loaded, THISOFF is subtracted.
#define THISOFF		95


// *****  Class declarations:  *****

class CourseClass
{
	public:
	CourseClass();
	~CourseClass(){}
	unsigned short nrKeys;
	unsigned short bestResult;
	UCHAR map[MAPSIZE][MAPSIZE];
	char * itsTitle;
	UCHAR startX, startY;
	UCHAR startDirection;
};

class TileClass
{
	public:
	TileClass();
	~TileClass(){}
	RLE_SPRITE * itsImage;
	UCHAR walkability;
};

class HiscoreListEntry
{
	public:
	HiscoreListEntry();
	~HiscoreListEntry(){}
	unsigned short itsTime;
	char * itsName;
};


// *****  Global variables:  *****

BITMAP * virscr;
DATAFILE * dfil = 0;
TileClass tile[NRTILES];
RLE_SPRITE * pandaPic[4][12];
CourseClass thisCourse;
HiscoreListEntry hiscore[5];
FONT * pfont = 0;
RGB * basePal = 0;
PALETTE lightPal;  // All colors in this palette are lighter and more grey, except color #18.
RGB * currentPal = 0;
struct tm * whatsTheTime = new struct tm;


// *****  Declarations of functions:  *****

void restore_screen();
void wait(unsigned short howLongTime);
inline short pauseScreen();
inline void intro();
inline void loadHiscore();
inline void saveHiscore();
short showHiscore();
inline void enterHiscore(short time);
void drawFrames();
void drawFrame();
inline short loadTile(UCHAR whichTile);
inline short loadPandaImage(UCHAR direction, UCHAR whichImage);
short loadCourse(short whichCourseToLoad);
void setTitle(char * title2Set);
inline void ending(short totalTime);
inline void printLevelTitle();
inline void printCourseNr(short nr);
inline void printLevelTime(short levelTime);
inline void printNrKeys(short nr);
inline void printNrMoves(short nr);
inline void printBestMoves();
inline void drawTile(short xloc, short yloc, UCHAR whichTile);
void endOfLevel();
inline short levelEditor();
void message(char * string2Print);
void printInfo(UCHAR tile2TalkAbout);
short save2File(CourseClass course2Save);
short loadFromFile(CourseClass &course2LoadInto, char * filename);
short selectTile(UCHAR &marker, UCHAR &tile2Put);
char * kinput(short x,short y, char * text,UCHAR &maxNrChars, UCHAR useAnyChar,UCHAR escapeable);
//short save4Use(CourseClass course2Save);


// *****  Definitions of class member methods:  *****

CourseClass::CourseClass()
{
	itsTitle = 0;
}

TileClass::TileClass()
{
	itsImage = 0;
}

HiscoreListEntry::HiscoreListEntry()
{
	itsName = 0;
}





// ************************  Main:  ************************

void main()
{
	WinAllegro_SetWindowTitle("Panda 2");

	allegro_init();
	install_keyboard();
	set_color_depth(8);
	if(set_gfx_mode(GFX_DIRECTX, 640,480, 0,0) < 0)
		return;
	virscr = create_bitmap(640,480);
	if(!virscr)
		return;

	install_lost_bitmap_callback(restore_screen);


	// Load the datafile, it holds the font and all the images.
	packfile_password("class_z");
	dfil = load_datafile("panda2.dat");
	packfile_password(NULL);
	if(!dfil)
	{
		#ifdef SVENSKA
			textprintf_centre(virscr,font, 320,224, 255, "Filen panda2.dat saknas eller r trasig. Tyvrr.");
		#else
			textprintf_centre(virscr,font, 320,224, 255, "The file panda2.dat is either broken or missing. Sad but true.");
		#endif
		BLIT_NOW;
		readkey();
		allegro_exit();
		return;
	}


	// Load palette.
	basePal = (RGB *)dfil[DPAL].dat;
	for(short y=0; y<256; y++)
	{
		lightPal[y].r = (UCHAR)( basePal[y].r*0.1 +
		(basePal[y].r*0.3 + basePal[y].g*0.5 + basePal[y].b*0.2)*0.1 +
		(basePal[BGCOL].r*0.3 + basePal[BGCOL].g*0.5 + basePal[BGCOL].b*0.2)*0.8 );
		lightPal[y].g = (UCHAR)( basePal[y].g*0.1 +
		(basePal[y].r*0.3 + basePal[y].g*0.5 + basePal[y].b*0.2)*0.1 +
		(basePal[BGCOL].r*0.3 + basePal[BGCOL].g*0.5 + basePal[BGCOL].b*0.2)*0.8 );
		lightPal[y].b = (UCHAR)( basePal[y].b*0.1 +
		(basePal[y].r*0.3 + basePal[y].g*0.5 + basePal[y].b*0.2)*0.1 +
		(basePal[BGCOL].r*0.3 + basePal[BGCOL].g*0.5 + basePal[BGCOL].b*0.2)*0.8 );
	}
	lightPal[SCOL].r = basePal[SCOL].r;
	lightPal[SCOL].g = basePal[SCOL].g;
	lightPal[SCOL].b = basePal[SCOL].b;

	currentPal = basePal;
	set_palette(currentPal);


	// Load the font that will be used.
	pfont = (FONT *)dfil[DFONT].dat;

	// Load graphics.
	for(UCHAR i=0;i<NRTILES;i++)
		loadTile(i);
	for(UCHAR o=0;o<4;o++)
		for(UCHAR i=0;i<12;i++)
			loadPandaImage(o, i);


	loadHiscore();  // Load hiscore-list.

	intro();  // Display the oh-so-cool intro sequence. (Can be skipped by pressing 2.)


	UCHAR keepRunningProgram = 1;
	char startmenyselector = 0;

	do
	{
		text_mode(BGCOL);
		clear_to_color(virscr, BGCOL);
		currentPal = basePal;
		set_palette(currentPal);
		drawFrames();

		draw_rle_sprite(virscr, (RLE_SPRITE *)dfil[DLETTER_P].dat, 112,64);
		draw_rle_sprite(virscr, (RLE_SPRITE *)dfil[DLETTER_A].dat, 112,120);
		draw_rle_sprite(virscr, (RLE_SPRITE *)dfil[DLETTER_N].dat, 112,176);
		draw_rle_sprite(virscr, (RLE_SPRITE *)dfil[DLETTER_D].dat, 112,232);
		draw_rle_sprite(virscr, (RLE_SPRITE *)dfil[DLETTER_A].dat, 112,288);
		draw_rle_sprite(virscr, (RLE_SPRITE *)dfil[DSIGN2B].dat, 112,352);

		long hicol;
		_getsystime(whatsTheTime);
		if(whatsTheTime->tm_hour > 5 AND whatsTheTime->tm_hour < 20)
		{
			draw_rle_sprite(virscr, (RLE_SPRITE *)dfil[DCPRIGHT_R].dat, 112,440);
			stretch_sprite(virscr,(BITMAP *)dfil[DSUN].dat, 197,64, 246,232);
			hicol = DAYCOL;
		}
		else
		{
			draw_rle_sprite(virscr, (RLE_SPRITE *)dfil[DCPRIGHT_B].dat, 112,440);
			stretch_sprite(virscr,(BITMAP *)dfil[DMOON].dat, 197,64, 246,232);
			hicol = NIGHTCOL;
		}
		draw_rle_sprite(virscr, (RLE_SPRITE *)dfil[DSIGN_R].dat, 460,96);
		draw_rle_sprite(virscr, (RLE_SPRITE *)dfil[DSIGN_G].dat, 460,168);
		draw_rle_sprite(virscr, (RLE_SPRITE *)dfil[DSIGN_B].dat, 464,240);

		hline(virscr, 236,320, 252,     TXCOL);
		hline(virscr, 236,344, 252,     TXCOL);
		hline(virscr, 236,368, 252,     TXCOL);
		hline(virscr, 236,392, 252,     TXCOL);
		hline(virscr, 236,416, 252,     TXCOL);
		hline(virscr, 236,440, 252,     TXCOL);
		vline(virscr, 244,312,     448, TXCOL);

		UCHAR keepPlayingLevels = 0;
		char * cFilename = 0;

		while(1)
		{
			hline(virscr, 252,320, 420,    BGCOL);
			hline(virscr, 252,344, 420,    BGCOL);
			hline(virscr, 252,368, 420,    BGCOL);
			hline(virscr, 252,392, 420,    BGCOL);
			hline(virscr, 252,416, 420,    BGCOL);
			hline(virscr, 252,440, 420,    BGCOL);
			hline(virscr, 252,startmenyselector*24+320, 420, TXCOL);
			hline(virscr, 252,startmenyselector*24+344, 420, TXCOL);

			#ifdef SVENSKA
				textprintf(virscr, pfont, 260,325, TXCOL, "Starta spelet");
				textprintf(virscr, pfont, 260,349, TXCOL, "Visa rekord");
				textprintf(virscr, pfont, 260,373, TXCOL, "Gora egna banor");
				textprintf(virscr, pfont, 260,397, TXCOL, "Spela egna banor");
				textprintf(virscr, pfont, 260,421, TXCOL, "Avsluta");
				switch(startmenyselector)
				{
					case 0:
						textprintf(virscr, pfont, 260,325, hicol, "Starta spelet");
						break;
					case 1:
						textprintf(virscr, pfont, 260,349, hicol, "Visa rekord");
						break;
					case 2:
						textprintf(virscr, pfont, 260,373, hicol, "Gora egna banor");
						break;
					case 3:
						textprintf(virscr, pfont, 260,397, hicol, "Spela egna banor"); 
						break;
					case 4:
						textprintf(virscr, pfont, 260,421, hicol, "Avsluta");
						break;
					default:
						break;
				}
			#else
				textprintf(virscr, pfont, 260,325, TXCOL, "Start the game");
				textprintf(virscr, pfont, 260,349, TXCOL, "Show past results");
				textprintf(virscr, pfont, 260,373, TXCOL, "Edit your own levels");
				textprintf(virscr, pfont, 260,397, TXCOL, "Play your own levels");
				textprintf(virscr, pfont, 260,421, TXCOL, "Quit");
				switch(startmenyselector)
				{
					case 0:
						textprintf(virscr, pfont, 260,325, hicol, "Start the game");
						break;
					case 1:
						textprintf(virscr, pfont, 260,349, hicol, "Show past results");
						break;
					case 2:
						textprintf(virscr, pfont, 260,373, hicol, "Edit your own levels");
						break;
					case 3:
						textprintf(virscr, pfont, 260,397, hicol, "Play your own levels");
						break;
					case 4:
						textprintf(virscr, pfont, 260,421, hicol, "Quit");
						break;
					default:
						break;
				}
			#endif

			BLIT_NOW;
			wait(100);
			clear_keybuf();
			long ko = readkey();
			ko = ko >> 8;

			if(ko == KEY_SPACE OR ko == KEY_ENTER)
			{
				UCHAR max = 8;
				char * tempname = 0;

				switch(startmenyselector)
				{
					case 0:
						keepPlayingLevels = OFFICIAL;
						break;
					case 1:
						showHiscore();
						break;
					case 2:
						levelEditor();
						break;
					case 3:
						text_mode(-1);
						currentPal = lightPal;
						set_palette(currentPal);
						clear_to_color(virscr, BGCOL);
						drawFrames();
						_getsystime(whatsTheTime);
						if(whatsTheTime->tm_hour > 5 AND whatsTheTime->tm_hour < 20)
							stretch_sprite(virscr,(BITMAP *)dfil[DSUN].dat, 197,64, 246,232);
						else
							stretch_sprite(virscr,(BITMAP *)dfil[DMOON].dat, 197,64, 246,232);
						#ifdef SVENSKA
							textprintf(virscr,pfont, 228,224, SCOL, "Oppna fil:");
						#else
							textprintf(virscr,pfont, 228,224, SCOL, "Open file:");
						#endif

						BLIT_NOW;

						// Let the user enter the name of the file to open.
						tempname = kinput(316,224, "",max, 0, 1);

						if(tempname)
						{
							cFilename = new char[max+4];
							for(UCHAR g=0;g<max;g++)
								cFilename[g] = tempname[g];
							delete[] tempname;
							tempname = 0;
							cFilename[max-1] = '.';
							cFilename[max] = 'p';
							cFilename[max+1] = 'a';
							cFilename[max+2] = 'n';
							cFilename[max+3] = 0;
							keepPlayingLevels = HOMEMADE;
						}
						break;

					case 4:
						keepRunningProgram = 0;
						break;
					default:
						break;
				}
				break;
			}

			if(ko == KEY_UP)
			{
				startmenyselector--;
				if(startmenyselector < 0)
					startmenyselector = 4;
			}
			if(ko == KEY_DOWN)
			{
				startmenyselector++;
				if(startmenyselector > 4)
					startmenyselector = 0;
			}
			if(ko == KEY_ESC)
			{
				keepRunningProgram = 0;
				break;
			}
/*
			if(key[KEY_P])
			{
				BITMAP * bmp;
				PALETTE pal;
				get_palette(pal);
				bmp = create_sub_bitmap(virscr, 0,0, SCREEN_W,SCREEN_H);
				save_bitmap("dump.pcx", bmp, pal);
				destroy_bitmap(bmp);
			}
*/

		}

		short courseNr = 0;
		unsigned long gameTimer = 0;


		while(keepPlayingLevels)
		{
			UCHAR keepPlayingThisLevel = 1;

			rest(100);

			if(keepPlayingLevels == OFFICIAL)
				if(loadCourse(courseNr))
				// If there are no more levels, that's it!
				{
					keepPlayingThisLevel = 0;
					keepPlayingLevels = 0;
					ending(gameTimer/1000);
					break;
				}

			if(keepPlayingLevels == HOMEMADE)
			{
				if(!loadFromFile(thisCourse, cFilename))
				{
					textprintf(virscr,pfont, 316,224, SCOL, "%s", cFilename);
					#ifdef SVENSKA
						textprintf_centre(virscr,pfont, 320,240, SCOL, "Det gick inte att oppna filen.");
					#else
						textprintf_centre(virscr,pfont, 320,240, SCOL, "Couldn't open file.");
					#endif
					keepPlayingThisLevel = 0;
					keepPlayingLevels = 0;
					BLIT_NOW;
					clear_keybuf();
					readkey();
					break;
				}
			}

			// Prepare for the next level.
			clear_to_color(virscr, BGCOL);
			currentPal = lightPal;
			set_palette(currentPal);

			UCHAR pandaTileX = thisCourse.startX;
			UCHAR pandaTileY = thisCourse.startY;
			unsigned short pandaPixelX = pandaTileX * TILESIZE;
			unsigned short pandaPixelY = pandaTileY * TILESIZE;
			UCHAR pandaWalking = 0;  // Is he walking?
			UCHAR pandaDirection = thisCourse.startDirection;  // Which direction is he facing?
			unsigned short nrMoves = 0;
			unsigned short nrKeysTaken = 0;
			UCHAR pandaStep = 0;  // There are 12 steps per tile.
			UCHAR newTile = 1;  // A flag, TRUE every 12 steps.
			UCHAR whatsNext = 0;
			UCHAR canIGo;
			unsigned long levelTimer = 0, rawTimer = 0;
			UCHAR startedYet = 0;  // A flag, FALSE until Panda makes his first move.

			// Here is a smart thing. It is used to specify which parts of the playscreen
			// that have changed since the last redraw. We only redraw these parts, we don't
			// want to waste time on the rest.
			UCHAR thisHasChanged[MAPSIZE][MAPSIZE];

			// Draw the course.
			drawFrame();
			for(long y=0; y<MAPSIZE; y++)
			{
				for(long x=0; x<MAPSIZE; x++)
				{
					thisHasChanged[y][x] = 0;
					drawTile(x,y, GRASS);
					if(thisCourse.map[y][x])
					{
						if(thisCourse.map[y][x] >= PIPE_NS_R AND thisCourse.map[y][x] <= SPINPIPE_WE)
						// Pipes are a special case. For now, draw only the bottom of the pipe.
						{
							if(thisCourse.map[y][x] % 2)
								drawTile(x,y, PIPE_NS);
							else
								drawTile(x,y, PIPE_WE);
						}
						else
							drawTile(x,y, thisCourse.map[y][x]);
					}
				}
			}

			// Draw Panda himself.
			draw_rle_sprite(virscr, pandaPic[pandaDirection][0], pandaPixelX,pandaPixelY);


			// Draw the top of the pipes, and the branches that hang out from the trees.

			for(y=1; y<19; y++)
			{
				for(long x=1; x<19; x++)
				{
					if(thisCourse.map[y][x] >= PIPE_NS_R AND thisCourse.map[y][x] <= SPINPIPE_WE)
						drawTile(x,y, thisCourse.map[y][x]);
					if(thisCourse.map[y-1][x] == TREE)
						drawTile(x,y, BRANCH_N);
					if(thisCourse.map[y][x-1] == TREE)
						drawTile(x,y, BRANCH_W);
					if(thisCourse.map[y][x+1] == TREE)
						drawTile(x,y, BRANCH_E);
					if(thisCourse.map[y+1][x] == TREE)
						drawTile(x,y, BRANCH_S);
				}
				if(thisCourse.map[y][0] >= PIPE_NS_R AND thisCourse.map[y][0] <= SPINPIPE_WE)
					drawTile(0,y, thisCourse.map[y][0]);
				if(thisCourse.map[y-1][0] == TREE)
					drawTile(0,y, BRANCH_N);
				if(thisCourse.map[y][1] == TREE)
					drawTile(0,y, BRANCH_E);
				if(thisCourse.map[y+1][0] == TREE)
					drawTile(0,y, BRANCH_S);

				if(thisCourse.map[y][19] >= PIPE_NS_R AND thisCourse.map[y][19] <= SPINPIPE_WE)
					drawTile(19,y, thisCourse.map[y][19]);
				if(thisCourse.map[y-1][19] == TREE)
					drawTile(19,y, BRANCH_N);
				if(thisCourse.map[y][18] == TREE)
					drawTile(19,y, BRANCH_W);
				if(thisCourse.map[y+1][19] == TREE)
					drawTile(19,y, BRANCH_S);
			}

			for(long x=1; x<19; x++)
			{
				if(thisCourse.map[0][x] >= PIPE_NS_R AND thisCourse.map[0][x] <= SPINPIPE_WE)
					drawTile(x,0, thisCourse.map[0][x]);
				if(thisCourse.map[0][x-1] == TREE)
					drawTile(x,0, BRANCH_W);
				if(thisCourse.map[0][x+1] == TREE)
					drawTile(x,0, BRANCH_E);
				if(thisCourse.map[1][x] == TREE)
					drawTile(x,0, BRANCH_S);

				if(thisCourse.map[19][x] >= PIPE_NS_R AND thisCourse.map[19][x] <= SPINPIPE_WE)
					drawTile(x,19, thisCourse.map[19][x]);
				if(thisCourse.map[18][x] == TREE)
					drawTile(x,19, BRANCH_N);
				if(thisCourse.map[19][x-1] == TREE)
					drawTile(x,19, BRANCH_W);
				if(thisCourse.map[19][x+1] == TREE)
					drawTile(x,19, BRANCH_E);
			}
			if(thisCourse.map[0][0] >= PIPE_NS_R AND thisCourse.map[0][0] <= SPINPIPE_WE)
				drawTile(0,0, thisCourse.map[0][0]);
			if(thisCourse.map[0][1] == TREE)
				drawTile(0,0, BRANCH_E);
			if(thisCourse.map[1][0] == TREE)
				drawTile(0,0, BRANCH_S);

			if(thisCourse.map[0][19] >= PIPE_NS_R AND thisCourse.map[0][19] <= SPINPIPE_WE)
				drawTile(19,0, thisCourse.map[0][19]);
			if(thisCourse.map[0][18] == TREE)
				drawTile(19,0, BRANCH_W);
			if(thisCourse.map[1][19] == TREE)
				drawTile(19,0, BRANCH_S);

			if(thisCourse.map[19][0] >= PIPE_NS_R AND thisCourse.map[19][0] <= SPINPIPE_WE)
				drawTile(0,19, thisCourse.map[19][0]);
			if(thisCourse.map[18][0] == TREE)
				drawTile(0,19, BRANCH_N);
			if(thisCourse.map[19][1] == TREE)
				drawTile(0,19, BRANCH_E);

			if(thisCourse.map[19][19] >= PIPE_NS_R AND thisCourse.map[19][19] <= SPINPIPE_WE)
				drawTile(19,19, thisCourse.map[19][19]);
			if(thisCourse.map[18][19] == TREE)
				drawTile(19,19, BRANCH_N);
			if(thisCourse.map[19][18] == TREE)
				drawTile(19,19, BRANCH_W);


			UCHAR thingsHaveChanged = 0;  // A flag, indicating if anything has changed at all.


			// Print all that info on the right side.
			text_mode(BGCOL);
			if(keepPlayingLevels == OFFICIAL)
			{
				printCourseNr(courseNr);
				printBestMoves();
			}
			else
				textprintf(virscr,pfont, 504,32, TXCOL, "%s", cFilename);
			printLevelTime(levelTimer);
			printNrKeys(nrKeysTaken);
			printNrMoves(nrMoves);

			// Print the title of the level.
			// This function won't return until a key is pressed.
			printLevelTitle();

			// And start the timer.
			UCHAR spinCheck = (long)(GetTickCount() / 1000) % 2;



			// *********** Main game loop ************


			while(keepPlayingThisLevel)
			{

				// This small part deals with time.
				long newTime = GetTickCount();
				if(startedYet)
				{
					rawTimer += 15;

					if((long)(rawTimer / 1000) > levelTimer)
					{
						levelTimer = (rawTimer / 1000);
						printLevelTime(levelTimer);
					}
				}


				// This small part deals with spinning pipes.
				if((long)(newTime / 1000) % 2 != spinCheck)
				{
					spinCheck = (long)(newTime / 1000) % 2;

					for(long y=0; y<400; y++)
					{
						if(thisCourse.map[0][y] == SPINPIPE_NS)
						{
							thisCourse.map[0][y] = SPINPIPE_WE;
							thisHasChanged[0][y] = 1;
							thingsHaveChanged = 1;
						}
						else if(thisCourse.map[0][y] == SPINPIPE_WE)
						{
							thisCourse.map[0][y] = SPINPIPE_NS;
							thisHasChanged[0][y] = 1;
							thingsHaveChanged = 1;
						}
					}

				}


        // This is the drawing part.
        // Redraw the screen, but only the parts of it that have changed since last time.
        if(thingsHaveChanged)
        {
//          vsync();

          for(long y=0; y<MAPSIZE; y++)
          {
            long x = MAPSIZE;
            while(x)
            {
              x--;
              if(thisHasChanged[y][x])
              {
                drawTile(x,y, GRASS);
                if(thisCourse.map[y][x])
                {
                  if(thisCourse.map[y][x] >= PIPE_NS_R AND thisCourse.map[y][x] <= SPINPIPE_WE)
                  // Pipes are a special case. Here, draw only the bottom of the pipe.
                  {
                    if(thisCourse.map[y][x] % 2)
                      drawTile(x,y, PIPE_NS);
                    else
                      drawTile(x,y, PIPE_WE);
                  }
                  else
                    drawTile(x,y, thisCourse.map[y][x]);
                }
              }
            }
          }

          // Draw Panda himself.
          if(thisHasChanged[pandaTileY][pandaTileX])
            draw_rle_sprite(virscr, pandaPic[pandaDirection][(short)(pandaStep/2)], pandaPixelX,pandaPixelY);


          // Draw the top of the pipes, and the branches that hang out from the trees.

          for(y=1; y<19; y++)
          {
            for(long x=1; x<19; x++)
            {
              if(thisHasChanged[y][x])
              {
                if(thisCourse.map[y][x] >= PIPE_NS_R AND thisCourse.map[y][x] <= SPINPIPE_WE)
                  drawTile(x,y, thisCourse.map[y][x]);
                if(thisCourse.map[y-1][x] == TREE)
                  drawTile(x,y, BRANCH_N);
                if(thisCourse.map[y][x-1] == TREE)
                  drawTile(x,y, BRANCH_W);
                if(thisCourse.map[y][x+1] == TREE)
                  drawTile(x,y, BRANCH_E);
                if(thisCourse.map[y+1][x] == TREE)
                  drawTile(x,y, BRANCH_S);
                thisHasChanged[y][x] = 0;
              }
            }

            if(thisHasChanged[y][0])
            {
              if(thisCourse.map[y][0] >= PIPE_NS_R AND thisCourse.map[y][0] <= SPINPIPE_WE)
                drawTile(0,y, thisCourse.map[y][0]);
              if(thisCourse.map[y-1][0] == TREE)
                drawTile(0,y, BRANCH_N);
              if(thisCourse.map[y][1] == TREE)
                drawTile(0,y, BRANCH_E);
              if(thisCourse.map[y+1][0] == TREE)
                drawTile(0,y, BRANCH_S);
              thisHasChanged[y][0] = 0;
            }
            if(thisHasChanged[y][19])
            {
              if(thisCourse.map[y][19] >= PIPE_NS_R AND thisCourse.map[y][19] <= SPINPIPE_WE)
                drawTile(19,y, thisCourse.map[y][19]);
              if(thisCourse.map[y-1][19] == TREE)
                drawTile(19,y, BRANCH_N);
              if(thisCourse.map[y][18] == TREE)
                drawTile(19,y, BRANCH_W);
              if(thisCourse.map[y+1][19] == TREE)
                drawTile(19,y, BRANCH_S);
              thisHasChanged[y][19] = 0;
            }
          }

          for(long x=1; x<19; x++)
          {
            if(thisHasChanged[0][x])
            {
              if(thisCourse.map[0][x] >= PIPE_NS_R AND thisCourse.map[0][x] <= SPINPIPE_WE)
                drawTile(x,0, thisCourse.map[0][x]);
              if(thisCourse.map[0][x-1] == TREE)
                drawTile(x,0, BRANCH_W);
              if(thisCourse.map[0][x+1] == TREE)
                drawTile(x,0, BRANCH_E);
              if(thisCourse.map[1][x] == TREE)
                drawTile(x,0, BRANCH_S);
              thisHasChanged[0][x] = 0;
            }
            if(thisHasChanged[19][x])
            {
              if(thisCourse.map[19][x] >= PIPE_NS_R AND thisCourse.map[19][x] <= SPINPIPE_WE)
                drawTile(x,19, thisCourse.map[19][x]);
              if(thisCourse.map[18][x] == TREE)
                drawTile(x,19, BRANCH_N);
              if(thisCourse.map[19][x-1] == TREE)
                drawTile(x,19, BRANCH_W);
              if(thisCourse.map[19][x+1] == TREE)
                drawTile(x,19, BRANCH_E);
              thisHasChanged[19][x] = 0;
            }
          }

          if(thisHasChanged[0][0])
          {
            if(thisCourse.map[0][0] >= PIPE_NS_R AND thisCourse.map[0][0] <= SPINPIPE_WE)
              drawTile(0,0, thisCourse.map[0][0]);
            if(thisCourse.map[0][1] == TREE)
              drawTile(0,0, BRANCH_E);
            if(thisCourse.map[1][0] == TREE)
              drawTile(0,0, BRANCH_S);
            thisHasChanged[0][0] = 0;
          }
          if(thisHasChanged[0][19])
          {
            if(thisCourse.map[0][19] >= PIPE_NS_R AND thisCourse.map[0][19] <= SPINPIPE_WE)
              drawTile(19,0, thisCourse.map[0][19]);
            if(thisCourse.map[0][18] == TREE)
              drawTile(19,0, BRANCH_W);
            if(thisCourse.map[1][19] == TREE)
              drawTile(19,0, BRANCH_S);
            thisHasChanged[0][19] = 0;
          }

          if(thisHasChanged[19][0])
          {
            if(thisCourse.map[19][0] >= PIPE_NS_R AND thisCourse.map[19][0] <= SPINPIPE_WE)
              drawTile(0,19, thisCourse.map[19][0]);
            if(thisCourse.map[18][0] == TREE)
              drawTile(0,19, BRANCH_N);
            if(thisCourse.map[19][1] == TREE)
              drawTile(0,19, BRANCH_E);
            thisHasChanged[19][0] = 0;
          }
          if(thisHasChanged[19][19])
          {
            if(thisCourse.map[19][19] >= PIPE_NS_R AND thisCourse.map[19][19] <= SPINPIPE_WE)
              drawTile(19,19, thisCourse.map[19][19]);
            if(thisCourse.map[18][19] == TREE)
              drawTile(19,19, BRANCH_N);
            if(thisCourse.map[19][18] == TREE)
              drawTile(19,19, BRANCH_W);
            thisHasChanged[19][19] = 0;
          }

          thingsHaveChanged = 0;
        }
		BLIT_NOW;


		// This is the part where the player can put an end to his suffering.
		if(key[KEY_ESC])
		{
			currentPal = lightPal;
			set_palette(currentPal);
			switch(pauseScreen())
			{
				case 1:
					keepPlayingThisLevel = 0;
					clear_to_color(virscr, BGCOL);
					break;
				case 2:
					keepPlayingThisLevel = 0;
					keepPlayingLevels = 0;
					clear_to_color(virscr, BGCOL);
					break;
				default:
					break;
			}
			wait(100);
			currentPal = basePal;
			set_palette(currentPal);
		}


/*		 This piece is not included in the final game.
		if(key[KEY_P])
		{
			BITMAP * bmp;
			PALETTE pal;
			get_palette(pal);
			bmp = create_sub_bitmap(virscr, 0,0, SCREEN_W,SCREEN_H);
			save_bitmap("dump.pcx", bmp, pal);
			destroy_bitmap(bmp);
		}
*/

        // This is the part where Panda moves.

        if(pandaWalking)
        {
          pandaStep += 2;

          // Panda is moving, which means a change to the playfield, right? Let's note it down.
          thisHasChanged[pandaTileY][pandaTileX] = 1;
          thingsHaveChanged = 1;

          if(pandaDirection == NORTH)
          {
            // Panda is moving, which means a change to the playfield, right? Let's note it down.
            thisHasChanged[pandaTileY-1][pandaTileX] = 1;

            if(pandaStep >= TILESIZE)
            {
              pandaStep = 0;
              newTile = 1;
              pandaTileY--;

              // We take care not to leave the screen.
              if(pandaTileY == 0)
              {
                pandaWalking = 0;
                nrMoves++;
                printNrMoves(nrMoves);
              }
              else
              {
                // Check to see if we can leave this tile.
                canIGo = tile[thisCourse.map[pandaTileY][pandaTileX]].walkability;
                canIGo = ((canIGo & 247) & 251) & 253;
                if(canIGo < SOLID_TOP)
                {
                  // Then check to see if we can go to the other tile.
                  whatsNext = thisCourse.map[pandaTileY-1][pandaTileX];
                  canIGo = tile[whatsNext].walkability;
                  if(canIGo >= SOLID_BOTTOM)
                  {
                    pandaWalking = 0;
                    nrMoves++;
                    printNrMoves(nrMoves);
                  }
                }
                else
                {
                  pandaWalking = 0;
                  nrMoves++;
                  printNrMoves(nrMoves);
                }
              }
            }

            pandaPixelY = pandaTileY * TILESIZE - pandaStep;
          }

          if(pandaDirection == WEST)
          {
            // Panda is moving, which means a change to the playfield, right? Let's note it down.
            thisHasChanged[pandaTileY][pandaTileX-1] = 1;

            if(pandaStep == TILESIZE)
            {
              pandaStep = 0;
              newTile = 1;
              pandaTileX--;

              // We take care not to leave the screen.
              if(pandaTileX == 0)
              {
                pandaWalking = 0;
                nrMoves++;
                printNrMoves(nrMoves);
              }
              else
              {
                // Check to see if we can leave this tile.
                canIGo = tile[thisCourse.map[pandaTileY][pandaTileX]].walkability;
                canIGo = (canIGo & 247) & 251;
                if(canIGo < SOLID_LEFT)
                {
                  // Then check to see if we can go to the other tile.
                  whatsNext = thisCourse.map[pandaTileY][pandaTileX-1];
                  canIGo = tile[whatsNext].walkability;
                  canIGo = canIGo & 247;
                  if(canIGo >= SOLID_RIGHT)
                  {
                    pandaWalking = 0;
                    nrMoves++;
                    printNrMoves(nrMoves);
                  }
                }
                else
                {
                  pandaWalking = 0;
                  nrMoves++;
                  printNrMoves(nrMoves);
                }
              }
            }

            pandaPixelX = pandaTileX * TILESIZE - pandaStep;
          }


          if(pandaDirection == EAST)
          {
            // Panda is moving, which means a change to the playfield, right? Let's note it down.
            thisHasChanged[pandaTileY][pandaTileX+1] = 1;

            if(pandaStep == TILESIZE)
            {
              pandaStep = 0;
              newTile = 1;
              pandaTileX++;

              // We take care not to leave the screen.
              if(pandaTileX == 19)
              {
                pandaWalking = 0;
                nrMoves++;
                printNrMoves(nrMoves);
              }
              else
              {
                // Check to see if we can leave this tile.
                canIGo = tile[thisCourse.map[pandaTileY][pandaTileX]].walkability;
                canIGo = canIGo & 247;
                if(canIGo < SOLID_RIGHT)
                {
                  // Then check to see if we can go to the other tile.
                  whatsNext = thisCourse.map[pandaTileY][pandaTileX+1];
                  canIGo = tile[whatsNext].walkability;
                  canIGo = (canIGo & 247) & 251;
                  if(canIGo >= SOLID_LEFT)
                  {
                    pandaWalking = 0;
                    nrMoves++;
                    printNrMoves(nrMoves);
                  }
                }
                else
                {
                  pandaWalking = 0;
                  nrMoves++;
                  printNrMoves(nrMoves);
                }
              }
            }

            pandaPixelX = pandaTileX * TILESIZE + pandaStep;
          }

          if(pandaDirection == SOUTH)
          {
            // Panda is moving, which means a change to the playfield, right? Let's note it down.
            thisHasChanged[pandaTileY+1][pandaTileX] = 1;

            if(pandaStep == TILESIZE)
            {
              pandaStep = 0;
              newTile = 1;
              pandaTileY++;

              // We take care not to leave the screen.
              if(pandaTileY == 19)
              {
                pandaWalking = 0;
                nrMoves++;
                printNrMoves(nrMoves);
              }
              else
              {
                // Check to see if we can leave this tile.
                canIGo = tile[thisCourse.map[pandaTileY][pandaTileX]].walkability;
                if(canIGo < SOLID_BOTTOM)
                {
                  // Then check to see if we can go to the other tile.
                  whatsNext = thisCourse.map[pandaTileY+1][pandaTileX];
                  canIGo = tile[whatsNext].walkability;
                  canIGo = ((canIGo & 247) & 251) & 253;
                  if(canIGo >= SOLID_TOP)
                  {
                    pandaWalking = 0;
                    nrMoves++;
                    printNrMoves(nrMoves);
                  }
                }
                else
                {
                  pandaWalking = 0;
                  nrMoves++;
                  printNrMoves(nrMoves);
                }
              }
            }

            pandaPixelY = pandaTileY * TILESIZE + pandaStep;
          }

        }


        else
        // Okay, so Panda isn't moving. Perhaps he should start to! This is
        // the part of the program where the player can make Panda move.
        {

          if(key[KEY_UP])
          // Trying to go north?
          {
            startedYet = 1;

            if(pandaDirection != NORTH)
            {
              // Start by turning north.
              pandaDirection = NORTH;

              // That's a change to the playfield.
              thisHasChanged[pandaTileY][pandaTileX] = 1;
              thingsHaveChanged = 1;
            }

            // We take care not to leave the screen.
            if(pandaTileY > 0)
            {
              // Check to see if we can leave this tile.
              canIGo = tile[thisCourse.map[pandaTileY][pandaTileX]].walkability;
              canIGo = ((canIGo & 247) & 251) & 253;
              if(canIGo < SOLID_TOP)
              {
                // Then check to see if we can go to the other tile.
                whatsNext = thisCourse.map[pandaTileY-1][pandaTileX];

                // I hate to put this here, but I can't find another way.
                if(whatsNext == OPENGATE)
                {
                  courseNr++;
                  gameTimer += rawTimer;
                  keepPlayingThisLevel = 0;
                  if(keepPlayingLevels == HOMEMADE)
                    keepPlayingLevels = 0;
                  fade_from(basePal,lightPal, 4);
                  endOfLevel();
                }
                canIGo = tile[whatsNext].walkability;
                if(canIGo < SOLID_BOTTOM)
                {
                  pandaWalking = 1;
                }
              }
            }
          }

          else if(key[KEY_LEFT])
          // Trying to go west?
          {
            startedYet = 1;

            if(pandaDirection != WEST)
            {
              // Start by turning west.
              pandaDirection = WEST;

              // That's a change to the playfield.
              thisHasChanged[pandaTileY][pandaTileX] = 1;
              thingsHaveChanged = 1;
            }

            // We take care not to leave the screen.
            if(pandaTileX > 0)
            {
              // Check to see if we can leave this tile.
              canIGo = tile[thisCourse.map[pandaTileY][pandaTileX]].walkability;
              canIGo = (canIGo & 247) & 251;
              if(canIGo < SOLID_LEFT)
              {
                // Then check to see if we can go to the other tile.
                whatsNext = thisCourse.map[pandaTileY][pandaTileX-1];

                // I hate to put this here, but I can't find another way.
                if(whatsNext == OPENGATE)
                {
                  courseNr++;
                  gameTimer += rawTimer;
                  keepPlayingThisLevel = 0;
                  if(keepPlayingLevels == HOMEMADE)
                    keepPlayingLevels = 0;
                  fade_from(basePal,lightPal, 4);
                  endOfLevel();
                }
                canIGo = tile[whatsNext].walkability;
                canIGo = canIGo & 247;
                if(canIGo < SOLID_RIGHT)
                {
                  pandaWalking = 1;
                }
              }
            }
          }

          else if(key[KEY_RIGHT])
          // Trying to go east?
          {
            startedYet = 1;

            if(pandaDirection != EAST)
            {
              // Start by turning east.
              pandaDirection = EAST;

              // That's a change to the playfield.
              thisHasChanged[pandaTileY][pandaTileX] = 1;
              thingsHaveChanged = 1;
            }

            // We take care not to leave the screen.
            if(pandaTileX < 19)
            {
              // Check to see if we can leave this tile.
              canIGo = tile[thisCourse.map[pandaTileY][pandaTileX]].walkability;
              canIGo = canIGo & 247;
              if(canIGo < SOLID_RIGHT)
              {
                // Then check to see if we can go to the other tile.
                whatsNext = thisCourse.map[pandaTileY][pandaTileX+1];

                // I hate to put this here, but I can't find another way.
                if(whatsNext == OPENGATE)
                {
                  courseNr++;
                  gameTimer += rawTimer;
                  keepPlayingThisLevel = 0;
                  if(keepPlayingLevels == HOMEMADE)
                    keepPlayingLevels = 0;
                  fade_from(basePal,lightPal, 4);
                  endOfLevel();
                }
                canIGo = tile[whatsNext].walkability;
                canIGo = (canIGo & 247) & 251;
                if(canIGo < SOLID_LEFT)
                {
                  pandaWalking = 1;
                }
              }
            }
          }

          else if(key[KEY_DOWN])
          // Trying to go south?
          {
            startedYet = 1;

            if(pandaDirection != SOUTH)
            {
              // Start by turning south.
              pandaDirection = SOUTH;

              // That's a change to the playfield.
              thisHasChanged[pandaTileY][pandaTileX] = 1;
              thingsHaveChanged = 1;
            }

            // We take care not to leave the screen.
            if(pandaTileY < 19)
            {
              // Check to see if we can leave this tile.
              canIGo = tile[thisCourse.map[pandaTileY][pandaTileX]].walkability;
              if(canIGo < SOLID_BOTTOM)
              {
                // Then check to see if we can go to the other tile.
                whatsNext = thisCourse.map[pandaTileY+1][pandaTileX];

                // I hate to put this here, but I can't find another way.
                if(whatsNext == OPENGATE)
                {
                  courseNr++;
                  gameTimer += rawTimer;
                  keepPlayingThisLevel = 0;
                  if(keepPlayingLevels == HOMEMADE)
                    keepPlayingLevels = 0;
                  fade_from(basePal,lightPal, 4);
                  endOfLevel();
                }
                canIGo = tile[whatsNext].walkability;
                canIGo = ((canIGo & 247) & 251) & 253;
                if(canIGo < SOLID_TOP)
                {
                  pandaWalking = 1;
                }
              }
            }
          }

        }



        // This is the part where Panda picks up keys and enters gates and such things.
        // It is executed each time Panda has moved to a new tile.

        if(newTile)
        {
          if(thisCourse.map[pandaTileY][pandaTileX] == KEY)
          {
            nrKeysTaken++;
            printNrKeys(nrKeysTaken);
            thisCourse.map[pandaTileY][pandaTileX] = 0;
            thisHasChanged[pandaTileY][pandaTileX] = 1;
            thingsHaveChanged = 1;
          }

          if(nrKeysTaken == thisCourse.nrKeys)
          {
            nrKeysTaken++;
            // If all keys are taken, then open the gate.
            for(long y=0;y<400;y++)
              if(thisCourse.map[0][y] == CLOSEDGATE)
              {
                thisCourse.map[0][y] = OPENGATE;

                // Now we made a change to the playfield, right? So we note it down.
                thisHasChanged[0][y] = 1;
                thingsHaveChanged = 1;
              }
          }

          if(thisCourse.map[pandaTileY][pandaTileX] == BUTTON_R)
            for(long y=0;y<400;y++)
            {
              if(thisCourse.map[0][y] == PIPE_NS_R OR
                 thisCourse.map[0][y] == PIPE_NS_RG OR
                 thisCourse.map[0][y] == PIPE_NS_RB )
              {
                thisCourse.map[0][y]++;

                // Now we made a change to the playfield, right? So we note it down.
                thisHasChanged[0][y] = 1;
                thingsHaveChanged = 1;
              }
              else if(thisCourse.map[0][y] == PIPE_WE_R OR
                      thisCourse.map[0][y] == PIPE_WE_RG OR
                      thisCourse.map[0][y] == PIPE_WE_RB )
              {
                thisCourse.map[0][y]--;

                // Now we made a change to the playfield, right? So we note it down.
                thisHasChanged[0][y] = 1;
                thingsHaveChanged = 1;
              }
            }
          if(thisCourse.map[pandaTileY][pandaTileX] == BUTTON_G)
            for(long y=0;y<400;y++)
            {
              if(thisCourse.map[0][y] == PIPE_NS_G OR
                 thisCourse.map[0][y] == PIPE_NS_RG OR
                 thisCourse.map[0][y] == PIPE_NS_GB )
              {
                thisCourse.map[0][y]++;

                // Now we made a change to the playfield, right? So we note it down.
                thisHasChanged[0][y] = 1;
                thingsHaveChanged = 1;
              }
              else if(thisCourse.map[0][y] == PIPE_WE_G OR
                      thisCourse.map[0][y] == PIPE_WE_RG OR
                      thisCourse.map[0][y] == PIPE_WE_GB )
              {
                thisCourse.map[0][y]--;

                // Now we made a change to the playfield, right? So we note it down.
                thisHasChanged[0][y] = 1;
                thingsHaveChanged = 1;
              }
            }
          if(thisCourse.map[pandaTileY][pandaTileX] == BUTTON_B)
            for(long y=0;y<400;y++)
            {
              if(thisCourse.map[0][y] == PIPE_NS_B OR
                 thisCourse.map[0][y] == PIPE_NS_RB OR
                 thisCourse.map[0][y] == PIPE_NS_GB )
              {
                thisCourse.map[0][y]++;

                // Now we made a change to the playfield, right? So we note it down.
                thisHasChanged[0][y] = 1;
                thingsHaveChanged = 1;
              }
              else if(thisCourse.map[0][y] == PIPE_WE_B OR
                      thisCourse.map[0][y] == PIPE_WE_RB OR
                      thisCourse.map[0][y] == PIPE_WE_GB )
              {
                thisCourse.map[0][y]--;

                // Now we made a change to the playfield, right? So we note it down.
                thisHasChanged[0][y] = 1;
                thingsHaveChanged = 1;
              }
            }

          if(whatsNext == OPENGATE)
          {
            courseNr++;
			gameTimer += rawTimer;
            keepPlayingThisLevel = 0;
            if(keepPlayingLevels == HOMEMADE)
              keepPlayingLevels = 0;
            fade_from(basePal,lightPal, 4);
            endOfLevel();
          }

          newTile = 0;
        }

				// Cause the game to run at a constant speed.
				while(GetTickCount() - newTime < 15);

			}  // The "keepPlayingThisLevel" - loop ends here.

		}  // The "keepPlayingLevels" - loop ends here.

		delete[] cFilename;
		cFilename = 0;

	}
	while(keepRunningProgram);

	// Save hiscore-list.
	saveHiscore();

	unload_datafile(dfil);

	allegro_exit();

	return;
}




// *****  Definitions of the other functions:  *****


void restore_screen()
// This is a very important function. It restores the screen when Windows has destroyed it.
{
	set_palette(currentPal);
	BLIT_NOW;
}


void wait(unsigned short howLongTime)
{
	long startTime = GetTickCount();
	long timePassed = 0;
	while(timePassed < howLongTime)
	{
		timePassed = GetTickCount() - startTime;
	}
}			


inline short pauseScreen()
// The return value from this function is a sort of message.
// 0 means "go on like nothing happened",
// 1 means "restart the level", and
// 2 means "quit playing".
{
	BITMAP * backup = create_bitmap(168,112);
	blit(virscr,backup, 156,112, 0,0, 168,112);
	#ifdef SVENSKA
		textprintf(virscr,pfont, 156,112, SCOL, "   Paus   ");
		textprintf(virscr,pfont, 156,144, SCOL, "                     ");
		textprintf(virscr,pfont, 156,160, SCOL, "   Fortsatta spela   ");
		textprintf(virscr,pfont, 156,176, SCOL, "   Starta om banan   ");
		textprintf(virscr,pfont, 156,192, SCOL, "   Sluta spela       ");
		textprintf(virscr,pfont, 156,208, SCOL, "                     ");
	#else
		textprintf(virscr,pfont, 156,112, SCOL, "    Pause    ");
		textprintf(virscr,pfont, 156,144, SCOL, "                     ");
		textprintf(virscr,pfont, 156,160, SCOL, "    Resume game      ");
		textprintf(virscr,pfont, 156,176, SCOL, "    Restart level    ");
		textprintf(virscr,pfont, 156,192, SCOL, "    Quit playing     ");
		textprintf(virscr,pfont, 156,208, SCOL, "                     ");
	#endif

	char selector = 0;

	while(1)
	{
		hline(virscr, 172,160, 307, BGCOL);
		hline(virscr, 172,176, 307, BGCOL);
		hline(virscr, 172,192, 307, BGCOL);
		hline(virscr, 172,208, 307, BGCOL);
		hline(virscr, 172,selector*16+160, 307, SCOL);
		hline(virscr, 172,selector*16+176, 307, SCOL);

		BLIT_NOW;

		wait(100);

		clear_keybuf();
		long ko = readkey();
		ko = ko >> 8;

		if(ko == KEY_SPACE OR ko == KEY_ENTER)
			break;
		if(ko == KEY_UP)
		{
			selector--;
			if(selector < 0)
				selector = 2;
		}
		if(ko == KEY_DOWN)
		{
			selector++;
			if(selector > 2)
				selector = 0;
		}

	}

	vsync();
	blit(backup,virscr, 0,0, 156,112, 168,112);
	destroy_bitmap(backup);
	return (short)selector;

}


inline void intro()
{
	// The main idea is palette-manipulation.

	set_color(BGCOL, basePal + BGCOL);
	set_color(TXCOL, basePal + BGCOL);
	set_color(1, basePal + BGCOL);
	set_color(5, basePal + BGCOL);

	long hicol;
	_getsystime(whatsTheTime);
	if(whatsTheTime->tm_hour > 5 AND whatsTheTime->tm_hour < 20)
		hicol = DAYCOL;
	else
		hicol = NIGHTCOL;
	set_color(hicol, basePal + BGCOL);
	clear_to_color(virscr, BGCOL);
	text_mode(BGCOL);

	drawFrames();

	#ifdef SVENSKA
		textprintf_centre(virscr,pfont, 320,224, TXCOL, "e l   H a m i l   p r e s e n t e r a r");
		text_mode(-1);
		textprintf_centre(virscr,pfont, 320,224, hicol, "      H                                ");
	#else
		textprintf_centre(virscr,pfont, 320,224, TXCOL, "e l   H a m i l   p r e s e n t s");
		text_mode(-1);
		textprintf_centre(virscr,pfont, 320,224, hicol, "      H                          ");
	#endif


	BLIT_NOW;

	for(short i=52;i>0;i--)
	{
		RGB tone = {i,i,i};
		RGB toneHI =
		{
			( basePal[hicol].r*(51-i) + basePal[BGCOL].r*i ) / 51,
			( basePal[hicol].g*(51-i) + basePal[BGCOL].g*i ) / 51,
			( basePal[hicol].b*(51-i) + basePal[BGCOL].b*i ) / 51,
		};
		RGB tonelight =
		{
			( basePal[5].r*(51-i) + basePal[BGCOL].r*i ) / 51,
			( basePal[5].g*(51-i) + basePal[BGCOL].g*i ) / 51,
			( basePal[5].b*(51-i) + basePal[BGCOL].b*i ) / 51,
		};
		RGB tonedark =
		{
			( basePal[1].r*(51-i) + basePal[BGCOL].r*i ) / 51,
			( basePal[1].g*(51-i) + basePal[BGCOL].g*i ) / 51,
			( basePal[1].b*(51-i) + basePal[BGCOL].b*i ) / 51,
		};
		set_color(TXCOL, &tone);
		set_color(hicol, &toneHI);
		set_color(5, &tonelight);
		set_color(1, &tonedark);

		if(key[KEY_2])
			return;

		rest(50);
	}
	for(i=0;i<52;i++)
	{
		RGB tone = {i,i,i};
		RGB toneHI =
		{
			( basePal[hicol].r*(51-i) + basePal[BGCOL].r*i ) / 51,
			( basePal[hicol].g*(51-i) + basePal[BGCOL].g*i ) / 51,
			( basePal[hicol].b*(51-i) + basePal[BGCOL].b*i ) / 51,
		};
		set_color(TXCOL, &tone);
		set_color(hicol, &toneHI);

		if(key[KEY_2])
			return;

		rest(25);
	}

}


inline void loadHiscore()
{

	UCHAR lo;

	// Open the highscore file for reading.
	ifstream fin("scorew.hi", ios::nocreate);

	if(fin.good())
	// If it worked...
	{
		// To prevent people from manually changing the data in the hiscore file, I encrypt
		// it a little. The encryption scheme is extremely simple, probably quite easy to
		// crack if you really go for it, but at least it will stop the majority of people,
		// who don't feel like spending half a day cracking an encryption scheme.

		// There are 5 entries in the hiscore file.
		for(short u=0; u<5; u++)
		{
			// Get name.
			char tempName[25];
			UCHAR nameLength = 0;
			do
			{
				fin.get(lo);

				if(lo % 4 == 3)
					tempName[nameLength] = (UCHAR)(lo - 120);
				if(lo % 4 == 2)
					tempName[nameLength] = (UCHAR)(lo - 116);
				if(lo % 4 == 1)
					tempName[nameLength] = (UCHAR)(lo - 124);
				if(lo % 4 == 0)
					tempName[nameLength] = (UCHAR)(lo - 128);

				nameLength++;
			}
			while(tempName[nameLength - 1]);

			hiscore[u].itsName = new char[nameLength];
			for(short i=0; i<nameLength; i++)
				(hiscore[u].itsName)[i] = tempName[i];

			// Get high byte of time.
			fin.get(lo);

			if(lo % 4 == 3)
				hiscore[u].itsTime = (UCHAR)(lo - 120) << 8;
			if(lo % 4 == 2)
				hiscore[u].itsTime = (UCHAR)(lo - 116) << 8;
			if(lo % 4 == 1)
				hiscore[u].itsTime = (UCHAR)(lo - 124) << 8;
			if(lo % 4 == 0)
				hiscore[u].itsTime = (UCHAR)(lo - 128) << 8;

			// Get low byte of time.
			fin.get(lo);

			if(lo % 4 == 3)
				hiscore[u].itsTime += (UCHAR)(lo - 120);
			if(lo % 4 == 2)
				hiscore[u].itsTime += (UCHAR)(lo - 116);
			if(lo % 4 == 1)
				hiscore[u].itsTime += (UCHAR)(lo - 124);
			if(lo % 4 == 0)
				hiscore[u].itsTime += (UCHAR)(lo - 128);
		}

	}

	else
	// So, the opening was not successful. I guess we have to make a new hiscore-list.
	// Who will be on top of it?
	{
		hiscore[0].itsName = 0;
		hiscore[0].itsName = new char[9];
		if(hiscore[0].itsName)
		{
			*(hiscore[0].itsName+0) = 'e';
			*(hiscore[0].itsName+1) = 'l';
			*(hiscore[0].itsName+2) = ' ';
			*(hiscore[0].itsName+3) = 'H';
			*(hiscore[0].itsName+4) = 'a';
			*(hiscore[0].itsName+5) = 'm';
			*(hiscore[0].itsName+6) = 'i';
			*(hiscore[0].itsName+7) = 'l';
			*(hiscore[0].itsName+8) = 0;
		}
		hiscore[0].itsTime = 240;
		hiscore[1].itsTime = 65534;
		hiscore[2].itsTime = 65534;
		hiscore[3].itsTime = 65534;
		hiscore[4].itsTime = 65534;
	}

	fin.close();

}


inline void saveHiscore()
{
	// Open the highscore file for writing.
	ofstream fout("scorew.hi");

	if(fout.good())
	{
		UCHAR lo;

		for(short u=0; u<5; u++)
		{
			if(hiscore[u].itsTime >= 65534)
			{
				hiscore[u].itsTime = 65534;
				delete[] hiscore[u].itsName;
				hiscore[u].itsName = new char[1];
				*hiscore[u].itsName = 0;
			}

			// Write name.
			for(unsigned short i=0; i<strlen(hiscore[u].itsName)+1; i++)
			{
				if(*(hiscore[u].itsName+i) % 4 == 3)
					fout << (UCHAR)(*(hiscore[u].itsName+i) + 120);
				if(*(hiscore[u].itsName+i) % 4 == 2)
					fout << (UCHAR)(*(hiscore[u].itsName+i) + 116);
				if(*(hiscore[u].itsName+i) % 4 == 1)
					fout << (UCHAR)(*(hiscore[u].itsName+i) + 124);
				if(*(hiscore[u].itsName+i) % 4 == 0)
					fout << (UCHAR)(*(hiscore[u].itsName+i) + 128);
			}

			// Write high byte of time.
			lo = (UCHAR)(hiscore[u].itsTime >> 8);

			if(lo % 4 == 3)
				fout << (UCHAR)(lo + 120);
			if(lo % 4 == 2)
				fout << (UCHAR)(lo + 116);
			if(lo % 4 == 1)
				fout << (UCHAR)(lo + 124);
			if(lo % 4 == 0)
				fout << (UCHAR)(lo + 128);

			// Write low byte of time.
			lo = (UCHAR)(hiscore[u].itsTime % 256);

			if(lo % 4 == 3)
				fout << (UCHAR)(lo + 120);
			if(lo % 4 == 2)
				fout << (UCHAR)(lo + 116);
			if(lo % 4 == 1)
				fout << (UCHAR)(lo + 124);
			if(lo % 4 == 0)
				fout << (UCHAR)(lo + 128);
		}
	}

	fout.close();
}


short showHiscore()
{
	currentPal = lightPal;
	set_palette(currentPal);

	text_mode(-1);
	clear_to_color(virscr, BGCOL);
	drawFrames();

	long hicol;
	_getsystime(whatsTheTime);
	if(whatsTheTime->tm_hour > 5 AND whatsTheTime->tm_hour < 20)
	{
		stretch_sprite(virscr,(BITMAP *)dfil[DSUN].dat, 197,64, 246,232);
		hicol = DAYCOL;
	}
	else
	{
		stretch_sprite(virscr,(BITMAP *)dfil[DMOON].dat, 197,64, 246,232);
		hicol = NIGHTCOL;
	}
	set_color(hicol, basePal+hicol);

	#ifdef SVENSKA
		textprintf(virscr, pfont, 256,96, hicol, "**            **");
		textprintf(virscr, pfont, 280,96, SCOL, "TOPPLISTAN");
		textprintf(virscr, pfont, 240,112, SCOL, "de fem basta tiderna");
	#else
		textprintf(virscr, pfont, 240,96, hicol, "**       **");
		textprintf(virscr, pfont, 264,96, SCOL, "TOP 5");
	#endif

	for(short u=0; u<5; u++)
	{
		unsigned short t = hiscore[u].itsTime;
		if(t < 65534)
		{
			if((short)(t/60) < 10)
			{
				if(t%60 < 10)
					textprintf(virscr, pfont, 240,u*32+144, hicol, "0%d:0%d", (short)(t/60), t%60);
				else
					textprintf(virscr, pfont, 240,u*32+144, hicol, "0%d:%d", (short)(t/60), t%60);
			}
			else
			{
				if(t%60 < 10)
					textprintf(virscr, pfont, 240,u*32+144, hicol, "%d:0%d", (short)(t/60), t%60);
				else
					textprintf(virscr, pfont, 240,u*32+144, hicol, "%d:%d", (short)(t/60), t%60);
			}

			textprintf(virscr, pfont, 288,u*32+144, SCOL, "%s", hiscore[u].itsName);
		}
	}
	BLIT_NOW;
	wait(100);

	clear_keybuf();
	readkey();
	clear_to_color(virscr, BGCOL);

	return 0;
}


inline void enterHiscore(short t)
{
	delete[] hiscore[4].itsName;

	// Look for the right place.
	UCHAR where = 0;
	for(EVER)
	{
		if(t < hiscore[where].itsTime)
			break;
		where++;
	}

	for(UCHAR i=4;i>where;i--)
	{
		hiscore[i].itsName = hiscore[i-1].itsName;
		hiscore[i].itsTime = hiscore[i-1].itsTime;
	}

	hiscore[where].itsTime = t;

	UCHAR max = 24;

	#ifdef SVENSKA
		textprintf(virscr,pfont, 148,256, SCOL, "Skriv in ditt namn:");
		hiscore[where].itsName = kinput(308,256, "",max, 1, 0);
	#else
		textprintf(virscr,pfont, 160,256, SCOL, "Enter your name:");
		hiscore[where].itsName = kinput(296,256, "",max, 1, 0);
	#endif

}


void drawFrames()
{
	long i = 60;
	while(i)
	{
		i--;
		draw_sprite(virscr,(BITMAP *)dfil[DFRAME_G].dat,  57,i<<3);
		draw_sprite(virscr,(BITMAP *)dfil[DFRAME_G].dat, 580,i<<3);
	}
}


void drawFrame()
{
	long i = 60;
	_getsystime(whatsTheTime);
	if(whatsTheTime->tm_hour > 5 AND whatsTheTime->tm_hour < 20)
		while(i)
		{
			i--;
			draw_sprite(virscr,(BITMAP *)dfil[DFRAME_R].dat, 480,i<<3);
		}
	else
		while(i)
		{
			i--;
			draw_sprite(virscr,(BITMAP *)dfil[DFRAME_B].dat, 480,i<<3);
		}
}


inline short loadTile(UCHAR nr)
{
  if(nr >= NRTILES)
    return -1;

  switch(nr)
  {
    case GRASS:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DGRASS].dat;
      tile[nr].walkability = NOSOLID;
      break;
    case TREE:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DTREE].dat;
      tile[nr].walkability = SOLID;
      break;
    case STUB:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DSTUB].dat;
      tile[nr].walkability = SOLID;
      break;
    case KEY:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DKEY].dat;
      tile[nr].walkability = NOSOLID;
      break;
    case CLOSEDGATE:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DCLOSED].dat;
      tile[nr].walkability = SOLID;
      break;
    case OPENGATE:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DOPEN].dat;
      tile[nr].walkability = SOLID;
      break;
    case BUTTON_R:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DSWITCH_R].dat;
      tile[nr].walkability = NOSOLID;
      break;
    case BUTTON_G:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DSWITCH_G].dat;
      tile[nr].walkability = NOSOLID;
      break;
    case BUTTON_B:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DSWITCH_B].dat;
      tile[nr].walkability = NOSOLID;
      break;
    case PIPE_NS_R:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DPIPE_NS_R].dat;
      tile[nr].walkability = SOLID_LEFT + SOLID_RIGHT;
      break;
    case PIPE_WE_R:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DPIPE_WE_R].dat;
      tile[nr].walkability = SOLID_TOP + SOLID_BOTTOM;
      break;
    case PIPE_NS_RG:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DPIPE_NS_RG].dat;
      tile[nr].walkability = SOLID_LEFT + SOLID_RIGHT;
      break;
    case PIPE_WE_RG:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DPIPE_WE_RG].dat;
      tile[nr].walkability = SOLID_TOP + SOLID_BOTTOM;
      break;
    case PIPE_NS_RB:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DPIPE_NS_RB].dat;
      tile[nr].walkability = SOLID_LEFT + SOLID_RIGHT;
      break;
    case PIPE_WE_RB:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DPIPE_WE_RB].dat;
      tile[nr].walkability = SOLID_TOP + SOLID_BOTTOM;
      break;
    case PIPE_NS_G:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DPIPE_NS_G].dat;
      tile[nr].walkability = SOLID_LEFT + SOLID_RIGHT;
      break;
    case PIPE_WE_G:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DPIPE_WE_G].dat;
      tile[nr].walkability = SOLID_TOP + SOLID_BOTTOM;
      break;
    case PIPE_NS_GB:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DPIPE_NS_GB].dat;
      tile[nr].walkability = SOLID_LEFT + SOLID_RIGHT;
      break;
    case PIPE_WE_GB:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DPIPE_WE_GB].dat;
      tile[nr].walkability = SOLID_TOP + SOLID_BOTTOM;
      break;
    case PIPE_NS_B:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DPIPE_NS_B].dat;
      tile[nr].walkability = SOLID_LEFT + SOLID_RIGHT;
      break;
    case PIPE_WE_B:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DPIPE_WE_B].dat;
      tile[nr].walkability = SOLID_TOP + SOLID_BOTTOM;
      break;
    case SPINPIPE_NS:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DPIPE_NS_SPIN].dat;
      tile[nr].walkability = SOLID_LEFT + SOLID_RIGHT;
      break;
    case SPINPIPE_WE:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DPIPE_WE_SPIN].dat;
      tile[nr].walkability = SOLID_TOP + SOLID_BOTTOM;
      break;
    case PIPE_NS:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DPIPE_NS].dat;
      tile[nr].walkability = SOLID_LEFT + SOLID_RIGHT;
      break;
    case PIPE_WE:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DPIPE_WE].dat;
      tile[nr].walkability = SOLID_TOP + SOLID_BOTTOM;
      break;
    case BRANCH_N:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DBRANCH_N].dat;
      tile[nr].walkability = NOSOLID;
      break;
    case BRANCH_W:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DBRANCH_W].dat;
      tile[nr].walkability = NOSOLID;
      break;
    case BRANCH_E:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DBRANCH_E].dat;
      tile[nr].walkability = NOSOLID;
      break;
    case BRANCH_S:
      tile[nr].itsImage = (RLE_SPRITE *)dfil[DBRANCH_S].dat;
      tile[nr].walkability = NOSOLID;
      break;
    default:
      break;
  }

  return 0;
}


inline short loadPandaImage(UCHAR di, UCHAR nr)
// There are 4 directions, and 12 images per direction. But I'm cheating a little;
// there aren't 48 *unique* images, some of them are the same. There are 20 unique images.
{
  if(di >= 4 OR nr >= 12)
    return -1;

  switch(di)
  {
    case NORTH:
      switch(nr)
      {
        case 0:
          pandaPic[di][nr] = (RLE_SPRITE *)dfil[DNORTH0].dat;
          break;
        case 1:
          pandaPic[di][nr] = (RLE_SPRITE *)dfil[DNORTH1].dat;
          break;
        case 2:
          pandaPic[di][nr] = pandaPic[di][1];
          break;
        case 3:
          pandaPic[di][nr] = (RLE_SPRITE *)dfil[DNORTH2].dat;
          break;
        case 4:
          pandaPic[di][nr] = pandaPic[di][3];
          break;
        case 5:
          pandaPic[di][nr] = pandaPic[di][1];
          break;
        case 6:
          pandaPic[di][nr] = pandaPic[di][0];
          break;
        case 7:
          pandaPic[di][nr] = (RLE_SPRITE *)dfil[DNORTH3].dat;
          break;
        case 8:
          pandaPic[di][nr] = pandaPic[di][7];
          break;
        case 9:
          pandaPic[di][nr] = (RLE_SPRITE *)dfil[DNORTH4].dat;
          break;
        case 10:
          pandaPic[di][nr] = pandaPic[di][9];
          break;
        case 11:
          pandaPic[di][nr] = pandaPic[di][7];
          break;
      }
      break;
    case WEST:
      switch(nr)
      {
        case 0:
          pandaPic[di][nr] = (RLE_SPRITE *)dfil[DWEST0].dat;
          break;
        case 1:
          pandaPic[di][nr] = (RLE_SPRITE *)dfil[DWEST1].dat;
          break;
        case 2:
          pandaPic[di][nr] = pandaPic[di][1];
          break;
        case 3:
          pandaPic[di][nr] = (RLE_SPRITE *)dfil[DWEST2].dat;
          break;
        case 4:
          pandaPic[di][nr] = pandaPic[di][3];
          break;
        case 5:
          pandaPic[di][nr] = pandaPic[di][1];
          break;
        case 6:
          pandaPic[di][nr] = pandaPic[di][0];
          break;
        case 7:
          pandaPic[di][nr] = (RLE_SPRITE *)dfil[DWEST3].dat;
          break;
        case 8:
          pandaPic[di][nr] = pandaPic[di][7];
          break;
        case 9:
          pandaPic[di][nr] = (RLE_SPRITE *)dfil[DWEST4].dat;
          break;
        case 10:
          pandaPic[di][nr] = pandaPic[di][9];
          break;
        case 11:
          pandaPic[di][nr] = pandaPic[di][7];
          break;
      }
      break;
    case EAST:
      switch(nr)
      {
        case 0:
          pandaPic[di][nr] = (RLE_SPRITE *)dfil[DEAST0].dat;
          break;
        case 1:
          pandaPic[di][nr] = (RLE_SPRITE *)dfil[DEAST1].dat;
          break;
        case 2:
          pandaPic[di][nr] = pandaPic[di][1];
          break;
        case 3:
          pandaPic[di][nr] = (RLE_SPRITE *)dfil[DEAST2].dat;
          break;
        case 4:
          pandaPic[di][nr] = pandaPic[di][3];
          break;
        case 5:
          pandaPic[di][nr] = pandaPic[di][1];
          break;
        case 6:
          pandaPic[di][nr] = pandaPic[di][0];
          break;
        case 7:
          pandaPic[di][nr] = (RLE_SPRITE *)dfil[DEAST3].dat;
          break;
        case 8:
          pandaPic[di][nr] = pandaPic[di][7];
          break;
        case 9:
          pandaPic[di][nr] = (RLE_SPRITE *)dfil[DEAST4].dat;
          break;
        case 10:
          pandaPic[di][nr] = pandaPic[di][9];
          break;
        case 11:
          pandaPic[di][nr] = pandaPic[di][7];
          break;
      }
      break;
    case SOUTH:
      switch(nr)
      {
        case 0:
          pandaPic[di][nr] = (RLE_SPRITE *)dfil[DSOUTH0].dat;
          break;
        case 1:
          pandaPic[di][nr] = (RLE_SPRITE *)dfil[DSOUTH1].dat;
          break;
        case 2:
          pandaPic[di][nr] = pandaPic[di][1];
          break;
        case 3:
          pandaPic[di][nr] = (RLE_SPRITE *)dfil[DSOUTH2].dat;
          break;
        case 4:
          pandaPic[di][nr] = pandaPic[di][3];
          break;
        case 5:
          pandaPic[di][nr] = pandaPic[di][1];
          break;
        case 6:
          pandaPic[di][nr] = pandaPic[di][0];
          break;
        case 7:
          pandaPic[di][nr] = (RLE_SPRITE *)dfil[DSOUTH3].dat;
          break;
        case 8:
          pandaPic[di][nr] = pandaPic[di][7];
          break;
        case 9:
          pandaPic[di][nr] = (RLE_SPRITE *)dfil[DSOUTH4].dat;
          break;
        case 10:
          pandaPic[di][nr] = pandaPic[di][9];
          break;
        case 11:
          pandaPic[di][nr] = pandaPic[di][7];
          break;
      }
      break;
  }

  return 0;
}


short loadCourse(short which2load)
{
	if(which2load >= NRLEVELS)
		return -1;

	UCHAR tmpMap[NRLEVELS][MAPSIZE][MAPSIZE] =
	{
		{  // 0. Welcome to the world of Panda
			{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0},
			{0,0,0,1,12,12,12,0,12,12,12,12,12,12,1,0,0,0,0,0},
			{0,0,0,11,1,1,0,4,0,1,1,1,1,1,11,0,0,0,0,0},
			{0,0,0,11,1,32,0,0,0,0,1,0,0,0,11,0,0,0,0,0},
			{0,0,0,11,1,0,0,0,0,0,0,3,0,0,11,0,0,0,0,0},
			{0,0,0,11,1,0,0,0,0,0,0,2,0,0,11,0,0,0,0,0},
			{0,0,0,11,1,0,0,0,0,2,0,0,0,0,11,0,0,0,0,0},
			{0,0,0,11,1,1,1,0,0,0,0,0,0,0,11,0,0,0,0,0},
			{0,0,0,11,0,1,1,0,0,0,0,0,0,0,11,0,0,0,0,0},
			{0,0,0,1,12,12,12,12,12,12,12,12,12,12,1,0,0,0,0,0},
			{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
			{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
			{0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1},
			{1,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,0},
			{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
			{1,1,0,1,0,1,0,0,1,1,0,1,0,0,1,1,0,1,1,0},
			{1,1,1,0,1,1,1,1,1,0,1,0,1,1,0,1,1,1,0,1}
		},
		{  // 1. What's that spinning thing?
			{1,1,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0},
			{0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0},
			{1,0,0,0,1,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0},
			{0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0},
			{1,0,1,1,0,0,1,1,1,1,1,1,1,1,0,1,0,0,0,0},
			{0,0,0,1,0,0,1,1,32,0,0,4,1,1,0,0,0,0,0,0},
			{1,1,1,0,1,1,1,1,21,0,0,0,1,1,0,0,0,0,0,0},
			{0,1,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,1,0},
			{1,0,1,1,0,1,1,1,0,3,0,0,1,1,1,1,0,0,0,0},
			{0,0,0,1,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0},
			{1,1,0,0,1,1,0,1,1,1,1,1,1,1,0,0,1,1,0,0},
			{0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0},
			{1,1,0,1,1,0,1,0,1,0,1,1,0,0,1,1,0,0,0,1},
			{1,0,0,1,1,0,1,1,1,1,0,0,0,0,0,0,0,1,0,0},
			{1,1,0,1,0,1,0,1,0,0,1,0,1,1,0,1,0,1,0,0},
			{1,1,1,0,1,1,0,0,1,0,0,0,0,1,0,0,0,0,0,0},
			{1,1,1,1,0,1,1,1,0,0,1,1,0,0,0,1,0,0,1,1},
			{1,1,1,1,1,1,0,1,1,1,0,1,1,1,0,1,1,0,0,0}
		},
		{  // 2. Now there are two keys...
			{1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1},
			{0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0},
			{0,0,0,1,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,1},
			{0,0,0,0,1,0,0,1,1,1,1,0,1,1,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,1,1,0,0,0},
			{0,0,0,1,0,0,1,1,32,0,0,1,1,0,0,0,0,0,0,0},
			{0,0,1,0,1,1,1,1,9,0,0,3,1,1,0,0,0,0,0,0},
			{0,0,0,0,0,0,1,1,0,0,6,0,4,1,1,1,1,0,0,0},
			{1,0,0,1,0,0,1,1,0,3,0,0,1,1,1,0,0,0,0,0},
			{0,0,0,0,0,1,1,1,0,0,0,0,1,1,0,0,1,0,0,0},
			{0,0,0,0,1,1,0,1,1,1,1,1,1,0,1,0,0,0,0,1},
			{0,0,0,0,1,0,0,0,1,1,1,1,0,0,0,1,0,0,0,0},
			{0,1,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0},
			{0,0,0,0,0,0,1,0,0,1,1,0,1,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0},
			{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
			{0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0},
			{1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1}
		},
		{  // 3. Deja vu?
			{1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,1,1,0,1},
			{1,1,1,1,0,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0},
			{1,1,1,0,1,1,1,0,0,0,1,1,1,1,1,0,0,0,0,0},
			{1,0,1,1,1,1,3,0,2,0,0,0,3,1,1,0,1,1,0,0},
			{1,1,1,0,1,1,0,0,0,0,1,1,0,1,1,0,0,0,0,0},
			{1,0,1,1,1,1,1,0,0,0,1,1,0,1,1,1,0,0,0,0},
			{1,1,1,1,1,0,0,0,0,0,0,1,0,1,1,1,1,0,0,0},
			{1,1,1,4,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0},
			{0,1,1,1,1,0,0,0,0,29,0,0,0,2,0,1,1,0,0,0},
			{1,0,1,1,1,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0},
			{1,0,0,1,1,0,0,0,0,0,1,1,0,1,1,1,1,0,0,0},
			{0,0,1,1,1,0,0,2,0,0,0,1,1,1,1,1,0,0,0,1},
			{1,0,1,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0},
			{1,1,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,7},
			{0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,7,7},
			{1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,7,7,7},
			{0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7},
			{1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,7,7,7,7,7},
			{0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7},
			{0,0,0,0,0,0,0,0,0,0,0,1,0,7,7,7,7,7,7,7}
		},
		{  // 4. Follow the Way of Panda
			{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
			{0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
			{0,1,1,0,1,1,0,1,1,1,1,1,1,1,1,1,0,1,1,0},
			{1,1,0,1,1,1,1,1,1,1,1,1,0,1,1,0,1,1,1,0},
			{1,0,1,0,0,0,1,0,1,1,0,1,1,1,0,1,1,0,0,1},
			{0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1},
			{1,0,1,0,0,0,0,1,1,0,1,1,1,0,0,1,0,0,0,0},
			{0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,0,0,1,1,0},
			{1,0,1,1,0,0,0,1,2,0,32,0,0,0,1,1,0,0,0,1},
			{0,0,0,0,0,1,0,1,0,0,0,4,0,0,1,1,0,1,0,0},
			{0,2,0,0,0,0,0,1,8,0,9,6,0,13,1,0,0,0,0,0},
			{0,0,0,2,0,0,0,0,1,1,1,0,3,8,1,0,0,0,0,2},
			{0,0,0,0,0,0,2,0,0,2,1,0,0,0,1,2,0,0,0,0},
			{0,2,0,0,0,0,2,0,0,0,0,1,1,1,0,0,0,0,2,0},
			{0,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,2,0,0,0},
			{2,0,2,0,0,2,0,0,0,0,2,0,0,2,0,0,2,0,0,2},
			{0,2,0,0,0,0,0,2,0,2,0,2,0,0,2,0,0,0,0,2},
			{2,0,2,0,0,2,0,0,0,0,0,0,2,0,0,0,2,0,2,0},
			{0,0,0,0,2,0,0,0,2,0,2,2,0,0,2,2,0,0,0,2},
			{2,2,0,2,0,0,2,2,0,2,0,0,0,0,2,0,2,0,2,2}
		},
    {  // 5. Little brother
      {0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
      {0,1,1,0,0,2,0,0,0,0,0,0,0,4,3,1,1,1,1,0},
      {0,1,1,0,10,0,0,0,0,0,0,32,0,0,10,0,1,1,1,0},
      {0,1,1,0,3,0,0,0,0,0,1,2,1,0,0,0,0,1,1,0},
      {0,1,1,0,1,0,0,0,0,0,0,6,0,0,0,0,0,1,1,0},
      {0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0},
      {0,1,1,1,0,2,0,0,0,0,0,0,1,0,0,0,0,1,1,0},
      {0,1,1,0,0,0,0,0,0,2,0,0,0,0,0,1,0,1,1,0},
      {0,1,1,0,0,0,0,0,0,0,0,0,0,2,0,0,0,1,1,0},
      {0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0},
      {0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {2,2,2,0,2,0,0,0,2,0,0,2,2,0,0,0,2,2,0,0},
      {2,0,0,0,2,0,0,0,2,0,2,0,0,2,0,2,0,0,2,0},
      {2,0,0,0,2,0,0,0,2,0,2,0,0,2,0,2,0,0,0,0},
      {2,2,0,0,2,0,0,0,2,0,2,2,2,2,0,0,2,2,0,0},
      {2,0,0,0,2,0,0,0,2,0,2,0,0,2,0,0,0,0,2,0},
      {2,0,0,0,2,0,0,0,2,0,2,0,0,2,0,2,0,0,2,0},
      {2,2,2,0,2,2,2,0,2,0,2,0,0,2,0,0,2,2,0,0},
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    {  // 6. Panda is trapped!
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0},
      {0,0,0,0,0,1,1,1,1,1,8,1,1,1,1,0,0,0,0,0},
      {0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0},
      {0,0,0,1,1,1,1,0,0,0,0,0,0,11,1,1,1,0,0,0},
      {0,0,1,1,1,3,0,0,9,16,32,0,0,0,6,1,1,1,0,0},
      {0,1,1,1,1,1,2,0,0,0,0,0,0,7,1,1,1,1,1,0},
      {0,0,1,1,1,1,6,0,20,0,0,1,1,1,1,1,1,1,0,0},
      {0,0,0,1,1,1,1,1,1,1,4,1,1,1,1,1,1,0,0,0},
      {0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0},
      {0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0},
      {0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0},
      {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
    },
    {  // 7. The level of long moves
      {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
      {1,0,1,6,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
      {1,0,0,14,0,0,0,0,2,0,3,0,0,0,0,0,0,0,0,1},
      {1,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,1},
      {1,0,0,0,1,1,0,0,0,0,0,8,0,1,0,0,0,0,0,1},
      {1,0,0,0,1,0,0,0,32,0,0,0,0,1,0,3,0,0,0,1},
      {1,1,1,11,0,0,0,0,0,0,0,1,1,1,0,10,0,0,0,1},
      {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
      {1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1},
      {1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,1},
      {1,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
      {1,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
      {1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,10,0,0,0,1},
      {1,0,0,0,0,0,0,1,0,0,0,1,1,0,0,0,0,4,0,1},
      {1,0,0,0,0,0,0,1,0,2,0,0,1,0,0,0,0,0,0,1},
      {1,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,1},
      {1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1},
      {1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
      {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1},
      {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}
    },
    {  // 8. In the deep forest
      {1,1,0,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,0,1},
      {1,1,1,0,1,1,1,1,1,1,1,1,1,1,0,1,1,0,1,1},
      {1,0,1,1,1,1,0,0,0,0,0,1,1,0,1,1,1,1,0,1},
      {1,1,1,0,1,1,0,1,0,6,0,1,1,1,1,0,1,1,1,0},
      {1,0,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,1,0,1},
      {1,1,0,1,1,1,1,0,0,0,0,1,1,1,0,1,1,1,1,1},
      {1,1,1,0,1,1,1,0,0,0,0,1,1,1,1,0,1,1,0,1},
      {0,1,0,1,1,1,1,0,0,9,0,0,0,1,1,1,0,1,1,0},
      {1,0,1,1,1,0,0,0,0,0,0,0,0,1,1,0,1,1,0,1},
      {1,1,1,1,8,0,0,0,0,0,0,0,1,1,1,1,0,1,1,1},
      {0,1,1,1,0,0,0,0,0,0,18,0,0,1,1,1,1,1,1,0},
      {1,1,1,1,1,0,0,0,0,0,0,0,0,13,3,1,1,1,0,1},
      {1,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1},
      {0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0},
      {1,1,1,31,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1},
      {1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1},
      {1,0,1,1,1,1,0,0,0,0,0,10,1,1,1,1,0,1,1,1},
      {0,1,1,0,1,1,1,1,4,0,1,3,1,1,1,1,1,1,0,1},
      {1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,1,0},
      {1,1,1,1,0,1,0,1,1,1,1,1,1,1,1,0,1,1,1,1}
    },
    {  // 9. Is this reality?
      {0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0},
      {0,0,0,1,1,1,1,6,1,8,1,1,1,0,0,0,0,0,0,0},
      {0,0,1,1,1,2,0,10,12,0,32,1,1,1,0,0,0,0,0,0},
      {0,0,1,1,1,0,0,0,1,0,0,0,1,1,1,0,0,0,0,0},
      {0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0},
      {0,1,1,0,0,1,0,0,0,0,0,12,0,0,1,1,1,0,0,0},
      {0,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0,0,0},
      {1,1,1,1,0,10,0,0,0,0,0,0,0,0,1,1,1,1,0,0},
      {1,1,1,0,0,0,0,0,2,0,7,0,0,0,0,1,1,1,1,0},
      {1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,0},
      {0,1,1,1,0,0,0,3,0,0,0,10,0,0,1,1,1,1,1,0},
      {0,1,1,0,11,0,0,6,0,0,0,0,0,0,0,1,1,1,1,0},
      {1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0},
      {1,1,0,0,0,0,4,0,0,0,0,0,1,1,1,1,1,0,0,0},
      {1,0,0,0,0,0,0,10,0,13,2,0,0,1,1,1,1,0,0,0},
      {1,0,0,13,0,0,1,1,0,0,1,7,0,0,1,1,0,0,0,0},
      {1,1,0,0,0,0,1,1,1,0,1,0,0,1,1,1,0,0,0,0},
      {1,1,0,0,2,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0},
      {1,1,1,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0},
      {0,1,1,1,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0}
    },
    {  // 10. One hundred and one key
      {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,4},
      {1,2,1,3,3,0,0,0,0,0,0,0,3,1,1,1,1,0,3,3},
      {1,1,1,3,6,10,3,22,21,22,21,22,21,3,3,3,3,3,3,1},
      {1,3,3,1,21,0,0,0,0,0,0,0,3,1,1,1,1,3,3,1},
      {1,3,0,0,21,0,0,1,3,0,0,0,0,3,3,3,1,1,3,1},
      {1,3,0,0,21,0,3,1,3,0,0,0,0,0,0,3,1,3,3,1},
      {2,1,3,0,21,0,0,0,0,0,0,0,0,0,3,0,1,3,1,1},
      {1,0,3,0,21,0,0,0,0,0,0,0,0,0,1,0,1,3,3,1},
      {1,0,3,0,0,0,3,0,3,0,0,0,0,3,3,3,1,1,3,1},
      {1,0,0,0,0,0,3,0,1,1,1,7,1,6,3,3,1,3,3,1},
      {1,0,0,3,0,3,3,0,1,32,1,3,0,0,0,1,1,3,1,2},
      {1,0,0,0,1,0,0,0,1,6,1,1,0,0,0,3,1,3,3,1},
      {1,0,3,0,0,0,3,0,1,21,0,9,0,0,0,3,1,1,3,1},
      {1,0,3,0,0,0,0,0,1,0,1,3,0,0,3,1,1,3,3,1},
      {1,0,0,0,0,0,3,3,1,8,1,0,0,0,0,3,1,3,3,1},
      {1,3,0,0,0,0,3,3,1,13,1,0,0,0,0,3,1,3,1,1},
      {1,3,3,0,0,0,3,3,1,1,1,3,0,0,0,3,1,3,3,1},
      {1,3,3,0,0,0,3,3,1,1,1,0,0,0,0,3,1,1,12,1},
      {1,3,3,3,3,3,3,3,1,2,1,3,3,3,3,3,1,3,0,1},
      {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}
    }
  };


	if(which2load == 0)
	{
		#ifdef SVENSKA
			setTitle("Valkommen till Pandas varld");
		#else
			setTitle("Welcome to the world of Panda");
		#endif
			thisCourse.bestResult = 8;
	}

	if(which2load == 1)
	{
		#ifdef SVENSKA
			setTitle("Vad ar det for snurrande sak?");
		#else
			setTitle("What's that spinning thing?");
		#endif
		thisCourse.bestResult = 6;
	}

	if(which2load == 2)
	{
		#ifdef SVENSKA
			setTitle("Nu finns det tva nycklar...");
		#else
			setTitle("Now there are two keys...");
		#endif
		thisCourse.bestResult = 11;
	}

	if(which2load == 3)
	{
		setTitle("Deja vu?");
		thisCourse.bestResult = 24;
	}

	if(which2load == 4)
	{
		#ifdef SVENSKA
			setTitle("Pandas vagar aro outgrundliga");
		#else
			setTitle("Follow the Way of Panda");
		#endif
		thisCourse.bestResult = 5;
	}

	if(which2load == 5)
	{
		#ifdef SVENSKA
			setTitle("Lillebror");
		#else
			setTitle("Little brother");
		#endif
		thisCourse.bestResult = 20;
	}

	if(which2load == 6)
	{
		#ifdef SVENSKA
			setTitle("Panda ar fangad!");
		#else
			setTitle("Panda is trapped!");
		#endif
		thisCourse.bestResult = 11;
	}

	if(which2load == 7)
	{
		#ifdef SVENSKA
			setTitle("De langa dragens bana");
		#else
			setTitle("The level of long moves");
		#endif
		thisCourse.bestResult = 57;
	}

	if(which2load == 8)
	{
		#ifdef SVENSKA
			setTitle("Ror pa dig i den djupa skogen");
		#else
			setTitle("In the deep forest");
		#endif
		thisCourse.bestResult = 42;
	}

	if(which2load == 9)
	{
		#ifdef SVENSKA
			setTitle("Ar detta verklighet?");
		#else
			setTitle("Is this reality?");
		#endif
		thisCourse.bestResult = 26;
	}

	if(which2load == 10)
	{
		#ifdef SVENSKA
			setTitle("Hundra och en nyckel");
		#else
			setTitle("One hundred and one key");
		#endif
		thisCourse.bestResult = 0;
	}



	thisCourse.nrKeys = 0;

	for(short y=0;y<MAPSIZE;y++)
		for(short x=0;x<MAPSIZE;x++)
		{
			if(tmpMap[which2load][y][x] == KEY)
				thisCourse.nrKeys++;

			if(tmpMap[which2load][y][x] >= PANDAHERE_N AND tmpMap[which2load][y][x] <= PANDAHERE_S)
			{
				thisCourse.startX = x;
				thisCourse.startY = y;
				thisCourse.startDirection = tmpMap[which2load][y][x] - PANDAHERE_N;
				tmpMap[which2load][y][x] = 0;
			}

			thisCourse.map[y][x] = tmpMap[which2load][y][x];
		}

	return 0;
}


void setTitle(char * title)
{
	thisCourse.itsTitle = new char[(UCHAR)(strlen(title)) + 1];
	for(short i=0; i<=(UCHAR)(strlen(title)); i++)
		thisCourse.itsTitle[i] = title[i];
}


inline void ending(short t)
{
	currentPal = basePal;
	set_palette(currentPal);
	clear_to_color(virscr, BGCOL);
	drawFrames();

	long hicol;
	_getsystime(whatsTheTime);
	if(whatsTheTime->tm_hour > 5 AND whatsTheTime->tm_hour < 20)
	{
		stretch_sprite(virscr,(BITMAP *)dfil[DSUN].dat, 197,64, 246,232);
		hicol = DAYCOL;
	}
	else
	{
		stretch_sprite(virscr,(BITMAP *)dfil[DMOON].dat, 197,64, 246,232);
		hicol = NIGHTCOL;
	}

	BITMAP * credits = create_bitmap(1280,144);
	clear_to_color(credits, BGCOL);


	textprintf(credits, pfont, 0,0, hicol, "Panda 2");
	#ifdef SVENSKA
		textprintf(credits, pfont,  256,0, hicol, "Programmering");
		textprintf(credits, pfont,  512,0, hicol, "Grafik");
		textprintf(credits, pfont,  768,0, hicol, "Speldesign");
		textprintf(credits, pfont, 1024,0, hicol, "Banor");
	#else
		textprintf(credits, pfont,  256,0, hicol, "Programming");
		textprintf(credits, pfont,  512,0, hicol, "Graphics");
		textprintf(credits, pfont,  768,0, hicol, "Game design");
		textprintf(credits, pfont, 1024,0, hicol, "Level design");
	#endif
	textprintf(credits, pfont,  256, 32, SCOL, " el Hamil");
	textprintf(credits, pfont,  512, 32, SCOL, " el Hamil");
	textprintf(credits, pfont,  768, 32, SCOL, " el Hamil");
	textprintf(credits, pfont, 1024, 32, SCOL, " el Hamil");
	textprintf(credits, pfont, 1024, 64, SCOL, " Elias Hall");
	textprintf(credits, pfont, 1024, 96, SCOL, " Micke Hansson");
	textprintf(credits, pfont, 1024,128, SCOL, " Krister Trangius");

	for(long posx=519; posx>0; posx -= 2)
	{
		long startTime = GetTickCount();
		blit(credits,virscr, 0,0, posx+60,320, 519-posx,144);
		BLIT_NOW;
		while(GetTickCount() - startTime < 16);
	}
	for(posx=0; posx<760; posx += 2)
	{
		long startTime = GetTickCount();
		blit(credits,virscr, posx,0, 60,320, 519,144);
		BLIT_NOW;
		while(GetTickCount() - startTime < 16);
	}
	for(posx=0; posx<520; posx += 2)
	{
		long startTime = GetTickCount();
		blit(credits,virscr, posx+760,0, 60,320, 519-posx,144);
		BLIT_NOW;
		while(GetTickCount() - startTime < 16);
	}

	destroy_bitmap(credits);


	currentPal = lightPal;
	set_palette(currentPal);
	text_mode(-1);

	if((short)(t/60) < 10)
	{
		if(t%60 < 10)
			#ifdef SVENSKA
				textprintf_centre(virscr,pfont, 320,200, SCOL, "Du klarade hela spelet pa 0%d:0%d", (short)(t/60), t%60);
			#else
				textprintf_centre(virscr,pfont, 320,200, SCOL, "You finished the whole game in 0%d:0%d", (short)(t/60), (t/1000)%60);
			#endif
		else
			#ifdef SVENSKA
				textprintf_centre(virscr,pfont, 320,200, SCOL, "Du klarade hela spelet pa 0%d:%d", (short)(t/60), t%60);
			#else
				textprintf_centre(virscr,pfont, 320,200, SCOL, "You finished the whole game in 0%d:%d", (short)(t/60), t%60);
			#endif
	}
	else
	{
		if(t%60 < 10)
			#ifdef SVENSKA
				textprintf_centre(virscr,pfont, 320,200, SCOL, "Du klarade hela spelet pa %d:0%d", (short)(t/60), t%60);
			#else
				textprintf_centre(virscr,pfont, 320,200, SCOL, "You finished the whole game in %d:0%d", (short)(t/60), t%60);
			#endif
		else
			#ifdef SVENSKA
				textprintf_centre(virscr,pfont, 320,200, SCOL, "Du klarade hela spelet pa %d:%d", (short)(t/60), t%60);
			#else
				textprintf_centre(virscr,pfont, 320,200, SCOL, "You finished the whole game in %d:%d", (short)(t/60), t%60);
			#endif
	}
	if(t < hiscore[4].itsTime)
	{
		#ifdef SVENSKA
			textprintf_centre(virscr,pfont, 320,224, SCOL, "Du kom in pa topplistan!");
		#else
			textprintf_centre(virscr,pfont, 320,224, SCOL, "You made it into the Top 5!");
		#endif
		BLIT_NOW;
		clear_keybuf();
		readkey();
		enterHiscore(t);
		showHiscore();
	}
	else
	{
		if((short)(t/60) >= 8)
			#ifdef SVENSKA
				textprintf_centre(virscr,pfont, 320,224, SCOL, "Det var inget vidare resultat...");
			#else
				textprintf_centre(virscr,pfont, 320,224, SCOL, "That's not too impressive...");
			#endif
		BLIT_NOW;
		clear_keybuf();
		readkey();
	}
}


inline void printLevelTitle()
{
	short textWidth = text_length(pfont, thisCourse.itsTitle) + 32;
	BITMAP * backup = create_bitmap(textWidth, 32);
	blit(virscr,backup, 240-textWidth/2,216, 0,0, textWidth,32);

	text_mode(BGCOL);
	textprintf_centre(virscr,pfont, 240,216, BGCOL, " %s ", thisCourse.itsTitle);
	textprintf_centre(virscr,pfont, 240,232, BGCOL, " %s ", thisCourse.itsTitle);
	textprintf_centre(virscr,pfont, 240,224, BGCOL, "  %s  ", thisCourse.itsTitle);
	textprintf_centre(virscr,pfont, 240,224, SCOL, " %s ", thisCourse.itsTitle);

	delete[] thisCourse.itsTitle;
	thisCourse.itsTitle = 0;

	BLIT_NOW;

	// Wait here until a key is pressed.
	clear_keybuf();
	readkey();

	// Fade from the monochrome palette to a more colorful one.
	fade_from(lightPal,basePal, 4);

	rest(100);

	// Erease the title from the screen.
	blit(backup,virscr, 0,0, 240-textWidth/2,216, textWidth,32);

	BLIT_NOW;

	destroy_bitmap(backup);
}


inline void printCourseNr(short nr)
{
	#ifdef SVENSKA
		textprintf(virscr,pfont, 504,32, TXCOL, "Bana %d / %d", nr+1, NRLEVELS);
	#else
		textprintf(virscr,pfont, 504,32, TXCOL, "Level %d / %d", nr+1, NRLEVELS);
	#endif
}


inline void printLevelTime(short t)
{
	if((short)(t/60) < 10)
	{
		if(t%60 < 10)
			textprintf(virscr,pfont, 504,64, TXCOL, "0%d:0%d", (short)(t/60), t%60);
		else
			textprintf(virscr,pfont, 504,64, TXCOL, "0%d:%d", (short)(t/60), t%60);
	}
	else
	{
		if(t%60 < 10)
			textprintf(virscr,pfont, 504,64, TXCOL, "%d:0%d", (short)(t/60), t%60);
		else
			textprintf(virscr,pfont, 504,64, TXCOL, "%d:%d", (short)(t/60), t%60);
	}
}


inline void printNrKeys(short nr)
{
	if(thisCourse.nrKeys == 1)
		#ifdef SVENSKA
			textprintf(virscr,pfont, 504,96, TXCOL, "%d / %d nyckel", nr, thisCourse.nrKeys);
		#else
			textprintf(virscr,pfont, 504,96, TXCOL, "%d / %d key", nr, thisCourse.nrKeys);
		#endif
	else
		#ifdef SVENSKA
			textprintf(virscr,pfont, 504,96, TXCOL, "%d / %d nycklar", nr, thisCourse.nrKeys);
		#else
			textprintf(virscr,pfont, 504,96, TXCOL, "%d / %d keys", nr, thisCourse.nrKeys);
		#endif
}


inline void printNrMoves(short nr)
{
	#ifdef SVENSKA
		textprintf(virscr,pfont, 504,144, TXCOL, "%d drag", nr);
	#else
		textprintf(virscr,pfont, 504,144, TXCOL, "%d moves", nr);
	#endif
}

inline void printBestMoves()
{
	if(thisCourse.bestResult)
		#ifdef SVENSKA
			textprintf(virscr,pfont, 504,168, TXCOL, "av %d nodvandiga", thisCourse.bestResult);
		#else
			textprintf(virscr,pfont, 488,168, TXCOL, "out of %d necessary", thisCourse.bestResult);
		#endif
}


inline void drawTile(short xloc, short yloc, UCHAR which)
{
	draw_rle_sprite(virscr,tile[which].itsImage, xloc*TILESIZE,yloc*TILESIZE);
}


void endOfLevel()
{
	#ifdef SVENSKA
		textprintf_centre(virscr,pfont, 240,224, SCOL, " Du klarade banan! ");
	#else
		textprintf_centre(virscr,pfont, 240,224, SCOL, " You made it! ");
	#endif
	BLIT_NOW;
	clear_keybuf();
	readkey();
}




inline short levelEditor()
{
  CourseClass theLevel;

  UCHAR markerX = 0, markerY = 0;
  UCHAR tileSelectMarker = TREE;
  UCHAR tile2Put = TREE;
  UCHAR justSaved = 1;

  theLevel.startX = 9; theLevel.startY = 9;
  theLevel.startDirection = SOUTH;

  for(short y=0; y<MAPSIZE; y++)
    for(short x=0; x<MAPSIZE; x++)
      theLevel.map[y][x] = GRASS;

  clear(virscr);
  printInfo(tile2Put);

	wait(100);


  for(EVER)  // Main level editor loop.
  {

    // Draw.
    for(long y=0; y<MAPSIZE; y++)
      for(long x=0; x<MAPSIZE; x++)
      {
        drawTile(x,y, GRASS);
        if(theLevel.map[y][x])
        {
          if(theLevel.map[y][x] >= PIPE_NS_R AND theLevel.map[y][x] <= SPINPIPE_WE)
          {
            if(theLevel.map[y][x] % 2)
              drawTile(x,y, PIPE_NS);
            else
              drawTile(x,y, PIPE_WE);
          }
          drawTile(x,y, theLevel.map[y][x]);
        }
      }

    draw_rle_sprite(virscr,pandaPic[theLevel.startDirection][0], theLevel.startX*TILESIZE,theLevel.startY*TILESIZE);

    // Draw the marker.
    hline(virscr, markerX*TILESIZE, markerY*TILESIZE, (markerX+1)*TILESIZE-1, TXCOL);
    vline(virscr, markerX*TILESIZE, markerY*TILESIZE, (markerY+1)*TILESIZE-1, TXCOL);
    hline(virscr, markerX*TILESIZE, (markerY+1)*TILESIZE-1, (markerX+1)*TILESIZE-1, TXCOL);
    vline(virscr, (markerX+1)*TILESIZE-1, markerY*TILESIZE, (markerY+1)*TILESIZE-1, TXCOL);

	BLIT_NOW;

    // Get user input, and respond to it.

		wait(40);
    clear_keybuf();
    long userCommand = readkey();
    userCommand = userCommand >> 8;

    if(userCommand == KEY_ESC)
    {
      if(justSaved)
        break;
      else
      {
        set_palette(lightPal);
        BITMAP * backup = create_bitmap(640,16);
        blit(virscr,backup, 0,200, 0,0, 640,16);
        #ifdef SVENSKA
          message("Vill du spara innan du avslutar? (Ja/Nej/Avbryt)");
          tryAgain:
			wait(40);
          userCommand = readkey();
          userCommand = userCommand >> 8;
          if(userCommand != KEY_J AND userCommand != KEY_N AND userCommand != KEY_A)
            goto tryAgain;
          blit(backup,virscr, 0,0, 0,200, 640,16);
          destroy_bitmap(backup);
          if(userCommand == KEY_J)
          {
            justSaved = (UCHAR)save2File(theLevel);
            set_palette(basePal);
            if(justSaved)
              break;
          }
          set_palette(basePal);
          if(userCommand == KEY_N)
            break;
        #else
          message("Want to save before exiting? (Yes/No/Cancel)");
          tryAgain:
          userCommand = readkey();
          userCommand = userCommand >> 8;
          if(userCommand != KEY_Y AND userCommand != KEY_N AND userCommand != KEY_C  AND userCommand != KEY_ESC)
            goto tryAgain;
          blit(backup,virscr, 0,0, 0,200, 640,16);
          destroy_bitmap(backup);
          if(userCommand == KEY_Y)
          {
            justSaved = (UCHAR)save2File(theLevel);
            set_palette(basePal);
            if(justSaved)
              break;
          }
          set_palette(basePal);
          if(userCommand == KEY_N)
            break;
        #endif
      }
      printInfo(tile2Put);
    }

    if(userCommand == KEY_S)
    {
		wait(100);
      set_palette(lightPal);
      if(save2File(theLevel))
        justSaved = 1;
      set_palette(basePal);
    }

    if(userCommand == KEY_O)
    {
		wait(100);
      set_palette(lightPal);
      #ifdef SVENSKA
        message("Oppna fil:");
      #else
        message("Open file:");
      #endif

      // Let the user enter the name of the file to open.
      UCHAR max = 8;
      char * tempname = kinput(128,200, "",max, 0, 1);

      if(tempname)
      {
        char * cFilename = new char[max+4];
        for(UCHAR g=0;g<max;g++)
          cFilename[g] = tempname[g];
        delete[] tempname;
        cFilename[max-1] = '.';
        cFilename[max] = 'p';
        cFilename[max+1] = 'a';
        cFilename[max+2] = 'n';
        cFilename[max+3] = 0;
        if(loadFromFile(theLevel, cFilename))
           justSaved = 1;
        else
        {
          textprintf(virscr,pfont, 128,200, SCOL, "%s", cFilename);
          #ifdef SVENSKA
            textprintf(virscr,pfont, 24,224, SCOL, " Det gick inte att oppna filen. ");
          #else
            textprintf(virscr,pfont, 24,224, SCOL, " Couldn't open file. ");
          #endif
          BLIT_NOW;
          clear_keybuf();
          readkey();
        }
		delete[] cFilename;
      }
      set_palette(basePal);
      printInfo(tile2Put);
    }

    if(userCommand == KEY_UP)
      if(markerY > 0)
        markerY--;

    if(userCommand == KEY_LEFT)
      if(markerX > 0)
        markerX--;

    if(userCommand == KEY_RIGHT)
      if(markerX < 19)
        markerX++;

    if(userCommand == KEY_DOWN)
      if(markerY < 19)
        markerY++;

    if(userCommand == KEY_T)
    {
		wait(100);
      set_palette(lightPal);
      #ifdef SVENSKA
        message("Titel:");
      #else
        message("Title:");
      #endif

      UCHAR max = 56;
      char * tempTitle = 0;
      if(theLevel.itsTitle)
        tempTitle = kinput(96,200, theLevel.itsTitle,max, 1,1);
      else
        tempTitle = kinput(96,200, "",max, 1,1);
      if(tempTitle)
      {
			if(theLevel.itsTitle)
			{
				for(short g=0;g<max;g++)
					if(tempTitle[g] != theLevel.itsTitle[g])
						justSaved = 0;

				delete[] theLevel.itsTitle;
			}
			else
				justSaved = 0;
			theLevel.itsTitle = tempTitle;
      }
      set_palette(basePal);
      printInfo(tile2Put);
    }

    if(userCommand == KEY_DEL)
    {
      if(theLevel.map[markerY][markerX])
        justSaved = 0;
      theLevel.map[markerY][markerX] = 0;
    }

    if(userCommand == KEY_SPACE)
    {
      if(tile2Put >= PANDAHERE_N AND tile2Put <= PANDAHERE_S)
      {
        if(theLevel.startX != markerX OR theLevel.startY != markerY OR
           theLevel.startDirection != tile2Put - PANDAHERE_N )
          justSaved = 0;
        theLevel.startX = markerX;
        theLevel.startY = markerY;
        theLevel.startDirection = tile2Put - PANDAHERE_N;
        theLevel.map[markerY][markerX] = 0;
      }
      else
        if(markerX != theLevel.startX OR markerY != theLevel.startY)
        {
          if(theLevel.map[markerY][markerX] != tile2Put)
            justSaved = 0;
          theLevel.map[markerY][markerX] = tile2Put;
        }
    }

    if(userCommand == KEY_ENTER)
    {
		wait(100);
      selectTile(tileSelectMarker, tile2Put);
      printInfo(tile2Put);
		wait(100);
    }

//    if(userCommand == KEY_3)
//      save4Use(theLevel);

  }

  delete[] theLevel.itsTitle;

  return 0;
}

void message(char * string)
{
  textprintf(virscr,pfont, 24,200, SCOL, " %s ", string);
  BLIT_NOW;
}

void printInfo(UCHAR theTile)
// Prints out all that info on the right side in the level editor.
{
	text_mode(BGCOL);

	// Empty the area that we will use (the right side of the screen, if you have forgotten).
	rectfill(virscr, 480,0, 639,479, BGCOL);

	drawFrame();

	long hicol;
	_getsystime(whatsTheTime);
	if(whatsTheTime->tm_hour > 5 AND whatsTheTime->tm_hour < 20)
		hicol = DAYCOL;
	else
		hicol = NIGHTCOL;

  // Draw the selected tile in the bottom-right corner of the screen,
  draw_rle_sprite(virscr,tile[GRASS].itsImage, 548,400);
  if(theTile >= PANDAHERE_N AND theTile <= PANDAHERE_S)
    draw_rle_sprite(virscr, pandaPic[theTile-PANDAHERE_N][0], 548,400);
  else
    if(theTile)
    {
      if(theTile >= PIPE_NS_R AND theTile <= SPINPIPE_WE)
      {
        if(theTile % 2)
          draw_rle_sprite(virscr,tile[PIPE_NS].itsImage, 548,400);
        else
          draw_rle_sprite(virscr,tile[PIPE_WE].itsImage, 548,400);
      }
      draw_rle_sprite(virscr,tile[theTile].itsImage, 548,400);
    }

  textprintf(virscr,pfont, 488,16, TXCOL, "Panda 2");

  #ifdef SVENSKA

    textprintf(virscr,pfont, 488,32, TXCOL, "baneditor");
    textprintf(virscr,pfont, 488,80, TXCOL, "Kommandon:");
    textprintf(virscr,pfont, 488,104, TXCOL, "O - Oppna");
    textprintf(virscr,pfont, 488,104, hicol, "O");
    textprintf(virscr,pfont, 488,120, TXCOL, "S - Spara");
    textprintf(virscr,pfont, 488,120, hicol, "S");
    textprintf(virscr,pfont, 488,136, TXCOL, "ESC - avsluta");
    textprintf(virscr,pfont, 488,136, hicol, "ESC");
    textprintf(virscr,pfont, 488,152, TXCOL, "T - Titel");
    textprintf(virscr,pfont, 488,152, hicol, "T");
    textprintf(virscr,pfont, 488,172, TXCOL, "Enter -");
    textprintf(virscr,pfont, 488,172, hicol, "Enter");
    textprintf(virscr,pfont, 488,186, TXCOL, "valja byggsten");
    textprintf(virscr,pfont, 488,206, TXCOL, "Mellanslag -");
    textprintf(virscr,pfont, 488,206, hicol, "Mellanslag");
    textprintf(virscr,pfont, 488,222, TXCOL, "placera ut byggsten");
    textprintf(virscr,pfont, 488,242, TXCOL, "Del - radera");
    textprintf(virscr,pfont, 488,242, hicol, "Del");
    textprintf_centre(virscr,pfont, 559,376, TXCOL, "Byggsten:");

	// Print the name of the currently selected tile right above it.
    switch(theTile)
    {
      case TREE:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Trad");
        break;
      case STUB:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Stubbe");
        break;
      case KEY:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Nyckel");
        break;
      case CLOSEDGATE:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Stangd port");
        break;
      case OPENGATE:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Oppen port");
        break;
      case BUTTON_R:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Rod knapp");
        break;
      case BUTTON_G:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Gron knapp");
        break;
      case BUTTON_B:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Bla knapp");
        break;
      case PIPE_NS_R:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Rott ror NS");
        break;
      case PIPE_NS_G:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Gront ror NS");
        break;
      case PIPE_NS_B:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Blatt ror NS");
        break;
      case PIPE_NS_RG:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Rodgront ror NS");
        break;
      case PIPE_NS_RB:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Rodblatt ror NS");
        break;
      case PIPE_NS_GB:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Gronblatt ror NS");
        break;
      case SPINPIPE_NS:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Snurr-ror NS");
        break;
      case PIPE_WE_R: 
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Rott ror VO");
        break;
      case PIPE_WE_G:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Gront ror VO");
        break;
      case PIPE_WE_B:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Blatt ror VO");
        break;
      case PIPE_WE_RG:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Rodgront ror VO");
        break;
      case PIPE_WE_RB:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Rodblatt ror VO");
        break;
      case PIPE_WE_GB:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Gronblatt ror VO");
        break;
      case SPINPIPE_WE:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Snurr-ror VO");
        break;
      case PANDAHERE_N:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Panda N");
        break;
      case PANDAHERE_W:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Panda V");
        break;
      case PANDAHERE_E:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Panda O");
        break;
      case PANDAHERE_S:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Panda S");
        break;
      default:
        break;
    }

  #else

    textprintf(virscr,pfont, 488,32, TXCOL, "level editor");
    textprintf(virscr,pfont, 488,80, TXCOL, "Commands:");
    textprintf(virscr,pfont, 488,104, TXCOL, "O - Open");
    textprintf(virscr,pfont, 488,104, hicol, "O");
    textprintf(virscr,pfont, 488,120, TXCOL, "S - Save");
    textprintf(virscr,pfont, 488,120, hicol, "S");
    textprintf(virscr,pfont, 488,136, TXCOL, "ESC - quit");
    textprintf(virscr,pfont, 488,136, hicol, "ESC");
    textprintf(virscr,pfont, 488,152, TXCOL, "T - Title");
    textprintf(virscr,pfont, 488,152, hicol, "T");
    textprintf(virscr,pfont, 488,172, TXCOL, "Enter -");
    textprintf(virscr,pfont, 488,172, hicol, "Enter");
    textprintf(virscr,pfont, 488,186, TXCOL, "select tile");
    textprintf(virscr,pfont, 488,206, TXCOL, "Space -");
    textprintf(virscr,pfont, 488,206, hicol, "Space");
    textprintf(virscr,pfont, 488,222, TXCOL, "put tile");
    textprintf(virscr,pfont, 488,242, TXCOL, "Del - remove tile");
    textprintf(virscr,pfont, 488,242, hicol, "Del");
    textprintf_centre(virscr,pfont, 559,376, TXCOL, "Tile:");

	// Print the name of the currently selected tile right above it.
    switch(theTile)
    {
      case TREE:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Tree");
        break;
      case STUB:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Stub");
        break;
      case KEY:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Key");
        break;
      case CLOSEDGATE:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Closed gate");
        break;
      case OPENGATE:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Open gate");
        break;
      case BUTTON_R:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Red switch");
        break;
      case BUTTON_G:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Green switch");
        break;
      case BUTTON_B:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Blue switch");
        break;
      case PIPE_NS_R:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Red pipe NS");
        break;
      case PIPE_NS_G:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Green pipe NS");
        break;
      case PIPE_NS_B:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Blue pipe NS");
        break;
      case PIPE_NS_RG:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Red&green pipe NS");
        break;
      case PIPE_NS_RB:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Red&blue pipe NS");
        break;
      case PIPE_NS_GB:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Green&blue pipe NS");
        break;
      case SPINPIPE_NS:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Spinpipe NS");
        break;
      case PIPE_WE_R:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Red pipe WE");
        break;
      case PIPE_WE_G:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Green pipe WE");
        break;
      case PIPE_WE_B:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Blue pipe WE");
        break;
      case PIPE_WE_RG:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Red&green pipe WE");
        break;
      case PIPE_WE_RB:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Red&blue pipe WE");
        break;
      case PIPE_WE_GB:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Green&blue pipe WE");
        break;
      case SPINPIPE_WE:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Spinpipe WE");
        break;
      case PANDAHERE_N:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Panda N");
        break;
      case PANDAHERE_W:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Panda W");
        break;
      case PANDAHERE_E:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Panda E");
        break;
      case PANDAHERE_S:
        textprintf_centre(virscr,pfont, 560,432, TXCOL, "Panda S");
        break;
      default:
        break;
     }
  #endif

	BLIT_NOW;

}

short save2File(CourseClass bla)
// Returns 1 if the course was successfully saved, otherwise it returns 0.
{
	wait(40);
	text_mode(BGCOL);

	if(bla.itsTitle == 0 OR *bla.itsTitle == 0)
	{
		#ifdef SVENSKA
			message("Banan maste ha en titel innan den kan sparas.");
		#else
			message("The level needs a title before it can be saved.");
		#endif
		clear_keybuf();
		readkey();
		return 0;
	}


	UCHAR max = 8;

	#ifdef SVENSKA
		message("Spara fil:");
	#else
		message("Save file:");
	#endif
	char * tempname = kinput(128,200, "",max, 0, 1);

	if(tempname == 0)
		return 0;
	textprintf(screen,pfont, 128,200, 18, "%s", tempname);
	char * filenam = new char[max+4];
	for(UCHAR position=0;position<max;position++)
		filenam[position] = tempname[position];
	delete[] tempname;
	filenam[max-1] = '.';
	filenam[max] = 'p';
	filenam[max+1] = 'a';
	filenam[max+2] = 'n';
	filenam[max+3] = 0;


	// Test to see if the file already exists, by opening it in read-mode.
	ifstream fin(filenam, ios::nocreate);

	if(!fin.fail())  // If it did, let's warn the user.
	{
		fin.close();

		#ifdef SVENSKA
			textprintf(virscr,pfont, 24,216, SCOL, " Filen finns redan! Vill du ersatta befintlig fil? (j/n) ");
		#else
			textprintf(virscr,pfont, 24,216, SCOL, " File already exists! Want to overwrite? (y/n) ");
		#endif

		BLIT_NOW;
		clear_keybuf();
		anotherPress:
		long kalle = readkey();
		kalle = kalle >> 8;

		#ifdef SVENSKA
			if(kalle != KEY_J AND kalle != KEY_N AND kalle != KEY_ESC)
		#else
			if(kalle != KEY_Y AND kalle != KEY_N AND kalle != KEY_ESC)
		#endif
			goto anotherPress;

		if(kalle == KEY_N OR kalle == KEY_ESC)
		{
			delete[] filenam;
			return 0;
		}
	}
	fin.close();

	// Open file for writing.
	ofstream fout(filenam);
	delete[] filenam;

	if(fout.good())
	{
		// Write course title.
		for(short i=0;;i++)
		{
			fout << (char)(bla.itsTitle[i]);
			if(bla.itsTitle[i] == 0)
				break;
		}

		// Write map.
		for(short y=0;y<MAPSIZE;y++)
			for(short x=0;x<MAPSIZE;x++)
			{
				// Is this the place of Panda...
				if(x == bla.startX AND y == bla.startY)
					fout << (char)(bla.startDirection + PANDAHERE_N + THISOFF);
				// ..or just an ordinary tile?
				else
					fout << (char)(bla.map[y][x] + THISOFF);
			}

	// Note: THISOFF is a constant I use to make the saved file easier to understand in a normal
	// text editor. Without it, the file would consist mainly of the characters 0-34, between
	// which there are no visual difference. "aaaabcaadaaaae" is kinda easier to understand.
	// When the file is saved, THISOFF is added. When the file is loaded, THISOFF is subtracted.

		// That's it!
		fout.close();
		return 1;
	}

	fout.close();

	#ifdef SVENSKA
		message("Det gick inte att spara filen.");
	#else
		message("Couldn't save file.");
	#endif

	clear_keybuf();
	readkey();
	return 0;
}


short loadFromFile(CourseClass &bla, char * filenam)
// Returns 1 if load was successful, 0 if not successful.
{
	// Open file for reading.
	ifstream fin(filenam, ios::nocreate);

  if(fin.fail())
  {
    fin.close();  
    return 0;
  }

  // I load neither the title or the map directly into "bla".
  // This is because there may be something wrong with the file we're trying to load, and
  // if we really encounter a such problem, we want the old contents of "bla" to remain.

  char tempTitle[64];
  UCHAR tempMap[MAPSIZE][MAPSIZE];
  UCHAR tempStartX, tempStartY;
  UCHAR tempStartDirection = 5;

  char letter;

  // Get course title.
  UCHAR position = 0;
  do
  {
    fin.get(letter);
    tempTitle[position++] = letter;

    if(position > 62)  // Safety test.
    {
      tempTitle[position] = 0;
      break;
    }
  }
  while(letter);

  // Get map.
  for(short y=0;y<MAPSIZE;y++)
  {
    for(short x=0;x<MAPSIZE;x++)
    {
      fin.get(letter);
      letter -= THISOFF;

    // Note: THISOFF is a constant I use to make the saved file easier to understand in a normal
    // text editor. Without it, the file would consist mainly of the characters 0-34, between
    // which there are no visual difference. "aaaabcaadaaaae" is kinda easier to understand.
    // When the file is saved, THISOFF is added. When the file is loaded, THISOFF is subtracted.

      // Is this the place of Panda...
      if(letter >= PANDAHERE_N AND letter <= PANDAHERE_S)
      {
        tempStartX = x;
        tempStartY = y;
        tempStartDirection = letter - PANDAHERE_N;
        tempMap[y][x] = 0;
      }
      // ..or just an ordinary tile?
      else
      {
        if(letter >= GRASS AND letter <= BRANCH_E)  // If this test fails, the file is not a
          tempMap[y][x] = letter;                   // legal Panda 2 level, so we restore the
        else                                        // old one and return failure;
        {
          fin.close();
          return 0;
        }
      }
    }
  }

  // That's it!
  fin.close();

  // Did Panda get a starting position?
  if(tempStartDirection == 5)
    return 0;

  bla.startX = tempStartX;
  bla.startY = tempStartY;
  bla.startDirection = tempStartDirection;

  bla.itsTitle = new char[position];
  for(letter=0;letter<position;letter++)
    bla.itsTitle[letter] = tempTitle[letter];

  // Loop through the course and count the keys.
  bla.nrKeys = 0;
  for(short gg=0;gg<400;gg++)
  {
    bla.map[0][gg] = tempMap[0][gg];
    if(bla.map[0][gg] == KEY)
      bla.nrKeys++;
  }
  
  return 1;
}

short selectTile(UCHAR &mark, UCHAR &tile2Put)
{
  clear_to_color(virscr, BGCOL);
  drawFrames();

  char tempMark = (char)mark;

  // Draw all tiles, with grass under.
  for(short pp=1;pp<9;pp++)
  {
    draw_rle_sprite(virscr,tile[GRASS].itsImage, pp*TILESIZE+pp+134,196);
    draw_rle_sprite(virscr,tile[pp].itsImage, pp*TILESIZE+pp+134,196);
  }
  for(pp=9;pp<14;pp++)
  {
    draw_rle_sprite(virscr,tile[GRASS].itsImage, pp*TILESIZE+pp+134,196);
    if(pp % 2)
      draw_rle_sprite(virscr,tile[PIPE_NS].itsImage, pp*TILESIZE+pp+134,196);
    else
      draw_rle_sprite(virscr,tile[PIPE_WE].itsImage, pp*TILESIZE+pp+134,196);
    draw_rle_sprite(virscr,tile[pp].itsImage, pp*TILESIZE+pp+134,196);
  }
  for(pp=0;pp<9;pp++)
  {
    short tt = pp + 14;
    draw_rle_sprite(virscr,tile[GRASS].itsImage, pp*TILESIZE+pp+159,221);
    if(tt % 2)
      draw_rle_sprite(virscr,tile[PIPE_NS].itsImage, pp*TILESIZE+pp+159,221);
    else
      draw_rle_sprite(virscr,tile[PIPE_WE].itsImage, pp*TILESIZE+pp+159,221);
    draw_rle_sprite(virscr,tile[tt].itsImage, pp*TILESIZE+pp+159,221);
  }
  for(pp=9;pp<13;pp++)
  {
    short tt = pp - 9;
    draw_rle_sprite(virscr,tile[GRASS].itsImage, pp*TILESIZE+pp+159,221);
    draw_rle_sprite(virscr,pandaPic[tt][0], pp*TILESIZE+pp+159,221);
  }


  do
  {
    // Erease the previous marker.
    hline(virscr,   60,195, 579,      BGCOL);
    hline(virscr,   60,220, 579,      BGCOL);
    hline(virscr,   60,245, 579,      BGCOL);
    vline(virscr, 158,195,      246, BGCOL);
    vline(virscr, 183,195,      246, BGCOL);
    vline(virscr, 208,195,      246, BGCOL);
    vline(virscr, 233,195,      246, BGCOL);
    vline(virscr, 258,195,      246, BGCOL);
    vline(virscr, 283,195,      246, BGCOL);
    vline(virscr, 308,195,      246, BGCOL);
    vline(virscr, 333,195,      246, BGCOL);
    vline(virscr, 358,195,      246, BGCOL);
    vline(virscr, 383,195,      246, BGCOL);
    vline(virscr, 408,195,      246, BGCOL);
    vline(virscr, 433,195,      246, BGCOL);
    vline(virscr, 458,195,      246, BGCOL);
    vline(virscr, 483,195,      246, BGCOL);
    vline(virscr, 508,195,      246, BGCOL);
    vline(virscr, 533,195,      246, BGCOL);
    vline(virscr, 558,195,      246, BGCOL);
    vline(virscr, 583,195,      246, BGCOL);

    // Erease the previous text.
    rectfill(virscr, 60,168, 579,184, BGCOL);

    // Draw marker at its new position.
    if(tempMark < 14)
    {
      hline(virscr, tempMark*TILESIZE+tempMark+133,195, (tempMark+1)*TILESIZE+tempMark+133, TXCOL);
      hline(virscr, tempMark*TILESIZE+tempMark+133,220, (tempMark+1)*TILESIZE+tempMark+133, TXCOL);
      vline(virscr, tempMark*TILESIZE+tempMark+133,195, 220, TXCOL);
      vline(virscr, (tempMark+1)*TILESIZE+tempMark+134,195, 220, TXCOL);
    }
    else
    {
      char corre = tempMark - 14;
      hline(virscr, corre*TILESIZE+corre+158,220, (corre+1)*TILESIZE+corre+158, TXCOL);
      hline(virscr, corre*TILESIZE+corre+158,245, (corre+1)*TILESIZE+corre+158, TXCOL);
      vline(virscr, corre*TILESIZE+corre+158,220, 245, TXCOL);
      vline(virscr, (corre+1)*TILESIZE+corre+159,220, 245, TXCOL);
    }

    // Write new text.
    #ifdef SVENSKA
      switch(tempMark)
      {
        case 1:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Trad");
          break;
        case 2:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Stubbe");
          break;
        case 3:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Nyckel");
          break;
        case 4:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Stangd port");
          break;
        case 5:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Oppen port");
          break;
        case 6:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Rod knapp");
          break;
        case 7:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Gron knapp");
          break;
        case 8:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Bla knapp");
          break;
        case 9:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Rott ror nord-syd");
          break;
        case 10:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Rott ror vast-ost");
          break;
        case 11:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Gront ror nord-syd");
          break;
        case 12:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Gront ror vast-ost");
          break;
        case 13:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Blatt ror nord-syd");
          break;
        case 14:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Blatt ror vast-ost");
          break;
        case 15:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Rodgront ror nord-syd");
          break;
        case 16:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Rodgront ror vast-ost");
          break;
        case 17:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Rodblatt ror nord-syd");
          break;
        case 18:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Rodblatt ror vast-ost");
          break;
        case 19:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Gronblatt ror nord-syd");
          break;
        case 20:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Gronblatt ror vast-ost");
          break;
        case 21:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Snurr-ror nord-syd");
          break;
        case 22:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Snurr-ror vast-ost");
          break;
        case 23:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Panda vand mot nord");
          break;
        case 24:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Panda vand mot vast");
          break;
        case 25:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Panda vand mot ost");
          break;
        case 26:
          textprintf_centre(virscr,pfont, 320,168, TXCOL, "Panda vand mot syd");
          break;
        default:
          break;
      }
      #else
        switch(tempMark)
        {
          case 1:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Tree");
            break;
          case 2:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Stub");
            break;
          case 3:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Key");
            break;
          case 4:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Closed gate");
            break;
          case 5:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Open gate");
            break;
          case 6:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Red switch");
            break;
          case 7:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Green switch");
            break;
          case 8:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Blue switch");
            break;
          case 9:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Red pipe north-south");
            break;
          case 10:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Red pipe west-east");
            break;
          case 11:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Green pipe north-south");
            break;
          case 12:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Green pipe west-east");
            break;
          case 13:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Blue pipe north-south");
            break;
          case 14:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Blue pipe west-east");
            break;
          case 15:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Red&green pipe north-south");
            break;
          case 16:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Red&green pipe west-east");
            break;
          case 17:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Red&blue pipe north-south");
            break;
          case 18:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Red&blue pipe west-east");
            break;
          case 19:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Green&blue pipe north-south");
            break;
          case 20:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Green&blue pipe west-east");
            break;
          case 21:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Spinpipe north-south");
            break;
          case 22:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Spinpipe west-east");
            break;
          case 23:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Panda, facing north");
            break;
          case 24:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Panda, facing west");
            break;
          case 25:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Panda, facing east");
            break;
          case 26:
            textprintf_centre(virscr,pfont, 320,168, TXCOL, "Panda, facing south");
            break;
          default:
            break;
        }
      #endif

    BLIT_NOW;
		wait(40);

    clear_keybuf();
    long userCom = readkey();
    userCom = userCom >> 8;

    switch(userCom)
    {
      case KEY_ESC:
        return 0;
        break;
      case KEY_UP:
        if((tempMark - 13) > 0)
          tempMark -= 13;
        break;
      case KEY_LEFT:
        if(tempMark < 14)
        {
          if(tempMark > 1)
            tempMark--;
        }
        else
        {
          if(tempMark > 14)
            tempMark--;
        }
        break;
      case KEY_RIGHT:
        if(tempMark < 14)
        {
          if(tempMark < 13)
            tempMark++;
        }
        else
        {
          if(tempMark < 26)
            tempMark++;
        }
        break;
      case KEY_DOWN:
        if((tempMark + 13) <= 26)
          tempMark += 13;
        break;
      default:
        mark = (UCHAR)tempMark;
        if(mark < 23)
          tile2Put = mark;
        else
          tile2Put = mark + 6;
        return 1;
        break;
    }

  }
  while(1);
}

char * kinput(short x,short y, char * text,UCHAR &max, UCHAR free,UCHAR escape)
// Kinput is short for Key Input. It is used in Panda 2 when you write your name, or a filename, or...
// The argument "text" holds text that should already be there.
// "max" is the maximum nr of chars that you should be able to input. When this function ends,
// "max" is set to the nr of chars that were actually entered.
// "free" should be TRUE if you want the user to be able to enter spaces, periods etc.
// When "escape" is TRUE, you can exit kinput by pressing ESC. When it is FALSE, you HAVE to
// enter some text and press enter.
// Kinput returns a pointer to an array on the free store.
// If no text was entered, the pointer is NULL.
{
	char * temp = new char[max+1];
	UCHAR nrLetters = 0;
	for(UCHAR b=0;b<max;b++)
	{
		temp[b] = text[b];
		if(temp[b] == 0)
			break;
		nrLetters++;
	}
	temp[nrLetters] = 0;  // Just to be sure.
	UCHAR position = 0;
	long keypress;
	char letter;
	char * result = 0;

	BITMAP * whatsUnder = create_bitmap(max*8,16);
	blit(virscr,whatsUnder, x,y, 0,0, max*8,16);

	_getsystime(whatsTheTime);
	if(whatsTheTime->tm_hour > 5 AND whatsTheTime->tm_hour < 20)
		set_color(254, basePal + DAYCOL);
	else
		set_color(254, basePal + NIGHTCOL);


	for(EVER)
	{
		blit(whatsUnder,virscr, 0,0, x,y, max*8,16);
		textprintf(virscr,pfont, x,y, 18, "%s",temp);
		if(position < max)
			hline(virscr, x+(position<<3),y+15, 7+x+(position<<3), 254);
		BLIT_NOW;

		wait(80);
		clear_keybuf();

		keypress = readkey();
		letter = keypress & 0xFF;
		keypress = keypress >> 8;

		if(keypress == KEY_ESC)
			if(escape)
				break;

		if(keypress == KEY_LEFT)
			if(position > 0)
				position--;
		if(keypress == KEY_RIGHT)
			if(position < nrLetters)
				position++;

		if(keypress == KEY_HOME)
			position = 0;

		if(keypress == KEY_END)
			position = nrLetters;

		if(keypress == KEY_BACKSPACE)
			if(position > 0)
			{
				position--;
				for(UCHAR b=position;b<=nrLetters;b++)
					temp[b] = temp[b+1];
				nrLetters--;
			}

		if(keypress == KEY_DEL)
			if(position < nrLetters)
			{
				for(UCHAR b=position;b<=nrLetters;b++)
					temp[b] = temp[b+1];
				nrLetters--;
			}

		if(keypress == KEY_ENTER)
			if(nrLetters > 0)
			{
				result = new char[nrLetters+1];
				for(UCHAR b=0;b<=nrLetters;b++)
					result[b] = temp[b];
				break;
			}

		if(free)
		{
			if(nrLetters < max)
			if(letter > 31 AND letter < 127)
			{
				nrLetters++;
				for(UCHAR b=nrLetters;b>position;b--)
					temp[b] = temp[b-1];
				temp[position++] = letter;
			}
		}
		else
		{
			if((letter >= '0' AND letter <= '9') OR (letter >= 'A' AND letter <= 'Z') OR
				(letter >= 'a' AND letter <= 'z') OR (letter == '_') )
				if(nrLetters < max)
				{
					nrLetters++;
					for(UCHAR b=nrLetters;b>position;b--)
						temp[b] = temp[b-1];
					temp[position++] = letter;
				}
		}

	}

	delete[] temp;
	blit(whatsUnder,virscr, 0,0, x,y, max*8,16);
	destroy_bitmap(whatsUnder);
	BLIT_NOW;

	max = nrLetters+1;
	return result;
}


/*
short save4Use(CourseClass bla)
// This is a special version of save2File. It won't be included in the final game.
{
  ofstream fout("sbana0.pan");

  if(fout.good())
  {
    // Write map.
    for(short y=0;y<MAPSIZE;y++)
    {
      fout << "      {";
      for(short x=0;x<MAPSIZE;x++)
      {
        // Is this the place of Panda...
        if(x == bla.startX AND y == bla.startY)
          fout << (short)((char)(bla.startDirection + PANDAHERE_N)) << ",";
        // ..or just an ordinary tile?
        else
        {
          fout << (short)((char)(bla.map[y][x]));
          if(x < 19)
            fout << ",";
        }
      }
      if(y < 19)
        fout << "},\n";
      else
        fout << "}\n";
    }
  }

  fout.close();
  return 0;
}
*/
